/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.streaming.device;

import com.android.annotations.concurrency.AnyThread;
import com.android.annotations.concurrency.UiThread;
import com.android.tools.adtui.actions.ZoomType;
import com.android.tools.idea.concurrency.CoroutinesUtilsKt;
import com.android.tools.idea.streaming.AbstractDisplayView;
import com.android.tools.idea.streaming.DeviceMirroringSettings;
import com.android.tools.idea.streaming.DeviceMirroringSettingsListener;
import com.android.tools.idea.streaming.StreamingUtilsKt;
import com.android.tools.idea.streaming.device.AndroidKeyEventActionType;
import com.android.tools.idea.streaming.device.AndroidKeyStroke;
import com.android.tools.idea.streaming.device.DeviceClient;
import com.android.tools.idea.streaming.device.DeviceClipboardSynchronizer;
import com.android.tools.idea.streaming.device.DeviceController;
import com.android.tools.idea.streaming.device.DeviceView;
import com.android.tools.idea.streaming.device.KeyEventMessage;
import com.android.tools.idea.streaming.device.MotionEventMessage;
import com.android.tools.idea.streaming.device.SetMaxVideoResolutionMessage;
import com.android.tools.idea.streaming.device.TextInputMessage;
import com.android.tools.idea.streaming.device.VideoDecoder;
import com.android.tools.idea.streaming.device.VideoDecoderKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.function.Consumer;
import javax.swing.KeyStroke;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00be\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u0003\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003:\u0005klmnoB5\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0010\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020\u001bH\u0007J\u0014\u0010C\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fH\u0002J\b\u0010D\u001a\u000201H\u0014J\b\u0010E\u001a\u00020#H\u0014J\u0010\u0010E\u001a\u00020#2\u0006\u0010F\u001a\u00020\nH\u0002J\u001c\u0010G\u001a\u00020A2\u0006\u0010\t\u001a\u00020\n2\n\b\u0002\u0010H\u001a\u0004\u0018\u00010IH\u0002J\b\u0010J\u001a\u00020AH\u0016J!\u0010K\u001a\u00020A2\u0006\u0010L\u001a\u00020#2\u0006\u0010\t\u001a\u00020\nH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010MJ\u0010\u0010N\u001a\u00020A2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010O\u001a\u0002012\u0006\u0010P\u001a\u00020QH\u0002J\u0016\u0010R\u001a\b\u0012\u0004\u0012\u00020T0S2\u0006\u0010U\u001a\u000208H\u0002J\u0016\u0010V\u001a\b\u0012\u0004\u0012\u00020T0S2\u0006\u0010U\u001a\u000208H\u0002J\u0010\u0010W\u001a\u00020A2\u0006\u0010X\u001a\u00020YH\u0014J\u0010\u0010Z\u001a\u00020A2\u0006\u0010B\u001a\u00020\u001bH\u0007J\u0018\u0010[\u001a\u00020A2\u0006\u0010U\u001a\u0002082\u0006\u0010\\\u001a\u00020\nH\u0002J\u0018\u0010]\u001a\u00020A2\u0006\u0010U\u001a\u0002082\u0006\u0010\\\u001a\u00020\nH\u0002J(\u0010^\u001a\u00020A2\u0006\u0010_\u001a\u00020\n2\u0006\u0010`\u001a\u00020\n2\u0006\u0010a\u001a\u00020\n2\u0006\u0010b\u001a\u00020\nH\u0016J\u0010\u0010c\u001a\u00020A2\u0006\u0010d\u001a\u00020eH\u0017J\b\u0010f\u001a\u00020AH\u0002J(\u0010g\u001a\u00020A*\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110h2\u0006\u0010i\u001a\u00020\u00062\u0006\u0010j\u001a\u00020\u0011H\u0002R\u001c\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u0015@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001e\u001a\u0004\u0018\u00010\u001f8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0014\u0010\"\u001a\u00020#X\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u001e\u0010)\u001a\u00020\n2\u0006\u0010(\u001a\u00020\n@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u001e\u0010,\u001a\u00020\n2\u0006\u0010(\u001a\u00020\n@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010+R\u000e\u0010.\u001a\u00020/X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u000201X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u00102\u001a\u0002018F\u00a2\u0006\u0006\u001a\u0004\b2\u00103R \u00104\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b5\u00106R\u0010\u00107\u001a\u0004\u0018\u000108X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u00109\u001a\u0002012\u0006\u0010\u0014\u001a\u000201@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b:\u0010;R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010<\u001a\u0004\u0018\u00010=8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b>\u0010?\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006p"}, d2={"Lcom/android/tools/idea/streaming/device/DeviceView;", "Lcom/android/tools/idea/streaming/AbstractDisplayView;", "Lcom/intellij/openapi/Disposable;", "Lcom/android/tools/idea/streaming/DeviceMirroringSettingsListener;", "disposableParent", "deviceSerialNumber", "", "deviceAbi", "deviceName", "initialDisplayOrientation", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/Disposable;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ILcom/intellij/openapi/project/Project;)V", "cachedKeyStrokeMap", "", "Ljavax/swing/KeyStroke;", "Lcom/android/tools/idea/streaming/device/AndroidKeyStroke;", "clipboardSynchronizer", "Lcom/android/tools/idea/streaming/device/DeviceClipboardSynchronizer;", "value", "Lcom/android/tools/idea/streaming/device/DeviceView$ConnectionState;", "connectionState", "setConnectionState", "(Lcom/android/tools/idea/streaming/device/DeviceView$ConnectionState;)V", "connectionStateListeners", "", "Lcom/android/tools/idea/streaming/device/DeviceView$ConnectionStateListener;", "deviceClient", "Lcom/android/tools/idea/streaming/device/DeviceClient;", "deviceController", "Lcom/android/tools/idea/streaming/device/DeviceController;", "getDeviceController$intellij_android_streaming", "()Lcom/android/tools/idea/streaming/device/DeviceController;", "deviceDisplaySize", "Ljava/awt/Dimension;", "getDeviceDisplaySize$intellij_android_streaming", "()Ljava/awt/Dimension;", "getDeviceSerialNumber", "()Ljava/lang/String;", "<set-?>", "displayOrientationCorrectionQuadrants", "getDisplayOrientationCorrectionQuadrants$intellij_android_streaming", "()I", "displayOrientationQuadrants", "getDisplayOrientationQuadrants", "displayTransform", "Ljava/awt/geom/AffineTransform;", "disposed", "", "isConnected", "()Z", "keyStrokeMap", "getKeyStrokeMap", "()Ljava/util/Map;", "lastTouchCoordinates", "Ljava/awt/Point;", "multiTouchMode", "setMultiTouchMode", "(Z)V", "videoDecoder", "Lcom/android/tools/idea/streaming/device/VideoDecoder;", "getVideoDecoder", "()Lcom/android/tools/idea/streaming/device/VideoDecoder;", "addConnectionStateListener", "", "listener", "buildKeystrokeMap", "canZoom", "computeActualSize", "rotationQuadrants", "disconnected", "exception", "", "dispose", "initializeAgent", "maxOutputSize", "(Ljava/awt/Dimension;ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "initializeAgentAsync", "isInsideDisplay", "event", "Ljava/awt/event/MouseEvent;", "originalAndMirroredPointer", "", "Lcom/android/tools/idea/streaming/device/MotionEventMessage$Pointer;", "p", "originalPointer", "paintComponent", "g", "Ljava/awt/Graphics;", "removeConnectionStateListener", "sendMotionEvent", "action", "sendMotionEventDisplayCoordinates", "setBounds", "x", "y", "width", "height", "settingsChanged", "settings", "Lcom/android/tools/idea/streaming/DeviceMirroringSettings;", "updateVideoSize", "addKeystrokesForAction", "", "actionId", "androidKeystroke", "ConnectionState", "ConnectionStateListener", "MyFrameListener", "MyKeyListener", "MyMouseListener", "intellij.android.streaming"})
public final class DeviceView
extends AbstractDisplayView
implements Disposable,
DeviceMirroringSettingsListener {
    @NotNull
    private final String deviceSerialNumber;
    @NotNull
    private final String deviceAbi;
    @NotNull
    private final String deviceName;
    private final int initialDisplayOrientation;
    @NotNull
    private final Project project;
    private int displayOrientationQuadrants;
    private int displayOrientationCorrectionQuadrants;
    @NotNull
    private ConnectionState connectionState;
    @Nullable
    private DeviceClient deviceClient;
    @Nullable
    private DeviceClipboardSynchronizer clipboardSynchronizer;
    @NotNull
    private final List<ConnectionStateListener> connectionStateListeners;
    @NotNull
    private final Dimension deviceDisplaySize;
    @NotNull
    private final AffineTransform displayTransform;
    private boolean disposed;
    @Nullable
    private Map<KeyStroke, AndroidKeyStroke> cachedKeyStrokeMap;
    private boolean multiTouchMode;
    @Nullable
    private Point lastTouchCoordinates;

    public DeviceView(@NotNull Disposable disposableParent, @NotNull String deviceSerialNumber, @NotNull String deviceAbi, @NotNull String deviceName, int initialDisplayOrientation, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)disposableParent, (String)"disposableParent");
        Intrinsics.checkNotNullParameter((Object)deviceSerialNumber, (String)"deviceSerialNumber");
        Intrinsics.checkNotNullParameter((Object)deviceAbi, (String)"deviceAbi");
        Intrinsics.checkNotNullParameter((Object)deviceName, (String)"deviceName");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(0);
        this.deviceSerialNumber = deviceSerialNumber;
        this.deviceAbi = deviceAbi;
        this.deviceName = deviceName;
        this.initialDisplayOrientation = initialDisplayOrientation;
        this.project = project;
        this.connectionState = ConnectionState.INITIAL;
        this.connectionStateListeners = new ArrayList();
        this.deviceDisplaySize = new Dimension();
        this.displayTransform = new AffineTransform();
        Disposer.register((Disposable)disposableParent, (Disposable)this);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(@NotNull ComponentEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (this.getPhysicalWidth() > 0 && this.getPhysicalHeight() > 0 && connectionState == ConnectionState.INITIAL) {
                    this.initializeAgentAsync(initialDisplayOrientation);
                }
            }
        });
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(@NotNull FocusEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                cachedKeyStrokeMap = null;
            }
        });
        MyMouseListener mouseListener2 = new MyMouseListener();
        this.addMouseListener(mouseListener2);
        this.addMouseMotionListener(mouseListener2);
        this.addKeyListener(new MyKeyListener());
        MessageBusConnection messageBusConnection = this.project.getMessageBus().connect((Disposable)this);
        Topic<DeviceMirroringSettingsListener> topic = DeviceMirroringSettingsListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, (Object)this);
    }

    @Override
    @NotNull
    public String getDeviceSerialNumber() {
        return this.deviceSerialNumber;
    }

    public final boolean isConnected() {
        return this.connectionState == ConnectionState.CONNECTED;
    }

    @Override
    public int getDisplayOrientationQuadrants() {
        return this.displayOrientationQuadrants;
    }

    public final int getDisplayOrientationCorrectionQuadrants$intellij_android_streaming() {
        return this.displayOrientationCorrectionQuadrants;
    }

    private final void setConnectionState(ConnectionState value2) {
        if (this.connectionState != value2) {
            this.connectionState = value2;
            for (ConnectionStateListener listener2 : this.connectionStateListeners) {
                listener2.connectionStateChanged(this.getDeviceSerialNumber(), this.connectionState);
            }
        }
    }

    @Nullable
    public final DeviceController getDeviceController$intellij_android_streaming() {
        DeviceClient deviceClient = this.deviceClient;
        return deviceClient != null ? deviceClient.getDeviceController() : null;
    }

    private final VideoDecoder getVideoDecoder() {
        DeviceClient deviceClient = this.deviceClient;
        return deviceClient != null ? deviceClient.getVideoDecoder() : null;
    }

    @Override
    @NotNull
    public Dimension getDeviceDisplaySize$intellij_android_streaming() {
        return this.deviceDisplaySize;
    }

    private final Map<KeyStroke, AndroidKeyStroke> getKeyStrokeMap() {
        Map<KeyStroke, AndroidKeyStroke> map2 = this.cachedKeyStrokeMap;
        if (map2 == null) {
            this.cachedKeyStrokeMap = map2 = this.buildKeystrokeMap();
        }
        return map2;
    }

    private final void setMultiTouchMode(boolean value2) {
        if (value2 != this.multiTouchMode) {
            this.multiTouchMode = value2;
            this.repaint();
            Point point = this.lastTouchCoordinates;
            if (point != null) {
                int action2 = value2 ? 5 : 6;
                this.sendMotionEvent(point, action2);
            }
        }
    }

    public void setBounds(int x, int y, int width, int height) {
        boolean resized = width != this.getWidth() || height != this.getHeight();
        super.setBounds(x, y, width, height);
        if (resized && this.getPhysicalWidth() > 0 && this.getPhysicalHeight() > 0) {
            if (this.connectionState == ConnectionState.INITIAL) {
                this.initializeAgentAsync(this.initialDisplayOrientation);
            } else {
                this.updateVideoSize();
            }
        }
    }

    private final void initializeAgentAsync(int initialDisplayOrientation) {
        this.setConnectionState(ConnectionState.CONNECTING);
        Dimension maxOutputSize = this.getPhysicalSize();
        BuildersKt.launch$default((CoroutineScope)CoroutinesUtilsKt.AndroidCoroutineScope$default((Disposable)this, null, (int)2, null), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, maxOutputSize, initialDisplayOrientation, null){
            int label;
            final /* synthetic */ DeviceView this$0;
            final /* synthetic */ Dimension $maxOutputSize;
            final /* synthetic */ int $initialDisplayOrientation;
            {
                this.this$0 = $receiver;
                this.$maxOutputSize = $maxOutputSize;
                this.$initialDisplayOrientation = $initialDisplayOrientation;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = DeviceView.access$initializeAgent(this.this$0, this.$maxOutputSize, this.$initialDisplayOrientation, (Continuation)this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    /*
     * Unable to fully structure code
     */
    private final Object initializeAgent(Dimension var1_1, int var2_2, Continuation<? super Unit> var3_3) {
        if (!(var3_3 instanceof initializeAgent.1)) ** GOTO lbl-1000
        var7_4 = var3_3;
        if ((var7_4.label & -2147483648) != 0) {
            var7_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                Object L$0;
                Object L$1;
                int I$0;
                /* synthetic */ Object result;
                final /* synthetic */ DeviceView this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return DeviceView.access$initializeAgent(this.this$0, null, 0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var8_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                deviceClient = new DeviceClient(this, this.getDeviceSerialNumber(), this.deviceAbi, this.deviceName, this.project);
                agentTerminationListener = new DeviceClient.AgentTerminationListener(this, initialDisplayOrientation){
                    final /* synthetic */ DeviceView this$0;
                    final /* synthetic */ int $initialDisplayOrientation;
                    {
                        this.this$0 = $receiver;
                        this.$initialDisplayOrientation = $initialDisplayOrientation;
                    }

                    public void agentTerminated(int exitCode2) {
                        DeviceView.disconnected$default(this.this$0, this.$initialDisplayOrientation, null, 2, null);
                    }

                    public void deviceDisconnected() {
                        DeviceView.disconnected$default(this.this$0, this.$initialDisplayOrientation, null, 2, null);
                    }
                };
                $continuation.L$0 = this;
                $continuation.L$1 = deviceClient;
                $continuation.I$0 = initialDisplayOrientation;
                $continuation.label = 1;
                v0 = deviceClient.startAgentAndConnect((Dimension)maxOutputSize, initialDisplayOrientation, new MyFrameListener(), agentTerminationListener, (Continuation<? super Unit>)$continuation);
                ** if (v0 != var8_6) goto lbl23
lbl22:
                // 1 sources

                return var8_6;
lbl23:
                // 1 sources

                ** GOTO lbl32
            }
            case 1: {
                initialDisplayOrientation = $continuation.I$0;
                deviceClient = (DeviceClient)$continuation.L$1;
                this = (DeviceView)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl32:
                    // 2 sources

                    EventQueue.invokeLater(new Runnable(this, deviceClient){
                        final /* synthetic */ DeviceView this$0;
                        final /* synthetic */ DeviceClient $deviceClient;
                        {
                            this.this$0 = $receiver;
                            this.$deviceClient = $deviceClient;
                        }

                        public final void run() {
                            if (!DeviceView.access$getDisposed$p(this.this$0)) {
                                DeviceView.access$setDeviceClient$p(this.this$0, this.$deviceClient);
                                if (DeviceMirroringSettings.Companion.getInstance().getSynchronizeClipboard()) {
                                    DeviceView.access$setClipboardSynchronizer$p(this.this$0, new DeviceClipboardSynchronizer(this.$deviceClient.getDeviceController()));
                                }
                                this.this$0.repaint();
                                DeviceView.access$updateVideoSize(this.this$0);
                            }
                        }
                    });
                }
                catch (CancellationException deviceClient) {
                }
                catch (Throwable e) {
                    this.disconnected(initialDisplayOrientation, e);
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final void updateVideoSize() {
        DeviceClient deviceClient = this.deviceClient;
        if (deviceClient == null) {
            return;
        }
        DeviceClient deviceClient2 = deviceClient;
        VideoDecoder videoDecoder = deviceClient2.getVideoDecoder();
        if (!Intrinsics.areEqual((Object)videoDecoder.getMaxOutputSize(), (Object)this.getPhysicalSize())) {
            videoDecoder.setMaxOutputSize(this.getPhysicalSize());
            deviceClient2.getDeviceController().sendControlMessage(new SetMaxVideoResolutionMessage(this.getPhysicalWidth(), this.getPhysicalHeight()));
        }
    }

    private final void disconnected(int initialDisplayOrientation, Throwable exception) {
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(this, exception, initialDisplayOrientation){
            final /* synthetic */ DeviceView this$0;
            final /* synthetic */ Throwable $exception;
            final /* synthetic */ int $initialDisplayOrientation;
            {
                this.this$0 = $receiver;
                this.$exception = $exception;
                this.$initialDisplayOrientation = $initialDisplayOrientation;
            }

            public final void run() {
                if (DeviceView.access$getDisposed$p(this.this$0)) {
                    return;
                }
                String message2 = null;
                AbstractDisplayView.Reconnector reconnector = null;
                switch (disconnected.WhenMappings.$EnumSwitchMapping$0[DeviceView.access$getConnectionState$p(this.this$0).ordinal()]) {
                    case 1: {
                        DeviceView $this$thisLogger$iv = this.this$0;
                        boolean $i$f$thisLogger = false;
                        Logger logger2 = Logger.getInstance(DeviceView.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"Logger.getInstance(T::class.java)");
                        logger2.error("Failed to initialize the screen sharing agent", this.$exception);
                        message2 = "Failed to initialize the device agent. See the error log.";
                        reconnector = this.this$0.new AbstractDisplayView.Reconnector("Retry", "Connecting to the device", (Function1<? super Continuation<? super Unit>, ? extends Object>)((Function1)new Function1<Continuation<? super Unit>, Object>(this.this$0, this.$initialDisplayOrientation, null){
                            int label;
                            final /* synthetic */ DeviceView this$0;
                            final /* synthetic */ int $initialDisplayOrientation;
                            {
                                this.this$0 = $receiver;
                                this.$initialDisplayOrientation = $initialDisplayOrientation;
                                super(1, $completion);
                            }

                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        DeviceView.access$initializeAgentAsync(this.this$0, this.$initialDisplayOrientation);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@Nullable Continuation<? super Unit> p1) {
                                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                            }
                        }));
                        break;
                    }
                    case 2: {
                        message2 = "Lost connection to the device. See the error log.";
                        reconnector = this.this$0.new AbstractDisplayView.Reconnector("Reconnect", "Attempting to reconnect", (Function1<? super Continuation<? super Unit>, ? extends Object>)((Function1)new Function1<Continuation<? super Unit>, Object>(this.this$0, null){
                            int label;
                            final /* synthetic */ DeviceView this$0;
                            {
                                this.this$0 = $receiver;
                                super(1, $completion);
                            }

                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        DeviceView.access$initializeAgentAsync(this.this$0, -1);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@Nullable Continuation<? super Unit> p1) {
                                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                            }
                        }));
                        break;
                    }
                    default: {
                        return;
                    }
                }
                DeviceClient deviceClient = DeviceView.access$getDeviceClient$p(this.this$0);
                if (deviceClient != null) {
                    DeviceClient it = deviceClient;
                    boolean bl = false;
                    Disposer.dispose((Disposable)it);
                }
                DeviceView.access$setDeviceClient$p(this.this$0, null);
                DeviceView.access$setConnectionState(this.this$0, ConnectionState.DISCONNECTED);
                DeviceView.access$showDisconnectedStateMessage(this.this$0, message2, reconnector);
            }
        });
    }

    static /* synthetic */ void disconnected$default(DeviceView deviceView, int n, Throwable throwable, int n2, Object object) {
        if ((n2 & 2) != 0) {
            throwable = null;
        }
        deviceView.disconnected(n, throwable);
    }

    public void dispose() {
        this.disposed = true;
    }

    @Override
    protected boolean canZoom() {
        return this.connectionState == ConnectionState.CONNECTED;
    }

    @Override
    @NotNull
    protected Dimension computeActualSize() {
        return this.computeActualSize(this.getDisplayOrientationQuadrants());
    }

    private final Dimension computeActualSize(int rotationQuadrants) {
        return StreamingUtilsKt.rotatedByQuadrants(this.getDeviceDisplaySize$intellij_android_streaming(), rotationQuadrants);
    }

    protected void paintComponent(@NotNull Graphics g) {
        Rectangle displayRect;
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        super.paintComponent(g);
        if (this.getWidth() == 0 || this.getHeight() == 0) {
            return;
        }
        VideoDecoder videoDecoder = this.getVideoDecoder();
        if (videoDecoder == null) {
            return;
        }
        VideoDecoder decoder = videoDecoder;
        Graphics2D cfr_ignored_0 = (Graphics2D)g;
        double physicalToVirtualScale = 1.0 / this.getScreenScale();
        ((Graphics2D)g).scale(physicalToVirtualScale, physicalToVirtualScale);
        decoder.consumeDisplayFrame(new Consumer(this, g){
            final /* synthetic */ DeviceView this$0;
            final /* synthetic */ Graphics $g;
            {
                this.this$0 = $receiver;
                this.$g = $g;
            }

            public final void accept(@NotNull VideoDecoder.VideoFrame displayFrame) {
                block4: {
                    DeviceClient deviceClient;
                    Intrinsics.checkNotNullParameter((Object)displayFrame, (String)"displayFrame");
                    if (this.this$0.getDisplayOrientationQuadrants() != displayFrame.getOrientation() || this.this$0.getDeviceDisplaySize$intellij_android_streaming().width != 0 && this.this$0.getDeviceDisplaySize$intellij_android_streaming().width != displayFrame.getDisplaySize().width || this.this$0.getDeviceDisplaySize$intellij_android_streaming().height != 0 && this.this$0.getDeviceDisplaySize$intellij_android_streaming().height != displayFrame.getDisplaySize().height) {
                        this.this$0.zoom(ZoomType.FIT);
                    }
                    Dimension rotatedDisplaySize = StreamingUtilsKt.rotatedByQuadrants(displayFrame.getDisplaySize(), displayFrame.getOrientation());
                    Dimension maxSize = DeviceView.access$computeMaxImageSize(this.this$0);
                    double scale = DeviceView.access$roundScale(this.this$0, Math.min((double)maxSize.width / (double)rotatedDisplaySize.width, (double)maxSize.height / (double)rotatedDisplaySize.height));
                    int w = RangesKt.coerceAtMost((int)StreamingUtilsKt.scaled(rotatedDisplaySize.width, scale), (int)DeviceView.access$getPhysicalWidth(this.this$0));
                    int h = RangesKt.coerceAtMost((int)StreamingUtilsKt.scaled(rotatedDisplaySize.height, scale), (int)DeviceView.access$getPhysicalHeight(this.this$0));
                    Rectangle displayRect = new Rectangle((DeviceView.access$getPhysicalWidth(this.this$0) - w) / 2, (DeviceView.access$getPhysicalHeight(this.this$0) - h) / 2, w, h);
                    DeviceView.access$setDisplayRectangle(this.this$0, displayRect);
                    BufferedImage image = displayFrame.getImage();
                    if (displayRect.width == image.getWidth() && displayRect.height == image.getHeight()) {
                        ((Graphics2D)this.$g).drawImage(image, null, displayRect.x, displayRect.y);
                    } else {
                        DeviceView.access$getDisplayTransform$p(this.this$0).setToTranslation(displayRect.x, displayRect.y);
                        DeviceView.access$getDisplayTransform$p(this.this$0).scale((double)displayRect.width / (double)image.getWidth(), (double)displayRect.height / (double)image.getHeight());
                        ((Graphics2D)this.$g).drawImage(image, DeviceView.access$getDisplayTransform$p(this.this$0), null);
                    }
                    this.this$0.getDeviceDisplaySize$intellij_android_streaming().setSize(displayFrame.getDisplaySize());
                    DeviceView.access$setDisplayOrientationQuadrants$p(this.this$0, displayFrame.getOrientation());
                    DeviceView.access$setDisplayOrientationCorrectionQuadrants$p(this.this$0, displayFrame.getOrientationCorrection());
                    DeviceView.access$setFrameNumber(this.this$0, displayFrame.getFrameNumber());
                    DeviceView.access$notifyFrameListeners(this.this$0, displayRect, displayFrame.getImage());
                    DeviceClient deviceClient2 = DeviceView.access$getDeviceClient$p(this.this$0);
                    if (deviceClient2 == null) break block4;
                    DeviceClient $this$accept_u24lambda_u2d0 = deviceClient = deviceClient2;
                    boolean bl = false;
                    if ($this$accept_u24lambda_u2d0.getStartTime$intellij_android_streaming() != 0L) {
                        long delay = System.currentTimeMillis() - $this$accept_u24lambda_u2d0.getStartTime$intellij_android_streaming();
                        long pushDelay = $this$accept_u24lambda_u2d0.getPushEndTime$intellij_android_streaming() - $this$accept_u24lambda_u2d0.getStartTime$intellij_android_streaming();
                        long agentStartDelay = $this$accept_u24lambda_u2d0.getStartAgentTime$intellij_android_streaming() - $this$accept_u24lambda_u2d0.getStartTime$intellij_android_streaming();
                        long connectionDelay = $this$accept_u24lambda_u2d0.getChannelConnectedTime$intellij_android_streaming() - $this$accept_u24lambda_u2d0.getStartTime$intellij_android_streaming();
                        long firstPacketDelay = VideoDecoderKt.getFirstPacketArrival() - $this$accept_u24lambda_u2d0.getStartTime$intellij_android_streaming();
                        String string = "Initialization took " + delay + " ms, push took " + pushDelay + " ms, agent was started after " + agentStartDelay + " ms, connected after " + connectionDelay + " ms, first video packet arrived after " + firstPacketDelay + " ms";
                        System.out.println((Object)string);
                        $this$accept_u24lambda_u2d0.setStartTime$intellij_android_streaming(0L);
                    }
                }
            }
        });
        if (this.multiTouchMode && (displayRect = this.getDisplayRectangle()) != null) {
            this.drawMultiTouchFeedback((Graphics2D)g, displayRect, this.lastTouchCoordinates != null);
        }
    }

    @Override
    @UiThread
    public void settingsChanged(@NotNull DeviceMirroringSettings settings) {
        block4: {
            block3: {
                Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
                Object object = this.deviceClient;
                if (object == null || (object = object.getDeviceController()) == null) {
                    return;
                }
                Object controller2 = object;
                if (!settings.getSynchronizeClipboard()) break block3;
                DeviceClipboardSynchronizer synchronizer = this.clipboardSynchronizer;
                if (synchronizer == null) {
                    this.clipboardSynchronizer = new DeviceClipboardSynchronizer((DeviceController)controller2);
                } else {
                    synchronizer.setDeviceClipboard();
                }
                break block4;
            }
            DeviceClipboardSynchronizer deviceClipboardSynchronizer = this.clipboardSynchronizer;
            if (deviceClipboardSynchronizer == null) break block4;
            DeviceClipboardSynchronizer it = deviceClipboardSynchronizer;
            boolean bl = false;
            Disposer.dispose((Disposable)it);
            this.clipboardSynchronizer = null;
        }
    }

    private final void sendMotionEvent(Point p, int action2) {
        Point point = this.toDeviceDisplayCoordinates$intellij_android_streaming(p);
        if (point == null) {
            return;
        }
        Point displayCoordinates = point;
        if (StreamingUtilsKt.contains(this.getDeviceDisplaySize$intellij_android_streaming(), displayCoordinates)) {
            this.sendMotionEventDisplayCoordinates(displayCoordinates, action2);
        } else if (action2 == 2) {
            this.lastTouchCoordinates = null;
            Point adjusted = StreamingUtilsKt.constrainInside(displayCoordinates, this.getDeviceDisplaySize$intellij_android_streaming());
            this.sendMotionEventDisplayCoordinates(adjusted, action2);
            this.sendMotionEventDisplayCoordinates(adjusted, 1);
        }
    }

    private final void sendMotionEventDisplayCoordinates(Point p, int action2) {
        DeviceController deviceController = this.getDeviceController$intellij_android_streaming();
        if (deviceController == null) {
            return;
        }
        DeviceController deviceController2 = deviceController;
        MotionEventMessage message2 = action2 == 5 || action2 == 6 ? new MotionEventMessage(this.originalAndMirroredPointer(p), action2 | 0x100, this.getDisplayId()) : (this.multiTouchMode ? new MotionEventMessage(this.originalAndMirroredPointer(p), action2, this.getDisplayId()) : new MotionEventMessage(this.originalPointer(p), action2, this.getDisplayId()));
        deviceController2.sendControlMessage(message2);
    }

    private final List<MotionEventMessage.Pointer> originalPointer(Point p) {
        return CollectionsKt.listOf((Object)new MotionEventMessage.Pointer(p.x, p.y, 0));
    }

    private final List<MotionEventMessage.Pointer> originalAndMirroredPointer(Point p) {
        Object[] objectArray = new MotionEventMessage.Pointer[]{new MotionEventMessage.Pointer(p.x, p.y, 0), new MotionEventMessage.Pointer(this.getDeviceDisplaySize$intellij_android_streaming().width - p.x, this.getDeviceDisplaySize$intellij_android_streaming().height - p.y, 1)};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private final boolean isInsideDisplay(MouseEvent event) {
        Rectangle rectangle = this.getDisplayRectangle();
        return rectangle != null ? rectangle.contains((double)event.getX() * this.getScreenScale(), (double)event.getY() * this.getScreenScale()) : false;
    }

    @UiThread
    public final void addConnectionStateListener(@NotNull ConnectionStateListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.connectionStateListeners.add(listener2);
    }

    @UiThread
    public final void removeConnectionStateListener(@NotNull ConnectionStateListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.connectionStateListeners.remove(listener2);
    }

    private final Map<KeyStroke, AndroidKeyStroke> buildKeystrokeMap() {
        Map map2;
        Map $this$buildKeystrokeMap_u24lambda_u2d1 = map2 = (Map)new LinkedHashMap();
        boolean bl = false;
        this.addKeystrokesForAction($this$buildKeystrokeMap_u24lambda_u2d1, "$Cut", new AndroidKeyStroke(277, 0, 2, null));
        this.addKeystrokesForAction($this$buildKeystrokeMap_u24lambda_u2d1, "$Cut", new AndroidKeyStroke(277, 0, 2, null));
        this.addKeystrokesForAction($this$buildKeystrokeMap_u24lambda_u2d1, "$Copy", new AndroidKeyStroke(278, 0, 2, null));
        this.addKeystrokesForAction($this$buildKeystrokeMap_u24lambda_u2d1, "$Paste", new AndroidKeyStroke(279, 0, 2, null));
        this.addKeystrokesForAction($this$buildKeystrokeMap_u24lambda_u2d1, "$SelectAll", new AndroidKeyStroke(29, 4096));
        this.addKeystrokesForAction($this$buildKeystrokeMap_u24lambda_u2d1, "EditorLeft", new AndroidKeyStroke(21, 0, 2, null));
        this.addKeystrokesForAction($this$buildKeystrokeMap_u24lambda_u2d1, "EditorRight", new AndroidKeyStroke(22, 0, 2, null));
        this.addKeystrokesForAction($this$buildKeystrokeMap_u24lambda_u2d1, "EditorLeftWithSelection", new AndroidKeyStroke(21, 1));
        this.addKeystrokesForAction($this$buildKeystrokeMap_u24lambda_u2d1, "EditorRightWithSelection", new AndroidKeyStroke(22, 1));
        this.addKeystrokesForAction($this$buildKeystrokeMap_u24lambda_u2d1, "EditorUp", new AndroidKeyStroke(19, 0, 2, null));
        this.addKeystrokesForAction($this$buildKeystrokeMap_u24lambda_u2d1, "EditorDown", new AndroidKeyStroke(20, 0, 2, null));
        this.addKeystrokesForAction($this$buildKeystrokeMap_u24lambda_u2d1, "EditorUpWithSelection", new AndroidKeyStroke(19, 1));
        this.addKeystrokesForAction($this$buildKeystrokeMap_u24lambda_u2d1, "EditorDownWithSelection", new AndroidKeyStroke(20, 1));
        this.addKeystrokesForAction($this$buildKeystrokeMap_u24lambda_u2d1, "EditorPreviousWord", new AndroidKeyStroke(21, 4096));
        this.addKeystrokesForAction($this$buildKeystrokeMap_u24lambda_u2d1, "EditorNextWord", new AndroidKeyStroke(22, 4096));
        this.addKeystrokesForAction($this$buildKeystrokeMap_u24lambda_u2d1, "EditorPreviousWordWithSelection", new AndroidKeyStroke(21, 4097));
        this.addKeystrokesForAction($this$buildKeystrokeMap_u24lambda_u2d1, "EditorNextWordWithSelection", new AndroidKeyStroke(22, 4097));
        this.addKeystrokesForAction($this$buildKeystrokeMap_u24lambda_u2d1, "EditorLineStart", new AndroidKeyStroke(122, 0, 2, null));
        this.addKeystrokesForAction($this$buildKeystrokeMap_u24lambda_u2d1, "EditorLineEnd", new AndroidKeyStroke(123, 0, 2, null));
        this.addKeystrokesForAction($this$buildKeystrokeMap_u24lambda_u2d1, "EditorLineStartWithSelection", new AndroidKeyStroke(122, 1));
        this.addKeystrokesForAction($this$buildKeystrokeMap_u24lambda_u2d1, "EditorLineEndWithSelection", new AndroidKeyStroke(123, 1));
        this.addKeystrokesForAction($this$buildKeystrokeMap_u24lambda_u2d1, "EditorPageUp", new AndroidKeyStroke(92, 0, 2, null));
        this.addKeystrokesForAction($this$buildKeystrokeMap_u24lambda_u2d1, "EditorPageDown", new AndroidKeyStroke(93, 0, 2, null));
        this.addKeystrokesForAction($this$buildKeystrokeMap_u24lambda_u2d1, "EditorPageUpWithSelection", new AndroidKeyStroke(92, 1));
        this.addKeystrokesForAction($this$buildKeystrokeMap_u24lambda_u2d1, "EditorPageDownWithSelection", new AndroidKeyStroke(93, 1));
        this.addKeystrokesForAction($this$buildKeystrokeMap_u24lambda_u2d1, "EditorTextStart", new AndroidKeyStroke(122, 4096));
        this.addKeystrokesForAction($this$buildKeystrokeMap_u24lambda_u2d1, "EditorTextEnd", new AndroidKeyStroke(123, 4096));
        this.addKeystrokesForAction($this$buildKeystrokeMap_u24lambda_u2d1, "EditorTextStartWithSelection", new AndroidKeyStroke(122, 4097));
        this.addKeystrokesForAction($this$buildKeystrokeMap_u24lambda_u2d1, "EditorTextEndWithSelection", new AndroidKeyStroke(123, 4097));
        return map2;
    }

    private final void addKeystrokesForAction(Map<KeyStroke, AndroidKeyStroke> $this$addKeystrokesForAction, String actionId, AndroidKeyStroke androidKeystroke) {
        for (KeyStroke keyStroke : KeymapUtil.getKeyStrokes((ShortcutSet)KeymapUtil.getActiveKeymapShortcuts((String)actionId))) {
            Intrinsics.checkNotNullExpressionValue((Object)keyStroke, (String)"keyStroke");
            $this$addKeystrokesForAction.put(keyStroke, androidKeystroke);
        }
    }

    public static final /* synthetic */ Object access$initializeAgent(DeviceView $this, Dimension maxOutputSize, int initialDisplayOrientation, Continuation $completion) {
        return $this.initializeAgent(maxOutputSize, initialDisplayOrientation, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ boolean access$getDisposed$p(DeviceView $this) {
        return $this.disposed;
    }

    public static final /* synthetic */ void access$setDeviceClient$p(DeviceView $this, DeviceClient deviceClient) {
        $this.deviceClient = deviceClient;
    }

    public static final /* synthetic */ void access$setClipboardSynchronizer$p(DeviceView $this, DeviceClipboardSynchronizer deviceClipboardSynchronizer) {
        $this.clipboardSynchronizer = deviceClipboardSynchronizer;
    }

    public static final /* synthetic */ void access$updateVideoSize(DeviceView $this) {
        $this.updateVideoSize();
    }

    public static final /* synthetic */ DeviceClient access$getDeviceClient$p(DeviceView $this) {
        return $this.deviceClient;
    }

    public static final /* synthetic */ void access$setConnectionState(DeviceView $this, ConnectionState value2) {
        $this.setConnectionState(value2);
    }

    public static final /* synthetic */ void access$showDisconnectedStateMessage(DeviceView $this, String message2, AbstractDisplayView.Reconnector reconnector) {
        $this.showDisconnectedStateMessage(message2, reconnector);
    }

    public static final /* synthetic */ Dimension access$computeMaxImageSize(DeviceView $this) {
        return $this.computeMaxImageSize();
    }

    public static final /* synthetic */ double access$roundScale(DeviceView $this, double value2) {
        return $this.roundScale(value2);
    }

    public static final /* synthetic */ void access$setDisplayRectangle(DeviceView $this, Rectangle rectangle) {
        $this.setDisplayRectangle(rectangle);
    }

    public static final /* synthetic */ AffineTransform access$getDisplayTransform$p(DeviceView $this) {
        return $this.displayTransform;
    }

    public static final /* synthetic */ void access$setDisplayOrientationQuadrants$p(DeviceView $this, int n) {
        $this.displayOrientationQuadrants = n;
    }

    public static final /* synthetic */ void access$setDisplayOrientationCorrectionQuadrants$p(DeviceView $this, int n) {
        $this.displayOrientationCorrectionQuadrants = n;
    }

    public static final /* synthetic */ void access$setFrameNumber(DeviceView $this, int n) {
        $this.setFrameNumber(n);
    }

    public static final /* synthetic */ void access$notifyFrameListeners(DeviceView $this, Rectangle displayRectangle, BufferedImage frame) {
        $this.notifyFrameListeners(displayRectangle, frame);
    }

    public static final /* synthetic */ void access$hideDisconnectedStateMessage(DeviceView $this) {
        $this.hideDisconnectedStateMessage();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/idea/streaming/device/DeviceView$ConnectionState;", "", "(Ljava/lang/String;I)V", "INITIAL", "CONNECTING", "CONNECTED", "DISCONNECTED", "intellij.android.streaming"})
    public static final class ConnectionState
    extends Enum<ConnectionState> {
        public static final /* enum */ ConnectionState INITIAL = new ConnectionState();
        public static final /* enum */ ConnectionState CONNECTING = new ConnectionState();
        public static final /* enum */ ConnectionState CONNECTED = new ConnectionState();
        public static final /* enum */ ConnectionState DISCONNECTED = new ConnectionState();
        private static final /* synthetic */ ConnectionState[] $VALUES;

        public static ConnectionState[] values() {
            return (ConnectionState[])$VALUES.clone();
        }

        public static ConnectionState valueOf(String value2) {
            return Enum.valueOf(ConnectionState.class, value2);
        }

        static {
            $VALUES = connectionStateArray = new ConnectionState[]{ConnectionState.INITIAL, ConnectionState.CONNECTING, ConnectionState.CONNECTED, ConnectionState.DISCONNECTED};
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H'\u00a8\u0006\b\u00c0\u0006\u0003"}, d2={"Lcom/android/tools/idea/streaming/device/DeviceView$ConnectionStateListener;", "", "connectionStateChanged", "", "deviceSerialNumber", "", "connectionState", "Lcom/android/tools/idea/streaming/device/DeviceView$ConnectionState;", "intellij.android.streaming"})
    public static interface ConnectionStateListener {
        @AnyThread
        public void connectionStateChanged(@NotNull String var1, @NotNull ConnectionState var2);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\b\u0010\u0005\u001a\u00020\u0004H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/idea/streaming/device/DeviceView$MyFrameListener;", "Lcom/android/tools/idea/streaming/device/VideoDecoder$FrameListener;", "(Lcom/android/tools/idea/streaming/device/DeviceView;)V", "onEndOfVideoStream", "", "onNewFrameAvailable", "intellij.android.streaming"})
    private final class MyFrameListener
    implements VideoDecoder.FrameListener {
        @Override
        public void onNewFrameAvailable() {
            EventQueue.invokeLater(new Runnable(DeviceView.this){
                final /* synthetic */ DeviceView this$0;
                {
                    this.this$0 = $receiver;
                }

                public final void run() {
                    if (DeviceView.access$getConnectionState$p(this.this$0) == ConnectionState.CONNECTING) {
                        DeviceView.access$hideDisconnectedStateMessage(this.this$0);
                        DeviceView.access$setConnectionState(this.this$0, ConnectionState.CONNECTED);
                    }
                    if (this.this$0.getWidth() != 0 && this.this$0.getHeight() != 0 && DeviceView.access$getDeviceClient$p(this.this$0) != null) {
                        this.this$0.repaint();
                    }
                }
            });
        }

        @Override
        public void onEndOfVideoStream() {
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002J\u001a\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004H\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J \u0010\u0010\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0004H\u0002J\u0010\u0010\u0013\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004H\u0002\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/idea/streaming/device/DeviceView$MyKeyListener;", "Ljava/awt/event/KeyAdapter;", "(Lcom/android/tools/idea/streaming/device/DeviceView;)V", "hostKeyCodeToDeviceKeyCode", "", "hostKeyCode", "hostKeyStrokeToAndroidKeyStroke", "Lcom/android/tools/idea/streaming/device/AndroidKeyStroke;", "modifiers", "keyPressed", "", "event", "Ljava/awt/event/KeyEvent;", "keyPressedOrReleased", "keyReleased", "keyTyped", "modifierToMetaState", "modifierMask", "metaState", "modifiersToMetaState", "intellij.android.streaming"})
    private final class MyKeyListener
    extends KeyAdapter {
        @Override
        public void keyTyped(@NotNull KeyEvent event) {
            block1: {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                char c = event.getKeyChar();
                if (c == '\uffff' || Character.isISOControl(c)) {
                    return;
                }
                TextInputMessage message2 = new TextInputMessage(String.valueOf(c));
                DeviceController deviceController = DeviceView.this.getDeviceController$intellij_android_streaming();
                if (deviceController == null) break block1;
                deviceController.sendControlMessage(message2);
            }
        }

        @Override
        public void keyPressed(@NotNull KeyEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            this.keyPressedOrReleased(event);
        }

        @Override
        public void keyReleased(@NotNull KeyEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            this.keyPressedOrReleased(event);
        }

        private final void keyPressedOrReleased(KeyEvent event) {
            int keyCode = event.getKeyCode();
            int modifiers = event.getModifiersEx();
            if (keyCode == 17) {
                if (modifiers == 128) {
                    DeviceView.this.setMultiTouchMode(true);
                } else if ((modifiers & 0x80) == 0) {
                    DeviceView.this.setMultiTouchMode(false);
                }
            }
            if (keyCode == 9 && modifiers == 64) {
                if (event.getID() == 401) {
                    Object object = event.getSource();
                    Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type java.awt.Component");
                    KeyEvent tabEvent = new KeyEvent((Component)object, event.getID(), event.getWhen(), 0, keyCode, event.getKeyChar(), event.getKeyLocation());
                    DeviceView.this.traverseFocusLocally(tabEvent);
                }
                return;
            }
            DeviceController deviceController = DeviceView.this.getDeviceController$intellij_android_streaming();
            if (deviceController == null) {
                return;
            }
            DeviceController deviceController2 = deviceController;
            AndroidKeyStroke androidKeystroke = this.hostKeyStrokeToAndroidKeyStroke(keyCode, modifiers);
            if (androidKeystroke == null) {
                int androidKeyCode;
                if (modifiers == 0 && (androidKeyCode = this.hostKeyCodeToDeviceKeyCode(keyCode)) != 0) {
                    AndroidKeyEventActionType action2 = event.getID() == 401 ? AndroidKeyEventActionType.ACTION_DOWN : AndroidKeyEventActionType.ACTION_UP;
                    deviceController2.sendControlMessage(new KeyEventMessage(action2, androidKeyCode, this.modifiersToMetaState(modifiers)));
                }
            } else if (event.getID() == 401) {
                deviceController2.sendKeystroke(androidKeystroke);
            }
            event.consume();
        }

        private final AndroidKeyStroke hostKeyStrokeToAndroidKeyStroke(int hostKeyCode, int modifiers) {
            int n;
            switch (hostKeyCode) {
                case 226: {
                    n = 37;
                    break;
                }
                case 227: {
                    n = 39;
                    break;
                }
                case 224: {
                    n = 38;
                    break;
                }
                case 225: {
                    n = 40;
                    break;
                }
                default: {
                    n = hostKeyCode;
                }
            }
            int canonicalKeyCode = n;
            return (AndroidKeyStroke)DeviceView.this.getKeyStrokeMap().get(KeyStroke.getKeyStroke(canonicalKeyCode, modifiers));
        }

        private final int hostKeyCodeToDeviceKeyCode(int hostKeyCode) {
            int n;
            switch (hostKeyCode) {
                case 8: {
                    n = 67;
                    break;
                }
                case 127: {
                    if (SystemInfo.isMac) {
                        n = 67;
                        break;
                    }
                    n = 112;
                    break;
                }
                case 10: {
                    n = 66;
                    break;
                }
                case 27: {
                    n = 111;
                    break;
                }
                case 9: {
                    n = 61;
                    break;
                }
                default: {
                    n = 0;
                }
            }
            return n;
        }

        private final int modifiersToMetaState(int modifiers) {
            return this.modifierToMetaState(modifiers, 64, 1) | this.modifierToMetaState(modifiers, 128, 4096) | this.modifierToMetaState(modifiers, 256, 65536) | this.modifierToMetaState(modifiers, 512, 2);
        }

        private final int modifierToMetaState(int modifiers, int modifierMask, int metaState) {
            return (modifiers & modifierMask) != 0 ? metaState : 0;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\r"}, d2={"Lcom/android/tools/idea/streaming/device/DeviceView$MyMouseListener;", "Ljava/awt/event/MouseAdapter;", "(Lcom/android/tools/idea/streaming/device/DeviceView;)V", "mouseDragged", "", "event", "Ljava/awt/event/MouseEvent;", "mouseEntered", "mouseExited", "mouseMoved", "mousePressed", "mouseReleased", "updateMultiTouchMode", "intellij.android.streaming"})
    private final class MyMouseListener
    extends MouseAdapter {
        @Override
        public void mousePressed(@NotNull MouseEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            DeviceView.this.requestFocusInWindow();
            if (DeviceView.this.isInsideDisplay(event) && event.getButton() == 1) {
                Point point = StreamingUtilsKt.getLocation(event);
                DeviceView deviceView = DeviceView.this;
                Point it = point;
                boolean bl = false;
                deviceView.lastTouchCoordinates = it;
                this.updateMultiTouchMode(event);
                deviceView.sendMotionEvent(it, 0);
            }
        }

        @Override
        public void mouseReleased(@NotNull MouseEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (event.getButton() == 1) {
                DeviceView.this.lastTouchCoordinates = null;
                this.updateMultiTouchMode(event);
                DeviceView.this.sendMotionEvent(StreamingUtilsKt.getLocation(event), 1);
            }
        }

        @Override
        public void mouseEntered(@NotNull MouseEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            this.updateMultiTouchMode(event);
        }

        @Override
        public void mouseExited(@NotNull MouseEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if ((event.getModifiersEx() & 0x400) != 0 && DeviceView.this.lastTouchCoordinates != null) {
                DeviceView.this.sendMotionEvent(StreamingUtilsKt.getLocation(event), 2);
            }
            DeviceView.this.lastTouchCoordinates = null;
            DeviceView.this.setMultiTouchMode(false);
        }

        @Override
        public void mouseDragged(@NotNull MouseEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            this.updateMultiTouchMode(event);
            if ((event.getModifiersEx() & 0x400) != 0 && DeviceView.this.lastTouchCoordinates != null) {
                DeviceView.this.sendMotionEvent(StreamingUtilsKt.getLocation(event), 2);
            }
        }

        @Override
        public void mouseMoved(@NotNull MouseEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            this.updateMultiTouchMode(event);
        }

        private final void updateMultiTouchMode(MouseEvent event) {
            boolean oldMultiTouchMode = DeviceView.this.multiTouchMode;
            DeviceView.this.setMultiTouchMode(DeviceView.this.isInsideDisplay(event) && (event.getModifiersEx() & 0x80) != 0);
            if (DeviceView.this.multiTouchMode && oldMultiTouchMode) {
                DeviceView.this.repaint();
            }
        }
    }
}

