/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.streaming.device;

import com.android.annotations.concurrency.AnyThread;
import com.android.tools.adtui.ZoomableKt;
import com.android.tools.adtui.common.StudioColorsKt;
import com.android.tools.adtui.util.ActionToolbarUtil;
import com.android.tools.idea.streaming.AbstractDisplayPanel;
import com.android.tools.idea.streaming.DeviceFileDropHandlerKt;
import com.android.tools.idea.streaming.DeviceId;
import com.android.tools.idea.streaming.RunningDevicePanel;
import com.android.tools.idea.streaming.device.DeviceConfiguration;
import com.android.tools.idea.streaming.device.DeviceConstants;
import com.android.tools.idea.streaming.device.DeviceDisplayPanel;
import com.android.tools.idea.streaming.device.DeviceToolWindowPanelKt;
import com.android.tools.idea.streaming.device.DeviceView;
import com.android.tools.idea.streaming.device.screenshot.DeviceScreenshotOptions;
import com.android.tools.idea.ui.screenrecording.ScreenRecorderAction;
import com.android.tools.idea.ui.screenshot.ScreenshotAction;
import com.google.wireless.android.sdk.stats.DeviceMirroringSession;
import com.intellij.ide.ui.customization.CustomActionsSchema;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001:\u0001AB9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\t\u00a2\u0006\u0002\u0010\nJ\u001a\u00102\u001a\u0002032\u0006\u00104\u001a\u00020$2\b\u00105\u001a\u0004\u0018\u000106H\u0016J\u0018\u00107\u001a\u00020'2\u0006\u00108\u001a\u00020\u00052\u0006\u00109\u001a\u00020$H\u0002J\b\u0010:\u001a\u00020;H\u0016J\u0012\u0010<\u001a\u0004\u0018\u00010=2\u0006\u0010>\u001a\u00020\u0005H\u0016J\u0010\u0010?\u001a\u0002032\u0006\u0010@\u001a\u00020$H\u0016R\u0014\u0010\u000b\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0016\u0010\u000f\u001a\u0004\u0018\u00010\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0014\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u001e\u001a\u00070\u001f\u00a2\u0006\u0002\b 8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0014\u0010#\u001a\u00020$X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010%R\u000e\u0010&\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010(\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010\u0017R\u0010\u0010*\u001a\u0004\u0018\u00010+X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010\u0011R$\u0010.\u001a\u00020$2\u0006\u0010-\u001a\u00020$@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u0010%\"\u0004\b0\u00101\u00a8\u0006B"}, d2={"Lcom/android/tools/idea/streaming/device/DeviceToolWindowPanel;", "Lcom/android/tools/idea/streaming/RunningDevicePanel;", "project", "Lcom/intellij/openapi/project/Project;", "deviceSerialNumber", "", "deviceAbi", "title", "deviceProperties", "", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/Map;)V", "apiLevel", "", "getApiLevel", "()I", "avdName", "getAvdName", "()Ljava/lang/String;", "centerPanel", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "component", "Ljavax/swing/JComponent;", "getComponent", "()Ljavax/swing/JComponent;", "contentDisposable", "Lcom/intellij/openapi/Disposable;", "deviceConfiguration", "Lcom/android/tools/idea/streaming/device/DeviceConfiguration;", "displayPanel", "Lcom/android/tools/idea/streaming/device/DeviceDisplayPanel;", "icon", "Ljavax/swing/Icon;", "Lorg/jetbrains/annotations/NotNull;", "getIcon", "()Ljavax/swing/Icon;", "isClosable", "", "()Z", "mainToolbar", "Lcom/intellij/openapi/actionSystem/ActionToolbar;", "preferredFocusableComponent", "getPreferredFocusableComponent", "primaryDeviceView", "Lcom/android/tools/idea/streaming/device/DeviceView;", "getTitle", "value", "zoomToolbarVisible", "getZoomToolbarVisible", "setZoomToolbarVisible", "(Z)V", "createContent", "", "deviceFrameVisible", "savedUiState", "Lcom/android/tools/idea/streaming/RunningDevicePanel$UiState;", "createToolbar", "toolbarId", "horizontal", "destroyContent", "Lcom/android/tools/idea/streaming/device/DeviceToolWindowPanel$DeviceUiState;", "getData", "", "dataId", "setDeviceFrameVisible", "visible", "DeviceUiState", "intellij.android.streaming"})
public final class DeviceToolWindowPanel
extends RunningDevicePanel {
    @NotNull
    private final Project project;
    @NotNull
    private final String deviceSerialNumber;
    @NotNull
    private final String deviceAbi;
    @NotNull
    private final String title;
    @NotNull
    private final ActionToolbar mainToolbar;
    @NotNull
    private final BorderLayoutPanel centerPanel;
    @Nullable
    private DeviceDisplayPanel displayPanel;
    @Nullable
    private Disposable contentDisposable;
    @Nullable
    private DeviceView primaryDeviceView;
    private final boolean isClosable;
    @NotNull
    private final DeviceConfiguration deviceConfiguration;
    private boolean zoomToolbarVisible;

    public DeviceToolWindowPanel(@NotNull Project project, @NotNull String deviceSerialNumber, @NotNull String deviceAbi, @NotNull String title, @NotNull Map<String, String> deviceProperties) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)deviceSerialNumber, (String)"deviceSerialNumber");
        Intrinsics.checkNotNullParameter((Object)deviceAbi, (String)"deviceAbi");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter(deviceProperties, (String)"deviceProperties");
        super(DeviceId.Companion.ofPhysicalDevice(deviceSerialNumber));
        this.project = project;
        this.deviceSerialNumber = deviceSerialNumber;
        this.deviceAbi = deviceAbi;
        this.title = title;
        this.centerPanel = new BorderLayoutPanel();
        this.deviceConfiguration = new DeviceConfiguration(deviceProperties);
        this.setBackground((Color)StudioColorsKt.getPrimaryPanelBackground());
        this.mainToolbar = this.createToolbar("DeviceToolbar", true);
        this.addToCenter((Component)this.centerPanel);
        this.mainToolbar.setOrientation(0);
        this.centerPanel.setBorder(IdeBorderFactory.createBorder((Color)JBColor.border(), (int)2));
        this.addToTop(this.mainToolbar.getComponent());
    }

    @Override
    @NotNull
    public String getTitle() {
        return this.title;
    }

    @Override
    @NotNull
    public Icon getIcon() {
        return DeviceToolWindowPanelKt.access$getICON$p();
    }

    @Override
    public boolean isClosable() {
        return this.isClosable;
    }

    @NotNull
    public final JComponent getComponent() {
        return (JComponent)((Object)this);
    }

    private final int getApiLevel() {
        return this.deviceConfiguration.getApiLevel();
    }

    private final String getAvdName() {
        return this.deviceConfiguration.getAvdName();
    }

    @Override
    @NotNull
    public JComponent getPreferredFocusableComponent() {
        DeviceView deviceView = this.primaryDeviceView;
        return deviceView != null ? (JComponent)((Object)deviceView) : (JComponent)((Object)this);
    }

    @Override
    public boolean getZoomToolbarVisible() {
        return this.zoomToolbarVisible;
    }

    @Override
    public void setZoomToolbarVisible(boolean value2) {
        this.zoomToolbarVisible = value2;
        DeviceDisplayPanel deviceDisplayPanel = this.displayPanel;
        if (deviceDisplayPanel != null) {
            deviceDisplayPanel.setZoomToolbarVisible(value2);
        }
    }

    @Override
    public void setDeviceFrameVisible(boolean visible) {
    }

    @Override
    public void createContent(boolean deviceFrameVisible, @Nullable RunningDevicePanel.UiState savedUiState) {
        DeviceView deviceView;
        Disposable disposable2;
        this.mirroringStarted();
        Disposable disposable3 = Disposer.newDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable3, (String)"newDisposable()");
        this.contentDisposable = disposable2 = disposable3;
        DeviceUiState cfr_ignored_0 = (DeviceUiState)savedUiState;
        DeviceUiState deviceUiState = (DeviceUiState)savedUiState;
        int initialOrientation = deviceUiState != null ? deviceUiState.getOrientation() : -1;
        DeviceDisplayPanel primaryDisplayPanel = new DeviceDisplayPanel(disposable2, this.deviceSerialNumber, this.deviceAbi, this.getTitle(), initialOrientation, this.project, this.getZoomToolbarVisible());
        Object object = (DeviceUiState)savedUiState;
        if (object != null && (object = ((DeviceUiState)object).getZoomScrollState()) != null) {
            Object it = object;
            boolean bl = false;
            primaryDisplayPanel.setZoomScrollState$intellij_android_streaming((AbstractDisplayPanel.ZoomScrollState)it);
        }
        this.displayPanel = primaryDisplayPanel;
        this.primaryDeviceView = deviceView = (DeviceView)primaryDisplayPanel.getDisplayView();
        this.mainToolbar.setTargetComponent((JComponent)((Object)deviceView));
        this.centerPanel.addToCenter((Component)((Object)primaryDisplayPanel));
        deviceView.addConnectionStateListener(new DeviceView.ConnectionStateListener(this){
            final /* synthetic */ DeviceToolWindowPanel this$0;
            {
                this.this$0 = $receiver;
            }

            @AnyThread
            public void connectionStateChanged(@NotNull String deviceSerialNumber, @NotNull DeviceView.ConnectionState connectionState) {
                Intrinsics.checkNotNullParameter((Object)deviceSerialNumber, (String)"deviceSerialNumber");
                Intrinsics.checkNotNullParameter((Object)((Object)connectionState), (String)"connectionState");
                EventQueue.invokeLater(new Runnable(this.this$0){
                    final /* synthetic */ DeviceToolWindowPanel this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    public final void run() {
                        DeviceToolWindowPanel.access$getMainToolbar$p(this.this$0).updateActionsImmediately();
                    }
                });
            }
        });
        DeviceFileDropHandlerKt.installFileDropHandler((JComponent)((Object)this), this.getId().getSerialNumber(), deviceView, this.project);
    }

    @Override
    @NotNull
    public DeviceUiState destroyContent() {
        this.mirroringEnded(DeviceMirroringSession.DeviceKind.PHYSICAL);
        DeviceUiState uiState = new DeviceUiState();
        DeviceView deviceView = this.primaryDeviceView;
        uiState.setOrientation(deviceView != null ? deviceView.getDisplayOrientationQuadrants() : 0);
        DeviceDisplayPanel deviceDisplayPanel = this.displayPanel;
        uiState.setZoomScrollState(deviceDisplayPanel != null ? deviceDisplayPanel.getZoomScrollState$intellij_android_streaming() : null);
        Disposable disposable2 = this.contentDisposable;
        if (disposable2 != null) {
            Disposable it = disposable2;
            boolean bl = false;
            Disposer.dispose((Disposable)it);
        }
        this.contentDisposable = null;
        this.centerPanel.removeAll();
        this.displayPanel = null;
        this.primaryDeviceView = null;
        this.mainToolbar.setTargetComponent((JComponent)((Object)this));
        return uiState;
    }

    @Override
    @Nullable
    public Object getData(@NotNull String dataId) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
        String string = dataId;
        if (Intrinsics.areEqual((Object)string, (Object)DeviceConstants.DEVICE_VIEW_KEY.getName()) ? true : Intrinsics.areEqual((Object)string, (Object)ZoomableKt.ZOOMABLE_KEY.getName())) {
            object = this.primaryDeviceView;
        } else if (Intrinsics.areEqual((Object)string, (Object)DeviceConstants.DEVICE_CONTROLLER_KEY.getName())) {
            DeviceView deviceView = this.primaryDeviceView;
            object = deviceView != null ? deviceView.getDeviceController$intellij_android_streaming() : null;
        } else if (Intrinsics.areEqual((Object)string, (Object)DeviceConstants.DEVICE_CONFIGURATION_KEY.getName())) {
            object = this.deviceConfiguration;
        } else if (Intrinsics.areEqual((Object)string, (Object)ScreenshotAction.Companion.getSCREENSHOT_OPTIONS_KEY().getName())) {
            DeviceView deviceView = this.primaryDeviceView;
            if (deviceView != null) {
                DeviceView it = deviceView;
                boolean bl = false;
                object = it.isConnected() ? new DeviceScreenshotOptions(this.deviceSerialNumber, this.deviceConfiguration, it) : null;
            } else {
                object = null;
            }
        } else if (Intrinsics.areEqual((Object)string, (Object)ScreenRecorderAction.Companion.getSCREEN_RECORDER_PARAMETERS_KEY().getName())) {
            DeviceView deviceView = this.primaryDeviceView;
            if (deviceView != null) {
                DeviceView it = deviceView;
                boolean bl = false;
                object = new ScreenRecorderAction.Parameters(this.deviceSerialNumber, this.deviceConfiguration.getApiLevel(), this.deviceConfiguration.getAvdName(), it);
            } else {
                object = null;
            }
        } else {
            object = super.getData(dataId);
        }
        return object;
    }

    private final ActionToolbar createToolbar(String toolbarId, boolean horizontal) {
        AnAction anAction = CustomActionsSchema.getInstance().getCorrectedAction(toolbarId);
        Intrinsics.checkNotNull((Object)anAction);
        List actions2 = CollectionsKt.listOf((Object)anAction);
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar(toolbarId, (ActionGroup)new DefaultActionGroup(actions2), horizontal);
        Intrinsics.checkNotNullExpressionValue((Object)actionToolbar, (String)"getInstance().createActi\u2026oup(actions), horizontal)");
        ActionToolbar toolbar2 = actionToolbar;
        toolbar2.setLayoutPolicy(2);
        toolbar2.setTargetComponent((JComponent)((Object)this));
        ActionToolbarUtil.makeToolbarNavigable((ActionToolbar)toolbar2);
        return toolbar2;
    }

    public static final /* synthetic */ ActionToolbar access$getMainToolbar$p(DeviceToolWindowPanel $this) {
        return $this.mainToolbar;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/idea/streaming/device/DeviceToolWindowPanel$DeviceUiState;", "Lcom/android/tools/idea/streaming/RunningDevicePanel$UiState;", "()V", "orientation", "", "getOrientation", "()I", "setOrientation", "(I)V", "zoomScrollState", "Lcom/android/tools/idea/streaming/AbstractDisplayPanel$ZoomScrollState;", "getZoomScrollState", "()Lcom/android/tools/idea/streaming/AbstractDisplayPanel$ZoomScrollState;", "setZoomScrollState", "(Lcom/android/tools/idea/streaming/AbstractDisplayPanel$ZoomScrollState;)V", "intellij.android.streaming"})
    public static final class DeviceUiState
    implements RunningDevicePanel.UiState {
        private int orientation;
        @Nullable
        private AbstractDisplayPanel.ZoomScrollState zoomScrollState;

        public final int getOrientation() {
            return this.orientation;
        }

        public final void setOrientation(int n) {
            this.orientation = n;
        }

        @Nullable
        public final AbstractDisplayPanel.ZoomScrollState getZoomScrollState() {
            return this.zoomScrollState;
        }

        public final void setZoomScrollState(@Nullable AbstractDisplayPanel.ZoomScrollState zoomScrollState) {
            this.zoomScrollState = zoomScrollState;
        }
    }
}

