/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.streaming.device;

import com.android.annotations.concurrency.AnyThread;
import com.android.tools.idea.concurrency.CoroutinesUtilsKt;
import com.android.tools.idea.streaming.device.AndroidKeyEventActionType;
import com.android.tools.idea.streaming.device.AndroidKeyStroke;
import com.android.tools.idea.streaming.device.ClipboardChangedNotification;
import com.android.tools.idea.streaming.device.ControlMessage;
import com.android.tools.idea.streaming.device.DeviceControllerKt;
import com.android.tools.idea.streaming.device.KeyEventMessage;
import com.android.tools.idea.streaming.device.SuspendingChannelsKt;
import com.android.tools.idea.streaming.device.SuspendingInputStream;
import com.android.tools.idea.streaming.device.SuspendingSocketChannel;
import com.android.utils.Base128InputStream;
import com.android.utils.Base128OutputStream;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001'B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\bJ\b\u0010\u0017\u001a\u00020\u0015H\u0016J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u000e\u0010\u001f\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\bJ\u0010\u0010 \u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020!H\u0002J\u000e\u0010\"\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020!J\u000e\u0010#\u001a\u00020\u00152\u0006\u0010$\u001a\u00020%J\b\u0010&\u001a\u00020\u0015H\u0002R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/android/tools/idea/streaming/device/DeviceController;", "Lcom/intellij/openapi/Disposable;", "disposableParent", "controlChannel", "Lcom/android/tools/idea/streaming/device/SuspendingSocketChannel;", "(Lcom/intellij/openapi/Disposable;Lcom/android/tools/idea/streaming/device/SuspendingSocketChannel;)V", "deviceClipboardListeners", "", "Lcom/android/tools/idea/streaming/device/DeviceController$DeviceClipboardListener;", "executor", "Ljava/util/concurrent/ExecutorService;", "Lorg/jetbrains/annotations/NotNull;", "inputStream", "Lcom/android/utils/Base128InputStream;", "outputStream", "Lcom/android/utils/Base128OutputStream;", "receiverScope", "Lkotlinx/coroutines/CoroutineScope;", "suspendingInputStream", "Lcom/android/tools/idea/streaming/device/SuspendingInputStream;", "addDeviceClipboardListener", "", "listener", "dispose", "onDeviceClipboardChanged", "message", "Lcom/android/tools/idea/streaming/device/ClipboardChangedNotification;", "pressMetaKeys", "metaState", "", "releaseMetaKeys", "removeDeviceClipboardListener", "send", "Lcom/android/tools/idea/streaming/device/ControlMessage;", "sendControlMessage", "sendKeystroke", "androidKeystroke", "Lcom/android/tools/idea/streaming/device/AndroidKeyStroke;", "startReceivingMessages", "DeviceClipboardListener", "intellij.android.streaming"})
public final class DeviceController
implements Disposable {
    @NotNull
    private final ExecutorService executor;
    @NotNull
    private final Base128OutputStream outputStream;
    @NotNull
    private final SuspendingInputStream suspendingInputStream;
    @NotNull
    private final Base128InputStream inputStream;
    @NotNull
    private final CoroutineScope receiverScope;
    @NotNull
    private final List<DeviceClipboardListener> deviceClipboardListeners;

    public DeviceController(@NotNull Disposable disposableParent, @NotNull SuspendingSocketChannel controlChannel) {
        Intrinsics.checkNotNullParameter((Object)disposableParent, (String)"disposableParent");
        Intrinsics.checkNotNullParameter((Object)controlChannel, (String)"controlChannel");
        ExecutorService executorService = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)this.getClass().getSimpleName(), (int)1);
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"createBoundedApplication\u2026(javaClass.simpleName, 1)");
        this.executor = executorService;
        this.outputStream = new Base128OutputStream(SuspendingChannelsKt.newOutputStream(controlChannel, 4096));
        this.suspendingInputStream = SuspendingChannelsKt.newInputStream(controlChannel, 4096);
        this.inputStream = new Base128InputStream((InputStream)this.suspendingInputStream);
        this.receiverScope = CoroutinesUtilsKt.AndroidCoroutineScope$default((Disposable)this, null, (int)2, null);
        List list2 = ContainerUtil.createLockFreeCopyOnWriteList();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"createLockFreeCopyOnWriteList()");
        this.deviceClipboardListeners = list2;
        Disposer.register((Disposable)disposableParent, (Disposable)this);
        this.startReceivingMessages();
    }

    public final void sendControlMessage(@NotNull ControlMessage message2) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        this.executor.submit(new Runnable(this, message2){
            final /* synthetic */ DeviceController this$0;
            final /* synthetic */ ControlMessage $message;
            {
                this.this$0 = $receiver;
                this.$message = $message;
            }

            public final void run() {
                DeviceController.access$send(this.this$0, this.$message);
            }
        });
    }

    private final void send(ControlMessage message2) {
        message2.serialize(this.outputStream);
        this.outputStream.flush();
    }

    public final void sendKeystroke(@NotNull AndroidKeyStroke androidKeystroke) {
        Intrinsics.checkNotNullParameter((Object)androidKeystroke, (String)"androidKeystroke");
        this.pressMetaKeys(androidKeystroke.getMetaState());
        this.sendControlMessage(new KeyEventMessage(AndroidKeyEventActionType.ACTION_DOWN_AND_UP, androidKeystroke.getKeyCode(), androidKeystroke.getMetaState()));
        this.releaseMetaKeys(androidKeystroke.getMetaState());
    }

    private final void pressMetaKeys(int metaState) {
        if (metaState != 0) {
            int currentMetaState = 0;
            for (AndroidKeyStroke androidKeyStroke : DeviceControllerKt.access$getANDROID_META_KEYS$p()) {
                int key = androidKeyStroke.component1();
                int state2 = androidKeyStroke.component2();
                if ((metaState & state2) == 0) continue;
                this.sendControlMessage(new KeyEventMessage(AndroidKeyEventActionType.ACTION_DOWN, key, currentMetaState |= state2));
                if (currentMetaState != metaState) continue;
                break;
            }
        }
    }

    private final void releaseMetaKeys(int metaState) {
        if (metaState != 0) {
            int currentMetaState = metaState;
            for (AndroidKeyStroke androidKeyStroke : CollectionsKt.asReversed((List)DeviceControllerKt.access$getANDROID_META_KEYS$p())) {
                int key = androidKeyStroke.component1();
                int state2 = androidKeyStroke.component2();
                if ((currentMetaState & state2) == 0) continue;
                this.sendControlMessage(new KeyEventMessage(AndroidKeyEventActionType.ACTION_UP, key, currentMetaState &= ~state2));
                if (currentMetaState != 0) continue;
                break;
            }
        }
    }

    public void dispose() {
        this.executor.shutdown();
        this.executor.awaitTermination(2L, TimeUnit.SECONDS);
    }

    public final void addDeviceClipboardListener(@NotNull DeviceClipboardListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.deviceClipboardListeners.add(listener2);
    }

    public final void removeDeviceClipboardListener(@NotNull DeviceClipboardListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.deviceClipboardListeners.remove(listener2);
    }

    private final void startReceivingMessages() {
        BuildersKt.launch$default((CoroutineScope)this.receiverScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ DeviceController this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var5_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        $this$launch = (CoroutineScope)this.L$0;
lbl7:
                        // 3 sources

                        while (true) {
                            this.L$0 = $this$launch;
                            this.label = 1;
                            v0 = SuspendingInputStream.waitForData$default(DeviceController.access$getSuspendingInputStream$p(this.this$0), 1, 0L, null, (Continuation)this, 6, null);
                            ** if (v0 != var5_2) goto lbl15
lbl14:
                            // 1 sources

                            return var5_2;
lbl15:
                            // 1 sources

                            ** GOTO lbl22
                            break;
                        }
                    }
                    case 1: {
                        $this$launch = (CoroutineScope)this.L$0;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl22:
                            // 2 sources

                            if (!((message = ControlMessage.Companion.deserialize(DeviceController.access$getInputStream$p(this.this$0))) instanceof ClipboardChangedNotification)) ** GOTO lbl25
                            DeviceController.access$onDeviceClipboardChanged(this.this$0, (ClipboardChangedNotification)message);
                            ** GOTO lbl7
lbl25:
                            // 1 sources

                            $i$f$thisLogger = false;
                            v1 = Logger.getInstance(CoroutineScope.class);
                            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"Logger.getInstance(T::class.java)");
                            v1.error("Unexpected type of a received message: " + message.getType());
                            ** continue;
                        }
                        catch (EOFException message) {
                        }
                        catch (IOException e) {
                            if (Intrinsics.areEqual((Object)e.getMessage(), (Object)"Connection reset by peer")) ** GOTO lbl35
                            throw e;
                        }
lbl35:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value2;
                return (Continuation)var3_3;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final void onDeviceClipboardChanged(ClipboardChangedNotification message2) {
        String text2 = message2.getText();
        for (DeviceClipboardListener listener2 : this.deviceClipboardListeners) {
            listener2.onDeviceClipboardChanged(text2);
        }
    }

    public static final /* synthetic */ void access$send(DeviceController $this, ControlMessage message2) {
        $this.send(message2);
    }

    public static final /* synthetic */ SuspendingInputStream access$getSuspendingInputStream$p(DeviceController $this) {
        return $this.suspendingInputStream;
    }

    public static final /* synthetic */ Base128InputStream access$getInputStream$p(DeviceController $this) {
        return $this.inputStream;
    }

    public static final /* synthetic */ void access$onDeviceClipboardChanged(DeviceController $this, ClipboardChangedNotification message2) {
        $this.onDeviceClipboardChanged(message2);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H'\u00a8\u0006\u0006\u00c0\u0006\u0003"}, d2={"Lcom/android/tools/idea/streaming/device/DeviceController$DeviceClipboardListener;", "", "onDeviceClipboardChanged", "", "text", "", "intellij.android.streaming"})
    public static interface DeviceClipboardListener {
        @AnyThread
        public void onDeviceClipboardChanged(@NotNull String var1);
    }
}

