/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.streaming.device;

import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0006\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0013\u0010\n\u001a\u0004\u0018\u00010\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\r\u001a\u0004\u0018\u00010\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\fR\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0012X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0014R\u0011\u0010\u0016\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0014\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/idea/streaming/device/DeviceConfiguration;", "", "deviceProperties", "", "", "(Ljava/util/Map;)V", "apiLevel", "", "getApiLevel", "()I", "avdName", "getAvdName", "()Ljava/lang/String;", "deviceModel", "getDeviceModel", "getDeviceProperties", "()Ljava/util/Map;", "hasOrientationSensors", "", "getHasOrientationSensors", "()Z", "isAutomotive", "isWatch", "intellij.android.streaming"})
public final class DeviceConfiguration {
    @NotNull
    private final Map<String, String> deviceProperties;
    private final boolean hasOrientationSensors;

    public DeviceConfiguration(@NotNull Map<String, String> deviceProperties) {
        Intrinsics.checkNotNullParameter(deviceProperties, (String)"deviceProperties");
        this.deviceProperties = deviceProperties;
        this.hasOrientationSensors = true;
    }

    @NotNull
    public final Map<String, String> getDeviceProperties() {
        return this.deviceProperties;
    }

    public final int getApiLevel() {
        String string = this.deviceProperties.get("ro.build.version.sdk");
        return string != null ? Integer.parseInt(string) : 33;
    }

    @Nullable
    public final String getAvdName() {
        String string = this.deviceProperties.get("ro.boot.qemu.avd_name");
        if (string == null) {
            string = this.deviceProperties.get("ro.kernel.qemu.avd_name");
        }
        return string;
    }

    @Nullable
    public final String getDeviceModel() {
        return this.deviceProperties.get("ro.product.model");
    }

    public final boolean isWatch() {
        String string = this.deviceProperties.get("ro.build.characteristics");
        return string != null ? StringsKt.contains$default((CharSequence)string, (CharSequence)"watch", (boolean)false, (int)2, null) : false;
    }

    public final boolean isAutomotive() {
        String string = this.deviceProperties.get("ro.build.characteristics");
        return string != null ? StringsKt.contains$default((CharSequence)string, (CharSequence)"automotive", (boolean)false, (int)2, null) : false;
    }

    public final boolean getHasOrientationSensors() {
        return this.hasOrientationSensors;
    }
}

