/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.streaming.device;

import com.android.annotations.concurrency.AnyThread;
import com.android.annotations.concurrency.UiThread;
import com.android.tools.idea.streaming.DeviceMirroringSettings;
import com.android.tools.idea.streaming.device.DeviceController;
import com.android.tools.idea.streaming.device.StartClipboardSyncMessage;
import com.android.tools.idea.streaming.device.StopClipboardSyncMessage;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ui.UIUtil;
import java.awt.KeyboardFocusManager;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001c\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0011H\u0017J\b\u0010\u0013\u001a\u00020\u000fH\u0017J\b\u0010\u0014\u001a\u00020\rH\u0003J\u0010\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\rH\u0017J\u0010\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\rH\u0003J\b\u0010\u0018\u001a\u00020\u000fH\u0007J\u000e\u0010\u0019\u001a\u0004\u0018\u00010\r*\u00020\u0011H\u0002R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/android/tools/idea/streaming/device/DeviceClipboardSynchronizer;", "Lcom/intellij/openapi/ide/CopyPasteManager$ContentChangedListener;", "Lcom/android/tools/idea/streaming/device/DeviceController$DeviceClipboardListener;", "Lcom/intellij/openapi/Disposable;", "deviceController", "Lcom/android/tools/idea/streaming/device/DeviceController;", "(Lcom/android/tools/idea/streaming/device/DeviceController;)V", "copyPasteManager", "Lcom/intellij/openapi/ide/CopyPasteManager;", "kotlin.jvm.PlatformType", "focusOwnerListener", "Ljava/beans/PropertyChangeListener;", "lastClipboardText", "", "contentChanged", "", "oldTransferable", "Ljava/awt/datatransfer/Transferable;", "newTransferable", "dispose", "getClipboardText", "onDeviceClipboardChanged", "text", "sendClipboardSyncMessage", "setDeviceClipboard", "getText", "intellij.android.streaming"})
public final class DeviceClipboardSynchronizer
implements CopyPasteManager.ContentChangedListener,
DeviceController.DeviceClipboardListener,
Disposable {
    @NotNull
    private final DeviceController deviceController;
    private final CopyPasteManager copyPasteManager;
    @NotNull
    private String lastClipboardText;
    @NotNull
    private final PropertyChangeListener focusOwnerListener;

    public DeviceClipboardSynchronizer(@NotNull DeviceController deviceController) {
        Intrinsics.checkNotNullParameter((Object)deviceController, (String)"deviceController");
        this.deviceController = deviceController;
        this.copyPasteManager = CopyPasteManager.getInstance();
        this.lastClipboardText = "";
        this.focusOwnerListener = new PropertyChangeListener(this){
            final /* synthetic */ DeviceClipboardSynchronizer this$0;
            {
                this.this$0 = $receiver;
            }

            public final void propertyChange(PropertyChangeEvent event) {
                if (event.getNewValue() != null && event.getOldValue() == null) {
                    this.this$0.setDeviceClipboard();
                }
            }
        };
        Disposer.register((Disposable)this.deviceController, (Disposable)this);
        this.copyPasteManager.addContentChangedListener((CopyPasteManager.ContentChangedListener)this, (Disposable)this);
        this.deviceController.addDeviceClipboardListener(this);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener("focusOwner", this.focusOwnerListener);
        this.setDeviceClipboard();
    }

    @UiThread
    public void dispose() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener("focusOwner", this.focusOwnerListener);
        this.deviceController.removeDeviceClipboardListener(this);
        StopClipboardSyncMessage message2 = new StopClipboardSyncMessage();
        this.deviceController.sendControlMessage(message2);
        this.lastClipboardText = "";
    }

    @UiThread
    public final void setDeviceClipboard() {
        String text2 = this.getClipboardText();
        this.sendClipboardSyncMessage(text2);
    }

    @UiThread
    private final void sendClipboardSyncMessage(String text2) {
        StartClipboardSyncMessage message2 = new StartClipboardSyncMessage(DeviceMirroringSettings.Companion.getInstance().getMaxSyncedClipboardLength(), text2);
        this.deviceController.sendControlMessage(message2);
    }

    @UiThread
    private final String getClipboardText() {
        String string;
        DataFlavor[] dataFlavorArray = new DataFlavor[]{DataFlavor.stringFlavor};
        if (this.copyPasteManager.areDataFlavorsAvailable(dataFlavorArray)) {
            string = (String)this.copyPasteManager.getContents(DataFlavor.stringFlavor);
            if (string == null) {
                string = "";
            }
        } else {
            string = "";
        }
        return string;
    }

    @AnyThread
    public void contentChanged(@Nullable Transferable oldTransferable, @Nullable Transferable newTransferable) {
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(newTransferable, this){
            final /* synthetic */ Transferable $newTransferable;
            final /* synthetic */ DeviceClipboardSynchronizer this$0;
            {
                this.$newTransferable = $newTransferable;
                this.this$0 = $receiver;
            }

            public final void run() {
                String string;
                Transferable transferable2 = this.$newTransferable;
                if (transferable2 == null || (string = DeviceClipboardSynchronizer.access$getText(this.this$0, transferable2)) == null) {
                    return;
                }
                String text2 = string;
                if (((CharSequence)text2).length() > 0 && !Intrinsics.areEqual((Object)text2, (Object)DeviceClipboardSynchronizer.access$getLastClipboardText$p(this.this$0))) {
                    DeviceClipboardSynchronizer.access$setLastClipboardText$p(this.this$0, text2);
                    DeviceClipboardSynchronizer.access$sendClipboardSyncMessage(this.this$0, text2);
                }
            }
        });
    }

    @Override
    @AnyThread
    public void onDeviceClipboardChanged(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(text2, this){
            final /* synthetic */ String $text;
            final /* synthetic */ DeviceClipboardSynchronizer this$0;
            {
                this.$text = $text;
                this.this$0 = $receiver;
            }

            public final void run() {
                if (!Intrinsics.areEqual((Object)this.$text, (Object)DeviceClipboardSynchronizer.access$getLastClipboardText$p(this.this$0))) {
                    DeviceClipboardSynchronizer.access$setLastClipboardText$p(this.this$0, this.$text);
                    DeviceClipboardSynchronizer.access$getCopyPasteManager$p(this.this$0).setContents((Transferable)new StringSelection(this.$text));
                }
            }
        });
    }

    private final String getText(Transferable $this$getText) {
        Object object;
        try {
            object = $this$getText.getTransferData(DataFlavor.stringFlavor);
            object = object instanceof String ? (String)object : null;
        }
        catch (UnsupportedFlavorException e) {
            object = null;
        }
        catch (IOException e) {
            object = null;
        }
        return object;
    }

    public static final /* synthetic */ String access$getText(DeviceClipboardSynchronizer $this, Transferable $receiver) {
        return $this.getText($receiver);
    }

    public static final /* synthetic */ String access$getLastClipboardText$p(DeviceClipboardSynchronizer $this) {
        return $this.lastClipboardText;
    }

    public static final /* synthetic */ void access$setLastClipboardText$p(DeviceClipboardSynchronizer $this, String string) {
        $this.lastClipboardText = string;
    }

    public static final /* synthetic */ void access$sendClipboardSyncMessage(DeviceClipboardSynchronizer $this, String text2) {
        $this.sendClipboardSyncMessage(text2);
    }

    public static final /* synthetic */ CopyPasteManager access$getCopyPasteManager$p(DeviceClipboardSynchronizer $this) {
        return $this.copyPasteManager;
    }
}

