/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.streaming.device;

import com.android.tools.idea.streaming.device.ClipboardChangedNotification;
import com.android.tools.idea.streaming.device.KeyEventMessage;
import com.android.tools.idea.streaming.device.MotionEventMessage;
import com.android.tools.idea.streaming.device.SetDeviceOrientationMessage;
import com.android.tools.idea.streaming.device.SetMaxVideoResolutionMessage;
import com.android.tools.idea.streaming.device.StartClipboardSyncMessage;
import com.android.tools.idea.streaming.device.StopClipboardSyncMessage;
import com.android.tools.idea.streaming.device.TextInputMessage;
import com.android.utils.Base128InputStream;
import com.android.utils.Base128OutputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u000b2\u00020\u0001:\u0002\u000b\fB\u000f\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u0082\u0001\b\r\u000e\u000f\u0010\u0011\u0012\u0013\u0014\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/idea/streaming/device/ControlMessage;", "", "type", "", "(I)V", "getType", "()I", "serialize", "", "stream", "Lcom/android/utils/Base128OutputStream;", "Companion", "Deserializer", "Lcom/android/tools/idea/streaming/device/ClipboardChangedNotification;", "Lcom/android/tools/idea/streaming/device/KeyEventMessage;", "Lcom/android/tools/idea/streaming/device/MotionEventMessage;", "Lcom/android/tools/idea/streaming/device/SetDeviceOrientationMessage;", "Lcom/android/tools/idea/streaming/device/SetMaxVideoResolutionMessage;", "Lcom/android/tools/idea/streaming/device/StartClipboardSyncMessage;", "Lcom/android/tools/idea/streaming/device/StopClipboardSyncMessage;", "Lcom/android/tools/idea/streaming/device/TextInputMessage;", "intellij.android.streaming"})
public abstract class ControlMessage {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int type;

    private ControlMessage(int type) {
        this.type = type;
    }

    public final int getType() {
        return this.type;
    }

    public void serialize(@NotNull Base128OutputStream stream) {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        stream.writeInt(this.type);
    }

    public /* synthetic */ ControlMessage(int type, DefaultConstructorMarker $constructor_marker) {
        this(type);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006\u00c0\u0006\u0003"}, d2={"Lcom/android/tools/idea/streaming/device/ControlMessage$Deserializer;", "", "deserialize", "Lcom/android/tools/idea/streaming/device/ControlMessage;", "stream", "Lcom/android/utils/Base128InputStream;", "intellij.android.streaming"})
    public static interface Deserializer {
        @NotNull
        public ControlMessage deserialize(@NotNull Base128InputStream var1);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/idea/streaming/device/ControlMessage$Companion;", "Lcom/android/tools/idea/streaming/device/ControlMessage$Deserializer;", "()V", "deserialize", "Lcom/android/tools/idea/streaming/device/ControlMessage;", "stream", "Lcom/android/utils/Base128InputStream;", "intellij.android.streaming"})
    public static final class Companion
    implements Deserializer {
        private Companion() {
        }

        @Override
        @NotNull
        public ControlMessage deserialize(@NotNull Base128InputStream stream) {
            ControlMessage controlMessage;
            Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
            int type = stream.readInt();
            switch (type) {
                case 1: {
                    controlMessage = MotionEventMessage.Companion.deserialize(stream);
                    break;
                }
                case 2: {
                    controlMessage = KeyEventMessage.Companion.deserialize(stream);
                    break;
                }
                case 3: {
                    controlMessage = TextInputMessage.Companion.deserialize(stream);
                    break;
                }
                case 4: {
                    controlMessage = SetDeviceOrientationMessage.Companion.deserialize(stream);
                    break;
                }
                case 5: {
                    controlMessage = SetMaxVideoResolutionMessage.Companion.deserialize(stream);
                    break;
                }
                case 6: {
                    controlMessage = StartClipboardSyncMessage.Companion.deserialize(stream);
                    break;
                }
                case 7: {
                    controlMessage = StopClipboardSyncMessage.Companion.deserialize(stream);
                    break;
                }
                case 8: {
                    controlMessage = ClipboardChangedNotification.Companion.deserialize(stream);
                    break;
                }
                default: {
                    throw new Base128InputStream.StreamFormatException("Unrecognized control message type " + type);
                }
            }
            return controlMessage;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

