/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.streaming.benchmark;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.io.PathKt;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\n\u001a\u00020\u000bH\u0016J<\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u00052\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0016\b\u0002\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u0013J,\u0010\u0012\u001a\u00020\u0007*\u00020\u00072\b\u0010\u0015\u001a\u0004\u0018\u00010\u00072\u0014\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u0013H\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00070\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/idea/streaming/benchmark/UrlFileCache;", "Lcom/intellij/openapi/Disposable;", "()V", "eTags", "", "", "files", "Ljava/nio/file/Path;", "lastModified", "tmpDir", "dispose", "", "get", "url", "maxFileAgeMs", "", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "transform", "Lkotlin/Function1;", "Ljava/io/InputStream;", "cachedPath", "Companion", "intellij.android.streaming"})
public final class UrlFileCache
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, Path> files = new LinkedHashMap();
    @NotNull
    private final Map<String, String> lastModified = new LinkedHashMap();
    @NotNull
    private final Map<String, String> eTags = new LinkedHashMap();
    @NotNull
    private final Path tmpDir;

    public UrlFileCache() {
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        Path path2 = Files.createTempDirectory(null, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"createTempDirectory(prefix, *attributes)");
        this.tmpDir = path2;
    }

    @NotNull
    public final Path get(@NotNull String url, long maxFileAgeMs, @Nullable ProgressIndicator indicator, @Nullable Function1<? super InputStream, ? extends InputStream> transform2) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        ProgressIndicator progressIndicator = indicator;
        if (progressIndicator != null) {
            progressIndicator.setIndeterminate(true);
        }
        ProgressIndicator progressIndicator2 = indicator;
        if (progressIndicator2 != null) {
            progressIndicator2.setText("Checking cached downloads");
        }
        Path existing2 = this.files.get(url);
        if (existing2 != null && PathKt.exists((Path)existing2) && System.currentTimeMillis() - PathKt.lastModified((Path)existing2).toMillis() < maxFileAgeMs) {
            return existing2;
        }
        ProgressIndicator progressIndicator3 = indicator;
        if (progressIndicator3 != null) {
            progressIndicator3.setText("Downloading from " + new URL(url).getHost());
        }
        Object object = HttpRequests.request((String)url).connectTimeout(5000).readTimeout(120000).tuner(new HttpRequests.ConnectionTuner(this, url){
            final /* synthetic */ UrlFileCache this$0;
            final /* synthetic */ String $url;
            {
                this.this$0 = $receiver;
                this.$url = $url;
            }

            public final void tune(@NotNull URLConnection connection2) {
                block1: {
                    String it;
                    Intrinsics.checkNotNullParameter((Object)connection2, (String)"connection");
                    String string = (String)UrlFileCache.access$getLastModified$p(this.this$0).get(this.$url);
                    if (string != null) {
                        it = string;
                        boolean bl = false;
                        connection2.setRequestProperty("If-Modified-Since", it);
                    }
                    String string2 = (String)UrlFileCache.access$getETags$p(this.this$0).get(this.$url);
                    if (string2 == null) break block1;
                    it = string2;
                    boolean bl = false;
                    connection2.setRequestProperty("If-None-Match", it);
                }
            }
        }).connect(new HttpRequests.RequestProcessor(existing2, url, this, indicator){
            final /* synthetic */ Path $existing;
            final /* synthetic */ String $url;
            final /* synthetic */ UrlFileCache this$0;
            final /* synthetic */ ProgressIndicator $indicator;
            {
                this.$existing = $existing;
                this.$url = $url;
                this.this$0 = $receiver;
                this.$indicator = $indicator;
            }

            public final Path process(@NotNull HttpRequests.Request request2) {
                String it;
                String string;
                UrlFileCache urlFileCache;
                String string2;
                Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
                URLConnection uRLConnection = request2.getConnection();
                Intrinsics.checkNotNull((Object)uRLConnection, (String)"null cannot be cast to non-null type java.net.HttpURLConnection");
                int responseCode = ((HttpURLConnection)uRLConnection).getResponseCode();
                if (responseCode == 304) {
                    if (this.$existing != null && PathKt.exists((Path)this.$existing)) {
                        return this.$existing;
                    }
                    throw new HttpRequests.HttpStatusException("Received NOT_MODIFIED (304) but nothing in the cache.", 304, this.$url);
                }
                String string3 = request2.getConnection().getHeaderField("Last-Modified");
                if (string3 != null) {
                    string2 = string3;
                    urlFileCache = this.this$0;
                    string = this.$url;
                    it = string2;
                    boolean bl = false;
                    UrlFileCache.access$getLastModified$p(urlFileCache).put(string, it);
                }
                String string4 = request2.getConnection().getHeaderField("ETag");
                if (string4 != null) {
                    string2 = string4;
                    urlFileCache = this.this$0;
                    string = this.$url;
                    it = string2;
                    boolean bl = false;
                    UrlFileCache.access$getETags$p(urlFileCache).put(string, it);
                }
                Path newFile = PathsKt.createTempFile$default((Path)UrlFileCache.access$getTmpDir$p(this.this$0), null, null, (FileAttribute[])new FileAttribute[0], (int)6, null);
                try {
                    request2.saveToFile(newFile, this.$indicator);
                }
                catch (IOException e) {
                    Files.deleteIfExists(newFile);
                    throw e;
                }
                return newFile;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fun get(\n    url: String\u2026 file\n    return file\n  }");
        Path file2 = this.transform((Path)object, this.files.get(url), transform2);
        if (!Intrinsics.areEqual((Object)existing2, (Object)file2)) {
            Path path2 = existing2;
            if (path2 != null) {
                Files.deleteIfExists(path2);
            }
        }
        this.files.put(url, file2);
        return file2;
    }

    public static /* synthetic */ Path get$default(UrlFileCache urlFileCache, String string, long l, ProgressIndicator progressIndicator, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            l = 0L;
        }
        if ((n & 4) != 0) {
            progressIndicator = null;
        }
        if ((n & 8) != 0) {
            function1 = null;
        }
        return urlFileCache.get(string, l, progressIndicator, (Function1<? super InputStream, ? extends InputStream>)function1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Path transform(Path $this$transform, Path cachedPath, Function1<? super InputStream, ? extends InputStream> transform2) {
        if (transform2 == null || Intrinsics.areEqual((Object)cachedPath, (Object)$this$transform)) {
            return $this$transform;
        }
        Path transformedPath = PathsKt.createTempFile$default((Path)this.tmpDir, null, null, (FileAttribute[])new FileAttribute[0], (int)6, null);
        try {
            Closeable closeable = Files.newInputStream($this$transform, new OpenOption[0]);
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)closeable;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                long l = Files.copy((InputStream)transform2.invoke((Object)it), transformedPath, copyOptionArray);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Exception e) {
            Files.deleteIfExists(transformedPath);
            throw e;
        }
        Path path2 = cachedPath;
        if (path2 != null) {
            Files.deleteIfExists(path2);
        }
        Files.deleteIfExists($this$transform);
        return transformedPath;
    }

    public void dispose() {
        File file2 = this.tmpDir.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"tmpDir.toFile()");
        FilesKt.deleteRecursively((File)file2);
    }

    @JvmStatic
    @NotNull
    public static final UrlFileCache getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    public static final /* synthetic */ Map access$getLastModified$p(UrlFileCache $this) {
        return $this.lastModified;
    }

    public static final /* synthetic */ Map access$getETags$p(UrlFileCache $this) {
        return $this.eTags;
    }

    public static final /* synthetic */ Path access$getTmpDir$p(UrlFileCache $this) {
        return $this.tmpDir;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/idea/streaming/benchmark/UrlFileCache$Companion;", "", "()V", "getInstance", "Lcom/android/tools/idea/streaming/benchmark/UrlFileCache;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.android.streaming"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final UrlFileCache getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Project $this$service$iv = project;
            boolean $i$f$service = false;
            return (UrlFileCache)$this$service$iv.getService(UrlFileCache.class);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

