/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.streaming.benchmark;

import com.android.tools.idea.streaming.benchmark.StreamingBenchmarkerAppInstaller;
import com.android.tools.idea.streaming.benchmark.StreamingBenchmarkerAppInstallerImpl;
import com.android.tools.idea.streaming.benchmark.UrlFileCache;
import com.android.tools.idea.util.StudioPathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.InputStream;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetProperties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.util.projectStructure.ProjectStructureUtilKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001b\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0010J\u001b\u0010\u0011\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0010J\u0011\u0010\u0012\u001a\u00020\rH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0013R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/idea/streaming/benchmark/StreamingBenchmarkerAppInstallerImpl;", "Lcom/android/tools/idea/streaming/benchmark/StreamingBenchmarkerAppInstaller;", "project", "Lcom/intellij/openapi/project/Project;", "deviceSerialNumber", "", "adb", "Lcom/android/tools/idea/streaming/benchmark/StreamingBenchmarkerAppInstaller$AdbWrapper;", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Lcom/android/tools/idea/streaming/benchmark/StreamingBenchmarkerAppInstaller$AdbWrapper;)V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "installBenchmarkingApp", "", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "(Lcom/intellij/openapi/progress/ProgressIndicator;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "launchBenchmarkingApp", "uninstallBenchmarkingApp", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.android.streaming"})
public final class StreamingBenchmarkerAppInstallerImpl
implements StreamingBenchmarkerAppInstaller {
    @NotNull
    private final Project project;
    @NotNull
    private final String deviceSerialNumber;
    @NotNull
    private final StreamingBenchmarkerAppInstaller.AdbWrapper adb;
    @NotNull
    private final Logger logger;

    public StreamingBenchmarkerAppInstallerImpl(@NotNull Project project, @NotNull String deviceSerialNumber, @NotNull StreamingBenchmarkerAppInstaller.AdbWrapper adb) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)deviceSerialNumber, (String)"deviceSerialNumber");
        Intrinsics.checkNotNullParameter((Object)adb, (String)"adb");
        this.project = project;
        this.deviceSerialNumber = deviceSerialNumber;
        this.adb = adb;
        StreamingBenchmarkerAppInstallerImpl $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger2 = Logger.getInstance(StreamingBenchmarkerAppInstallerImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"Logger.getInstance(T::class.java)");
        this.logger = logger2;
    }

    @Override
    @Nullable
    public Object installBenchmarkingApp(@Nullable ProgressIndicator indicator, @NotNull Continuation<? super Boolean> $completion) {
        String msg = "Installing benchmarking app";
        this.logger.debug(msg);
        ProgressIndicator progressIndicator = indicator;
        if (progressIndicator != null) {
            progressIndicator.setIndeterminate(true);
        }
        ProgressIndicator progressIndicator2 = indicator;
        if (progressIndicator2 != null) {
            progressIndicator2.setText(msg);
        }
        Path apkFile = null;
        if (StudioPathManager.isRunningFromSources()) {
            Path path2;
            Path projectDir;
            VirtualFile virtualFile = ProjectUtil.guessProjectDir((Project)this.project);
            Path path3 = projectDir = virtualFile != null ? virtualFile.toNioPath() : null;
            if (projectDir != null && projectDir.endsWith("tools/adt/idea/streaming/streaming-benchmarker")) {
                String string;
                AndroidFacetProperties facet2;
                AndroidFacetProperties androidFacetProperties;
                AndroidFacetProperties androidFacetProperties2;
                block12: {
                    this.logger.debug("App project open, building and installing from here.");
                    for (Module it : (Iterable)ProjectStructureUtilKt.allModules((Project)this.project)) {
                        boolean bl = false;
                        AndroidFacet androidFacet = AndroidFacet.getInstance((Module)it);
                        if (androidFacet == null) continue;
                        androidFacetProperties2 = androidFacet;
                        break block12;
                    }
                    androidFacetProperties2 = null;
                }
                if (((androidFacetProperties = (facet2 = androidFacetProperties2)) != null && (androidFacetProperties = androidFacetProperties.getProperties()) != null ? androidFacetProperties.SELECTED_BUILD_VARIANT : (string = null)) == null) {
                    string = "debug";
                }
                String buildVariant = string;
                Path path4 = projectDir.resolve("app/build/outputs/apk/" + buildVariant + "/app-" + buildVariant + ".apk");
                Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"{\n        // Development\u2026uildVariant.apk\")\n      }");
                path2 = path4;
            } else {
                Path path5 = StudioPathManager.resolvePathFromSourcesRoot((String)"prebuilts/tools/common/streaming-benchmarker/streaming-benchmarker.apk");
                path2 = path5;
                Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"{\n        // Development\u2026ot(PREBUILT_PATH)\n      }");
            }
            apkFile = path2;
        } else {
            try {
                apkFile = UrlFileCache.Companion.getInstance(this.project).get("https://android.googlesource.com/platform/prebuilts/tools/+/refs/heads/mirror-goog-studio-main/common/streaming-benchmarker/streaming-benchmarker.apk?format=TEXT", Duration.getInWholeMilliseconds-impl((long)DurationKt.toDuration((int)12, (DurationUnit)DurationUnit.HOURS)), indicator, (Function1<? super InputStream, ? extends InputStream>)((Function1)installBenchmarkingApp.2.INSTANCE));
            }
            catch (Exception e) {
                this.logger.error((Throwable)e);
                return Boxing.boxBoolean((boolean)false);
            }
        }
        ProgressIndicator progressIndicator3 = indicator;
        if (progressIndicator3 != null) {
            progressIndicator3.setIndeterminate(true);
        }
        ProgressIndicator progressIndicator4 = indicator;
        if (progressIndicator4 != null) {
            progressIndicator4.setText(msg);
        }
        return this.adb.install(this.deviceSerialNumber, apkFile, $completion);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object launchBenchmarkingApp(@Nullable ProgressIndicator var1_1, @NotNull Continuation<? super Boolean> var2_2) {
        if (!(var2_2 instanceof launchBenchmarkingApp.1)) ** GOTO lbl-1000
        var5_3 = var2_2;
        if ((var5_3.label & -2147483648) != 0) {
            var5_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ StreamingBenchmarkerAppInstallerImpl this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.launchBenchmarkingApp(null, (Continuation<? super Boolean>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var6_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                msg = "Launching benchmarking app";
                this.logger.debug(msg);
                v0 = indicator;
                if (v0 != null) {
                    v0.setIndeterminate(true);
                }
                v1 = indicator;
                if (v1 != null) {
                    v1.setText(msg);
                }
                $continuation.L$0 = this;
                $continuation.label = 1;
                v2 = this.adb.shellCommand(this.deviceSerialNumber, "settings put secure immersive_mode_confirmations confirmed", (Continuation<? super Boolean>)$continuation);
                if (v2 == var6_5) {
                    return var6_5;
                }
                ** GOTO lbl30
            }
            case 1: {
                this = (StreamingBenchmarkerAppInstallerImpl)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl30:
                // 2 sources

                if (!((Boolean)v2).booleanValue()) break;
                $continuation.L$0 = null;
                $continuation.label = 2;
                v3 = this.adb.shellCommand(this.deviceSerialNumber, "am start -n com.android.tools.screensharing.benchmark/.InputEventRenderingActivity -f 65536", (Continuation<? super Boolean>)$continuation);
                if (v3 == var6_5) {
                    return var6_5;
                }
                ** GOTO lbl40
            }
            case 2: {
                ResultKt.throwOnFailure((Object)$result);
                v3 = $result;
lbl40:
                // 2 sources

                return v3;
            }
        }
        return Boxing.boxBoolean((boolean)false);
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Override
    @Nullable
    public Object uninstallBenchmarkingApp(@NotNull Continuation<? super Boolean> $completion) {
        return this.adb.uninstall(this.deviceSerialNumber, $completion);
    }
}

