/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.streaming.benchmark;

import com.android.tools.idea.util.fsm.StateMachine;
import com.android.utils.time.TimeSource;
import com.google.common.math.Quantiles;
import com.intellij.openapi.diagnostic.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.math.MathKt;
import kotlin.ranges.IntRange;
import kotlin.time.Duration;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\b\u0018\u0000 4*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u000523456B1\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0014\u0010'\u001a\u00020(2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\u000eJ\b\u0010)\u001a\u00020(H\u0002J\u001d\u0010*\u001a\u00020(2\u0006\u0010+\u001a\u00028\u00002\u0006\u0010,\u001a\u00020\u001aH\u0002\u00a2\u0006\u0002\u0010-J\u0006\u0010.\u001a\u00020/J\u0006\u00100\u001a\u00020(J\u0006\u00101\u001a\u00020(R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0010@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00180\u0017X\u0082\u0004\u00f8\u0001\u0000\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u001a0\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R+\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u000f\u001a\u00020\u001b8B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"*\u0004\b\u001d\u0010\u001eR\u0014\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001b0$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u00067"}, d2={"Lcom/android/tools/idea/streaming/benchmark/Benchmarker;", "InputType", "", "adapter", "Lcom/android/tools/idea/streaming/benchmark/Benchmarker$Adapter;", "inputRateHz", "", "timeSource", "Lcom/android/utils/time/TimeSource;", "timer", "Ljava/util/Timer;", "(Lcom/android/tools/idea/streaming/benchmark/Benchmarker$Adapter;ILcom/android/utils/time/TimeSource;Ljava/util/Timer;)V", "callbacks", "", "Lcom/android/tools/idea/streaming/benchmark/Benchmarker$Callbacks;", "<set-?>", "", "failureMsg", "getFailureMsg", "()Ljava/lang/String;", "frameDurationMillis", "", "inputRoundTrips", "", "Lkotlin/time/Duration;", "outstandingInputs", "Lcom/android/utils/time/TimeSource$TimeMark;", "Lcom/android/tools/idea/streaming/benchmark/Benchmarker$State;", "state", "getState$delegate", "(Lcom/android/tools/idea/streaming/benchmark/Benchmarker;)Ljava/lang/Object;", "getState", "()Lcom/android/tools/idea/streaming/benchmark/Benchmarker$State;", "setState", "(Lcom/android/tools/idea/streaming/benchmark/Benchmarker$State;)V", "stateMachine", "Lcom/android/tools/idea/util/fsm/StateMachine;", "getTimeSource", "()Lcom/android/utils/time/TimeSource;", "addCallbacks", "", "dispatchNextInput", "inputReturned", "input", "effectiveDispatchTime", "(Ljava/lang/Object;Lcom/android/utils/time/TimeSource$TimeMark;)V", "isDone", "", "start", "stop", "Adapter", "Callbacks", "Companion", "Results", "State", "intellij.android.streaming"})
public final class Benchmarker<InputType> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Adapter<InputType> adapter;
    @NotNull
    private final TimeSource timeSource;
    @NotNull
    private String failureMsg;
    private final long frameDurationMillis;
    @NotNull
    private final StateMachine<State> stateMachine;
    @NotNull
    private final List<Callbacks<InputType>> callbacks;
    @NotNull
    private final Map<InputType, TimeSource.TimeMark> outstandingInputs;
    @NotNull
    private final Map<InputType, Duration> inputRoundTrips;
    @NotNull
    private static final Logger LOG;

    public Benchmarker(@NotNull Adapter<InputType> adapter2, int inputRateHz, @NotNull TimeSource timeSource, @NotNull Timer timer) {
        Intrinsics.checkNotNullParameter(adapter2, (String)"adapter");
        Intrinsics.checkNotNullParameter((Object)timeSource, (String)"timeSource");
        Intrinsics.checkNotNullParameter((Object)timer, (String)"timer");
        this.adapter = adapter2;
        this.timeSource = timeSource;
        this.failureMsg = "Benchmarking terminated unexpectedly";
        this.frameDurationMillis = MathKt.roundToLong((double)((double)1000 / (double)inputRateHz));
        this.stateMachine = StateMachine.Companion.stateMachine((Enum)State.INITIALIZED, new StateMachine.Config(null, LOG, this.timeSource, 1, null), (Function1)new Function1<StateMachine.StateMachineBuilderScope<State>, Unit>(this, timer){
            final /* synthetic */ Benchmarker<InputType> this$0;
            final /* synthetic */ Timer $timer;
            {
                this.this$0 = $receiver;
                this.$timer = $timer;
                super(1);
            }

            public final void invoke(@NotNull StateMachine.StateMachineBuilderScope<State> $this$stateMachine) {
                Intrinsics.checkNotNullParameter($this$stateMachine, (String)"$this$stateMachine");
                State[] stateArray = new State[]{State.GETTING_READY, State.STOPPED};
                StateMachine.StateMachineBuilderScope.transitionsTo$default($this$stateMachine, (Enum)State.INITIALIZED, (Enum[])stateArray, null, (int)2, null);
                $this$stateMachine.invoke((Enum)State.GETTING_READY, (Function1)new Function1<State, Unit>($this$stateMachine, this.this$0){
                    final /* synthetic */ StateMachine.StateMachineBuilderScope<State> $this_stateMachine;
                    final /* synthetic */ Benchmarker<InputType> this$0;
                    {
                        this.$this_stateMachine = $this_stateMachine;
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull State $this$invoke) {
                        Intrinsics.checkNotNullParameter((Object)((Object)$this$invoke), (String)"$this$invoke");
                        State[] stateArray = new State[]{State.SENDING_INPUTS, State.STOPPED};
                        StateMachine.StateMachineBuilderScope.transitionsTo$default(this.$this_stateMachine, (Enum)$this$invoke, (Enum[])stateArray, null, (int)2, null);
                        this.$this_stateMachine.onEnter((Enum)$this$invoke, (Function0)new Function0<Unit>(this.this$0){
                            final /* synthetic */ Benchmarker<InputType> this$0;
                            {
                                this.this$0 = $receiver;
                                super(0);
                            }

                            public final void invoke() {
                                Benchmarker.access$getAdapter$p(this.this$0).ready();
                            }
                        });
                    }
                });
                $this$stateMachine.invoke((Enum)State.SENDING_INPUTS, (Function1)new Function1<State, Unit>($this$stateMachine, this.$timer, this.this$0){
                    final /* synthetic */ StateMachine.StateMachineBuilderScope<State> $this_stateMachine;
                    final /* synthetic */ Timer $timer;
                    final /* synthetic */ Benchmarker<InputType> this$0;
                    {
                        this.$this_stateMachine = $this_stateMachine;
                        this.$timer = $timer;
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull State $this$invoke) {
                        Intrinsics.checkNotNullParameter((Object)((Object)$this$invoke), (String)"$this$invoke");
                        State[] stateArray = new State[]{State.WAITING_FOR_OUTSTANDING_INPUTS, State.STOPPED};
                        StateMachine.StateMachineBuilderScope.transitionsTo$default(this.$this_stateMachine, (Enum)$this$invoke, (Enum[])stateArray, null, (int)2, null);
                        this.$this_stateMachine.onEnter((Enum)$this$invoke, (Function0)new Function0<Unit>(this.$timer, this.this$0){
                            final /* synthetic */ Timer $timer;
                            final /* synthetic */ Benchmarker<InputType> this$0;
                            {
                                this.$timer = $timer;
                                this.this$0 = $receiver;
                                super(0);
                            }

                            public final void invoke() {
                                Timer timer = this.$timer;
                                long l = 0L;
                                long l2 = Benchmarker.access$getFrameDurationMillis$p(this.this$0);
                                Benchmarker<InputType> benchmarker = this.this$0;
                                TimerTask timerTask = new TimerTask(benchmarker){
                                    final /* synthetic */ Benchmarker this$0;
                                    {
                                        this.this$0 = benchmarker;
                                    }

                                    public void run() {
                                        TimerTask $this$invoke_u24lambda_u2d0 = this;
                                        boolean bl = false;
                                        Benchmarker.access$dispatchNextInput(this.this$0);
                                    }
                                };
                                timer.scheduleAtFixedRate(timerTask, l, l2);
                            }
                        });
                        this.$this_stateMachine.onExit((Enum)$this$invoke, (Function0)new Function0<Unit>(this.this$0, this.$timer){
                            final /* synthetic */ Benchmarker<InputType> this$0;
                            final /* synthetic */ Timer $timer;
                            {
                                this.this$0 = $receiver;
                                this.$timer = $timer;
                                super(0);
                            }

                            public final void invoke() {
                                Benchmarker.access$getAdapter$p(this.this$0).finalizeInputs();
                                this.$timer.cancel();
                            }
                        });
                    }
                });
                stateArray = new State[]{State.STOPPED, State.COMPLETE};
                StateMachine.StateMachineBuilderScope.transitionsTo$default($this$stateMachine, (Enum)State.WAITING_FOR_OUTSTANDING_INPUTS, (Enum[])stateArray, null, (int)2, null);
                $this$stateMachine.onEnter((Enum)State.STOPPED, (Function0)new Function0<Unit>(this.this$0){
                    final /* synthetic */ Benchmarker<InputType> this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final void invoke() {
                        void $this$forEach$iv;
                        Benchmarker.access$getAdapter$p(this.this$0).cleanUp();
                        Iterable iterable = Benchmarker.access$getCallbacks$p(this.this$0);
                        Benchmarker<InputType> benchmarker = this.this$0;
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            Callbacks it = (Callbacks)element$iv;
                            boolean bl = false;
                            it.onStopped();
                            it.onFailure(benchmarker.getFailureMsg());
                        }
                    }
                });
                $this$stateMachine.onEnter((Enum)State.COMPLETE, (Function0)new Function0<Unit>(this.this$0){
                    final /* synthetic */ Benchmarker<InputType> this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    public final void invoke() {
                        Benchmarker.access$getAdapter$p(this.this$0).cleanUp();
                        Results<InputType> results = new Results<InputType>(Benchmarker.access$getInputRoundTrips$p(this.this$0));
                        Iterable $this$forEach$iv = Benchmarker.access$getCallbacks$p(this.this$0);
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            Callbacks it = (Callbacks)element$iv;
                            boolean bl = false;
                            it.onStopped();
                            it.onComplete(results);
                        }
                    }
                });
            }
        });
        this.callbacks = new ArrayList();
        this.outstandingInputs = new LinkedHashMap();
        this.inputRoundTrips = new LinkedHashMap();
        Adapter.Callbacks callbacks2 = new Adapter.Callbacks<InputType>(this){
            final /* synthetic */ Benchmarker<InputType> this$0;
            {
                this.this$0 = $receiver;
            }

            public void inputReturned(InputType input2, @NotNull TimeSource.TimeMark effectiveDispatchTime) {
                Intrinsics.checkNotNullParameter((Object)effectiveDispatchTime, (String)"effectiveDispatchTime");
                Benchmarker.access$inputReturned(this.this$0, input2, effectiveDispatchTime);
            }

            public void onReady() {
                Iterable $this$forEach$iv = Benchmarker.access$getCallbacks$p(this.this$0);
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    Callbacks it = (Callbacks)element$iv;
                    boolean bl = false;
                    it.onProgress(0.0, 0.0);
                }
                Benchmarker.access$setState(this.this$0, State.SENDING_INPUTS);
            }

            public void onFailedToBecomeReady(@NotNull String msg) {
                Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
                Benchmarker.access$getLOG$cp().warn(msg);
                Benchmarker.access$setFailureMsg$p(this.this$0, msg);
                Benchmarker.access$setState(this.this$0, State.STOPPED);
            }
        };
        this.adapter.setCallbacks(callbacks2);
    }

    public /* synthetic */ Benchmarker(Adapter adapter2, int n, TimeSource timeSource, Timer timer, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 60;
        }
        if ((n2 & 4) != 0) {
            timeSource = (TimeSource)TimeSource.Monotonic.INSTANCE;
        }
        if ((n2 & 8) != 0) {
            timer = new Timer();
        }
        this(adapter2, n, timeSource, timer);
    }

    @NotNull
    protected final TimeSource getTimeSource() {
        return this.timeSource;
    }

    @NotNull
    public final String getFailureMsg() {
        return this.failureMsg;
    }

    private final State getState() {
        return (State)this.stateMachine.getState();
    }

    private final void setState(State state2) {
        this.stateMachine.setState((Enum)state2);
    }

    private static Object getState$delegate(Benchmarker<Object> benchmarker) {
        return Reflection.mutableProperty0((MutablePropertyReference0)((MutablePropertyReference0)new MutablePropertyReference0Impl(benchmarker.stateMachine, StateMachine.class, "state", "getState()Ljava/lang/Enum;", 0)));
    }

    private final synchronized void inputReturned(InputType input2, TimeSource.TimeMark effectiveDispatchTime) {
        State[] stateArray = new State[]{State.INITIALIZED, State.STOPPED, State.COMPLETE};
        if (CollectionsKt.listOf((Object[])stateArray).contains((Object)this.getState())) {
            return;
        }
        LOG.trace("Got input " + input2);
        if (this.outstandingInputs.containsKey(input2)) {
            Iterator<Map.Entry<InputType, TimeSource.TimeMark>> iterator2 = this.outstandingInputs.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry<InputType, TimeSource.TimeMark> cur = iterator2.next();
                iterator2.remove();
                this.inputRoundTrips.put(cur.getKey(), Duration.box-impl((long)Duration.minus-LRDsOJo((long)cur.getValue().elapsedNow-UwyO8pc(), (long)effectiveDispatchTime.elapsedNow-UwyO8pc())));
                if (!Intrinsics.areEqual(cur.getKey(), input2)) continue;
            }
        }
        double denominator = this.adapter.numInputs();
        double dispatchedProgress = (double)(this.inputRoundTrips.size() + this.outstandingInputs.size()) / denominator;
        double returnedProgress = (double)this.inputRoundTrips.size() / denominator;
        Iterable $this$forEach$iv = this.callbacks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Callbacks it = (Callbacks)element$iv;
            boolean bl = false;
            it.onProgress(dispatchedProgress, returnedProgress);
        }
        if (this.getState() == State.WAITING_FOR_OUTSTANDING_INPUTS && this.outstandingInputs.isEmpty()) {
            this.setState(State.COMPLETE);
        }
    }

    public final synchronized void addCallbacks(@NotNull Callbacks<InputType> callbacks2) {
        Intrinsics.checkNotNullParameter(callbacks2, (String)"callbacks");
        this.callbacks.add(callbacks2);
    }

    public final synchronized void start() {
        this.setState(State.GETTING_READY);
    }

    public final synchronized void stop() {
        this.failureMsg = "Benchmarking was canceled.";
        this.setState(State.STOPPED);
    }

    public final synchronized boolean isDone() {
        return this.getState() == State.COMPLETE;
    }

    private final synchronized void dispatchNextInput() {
        if (this.adapter.inputs().hasNext()) {
            InputType it = this.adapter.inputs().next();
            boolean bl = false;
            this.outstandingInputs.put(it, this.timeSource.markNow());
            LOG.trace("Dispatching input " + it + ".");
            this.adapter.dispatch(it);
            if (!this.adapter.inputs().hasNext()) {
                this.setState(State.WAITING_FOR_OUTSTANDING_INPUTS);
            }
        }
    }

    public static final /* synthetic */ Adapter access$getAdapter$p(Benchmarker $this) {
        return $this.adapter;
    }

    public static final /* synthetic */ long access$getFrameDurationMillis$p(Benchmarker $this) {
        return $this.frameDurationMillis;
    }

    public static final /* synthetic */ void access$dispatchNextInput(Benchmarker $this) {
        $this.dispatchNextInput();
    }

    public static final /* synthetic */ List access$getCallbacks$p(Benchmarker $this) {
        return $this.callbacks;
    }

    public static final /* synthetic */ Map access$getInputRoundTrips$p(Benchmarker $this) {
        return $this.inputRoundTrips;
    }

    public static final /* synthetic */ void access$inputReturned(Benchmarker $this, Object input2, TimeSource.TimeMark effectiveDispatchTime) {
        $this.inputReturned(input2, effectiveDispatchTime);
    }

    public static final /* synthetic */ void access$setState(Benchmarker $this, State state2) {
        $this.setState(state2);
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    public static final /* synthetic */ void access$setFailureMsg$p(Benchmarker $this, String string) {
        $this.failureMsg = string;
    }

    static {
        Logger logger2 = Logger.getInstance(Benchmarker.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(Benchmarker::class.java)");
        LOG = logger2;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0010\u0006\n\u0002\b\u0004\u0018\u0000*\u0004\b\u0001\u0010\u00012\u00020\u0002B\u001c\u0012\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\u00050\u0004\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0006R\u001d\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR \u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\u00050\u0004\u00f8\u0001\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000b\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\r"}, d2={"Lcom/android/tools/idea/streaming/benchmark/Benchmarker$Results;", "InputType", "", "raw", "", "Lkotlin/time/Duration;", "(Ljava/util/Map;)V", "percentiles", "", "", "getPercentiles", "()Ljava/util/Map;", "getRaw", "intellij.android.streaming"})
    public static final class Results<InputType> {
        @NotNull
        private final Map<InputType, Duration> raw;
        @NotNull
        private final Map<Integer, Double> percentiles;

        /*
         * WARNING - void declaration
         */
        public Results(@NotNull Map<InputType, Duration> raw) {
            Collection<Long> collection2;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter(raw, (String)"raw");
            this.raw = raw;
            Iterable iterable = this.raw.values();
            Quantiles.ScaleAndIndexes scaleAndIndexes = Quantiles.percentiles().indexes((Collection)CollectionsKt.toList((Iterable)((Iterable)new IntRange(1, 100))));
            Results results = this;
            boolean $i$f$map = false;
            void var4_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                long l = ((Duration)item$iv$iv).unbox-impl();
                collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add(Duration.getInWholeMilliseconds-impl((long)it));
            }
            collection2 = (List)destination$iv$iv;
            Map map2 = scaleAndIndexes.compute((Collection)collection2);
            Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"percentiles().indexes(In\u2026it.inWholeMilliseconds })");
            results.percentiles = map2;
        }

        @NotNull
        public final Map<InputType, Duration> getRaw() {
            return this.raw;
        }

        @NotNull
        public final Map<Integer, Double> getPercentiles() {
            return this.percentiles;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\bf\u0018\u0000*\u0004\b\u0001\u0010\u00012\u00020\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00010\u0006H&J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH&J\u0018\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH&J\b\u0010\u000e\u001a\u00020\u0004H&\u00a8\u0006\u000f\u00c0\u0006\u0003"}, d2={"Lcom/android/tools/idea/streaming/benchmark/Benchmarker$Callbacks;", "InputType", "", "onComplete", "", "results", "Lcom/android/tools/idea/streaming/benchmark/Benchmarker$Results;", "onFailure", "failureMessage", "", "onProgress", "dispatched", "", "returned", "onStopped", "intellij.android.streaming"})
    public static interface Callbacks<InputType> {
        public void onProgress(double var1, double var3);

        public void onStopped();

        public void onFailure(@NotNull String var1);

        public void onComplete(@NotNull Results<InputType> var1);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010(\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000*\u0004\b\u0001\u0010\u00012\u00020\u0002:\u0001\u0011J\b\u0010\u0003\u001a\u00020\u0004H&J\u0015\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00028\u0001H&\u00a2\u0006\u0002\u0010\u0007J\b\u0010\b\u001a\u00020\u0004H&J\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00010\nH&J\b\u0010\u000b\u001a\u00020\fH&J\b\u0010\r\u001a\u00020\u0004H&J\u0016\u0010\u000e\u001a\u00020\u00042\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00010\u0010H&\u00a8\u0006\u0012\u00c0\u0006\u0003"}, d2={"Lcom/android/tools/idea/streaming/benchmark/Benchmarker$Adapter;", "InputType", "", "cleanUp", "", "dispatch", "input", "(Ljava/lang/Object;)V", "finalizeInputs", "inputs", "", "numInputs", "", "ready", "setCallbacks", "callbacks", "Lcom/android/tools/idea/streaming/benchmark/Benchmarker$Adapter$Callbacks;", "Callbacks", "intellij.android.streaming"})
    public static interface Adapter<InputType> {
        @NotNull
        public Iterator<InputType> inputs();

        public int numInputs();

        public void dispatch(InputType var1);

        public void setCallbacks(@NotNull Callbacks<InputType> var1);

        public void ready();

        public void finalizeInputs();

        public void cleanUp();

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\bf\u0018\u0000*\u0004\b\u0002\u0010\u00012\u00020\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00028\u00022\u0006\u0010\u0006\u001a\u00020\u0007H&\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH&J\b\u0010\f\u001a\u00020\u0004H&\u00a8\u0006\r\u00c0\u0006\u0003"}, d2={"Lcom/android/tools/idea/streaming/benchmark/Benchmarker$Adapter$Callbacks;", "InputType", "", "inputReturned", "", "input", "effectiveDispatchTime", "Lcom/android/utils/time/TimeSource$TimeMark;", "(Ljava/lang/Object;Lcom/android/utils/time/TimeSource$TimeMark;)V", "onFailedToBecomeReady", "msg", "", "onReady", "intellij.android.streaming"})
        public static interface Callbacks<InputType> {
            public void inputReturned(InputType var1, @NotNull TimeSource.TimeMark var2);

            public void onReady();

            public void onFailedToBecomeReady(@NotNull String var1);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\b\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lcom/android/tools/idea/streaming/benchmark/Benchmarker$State;", "", "(Ljava/lang/String;I)V", "INITIALIZED", "GETTING_READY", "SENDING_INPUTS", "WAITING_FOR_OUTSTANDING_INPUTS", "STOPPED", "COMPLETE", "intellij.android.streaming"})
    private static final class State
    extends Enum<State> {
        public static final /* enum */ State INITIALIZED = new State();
        public static final /* enum */ State GETTING_READY = new State();
        public static final /* enum */ State SENDING_INPUTS = new State();
        public static final /* enum */ State WAITING_FOR_OUTSTANDING_INPUTS = new State();
        public static final /* enum */ State STOPPED = new State();
        public static final /* enum */ State COMPLETE = new State();
        private static final /* synthetic */ State[] $VALUES;

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String value2) {
            return Enum.valueOf(State.class, value2);
        }

        static {
            $VALUES = stateArray = new State[]{State.INITIALIZED, State.GETTING_READY, State.SENDING_INPUTS, State.WAITING_FOR_OUTSTANDING_INPUTS, State.STOPPED, State.COMPLETE};
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/idea/streaming/benchmark/Benchmarker$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.android.streaming"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

