/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.streaming;

import com.android.tools.adtui.Zoomable;
import com.android.tools.adtui.actions.ZoomType;
import com.android.tools.idea.streaming.StreamingUtilsKt;
import com.android.tools.idea.streaming.ZoomablePanelKt;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.geom.AffineTransform;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0006\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u001a\u001a\u00020\u001bH$J\b\u0010\u001c\u001a\u00020\u001bH\u0016J\b\u0010\u001d\u001a\u00020\u001bH\u0016J\b\u0010\u001e\u001a\u00020\u001bH\u0016J\b\u0010\u001f\u001a\u00020\u001bH\u0016J\b\u0010 \u001a\u00020\u0005H$J\b\u0010!\u001a\u00020\u0005H\u0002J\b\u0010\"\u001a\u00020\u0005H\u0004J\u0010\u0010#\u001a\u00020\u00112\u0006\u0010$\u001a\u00020\u0005H\u0002J\u0018\u0010#\u001a\u00020\u00112\u0006\u0010%\u001a\u00020\u00052\u0006\u0010$\u001a\u00020\u0005H\u0002J\b\u0010&\u001a\u00020\u0011H\u0002J\u0012\u0010'\u001a\u0004\u0018\u00010\u00052\u0006\u0010(\u001a\u00020)H\u0002J\u0010\u0010*\u001a\u00020\u001b2\u0006\u0010+\u001a\u00020)H\u0016R\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u00058@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\u00058DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0007R\u0014\u0010\u000e\u001a\u00020\t8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u000bR\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u001c\u0010\u0014\u001a\u00020\u00118DX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0013\"\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0013\u00a8\u0006,"}, d2={"Lcom/android/tools/idea/streaming/ZoomablePanel;", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "Lcom/android/tools/adtui/Zoomable;", "()V", "explicitlySetPreferredSize", "Ljava/awt/Dimension;", "getExplicitlySetPreferredSize$intellij_android_streaming", "()Ljava/awt/Dimension;", "physicalHeight", "", "getPhysicalHeight", "()I", "physicalSize", "getPhysicalSize", "physicalWidth", "getPhysicalWidth", "scale", "", "getScale", "()D", "screenScale", "getScreenScale", "setScreenScale", "(D)V", "screenScalingFactor", "getScreenScalingFactor", "canZoom", "", "canZoomIn", "canZoomOut", "canZoomToActual", "canZoomToFit", "computeActualSize", "computeAvailableSize", "computeMaxImageSize", "computeScaleToFit", "availableSize", "actualSize", "computeScaleToFitInParent", "computeZoomedSize", "zoomType", "Lcom/android/tools/adtui/actions/ZoomType;", "zoom", "type", "intellij.android.streaming"})
public abstract class ZoomablePanel
extends BorderLayoutPanel
implements Zoomable {
    private double screenScale;

    protected final double getScreenScale() {
        if (this.screenScale == 0.0) {
            Object object = this.getGraphicsConfiguration();
            this.screenScale = object != null && (object = ((GraphicsConfiguration)object).getDefaultTransform()) != null ? ((AffineTransform)object).getScaleX() : 1.0;
        }
        return this.screenScale;
    }

    protected final void setScreenScale(double d) {
        this.screenScale = d;
    }

    protected final int getPhysicalWidth() {
        return StreamingUtilsKt.scaled(this.getWidth(), this.getScreenScale());
    }

    protected final int getPhysicalHeight() {
        return StreamingUtilsKt.scaled(this.getHeight(), this.getScreenScale());
    }

    @NotNull
    protected final Dimension getPhysicalSize() {
        return new Dimension(this.getPhysicalWidth(), this.getPhysicalHeight());
    }

    public double getScale() {
        return this.computeScaleToFit(this.computeMaxImageSize());
    }

    public double getScreenScalingFactor() {
        return this.getScreenScale();
    }

    protected abstract boolean canZoom();

    public boolean zoom(@NotNull ZoomType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Dimension scaledSize = this.computeZoomedSize(type);
        if (Intrinsics.areEqual((Object)scaledSize, (Object)this.getPreferredSize())) {
            return false;
        }
        this.setPreferredSize(scaledSize);
        this.revalidate();
        return true;
    }

    public boolean canZoomIn() {
        return this.canZoom() && !Intrinsics.areEqual((Object)this.computeZoomedSize(ZoomType.IN), (Object)this.getExplicitlySetPreferredSize$intellij_android_streaming());
    }

    public boolean canZoomOut() {
        return this.canZoom() && !Intrinsics.areEqual((Object)this.computeZoomedSize(ZoomType.OUT), (Object)this.getExplicitlySetPreferredSize$intellij_android_streaming());
    }

    public boolean canZoomToActual() {
        return this.canZoom() && !Intrinsics.areEqual((Object)this.computeZoomedSize(ZoomType.ACTUAL), (Object)this.getExplicitlySetPreferredSize$intellij_android_streaming());
    }

    public boolean canZoomToFit() {
        return this.canZoom() && this.isPreferredSizeSet();
    }

    @Nullable
    public final Dimension getExplicitlySetPreferredSize$intellij_android_streaming() {
        return this.isPreferredSizeSet() ? this.getPreferredSize() : null;
    }

    @NotNull
    protected final Dimension computeMaxImageSize() {
        Dimension dimension2 = this.getExplicitlySetPreferredSize$intellij_android_streaming();
        if (dimension2 == null) {
            dimension2 = this.getSize();
        }
        Intrinsics.checkNotNullExpressionValue((Object)dimension2, (String)"explicitlySetPreferredSize ?: size");
        return StreamingUtilsKt.scaled(dimension2, this.getScreenScale());
    }

    private final Dimension computeZoomedSize(ZoomType zoomType) {
        double d;
        switch (WhenMappings.$EnumSwitchMapping$0[zoomType.ordinal()]) {
            case 1: {
                double nextScale = (double)ZoomType.zoomIn((int)MathKt.roundToInt((double)(this.getScale() * (double)100)), (int[])ZoomablePanelKt.access$getZOOM_LEVELS$p()) / 100.0;
                double fitScale = this.computeScaleToFitInParent();
                if (nextScale >= fitScale) {
                    if (fitScale >= 2.0) {
                        return null;
                    }
                    if (nextScale > 2.0) {
                        nextScale = 2.0;
                    }
                }
                d = nextScale;
                break;
            }
            case 2: {
                double nextScale = (double)ZoomType.zoomOut((int)MathKt.roundToInt((double)(this.getScale() * (double)100)), (int[])ZoomablePanelKt.access$getZOOM_LEVELS$p()) / 100.0;
                double fitScale = this.computeScaleToFitInParent();
                if (fitScale > 1.0) {
                    if (nextScale < 1.0) {
                        nextScale = 1.0;
                    }
                } else if (nextScale <= fitScale) {
                    return null;
                }
                d = nextScale;
                break;
            }
            case 3: {
                if (this.computeScaleToFitInParent() == 1.0) {
                    return null;
                }
                d = 1.0;
                break;
            }
            case 4: {
                return null;
            }
            default: {
                throw new IllegalArgumentException("Unsupported zoom type " + zoomType);
            }
        }
        double newScale = d;
        Dimension newScaledSize = StreamingUtilsKt.scaled(this.computeActualSize(), newScale);
        return StreamingUtilsKt.scaled(newScaledSize, 1.0 / this.getScreenScale());
    }

    private final double computeScaleToFitInParent() {
        return this.computeScaleToFit(this.computeAvailableSize());
    }

    private final Dimension computeAvailableSize() {
        Container container = this.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)container, (String)"parent");
        return StreamingUtilsKt.scaled(StreamingUtilsKt.getSizeWithoutInsets(container), this.getScreenScale());
    }

    private final double computeScaleToFit(Dimension availableSize) {
        return this.computeScaleToFit(this.computeActualSize(), availableSize);
    }

    private final double computeScaleToFit(Dimension actualSize, Dimension availableSize) {
        if (actualSize.width == 0 || actualSize.height == 0) {
            return 1.0;
        }
        double scale = Math.min((double)availableSize.width / (double)actualSize.width, (double)availableSize.height / (double)actualSize.height);
        return scale <= 1.0 ? scale : Math.floor(scale);
    }

    @NotNull
    protected abstract Dimension computeActualSize();

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ZoomType.values().length];
            nArray[ZoomType.IN.ordinal()] = 1;
            nArray[ZoomType.OUT.ordinal()] = 2;
            nArray[ZoomType.ACTUAL.ordinal()] = 3;
            nArray[ZoomType.FIT.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

