/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.streaming;

import com.android.emulator.control.KeyboardEvent;
import com.android.emulator.control.ThemingStyle;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.ide.ui.LafManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectEx;
import com.intellij.util.concurrency.SameThreadExecutor;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.DebugProbesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CancellableContinuation;
import kotlinx.coroutines.CancellableContinuationImpl;
import kotlinx.coroutines.JobKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000h\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0018\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001a\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\b\b\u0002\u0010\u001c\u001a\u00020\u001dH\u0000\u001a\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0000\u001a0\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u00012\u0006\u0010%\u001a\u00020\u00012\u0006\u0010&\u001a\u00020\u00012\u0006\u0010'\u001a\u00020\u00012\u0006\u0010(\u001a\u00020)H\u0000\u001a\u0014\u0010*\u001a\u00020\u0014*\u00020\u00142\u0006\u0010+\u001a\u00020\u0014H\u0000\u001a\u0014\u0010,\u001a\u00020\r*\u00020\r2\u0006\u0010-\u001a\u00020\u0014H\u0000\u001a\u0015\u0010.\u001a\u00020#*\u00020\u00142\u0006\u0010/\u001a\u00020\rH\u0080\u0002\u001a\u0014\u00100\u001a\u00020\u0014*\u00020\u00142\u0006\u00101\u001a\u00020\u0001H\u0000\u001a\u0014\u00100\u001a\u00020\r*\u00020\r2\u0006\u00102\u001a\u00020\u0001H\u0000\u001a\u0014\u00103\u001a\u00020\u0014*\u00020\u00142\u0006\u00104\u001a\u00020)H\u0000\u001a\u001c\u00103\u001a\u00020\u0014*\u00020\u00142\u0006\u00105\u001a\u00020)2\u0006\u00106\u001a\u00020)H\u0000\u001a\u0014\u00103\u001a\u00020\r*\u00020\r2\u0006\u00104\u001a\u00020)H\u0000\u001a\u0014\u00103\u001a\u00020\u0001*\u00020\u00012\u0006\u00104\u001a\u00020)H\u0000\u001a\u0014\u00107\u001a\u00020\u0001*\u00020\u00012\u0006\u00104\u001a\u00020)H\u0000\u001a\u001c\u00107\u001a\u00020\u0001*\u00020\u00012\u0006\u00108\u001a\u00020\u00012\u0006\u00109\u001a\u00020\u0001H\u0000\u001a\u001c\u0010:\u001a\u00020\r*\u00020\r2\u0006\u0010;\u001a\u00020\u00142\u0006\u0010<\u001a\u00020\u0014H\u0000\u001a\u001c\u0010:\u001a\u00020\u0001*\u00020\u00012\u0006\u0010=\u001a\u00020\u00012\u0006\u0010>\u001a\u00020\u0001H\u0000\u001a\u0014\u0010?\u001a\u00020\u0001*\u00020\u00012\u0006\u00104\u001a\u00020)H\u0000\u001a!\u0010@\u001a\u0002HA\"\u0004\b\u0000\u0010A*\b\u0012\u0004\u0012\u0002HA0BH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010C\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u001b\u0010\u0005\u001a\u00020\u0006*\u00020\u00078F\u00a2\u0006\f\u0012\u0004\b\b\u0010\t\u001a\u0004\b\n\u0010\u000b\"\u0018\u0010\f\u001a\u00020\r*\u00020\u000e8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\"\u0018\u0010\u0011\u001a\u00020\u0001*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0004\"\u0018\u0010\u0013\u001a\u00020\u0014*\u00020\u00158@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006D"}, d2={"bottom", "", "Ljava/awt/Rectangle;", "getBottom", "(Ljava/awt/Rectangle;)I", "earlyDisposable", "Lcom/intellij/openapi/Disposable;", "Lcom/intellij/openapi/project/Project;", "getEarlyDisposable$annotations", "(Lcom/intellij/openapi/project/Project;)V", "getEarlyDisposable", "(Lcom/intellij/openapi/project/Project;)Lcom/intellij/openapi/Disposable;", "location", "Ljava/awt/Point;", "Ljava/awt/event/MouseEvent;", "getLocation", "(Ljava/awt/event/MouseEvent;)Ljava/awt/Point;", "right", "getRight", "sizeWithoutInsets", "Ljava/awt/Dimension;", "Ljava/awt/Container;", "getSizeWithoutInsets", "(Ljava/awt/Container;)Ljava/awt/Dimension;", "createHardwareKeyEvent", "Lcom/android/emulator/control/KeyboardEvent;", "keyName", "", "eventType", "Lcom/android/emulator/control/KeyboardEvent$KeyEventType;", "getEmulatorUiTheme", "Lcom/android/emulator/control/ThemingStyle$Style;", "lafManager", "Lcom/intellij/ide/ui/LafManager;", "isSameAspectRatio", "", "width1", "height1", "width2", "height2", "tolerance", "", "coerceAtMost", "maximumValue", "constrainInside", "d", "contains", "p", "rotatedByQuadrants", "numQuadrants", "rotation", "scaled", "scale", "scaleX", "scaleY", "scaledDown", "numerator", "denominator", "scaledUnbiased", "fromDim", "toDim", "fromRange", "toRange", "scaledUp", "suspendingGet", "T", "Lcom/google/common/util/concurrent/ListenableFuture;", "(Lcom/google/common/util/concurrent/ListenableFuture;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.android.streaming"})
public final class StreamingUtilsKt {
    @NotNull
    public static final ThemingStyle.Style getEmulatorUiTheme(@NotNull LafManager lafManager) {
        Intrinsics.checkNotNullParameter((Object)lafManager, (String)"lafManager");
        String themeName = lafManager.getCurrentLookAndFeel().getName();
        Intrinsics.checkNotNullExpressionValue((Object)themeName, (String)"themeName");
        return StringsKt.contains((CharSequence)themeName, (CharSequence)"High contrast", (boolean)true) ? ThemingStyle.Style.CONTRAST : (StringsKt.contains((CharSequence)themeName, (CharSequence)"Light", (boolean)true) ? ThemingStyle.Style.LIGHT : ThemingStyle.Style.DARK);
    }

    @Nullable
    public static final <T> Object suspendingGet(@NotNull ListenableFuture<T> $this$suspendingGet, @NotNull Continuation<? super T> $completion) {
        if ($this$suspendingGet.isDone()) {
            return $this$suspendingGet.get();
        }
        boolean $i$f$suspendCancellableCoroutine = false;
        Continuation<? super T> uCont$iv = $completion;
        boolean bl = false;
        CancellableContinuationImpl cancellable$iv = new CancellableContinuationImpl(IntrinsicsKt.intercepted(uCont$iv), 1);
        cancellable$iv.initCancellability();
        CancellableContinuation continuation = (CancellableContinuation)cancellable$iv;
        boolean bl2 = false;
        JobKt.cancelFutureOnCancellation((CancellableContinuation)continuation, (Future)((Future)$this$suspendingGet));
        Runnable listener2 = new Runnable($this$suspendingGet, continuation){
            final /* synthetic */ ListenableFuture<T> $this_suspendingGet;
            final /* synthetic */ CancellableContinuation<T> $continuation;
            {
                this.$this_suspendingGet = $receiver;
                this.$continuation = $continuation;
            }

            public final void run() {
                Object object;
                try {
                    object = this.$this_suspendingGet.get();
                }
                catch (Throwable e) {
                    ((Continuation)this.$continuation).resumeWith(Result.constructor-impl((Object)ResultKt.createFailure((Throwable)e)));
                    return;
                }
                Object value2 = object;
                ((Continuation)this.$continuation).resumeWith(Result.constructor-impl((Object)value2));
            }
        };
        $this$suspendingGet.addListener(listener2, SameThreadExecutor.INSTANCE);
        Object object = cancellable$iv.getResult();
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            DebugProbesKt.probeCoroutineSuspended($completion);
        }
        return object;
    }

    @NotNull
    public static final KeyboardEvent createHardwareKeyEvent(@NotNull String keyName, @NotNull KeyboardEvent.KeyEventType eventType) {
        Intrinsics.checkNotNullParameter((Object)keyName, (String)"keyName");
        Intrinsics.checkNotNullParameter((Object)eventType, (String)"eventType");
        KeyboardEvent keyboardEvent = KeyboardEvent.newBuilder().setKey(keyName).setEventType(eventType).build();
        Intrinsics.checkNotNullExpressionValue((Object)keyboardEvent, (String)"newBuilder()\n    .setKey\u2026e(eventType)\n    .build()");
        return keyboardEvent;
    }

    public static /* synthetic */ KeyboardEvent createHardwareKeyEvent$default(String string, KeyboardEvent.KeyEventType keyEventType, int n, Object object) {
        if ((n & 2) != 0) {
            keyEventType = KeyboardEvent.KeyEventType.keypress;
        }
        return StreamingUtilsKt.createHardwareKeyEvent(string, keyEventType);
    }

    public static final int scaled(int $this$scaled, double scale) {
        return MathKt.roundToInt((double)((double)$this$scaled * scale));
    }

    public static final int scaledDown(int $this$scaledDown, double scale) {
        return (int)((double)$this$scaledDown * scale);
    }

    public static final int scaledUp(int $this$scaledUp, double scale) {
        return MathKt.roundToInt((double)Math.ceil((double)$this$scaledUp * scale));
    }

    @NotNull
    public static final Dimension scaled(@NotNull Dimension $this$scaled, double scale) {
        Intrinsics.checkNotNullParameter((Object)$this$scaled, (String)"<this>");
        return scale == 1.0 ? $this$scaled : new Dimension(StreamingUtilsKt.scaled($this$scaled.width, scale), StreamingUtilsKt.scaled($this$scaled.height, scale));
    }

    @NotNull
    public static final Dimension scaled(@NotNull Dimension $this$scaled, double scaleX, double scaleY) {
        Intrinsics.checkNotNullParameter((Object)$this$scaled, (String)"<this>");
        return scaleX == 1.0 && scaleY == 1.0 ? $this$scaled : new Dimension(StreamingUtilsKt.scaled($this$scaled.width, scaleX), StreamingUtilsKt.scaled($this$scaled.height, scaleY));
    }

    @NotNull
    public static final Point scaled(@NotNull Point $this$scaled, double scale) {
        Intrinsics.checkNotNullParameter((Object)$this$scaled, (String)"<this>");
        return scale == 1.0 ? $this$scaled : new Point(StreamingUtilsKt.scaled($this$scaled.x, scale), StreamingUtilsKt.scaled($this$scaled.y, scale));
    }

    public static final int scaledDown(int $this$scaledDown, int numerator, int denominator) {
        return (int)((long)$this$scaledDown * (long)numerator / (long)denominator);
    }

    public static final int scaledUnbiased(int $this$scaledUnbiased, int fromRange, int toRange) {
        return (int)(((long)$this$scaledUnbiased * 2L + 1L) * (long)toRange / (long)(2 * fromRange));
    }

    @NotNull
    public static final Point scaledUnbiased(@NotNull Point $this$scaledUnbiased, @NotNull Dimension fromDim, @NotNull Dimension toDim) {
        Intrinsics.checkNotNullParameter((Object)$this$scaledUnbiased, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)fromDim, (String)"fromDim");
        Intrinsics.checkNotNullParameter((Object)toDim, (String)"toDim");
        return new Point(StreamingUtilsKt.scaledUnbiased($this$scaledUnbiased.x, fromDim.width, toDim.width), StreamingUtilsKt.scaledUnbiased($this$scaledUnbiased.y, fromDim.height, toDim.height));
    }

    public static final boolean isSameAspectRatio(int width1, int height1, int width2, int height2, double tolerance) {
        double a = (double)width1 * (double)height2;
        double b = (double)width2 * (double)height1;
        double d = a - b;
        return Math.abs(d) <= tolerance * Math.abs(a + b) / (double)2;
    }

    @NotNull
    public static final Dimension rotatedByQuadrants(@NotNull Dimension $this$rotatedByQuadrants, int numQuadrants) {
        Intrinsics.checkNotNullParameter((Object)$this$rotatedByQuadrants, (String)"<this>");
        return numQuadrants % 2 == 0 ? $this$rotatedByQuadrants : new Dimension($this$rotatedByQuadrants.height, $this$rotatedByQuadrants.width);
    }

    @NotNull
    public static final Point rotatedByQuadrants(@NotNull Point $this$rotatedByQuadrants, int rotation) {
        Point point;
        Intrinsics.checkNotNullParameter((Object)$this$rotatedByQuadrants, (String)"<this>");
        switch (rotation & 3) {
            case 1: {
                point = new Point($this$rotatedByQuadrants.y, -$this$rotatedByQuadrants.x);
                break;
            }
            case 2: {
                point = new Point(-$this$rotatedByQuadrants.x, -$this$rotatedByQuadrants.y);
                break;
            }
            case 3: {
                point = new Point(-$this$rotatedByQuadrants.y, $this$rotatedByQuadrants.x);
                break;
            }
            default: {
                point = $this$rotatedByQuadrants;
            }
        }
        return point;
    }

    @NotNull
    public static final Dimension coerceAtMost(@NotNull Dimension $this$coerceAtMost, @NotNull Dimension maximumValue) {
        Intrinsics.checkNotNullParameter((Object)$this$coerceAtMost, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)maximumValue, (String)"maximumValue");
        if ($this$coerceAtMost.width <= maximumValue.width && $this$coerceAtMost.height <= maximumValue.height) {
            return $this$coerceAtMost;
        }
        double scale = RangesKt.coerceAtMost((double)Math.min((double)maximumValue.width / (double)$this$coerceAtMost.width, (double)maximumValue.height / (double)$this$coerceAtMost.height), (double)1.0);
        return new Dimension(RangesKt.coerceAtMost((int)StreamingUtilsKt.scaled($this$coerceAtMost.width, scale), (int)maximumValue.width), RangesKt.coerceAtMost((int)StreamingUtilsKt.scaled($this$coerceAtMost.height, scale), (int)maximumValue.height));
    }

    @NotNull
    public static final Dimension getSizeWithoutInsets(@NotNull Container $this$sizeWithoutInsets) {
        Intrinsics.checkNotNullParameter((Object)$this$sizeWithoutInsets, (String)"<this>");
        return new Dimension($this$sizeWithoutInsets.getWidth() - $this$sizeWithoutInsets.getInsets().left - RangesKt.coerceAtLeast((int)$this$sizeWithoutInsets.getInsets().right, (int)0), $this$sizeWithoutInsets.getHeight() - $this$sizeWithoutInsets.getInsets().top - RangesKt.coerceAtLeast((int)$this$sizeWithoutInsets.getInsets().bottom, (int)0));
    }

    @NotNull
    public static final Disposable getEarlyDisposable(@NotNull Project $this$earlyDisposable) {
        Intrinsics.checkNotNullParameter((Object)$this$earlyDisposable, (String)"<this>");
        ProjectEx projectEx = $this$earlyDisposable instanceof ProjectEx ? (ProjectEx)$this$earlyDisposable : null;
        Object object = projectEx != null ? projectEx.getEarlyDisposable() : null;
        if (object == null) {
            object = (Disposable)$this$earlyDisposable;
        }
        return object;
    }

    public static /* synthetic */ void getEarlyDisposable$annotations(Project project) {
    }

    @NotNull
    public static final Point constrainInside(@NotNull Point $this$constrainInside, @NotNull Dimension d) {
        Intrinsics.checkNotNullParameter((Object)$this$constrainInside, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)d, (String)"d");
        return StreamingUtilsKt.contains(d, $this$constrainInside) ? $this$constrainInside : new Point(RangesKt.coerceIn((int)$this$constrainInside.x, (int)0, (int)(d.width - 1)), RangesKt.coerceIn((int)$this$constrainInside.y, (int)0, (int)(d.height - 1)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean contains(@NotNull Dimension $this$contains, @NotNull Point p) {
        Intrinsics.checkNotNullParameter((Object)$this$contains, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        int n = $this$contains.width;
        int n2 = p.x;
        if (0 > n2) return false;
        if (n2 >= n) return false;
        boolean bl = true;
        if (!bl) return false;
        n = $this$contains.height;
        n2 = p.y;
        if (0 > n2) return false;
        if (n2 >= n) return false;
        return true;
    }

    public static final int getRight(@NotNull Rectangle $this$right) {
        Intrinsics.checkNotNullParameter((Object)$this$right, (String)"<this>");
        return $this$right.x + $this$right.width;
    }

    public static final int getBottom(@NotNull Rectangle $this$bottom) {
        Intrinsics.checkNotNullParameter((Object)$this$bottom, (String)"<this>");
        return $this$bottom.y + $this$bottom.height;
    }

    @NotNull
    public static final Point getLocation(@NotNull MouseEvent $this$location) {
        Intrinsics.checkNotNullParameter((Object)$this$location, (String)"<this>");
        return new Point($this$location.getX(), $this$location.getY());
    }
}

