/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.streaming;

import com.android.adblib.AdbDeviceServices;
import com.android.adblib.AdbDeviceServicesKt;
import com.android.adblib.AdbSession;
import com.android.adblib.AdbSessionKt;
import com.android.adblib.DeviceInfo;
import com.android.adblib.DeviceProperties;
import com.android.adblib.DeviceSelector;
import com.android.adblib.DeviceState;
import com.android.adblib.TrackedDeviceList;
import com.android.annotations.concurrency.AnyThread;
import com.android.annotations.concurrency.UiThread;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.tools.idea.adblib.AdbLibService;
import com.android.tools.idea.avdmanager.AvdLaunchListener;
import com.android.tools.idea.concurrency.CoroutinesUtilsKt;
import com.android.tools.idea.concurrency.FutureUtils;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.run.DeviceHeadsUpListener;
import com.android.tools.idea.streaming.DeviceId;
import com.android.tools.idea.streaming.DeviceMirroringSettings;
import com.android.tools.idea.streaming.DeviceMirroringSettingsListener;
import com.android.tools.idea.streaming.EmptyStatePanel;
import com.android.tools.idea.streaming.RunningDevicePanel;
import com.android.tools.idea.streaming.StreamingToolWindowManager;
import com.android.tools.idea.streaming.StreamingUtilsKt;
import com.android.tools.idea.streaming.device.DeviceToolWindowPanel;
import com.android.tools.idea.streaming.device.dialogs.MirroringConfirmationDialog;
import com.android.tools.idea.streaming.emulator.EmulatorController;
import com.android.tools.idea.streaming.emulator.EmulatorId;
import com.android.tools.idea.streaming.emulator.EmulatorToolWindowPanel;
import com.android.tools.idea.streaming.emulator.RunningEmulatorCatalog;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.ide.actions.ToggleToolbarAction;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.util.Alarm;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.UIUtil;
import icons.StudioIcons;
import java.awt.EventQueue;
import java.text.Collator;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference0Impl;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.ExecutorsKt;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import org.apache.commons.lang.WordUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@UiThread
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00c6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010$\n\u0000\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\"\n\u0002\b\u0010*\u0002\n\u000f\b\u0001\u0018\u0000 j2\u00020\u00012\u00020\u00022\u00020\u0003:\u0004jklmB\u000f\b\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020\u001bH\u0002J\u0010\u0010=\u001a\u00020;2\u0006\u0010>\u001a\u00020(H\u0002J4\u0010?\u001a\u00020;2\u0006\u0010@\u001a\u00020!2\u0006\u0010A\u001a\u00020!2\u0006\u0010B\u001a\u00020!2\u0012\u0010C\u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020!0\"H\u0002J\u0010\u0010D\u001a\u00020;2\u0006\u0010E\u001a\u00020FH\u0002J\b\u0010G\u001a\u00020;H\u0002J\u0010\u0010H\u001a\u00020;2\u0006\u0010I\u001a\u00020JH\u0002J\u0010\u0010K\u001a\u00020;2\u0006\u0010E\u001a\u00020FH\u0002J\u0010\u0010L\u001a\u00020;2\u0006\u0010<\u001a\u00020\u001bH\u0017J\u0010\u0010M\u001a\u00020;2\u0006\u0010<\u001a\u00020\u001bH\u0017J\u0012\u0010N\u001a\u0004\u0018\u00010(2\u0006\u0010O\u001a\u00020!H\u0002J\u0012\u0010P\u001a\u0004\u0018\u00010(2\u0006\u0010Q\u001a\u00020\u001eH\u0002J\u0012\u0010R\u001a\u0004\u0018\u00010(2\u0006\u0010S\u001a\u00020TH\u0002J\u0012\u0010U\u001a\u0004\u0018\u00010(2\u0006\u0010@\u001a\u00020!H\u0002J\b\u0010V\u001a\u00020WH\u0002J\b\u0010X\u001a\u00020FH\u0002J\u0010\u0010Y\u001a\u00020;2\u0006\u0010E\u001a\u00020FH\u0002J\u0010\u0010Z\u001a\u00020;2\u0006\u0010[\u001a\u00020!H\u0002J\u0010\u0010\\\u001a\u00020;2\u0006\u0010O\u001a\u00020!H\u0002J\u001e\u0010\\\u001a\u00020;2\u0006\u0010[\u001a\u00020!2\f\u0010]\u001a\b\u0012\u0004\u0012\u00020\u001b0^H\u0002J\u0010\u0010_\u001a\u00020;2\u0006\u0010[\u001a\u00020!H\u0002J\b\u0010`\u001a\u00020;H\u0002J\u0010\u0010a\u001a\u00020;2\u0006\u0010<\u001a\u00020\u001bH\u0002J\u0010\u0010b\u001a\u00020;2\u0006\u0010>\u001a\u00020(H\u0002J\u0010\u0010c\u001a\u00020;2\u0006\u0010@\u001a\u00020!H\u0002J\u0018\u0010d\u001a\u00020;2\u0006\u0010>\u001a\u00020(2\u0006\u0010E\u001a\u00020FH\u0002J\u0010\u0010e\u001a\u00020;2\u0006\u0010f\u001a\u00020\u0018H\u0016J\u0010\u0010g\u001a\u00020;2\u0006\u0010E\u001a\u00020FH\u0002J\u0010\u0010h\u001a\u00020;2\u0006\u0010E\u001a\u00020FH\u0002J\f\u0010i\u001a\u00020;*\u00020FH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010R$\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\r8B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0019\u001a\u0012\u0012\u0004\u0012\u00020\u001b0\u001aj\b\u0012\u0004\u0012\u00020\u001b`\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010\u001f\u001a\u001a\u0012\u0004\u0012\u00020!\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020!0\"0 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010#\u001a\b\u0012\u0004\u0012\u00020!0$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010&\u001a\u0012\u0012\u0004\u0012\u00020(0'j\b\u0012\u0004\u0012\u00020(`)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010*\u001a\b\u0018\u00010+R\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010,\u001a\n .*\u0004\u0018\u00010-0-X\u0082\u0004\u00a2\u0006\u0002\n\u0000RN\u0010/\u001aB\u0012\f\u0012\n .*\u0004\u0018\u00010!0!\u0012\f\u0012\n .*\u0004\u0018\u00010!0! .* \u0012\f\u0012\n .*\u0004\u0018\u00010!0!\u0012\f\u0012\n .*\u0004\u0018\u00010!0!\u0018\u00010000X\u0082\u0004\u00a2\u0006\u0002\n\u0000RN\u00101\u001aB\u0012\f\u0012\n .*\u0004\u0018\u00010!0!\u0012\f\u0012\n .*\u0004\u0018\u00010!0! .* \u0012\f\u0012\n .*\u0004\u0018\u00010!0!\u0012\f\u0012\n .*\u0004\u0018\u00010!0!\u0018\u00010000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u00102\u001a\u001e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020403j\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u000204`5X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00106\u001a\u0004\u0018\u00010(X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u00107\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\r8B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b8\u0010\u0014\"\u0004\b9\u0010\u0016\u00a8\u0006n"}, d2={"Lcom/android/tools/idea/streaming/StreamingToolWindowManager;", "Lcom/android/tools/idea/streaming/emulator/RunningEmulatorCatalog$Listener;", "Lcom/android/tools/idea/streaming/DeviceMirroringSettingsListener;", "Lcom/intellij/openapi/project/DumbAware;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "alarm", "Lcom/intellij/util/Alarm;", "connectionStateListener", "com/android/tools/idea/streaming/StreamingToolWindowManager$connectionStateListener$1", "Lcom/android/tools/idea/streaming/StreamingToolWindowManager$connectionStateListener$1;", "contentCreated", "", "contentManagerListener", "com/android/tools/idea/streaming/StreamingToolWindowManager$contentManagerListener$1", "Lcom/android/tools/idea/streaming/StreamingToolWindowManager$contentManagerListener$1;", "value", "deviceFrameVisible", "getDeviceFrameVisible", "()Z", "setDeviceFrameVisible", "(Z)V", "deviceMirroringSettings", "Lcom/android/tools/idea/streaming/DeviceMirroringSettings;", "emulators", "Ljava/util/HashSet;", "Lcom/android/tools/idea/streaming/emulator/EmulatorController;", "Lkotlin/collections/HashSet;", "lastSelectedDeviceId", "Lcom/android/tools/idea/streaming/DeviceId;", "mirrorableDeviceProperties", "", "", "", "mirroredDevices", "", "mirroringConfirmationDialogShowing", "panels", "Ljava/util/ArrayList;", "Lcom/android/tools/idea/streaming/RunningDevicePanel;", "Lkotlin/collections/ArrayList;", "physicalDeviceWatcher", "Lcom/android/tools/idea/streaming/StreamingToolWindowManager$PhysicalDeviceWatcher;", "properties", "Lcom/intellij/ide/util/PropertiesComponent;", "kotlin.jvm.PlatformType", "recentAttentionRequests", "Lcom/google/common/cache/Cache;", "recentEmulatorLaunches", "savedUiState", "Ljava/util/HashMap;", "Lcom/android/tools/idea/streaming/RunningDevicePanel$UiState;", "Lkotlin/collections/HashMap;", "selectedPanel", "zoomToolbarIsVisible", "getZoomToolbarIsVisible", "setZoomToolbarIsVisible", "addEmulatorPanel", "", "emulator", "addPanel", "panel", "addPhysicalDevicePanel", "serialNumber", "abi", "title", "deviceProperties", "createContent", "toolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "createEmptyStatePanel", "createPhysicalDeviceWatcherIfToolWindowAvailable", "toolWindowManager", "Lcom/intellij/openapi/wm/ToolWindowManager;", "destroyContent", "emulatorAdded", "emulatorRemoved", "findPanelByAvdId", "avdId", "findPanelByDeviceId", "deviceId", "findPanelByEmulatorId", "emulatorId", "Lcom/android/tools/idea/streaming/emulator/EmulatorId;", "findPanelBySerialNumber", "getContentManager", "Lcom/intellij/ui/content/ContentManager;", "getToolWindow", "hideLiveIndicator", "onDeviceHeadsUp", "deviceSerialNumber", "onEmulatorHeadsUp", "runningEmulators", "", "onPhysicalDeviceHeadsUp", "removeAllPhysicalDevicePanels", "removeEmulatorPanel", "removePanel", "removePhysicalDevicePanel", "selectPanel", "settingsChanged", "settings", "showLiveIndicator", "viewSelectionChanged", "showAndActivate", "Companion", "PhysicalDeviceWatcher", "ToggleDeviceFrameAction", "ToggleZoomToolbarAction", "intellij.android.streaming"})
public final class StreamingToolWindowManager
implements RunningEmulatorCatalog.Listener,
DeviceMirroringSettingsListener,
DumbAware {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final DeviceMirroringSettings deviceMirroringSettings;
    private boolean contentCreated;
    private boolean mirroringConfirmationDialogShowing;
    @Nullable
    private PhysicalDeviceWatcher physicalDeviceWatcher;
    @NotNull
    private final ArrayList<RunningDevicePanel> panels;
    @Nullable
    private RunningDevicePanel selectedPanel;
    @Nullable
    private DeviceId lastSelectedDeviceId;
    @NotNull
    private final HashMap<DeviceId, RunningDevicePanel.UiState> savedUiState;
    @NotNull
    private final HashSet<EmulatorController> emulators;
    @NotNull
    private Map<String, Map<String, String>> mirrorableDeviceProperties;
    @NotNull
    private Set<String> mirroredDevices;
    private final PropertiesComponent properties;
    private final Cache<String, String> recentAttentionRequests;
    private final Cache<String, String> recentEmulatorLaunches;
    @NotNull
    private final Alarm alarm;
    @NotNull
    private final contentManagerListener.1 contentManagerListener;
    @NotNull
    private final connectionStateListener.1 connectionStateListener;
    @NotNull
    private static final String DEVICE_FRAME_VISIBLE_PROPERTY = "com.android.tools.idea.streaming.emulator.frame.visible";
    private static final boolean DEVICE_FRAME_VISIBLE_DEFAULT = true;
    @NotNull
    private static final String ZOOM_TOOLBAR_VISIBLE_PROPERTY = "com.android.tools.idea.streaming.emulator.zoom.toolbar.visible";
    private static final boolean ZOOM_TOOLBAR_VISIBLE_DEFAULT = true;
    private static final int EMULATOR_DISCOVERY_INTERVAL_MILLIS = 1000;
    @NotNull
    private static final Key<DeviceId> ID_KEY;
    private static final Duration ATTENTION_REQUEST_EXPIRATION;
    private static final Collator COLLATOR;
    @NotNull
    private static final Comparator<RunningDevicePanel> PANEL_COMPARATOR;
    @NotNull
    private static final Set<Project> registeredProjects;

    @AnyThread
    private StreamingToolWindowManager(Project project) {
        this.project = project;
        this.deviceMirroringSettings = DeviceMirroringSettings.Companion.getInstance();
        this.panels = new ArrayList();
        this.savedUiState = new HashMap();
        this.emulators = new HashSet();
        this.mirrorableDeviceProperties = new LinkedHashMap();
        this.mirroredDevices = new LinkedHashSet();
        this.properties = PropertiesComponent.getInstance((Project)this.project);
        this.recentAttentionRequests = CacheBuilder.newBuilder().expireAfterWrite(ATTENTION_REQUEST_EXPIRATION).build();
        this.recentEmulatorLaunches = CacheBuilder.newBuilder().expireAfterWrite(ATTENTION_REQUEST_EXPIRATION).build();
        this.alarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, StreamingUtilsKt.getEarlyDisposable(this.project));
        this.contentManagerListener = new ContentManagerListener(this){
            final /* synthetic */ StreamingToolWindowManager this$0;
            {
                this.this$0 = $receiver;
            }

            public void selectionChanged(@NotNull ContentManagerEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                StreamingToolWindowManager.access$viewSelectionChanged(this.this$0, StreamingToolWindowManager.access$getToolWindow(this.this$0));
            }

            public void contentRemoveQuery(@NotNull ContentManagerEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                JComponent jComponent = event.getContent().getComponent();
                RunningDevicePanel runningDevicePanel = jComponent instanceof RunningDevicePanel ? (RunningDevicePanel)((Object)jComponent) : null;
                if (runningDevicePanel == null) {
                    return;
                }
                RunningDevicePanel panel2 = runningDevicePanel;
                if (panel2 instanceof EmulatorToolWindowPanel) {
                    ((EmulatorToolWindowPanel)panel2).getEmulator().shutdown();
                }
                StreamingToolWindowManager.access$getPanels$p(this.this$0).remove((Object)((Object)panel2));
                StreamingToolWindowManager.access$getSavedUiState$p(this.this$0).remove(panel2.getId());
                if (StreamingToolWindowManager.access$getPanels$p(this.this$0).isEmpty()) {
                    StreamingToolWindowManager.access$createEmptyStatePanel(this.this$0);
                    StreamingToolWindowManager.access$hideLiveIndicator(this.this$0, StreamingToolWindowManager.access$getToolWindow(this.this$0));
                }
            }
        };
        this.connectionStateListener = new EmulatorController.ConnectionStateListener(this){
            final /* synthetic */ StreamingToolWindowManager this$0;
            {
                this.this$0 = $receiver;
            }

            @AnyThread
            public void connectionStateChanged(@NotNull EmulatorController emulator, @NotNull EmulatorController.ConnectionState connectionState) {
                Intrinsics.checkNotNullParameter((Object)emulator, (String)"emulator");
                Intrinsics.checkNotNullParameter((Object)((Object)connectionState), (String)"connectionState");
                if (connectionState == EmulatorController.ConnectionState.DISCONNECTED) {
                    EventQueue.invokeLater(new Runnable(this.this$0, emulator){
                        final /* synthetic */ StreamingToolWindowManager this$0;
                        final /* synthetic */ EmulatorController $emulator;
                        {
                            this.this$0 = $receiver;
                            this.$emulator = $emulator;
                        }

                        public final void run() {
                            if (StreamingToolWindowManager.access$getContentCreated$p(this.this$0) && StreamingToolWindowManager.access$getEmulators$p(this.this$0).remove(this.$emulator)) {
                                StreamingToolWindowManager.access$removeEmulatorPanel(this.this$0, this.$emulator);
                            }
                        }
                    });
                }
            }
        };
        Disposer.register((Disposable)StreamingUtilsKt.getEarlyDisposable(this.project), (Disposable)new Disposable(){

            public final void dispose() {
                block0: {
                    ToolWindow toolWindow = ToolWindowManager.Companion.getInstance(project).getToolWindow("Running Devices");
                    if (toolWindow == null) break block0;
                    ToolWindow toolWindow2 = toolWindow;
                    StreamingToolWindowManager streamingToolWindowManager = this;
                    ToolWindow it = toolWindow2;
                    boolean bl = false;
                    streamingToolWindowManager.destroyContent(it);
                }
            }
        });
        MessageBusConnection messageBusConnection = this.project.getMessageBus().connect(StreamingUtilsKt.getEarlyDisposable(this.project));
        Intrinsics.checkNotNullExpressionValue((Object)messageBusConnection, (String)"project.messageBus.conne\u2026(project.earlyDisposable)");
        final MessageBusConnection messageBusConnection2 = messageBusConnection;
        Topic topic = ToolWindowManagerListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        messageBusConnection2.subscribe(topic, (Object)new ToolWindowManagerListener(){

            public void stateChanged(@NotNull ToolWindowManager toolWindowManager) {
                Intrinsics.checkNotNullParameter((Object)toolWindowManager, (String)"toolWindowManager");
                ToolWindow toolWindow = toolWindowManager.getToolWindow("Running Devices");
                if (toolWindow == null) {
                    return;
                }
                ToolWindow toolWindow2 = toolWindow;
                toolWindowManager.invokeLater(new Runnable(this, toolWindow2){
                    final /* synthetic */ StreamingToolWindowManager this$0;
                    final /* synthetic */ ToolWindow $toolWindow;
                    {
                        this.this$0 = $receiver;
                        this.$toolWindow = $toolWindow;
                    }

                    public final void run() {
                        if (!StreamingToolWindowManager.access$getProject$p(this.this$0).isDisposed()) {
                            if (this.$toolWindow.isVisible()) {
                                StreamingToolWindowManager.access$createContent(this.this$0, this.$toolWindow);
                            } else {
                                StreamingToolWindowManager.access$destroyContent(this.this$0, this.$toolWindow);
                            }
                        }
                    }
                });
            }
        });
        Topic<AvdLaunchListener> topic2 = AvdLaunchListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic2, (String)"TOPIC");
        messageBusConnection2.subscribe(topic2, (Object)new AvdLaunchListener(){

            @Override
            public final void avdLaunched(final @NotNull AvdInfo avd, @NotNull GeneralCommandLine commandLine, @Nullable Project project) {
                Intrinsics.checkNotNullParameter((Object)avd, (String)"avd");
                Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
                if (Intrinsics.areEqual((Object)project, (Object)project) && Companion.isEmbeddedEmulator(commandLine)) {
                    RunningEmulatorCatalog.Companion.getInstance().updateNow();
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public final void run() {
                            String string = avd.getName();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"avd.name");
                            this.onEmulatorHeadsUp(string);
                        }
                    });
                }
            }
        });
        Topic<DeviceHeadsUpListener> topic3 = DeviceHeadsUpListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic3, (String)"TOPIC");
        messageBusConnection2.subscribe(topic3, (Object)new DeviceHeadsUpListener(){

            @Override
            public final void deviceNeedsAttention(final @NotNull String deviceSerialNumber, @NotNull Project project) {
                Intrinsics.checkNotNullParameter((Object)deviceSerialNumber, (String)"deviceSerialNumber");
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                if (Intrinsics.areEqual((Object)project, (Object)project)) {
                    UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                        @Override
                        public final void run() {
                            this.onDeviceHeadsUp(deviceSerialNumber);
                        }
                    });
                }
            }
        });
        Topic<DeviceMirroringSettingsListener> topic4 = DeviceMirroringSettingsListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic4, (String)"TOPIC");
        messageBusConnection2.subscribe(topic4, (Object)this);
        if (this.deviceMirroringSettings.getDeviceMirroringEnabled()) {
            UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                @Override
                public final void run() {
                    this.createPhysicalDeviceWatcherIfToolWindowAvailable(ToolWindowManager.Companion.getInstance(project));
                    if (physicalDeviceWatcher == null) {
                        Topic topic = ToolWindowManagerListener.TOPIC;
                        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
                        messageBusConnection2.subscribe(topic, (Object)new ToolWindowManagerListener(){

                            public void toolWindowsRegistered(@NotNull List<String> ids2, @NotNull ToolWindowManager toolWindowManager) {
                                Intrinsics.checkNotNullParameter(ids2, (String)"ids");
                                Intrinsics.checkNotNullParameter((Object)toolWindowManager, (String)"toolWindowManager");
                                if (ids2.contains("Running Devices") && deviceMirroringSettings.getDeviceMirroringEnabled() && physicalDeviceWatcher == null) {
                                    this.createPhysicalDeviceWatcherIfToolWindowAvailable(toolWindowManager);
                                }
                            }
                        });
                    }
                }
            });
        }
    }

    private final boolean getDeviceFrameVisible() {
        return this.properties.getBoolean(DEVICE_FRAME_VISIBLE_PROPERTY, true);
    }

    private final void setDeviceFrameVisible(boolean value2) {
        this.properties.setValue(DEVICE_FRAME_VISIBLE_PROPERTY, value2, true);
        for (RunningDevicePanel panel2 : this.panels) {
            panel2.setDeviceFrameVisible(value2);
        }
    }

    private final boolean getZoomToolbarIsVisible() {
        return this.properties.getBoolean(ZOOM_TOOLBAR_VISIBLE_PROPERTY, true);
    }

    private final void setZoomToolbarIsVisible(boolean value2) {
        this.properties.setValue(ZOOM_TOOLBAR_VISIBLE_PROPERTY, value2, true);
        for (RunningDevicePanel panel2 : this.panels) {
            panel2.setZoomToolbarVisible(value2);
        }
    }

    private final void createPhysicalDeviceWatcherIfToolWindowAvailable(ToolWindowManager toolWindowManager) {
        ToolWindow toolWindow = toolWindowManager.getToolWindow("Running Devices");
        if (toolWindow != null) {
            Disposable disposable2 = toolWindow.getDisposable();
            Intrinsics.checkNotNullExpressionValue((Object)disposable2, (String)"toolWindow.disposable");
            this.physicalDeviceWatcher = new PhysicalDeviceWatcher(disposable2);
        }
    }

    private final void onDeviceHeadsUp(String deviceSerialNumber) {
        if (this.mirrorableDeviceProperties.containsKey(deviceSerialNumber)) {
            this.onPhysicalDeviceHeadsUp(deviceSerialNumber);
        } else {
            this.recentAttentionRequests.put((Object)deviceSerialNumber, (Object)deviceSerialNumber);
            Cache<String, String> cache2 = this.recentAttentionRequests;
            Intrinsics.checkNotNullExpressionValue(cache2, (String)"recentAttentionRequests");
            Cache<String, String> cache3 = cache2;
            this.alarm.addRequest(new Runnable(cache3){
                final /* synthetic */ Cache<String, String> $tmp0;
                {
                    this.$tmp0 = $tmp0;
                }

                public final void run() {
                    this.$tmp0.cleanUp();
                }
            }, ATTENTION_REQUEST_EXPIRATION.toMillis());
            if (StringsKt.startsWith$default((String)deviceSerialNumber, (String)"emulator-", (boolean)false, (int)2, null)) {
                ListenableFuture<Set<EmulatorController>> future2 = RunningEmulatorCatalog.Companion.getInstance().updateNow();
                EdtExecutorService edtExecutorService = EdtExecutorService.getInstance();
                Intrinsics.checkNotNullExpressionValue((Object)edtExecutorService, (String)"getInstance()");
                FutureUtils.addCallback(future2, (Executor)((Executor)edtExecutorService), (Function1)((Function1)new Function1<Set<? extends EmulatorController>, Unit>(this, deviceSerialNumber){
                    final /* synthetic */ StreamingToolWindowManager this$0;
                    final /* synthetic */ String $deviceSerialNumber;
                    {
                        this.this$0 = $receiver;
                        this.$deviceSerialNumber = $deviceSerialNumber;
                        super(1);
                    }

                    public final void invoke(@Nullable Set<EmulatorController> emulators) {
                        if (emulators != null) {
                            StreamingToolWindowManager.access$onEmulatorHeadsUp(this.this$0, this.$deviceSerialNumber, emulators);
                        }
                    }
                }), (Function1)onDeviceHeadsUp.3.INSTANCE);
            }
        }
    }

    private final void onPhysicalDeviceHeadsUp(String deviceSerialNumber) {
        ToolWindow toolWindow = this.getToolWindow();
        if (!toolWindow.isVisible()) {
            this.lastSelectedDeviceId = DeviceId.Companion.ofPhysicalDevice(deviceSerialNumber);
            this.showAndActivate(toolWindow);
        } else {
            RunningDevicePanel panel2 = this.findPanelBySerialNumber(deviceSerialNumber);
            if (panel2 != null) {
                this.selectPanel(panel2, toolWindow);
                this.showAndActivate(toolWindow);
            }
        }
    }

    private final void onEmulatorHeadsUp(String deviceSerialNumber, Set<EmulatorController> runningEmulators) {
        Object v0;
        block3: {
            Iterable iterable = runningEmulators;
            for (Object t : iterable) {
                EmulatorController it = (EmulatorController)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getEmulatorId().getSerialNumber(), (Object)deviceSerialNumber)) continue;
                v0 = t;
                break block3;
            }
            v0 = null;
        }
        EmulatorController emulatorController = v0;
        if (emulatorController == null) {
            return;
        }
        EmulatorController emulator = emulatorController;
        if (emulator.getEmulatorId().isEmbedded()) {
            this.onEmulatorHeadsUp(emulator.getEmulatorId().getAvdId());
        }
    }

    private final void onEmulatorHeadsUp(String avdId) {
        ToolWindow toolWindow = this.getToolWindow();
        this.showAndActivate(toolWindow);
        RunningDevicePanel panel2 = this.findPanelByAvdId(avdId);
        if (panel2 == null) {
            RunningEmulatorCatalog.Companion.getInstance().updateNow();
            this.recentEmulatorLaunches.put((Object)avdId, (Object)avdId);
            Cache<String, String> cache2 = this.recentEmulatorLaunches;
            Intrinsics.checkNotNullExpressionValue(cache2, (String)"recentEmulatorLaunches");
            Cache<String, String> cache3 = cache2;
            this.alarm.addRequest(new Runnable(cache3){
                final /* synthetic */ Cache<String, String> $tmp0;
                {
                    this.$tmp0 = $tmp0;
                }

                public final void run() {
                    this.$tmp0.cleanUp();
                }
            }, ATTENTION_REQUEST_EXPIRATION.toMillis());
        } else {
            this.selectPanel(panel2, toolWindow);
        }
    }

    private final void selectPanel(RunningDevicePanel panel2, ToolWindow toolWindow) {
        if (!Intrinsics.areEqual((Object)((Object)this.selectedPanel), (Object)((Object)panel2))) {
            ContentManager contentManager = toolWindow.getContentManager();
            Intrinsics.checkNotNullExpressionValue((Object)contentManager, (String)"toolWindow.contentManager");
            ContentManager contentManager2 = contentManager;
            Content content2 = contentManager2.getContent((JComponent)((Object)panel2));
            contentManager2.setSelectedContent(content2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void createContent(ToolWindow toolWindow) {
        Map<String, String> deviceProperties;
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        if (this.contentCreated) {
            return;
        }
        this.contentCreated = true;
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        actionGroup.addAction((AnAction)new ToggleZoomToolbarAction());
        actionGroup.addAction((AnAction)new ToggleDeviceFrameAction());
        Intrinsics.checkNotNull((Object)toolWindow, (String)"null cannot be cast to non-null type com.intellij.openapi.wm.ex.ToolWindowEx");
        ((ToolWindowEx)toolWindow).setAdditionalGearActions((ActionGroup)actionGroup);
        RunningEmulatorCatalog emulatorCatalog = RunningEmulatorCatalog.Companion.getInstance();
        emulatorCatalog.updateNow();
        emulatorCatalog.addListener(this, 1000);
        Iterable iterable = emulatorCatalog.getEmulators();
        HashSet<EmulatorController> hashSet = this.emulators;
        boolean $i$f$filter = false;
        void var6_11 = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            EmulatorController it = (EmulatorController)element$iv$iv;
            boolean bl = false;
            if (!it.getEmulatorId().isEmbedded()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        hashSet.addAll((List)destination$iv$iv);
        Iterator<Map.Entry<String, Map<String, String>>> activeDeviceId = this.lastSelectedDeviceId;
        if (activeDeviceId instanceof DeviceId.EmulatorDeviceId) {
            Iterator<Object> iterator2;
            block11: {
                destination$iv$iv = this.emulators;
                for (Iterator<Object> iterator3 : destination$iv$iv) {
                    EmulatorController it = (EmulatorController)((Object)iterator3);
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getEmulatorId(), (Object)((DeviceId.EmulatorDeviceId)((Object)activeDeviceId)).getEmulatorId())) continue;
                    iterator2 = iterator3;
                    break block11;
                }
                iterator2 = null;
            }
            EmulatorController activeEmulator = (EmulatorController)((Object)iterator2);
            if (activeEmulator != null && !activeEmulator.isShuttingDown()) {
                this.addEmulatorPanel(activeEmulator);
            }
        } else if (activeDeviceId instanceof DeviceId.PhysicalDeviceId && (deviceProperties = this.mirrorableDeviceProperties.get(((DeviceId.PhysicalDeviceId)((Object)activeDeviceId)).getSerialNumber())) != null) {
            PhysicalDeviceWatcher physicalDeviceWatcher = this.physicalDeviceWatcher;
            if (physicalDeviceWatcher != null) {
                physicalDeviceWatcher.deviceConnected(((DeviceId.PhysicalDeviceId)((Object)activeDeviceId)).getSerialNumber(), deviceProperties);
            }
        }
        for (EmulatorController emulator : this.emulators) {
            DeviceId deviceId = this.lastSelectedDeviceId;
            if (Intrinsics.areEqual((Object)emulator.getEmulatorId().getSerialNumber(), (Object)(deviceId != null ? deviceId.getSerialNumber() : null)) || emulator.isShuttingDown()) continue;
            Intrinsics.checkNotNullExpressionValue((Object)emulator, (String)"emulator");
            this.addEmulatorPanel(emulator);
        }
        for (Map.Entry<String, Map<String, String>> entry : this.mirrorableDeviceProperties.entrySet()) {
            String serialNumber = entry.getKey();
            Map<String, String> deviceProperties2 = entry.getValue();
            DeviceId deviceId = this.lastSelectedDeviceId;
            if (Intrinsics.areEqual((Object)serialNumber, (Object)(deviceId != null ? deviceId.getSerialNumber() : null))) continue;
            PhysicalDeviceWatcher physicalDeviceWatcher = this.physicalDeviceWatcher;
            if (physicalDeviceWatcher == null) continue;
            physicalDeviceWatcher.deviceConnected(serialNumber, deviceProperties2);
        }
        this.lastSelectedDeviceId = null;
        ContentManager contentManager = ((ToolWindowEx)toolWindow).getContentManager();
        Intrinsics.checkNotNullExpressionValue((Object)contentManager, (String)"toolWindow.contentManager");
        ContentManager contentManager2 = contentManager;
        if (contentManager2.getContentCount() == 0) {
            this.createEmptyStatePanel();
        }
        contentManager2.addContentManagerListener((ContentManagerListener)this.contentManagerListener);
        this.viewSelectionChanged(toolWindow);
    }

    private final void destroyContent(ToolWindow toolWindow) {
        if (!this.contentCreated) {
            return;
        }
        this.contentCreated = false;
        RunningDevicePanel runningDevicePanel = this.selectedPanel;
        this.lastSelectedDeviceId = runningDevicePanel != null ? runningDevicePanel.getId() : null;
        RunningEmulatorCatalog.Companion.getInstance().removeListener(this);
        for (EmulatorController emulator : this.emulators) {
            emulator.removeConnectionStateListener(this.connectionStateListener);
        }
        this.emulators.clear();
        this.mirroredDevices.clear();
        RunningDevicePanel runningDevicePanel2 = this.selectedPanel;
        if (runningDevicePanel2 != null) {
            RunningDevicePanel it = runningDevicePanel2;
            boolean bl = false;
            ((Map)this.savedUiState).put(it.getId(), it.destroyContent());
        }
        this.selectedPanel = null;
        this.panels.clear();
        this.recentAttentionRequests.invalidateAll();
        this.recentEmulatorLaunches.invalidateAll();
        ContentManager contentManager = toolWindow.getContentManager();
        Intrinsics.checkNotNullExpressionValue((Object)contentManager, (String)"toolWindow.contentManager");
        ContentManager contentManager2 = contentManager;
        contentManager2.removeContentManagerListener((ContentManagerListener)this.contentManagerListener);
        contentManager2.removeAllContents(true);
    }

    private final void addEmulatorPanel(EmulatorController emulator) {
        emulator.addConnectionStateListener(this.connectionStateListener);
        this.addPanel(new EmulatorToolWindowPanel(this.project, emulator));
    }

    private final void addPhysicalDevicePanel(String serialNumber, String abi, String title, Map<String, String> deviceProperties) {
        this.addPanel(new DeviceToolWindowPanel(this.project, serialNumber, abi, title, deviceProperties));
    }

    private final void addPanel(RunningDevicePanel panel2) {
        block5: {
            String avdId;
            DeviceId deviceId;
            boolean bl;
            Content content2;
            ToolWindow toolWindow = this.getToolWindow();
            ContentManager contentManager = toolWindow.getContentManager();
            Intrinsics.checkNotNullExpressionValue((Object)contentManager, (String)"toolWindow.contentManager");
            ContentManager contentManager2 = contentManager;
            Content placeholderContent = null;
            if (this.panels.isEmpty()) {
                this.showLiveIndicator(toolWindow);
                if (!contentManager2.isEmpty()) {
                    placeholderContent = contentManager2.getContent(0);
                }
            }
            ContentFactory contentFactory = ContentFactory.getInstance();
            Object $this$addPanel_u24lambda_u2d4 = content2 = contentFactory.createContent((JComponent)((Object)panel2), panel2.getTitle(), false);
            boolean bl2 = false;
            $this$addPanel_u24lambda_u2d4.putUserData(ToolWindow.SHOW_CONTENT_ICON, (Object)true);
            $this$addPanel_u24lambda_u2d4.setCloseable(panel2.isClosable());
            $this$addPanel_u24lambda_u2d4.setTabName(panel2.getTitle());
            $this$addPanel_u24lambda_u2d4.setIcon(panel2.getIcon());
            $this$addPanel_u24lambda_u2d4.setPopupIcon(panel2.getIcon());
            PropertyReference0Impl propertyReference0Impl = new PropertyReference0Impl((Object)panel2){

                @Nullable
                public Object get() {
                    return ((RunningDevicePanel)((Object)this.receiver)).getPreferredFocusableComponent();
                }
            };
            $this$addPanel_u24lambda_u2d4.setPreferredFocusedComponent(new Computable((Function0)propertyReference0Impl){
                private final /* synthetic */ Function0 function;
                {
                    this.function = function;
                }

                public final /* synthetic */ Object compute() {
                    return this.function.invoke();
                }
            });
            $this$addPanel_u24lambda_u2d4.putUserData(ID_KEY, (Object)panel2.getId());
            Content content3 = content2;
            Intrinsics.checkNotNullExpressionValue((Object)content3, (String)"contentFactory.createCon\u2026a(ID_KEY, panel.id)\n    }");
            Content content4 = content3;
            panel2.setZoomToolbarVisible(this.getZoomToolbarIsVisible());
            int index2 = ~CollectionsKt.binarySearch$default((List)this.panels, (Object)((Object)panel2), PANEL_COMPARATOR, (int)0, (int)0, (int)12, null);
            boolean bl3 = bl = index2 >= 0;
            if (_Assertions.ENABLED && !bl) {
                $this$addPanel_u24lambda_u2d4 = "Assertion failed";
                throw new AssertionError($this$addPanel_u24lambda_u2d4);
            }
            if (index2 < 0) break block5;
            this.panels.add(index2, panel2);
            contentManager2.addContent(content4, index2);
            if (!Intrinsics.areEqual((Object)((Object)this.selectedPanel), (Object)((Object)panel2)) && (deviceId = panel2.getId()) instanceof DeviceId.EmulatorDeviceId && this.recentEmulatorLaunches.getIfPresent((Object)(avdId = ((DeviceId.EmulatorDeviceId)deviceId).getEmulatorId().getAvdId())) != null) {
                this.recentEmulatorLaunches.invalidate((Object)avdId);
                contentManager2.setSelectedContent(content4);
            }
            Content content5 = placeholderContent;
            if (content5 != null) {
                Content it = content5;
                boolean bl4 = false;
                contentManager2.removeContent(it, true);
            }
        }
    }

    private final void removeEmulatorPanel(EmulatorController emulator) {
        emulator.removeConnectionStateListener(this.connectionStateListener);
        RunningDevicePanel runningDevicePanel = this.findPanelByEmulatorId(emulator.getEmulatorId());
        if (runningDevicePanel == null) {
            return;
        }
        RunningDevicePanel panel2 = runningDevicePanel;
        this.removePanel(panel2);
    }

    private final void removePhysicalDevicePanel(String serialNumber) {
        RunningDevicePanel runningDevicePanel = this.findPanelBySerialNumber(serialNumber);
        if (runningDevicePanel == null) {
            return;
        }
        RunningDevicePanel panel2 = runningDevicePanel;
        this.removePanel(panel2);
    }

    /*
     * WARNING - void declaration
     */
    private final void removeAllPhysicalDevicePanels() {
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv = this.panels;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof DeviceToolWindowPanel)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RunningDevicePanel p0 = (RunningDevicePanel)((Object)element$iv);
            boolean bl = false;
            this.removePanel(p0);
        }
    }

    private final void removePanel(RunningDevicePanel panel2) {
        ToolWindow toolWindow = this.getToolWindow();
        ContentManager contentManager = toolWindow.getContentManager();
        Intrinsics.checkNotNullExpressionValue((Object)contentManager, (String)"toolWindow.contentManager");
        ContentManager contentManager2 = contentManager;
        Content content2 = contentManager2.getContent((JComponent)((Object)panel2));
        contentManager2.removeContent(content2, true);
    }

    private final void createEmptyStatePanel() {
        Content content2;
        EmptyStatePanel panel2 = new EmptyStatePanel(this.project);
        ContentFactory contentFactory = ContentFactory.getInstance();
        Content $this$createEmptyStatePanel_u24lambda_u2d6 = content2 = contentFactory.createContent((JComponent)((Object)panel2), null, false);
        boolean bl = false;
        $this$createEmptyStatePanel_u24lambda_u2d6.setCloseable(false);
        Content content3 = content2;
        Intrinsics.checkNotNullExpressionValue((Object)content3, (String)"contentFactory.createCon\u2026isCloseable = false\n    }");
        Content content4 = content3;
        ContentManager contentManager = this.getContentManager();
        contentManager.addContent(content4);
        contentManager.setSelectedContent(content4);
    }

    private final void viewSelectionChanged(ToolWindow toolWindow) {
        Content content2;
        ContentManager contentManager = toolWindow.getContentManager();
        Intrinsics.checkNotNullExpressionValue((Object)contentManager, (String)"toolWindow.contentManager");
        ContentManager contentManager2 = contentManager;
        Content content3 = content2 = contentManager2.getSelectedContent();
        DeviceId id2 = content3 != null ? (DeviceId)content3.getUserData(ID_KEY) : null;
        RunningDevicePanel runningDevicePanel = this.selectedPanel;
        if (!Intrinsics.areEqual((Object)id2, (Object)(runningDevicePanel != null ? runningDevicePanel.getId() : null))) {
            RunningDevicePanel runningDevicePanel2 = this.selectedPanel;
            if (runningDevicePanel2 != null) {
                RunningDevicePanel panel2 = runningDevicePanel2;
                boolean bl = false;
                ((Map)this.savedUiState).put(panel2.getId(), panel2.destroyContent());
                this.selectedPanel = null;
            }
            if (id2 != null) {
                RunningDevicePanel runningDevicePanel3 = this.selectedPanel = this.findPanelByDeviceId(id2);
                if (runningDevicePanel3 != null) {
                    runningDevicePanel3.createContent(this.getDeviceFrameVisible(), this.savedUiState.remove(id2));
                }
                ToggleToolbarAction.setToolbarVisible((ToolWindow)toolWindow, (PropertiesComponent)PropertiesComponent.getInstance((Project)this.project), null);
            }
        }
    }

    private final RunningDevicePanel findPanelByDeviceId(DeviceId deviceId) {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = this.panels;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                RunningDevicePanel it = (RunningDevicePanel)((Object)element$iv);
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getId(), (Object)deviceId)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private final RunningDevicePanel findPanelByEmulatorId(EmulatorId emulatorId) {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = this.panels;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                RunningDevicePanel it = (RunningDevicePanel)((Object)element$iv);
                boolean bl = false;
                if (!(it.getId() instanceof DeviceId.EmulatorDeviceId && Intrinsics.areEqual((Object)((DeviceId.EmulatorDeviceId)it.getId()).getEmulatorId(), (Object)emulatorId))) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private final RunningDevicePanel findPanelByAvdId(String avdId) {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = this.panels;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                RunningDevicePanel it = (RunningDevicePanel)((Object)element$iv);
                boolean bl = false;
                if (!(it.getId() instanceof DeviceId.EmulatorDeviceId && Intrinsics.areEqual((Object)((DeviceId.EmulatorDeviceId)it.getId()).getEmulatorId().getAvdId(), (Object)avdId))) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private final RunningDevicePanel findPanelBySerialNumber(String serialNumber) {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = this.panels;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                RunningDevicePanel it = (RunningDevicePanel)((Object)element$iv);
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getId().getSerialNumber(), (Object)serialNumber)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private final ContentManager getContentManager() {
        ContentManager contentManager = this.getToolWindow().getContentManager();
        Intrinsics.checkNotNullExpressionValue((Object)contentManager, (String)"getToolWindow().contentManager");
        return contentManager;
    }

    private final ToolWindow getToolWindow() {
        ToolWindow toolWindow = ToolWindowManager.Companion.getInstance(this.project).getToolWindow("Running Devices");
        if (toolWindow == null) {
            throw new IllegalStateException("Could not find the Running Devices tool window");
        }
        return toolWindow;
    }

    private final void showLiveIndicator(ToolWindow toolWindow) {
        toolWindow.setIcon(ExecutionUtil.getLiveIndicator((Icon)StudioIcons.Shell.ToolWindows.EMULATOR));
    }

    private final void hideLiveIndicator(ToolWindow toolWindow) {
        toolWindow.setIcon(StudioIcons.Shell.ToolWindows.EMULATOR);
    }

    @Override
    @AnyThread
    public void emulatorAdded(@NotNull EmulatorController emulator) {
        Intrinsics.checkNotNullParameter((Object)emulator, (String)"emulator");
        if (emulator.getEmulatorId().isEmbedded()) {
            EventQueue.invokeLater(new Runnable(this, emulator){
                final /* synthetic */ StreamingToolWindowManager this$0;
                final /* synthetic */ EmulatorController $emulator;
                {
                    this.this$0 = $receiver;
                    this.$emulator = $emulator;
                }

                public final void run() {
                    if (StreamingToolWindowManager.access$getContentCreated$p(this.this$0) && StreamingToolWindowManager.access$getEmulators$p(this.this$0).add(this.$emulator)) {
                        StreamingToolWindowManager.access$addEmulatorPanel(this.this$0, this.$emulator);
                    }
                }
            });
        }
    }

    @Override
    @AnyThread
    public void emulatorRemoved(@NotNull EmulatorController emulator) {
        Intrinsics.checkNotNullParameter((Object)emulator, (String)"emulator");
        if (emulator.getEmulatorId().isEmbedded()) {
            EventQueue.invokeLater(new Runnable(this, emulator){
                final /* synthetic */ StreamingToolWindowManager this$0;
                final /* synthetic */ EmulatorController $emulator;
                {
                    this.this$0 = $receiver;
                    this.$emulator = $emulator;
                }

                public final void run() {
                    if (StreamingToolWindowManager.access$getContentCreated$p(this.this$0) && StreamingToolWindowManager.access$getEmulators$p(this.this$0).remove(this.$emulator)) {
                        StreamingToolWindowManager.access$removeEmulatorPanel(this.this$0, this.$emulator);
                    }
                }
            });
        }
    }

    @Override
    public void settingsChanged(@NotNull DeviceMirroringSettings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        if (settings.getDeviceMirroringEnabled()) {
            if (this.physicalDeviceWatcher == null) {
                this.createPhysicalDeviceWatcherIfToolWindowAvailable(ToolWindowManager.Companion.getInstance(this.project));
            }
        } else {
            PhysicalDeviceWatcher physicalDeviceWatcher = this.physicalDeviceWatcher;
            if (physicalDeviceWatcher != null) {
                PhysicalDeviceWatcher it = physicalDeviceWatcher;
                boolean bl = false;
                Disposer.dispose((Disposable)it);
            }
            this.physicalDeviceWatcher = null;
            this.removeAllPhysicalDevicePanels();
        }
    }

    private final void showAndActivate(ToolWindow $this$showAndActivate) {
        if ($this$showAndActivate.isVisible()) {
            $this$showAndActivate.activate(null);
        } else {
            $this$showAndActivate.show(new Runnable($this$showAndActivate){
                final /* synthetic */ ToolWindow $this_showAndActivate;
                {
                    this.$this_showAndActivate = $receiver;
                }

                public final void run() {
                    this.$this_showAndActivate.activate(null);
                }
            });
        }
    }

    @AnyThread
    @JvmStatic
    public static final void initializeForProject(@NotNull Project project) {
        Companion.initializeForProject(project);
    }

    @AnyThread
    @JvmStatic
    private static final boolean isEmbeddedEmulator(GeneralCommandLine commandLine) {
        return StreamingToolWindowManager.Companion.isEmbeddedEmulator(commandLine);
    }

    public static final /* synthetic */ void access$onEmulatorHeadsUp(StreamingToolWindowManager $this, String deviceSerialNumber, Set runningEmulators) {
        $this.onEmulatorHeadsUp(deviceSerialNumber, runningEmulators);
    }

    public static final /* synthetic */ void access$addEmulatorPanel(StreamingToolWindowManager $this, EmulatorController emulator) {
        $this.addEmulatorPanel(emulator);
    }

    public static final /* synthetic */ void access$removeEmulatorPanel(StreamingToolWindowManager $this, EmulatorController emulator) {
        $this.removeEmulatorPanel(emulator);
    }

    public /* synthetic */ StreamingToolWindowManager(Project project, DefaultConstructorMarker $constructor_marker) {
        this(project);
    }

    public static final /* synthetic */ void access$showLiveIndicator(StreamingToolWindowManager $this, ToolWindow toolWindow) {
        $this.showLiveIndicator(toolWindow);
    }

    public static final /* synthetic */ Cache access$getRecentAttentionRequests$p(StreamingToolWindowManager $this) {
        return $this.recentAttentionRequests;
    }

    public static final /* synthetic */ void access$setLastSelectedDeviceId$p(StreamingToolWindowManager $this, DeviceId deviceId) {
        $this.lastSelectedDeviceId = deviceId;
    }

    public static final /* synthetic */ void access$showAndActivate(StreamingToolWindowManager $this, ToolWindow $receiver) {
        $this.showAndActivate($receiver);
    }

    public static final /* synthetic */ void access$viewSelectionChanged(StreamingToolWindowManager $this, ToolWindow toolWindow) {
        $this.viewSelectionChanged(toolWindow);
    }

    public static final /* synthetic */ ArrayList access$getPanels$p(StreamingToolWindowManager $this) {
        return $this.panels;
    }

    public static final /* synthetic */ HashMap access$getSavedUiState$p(StreamingToolWindowManager $this) {
        return $this.savedUiState;
    }

    public static final /* synthetic */ void access$createEmptyStatePanel(StreamingToolWindowManager $this) {
        $this.createEmptyStatePanel();
    }

    public static final /* synthetic */ void access$createContent(StreamingToolWindowManager $this, ToolWindow toolWindow) {
        $this.createContent(toolWindow);
    }

    static {
        Key key = Key.create((String)"device-id");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create<DeviceId>(\"device-id\")");
        ID_KEY = key;
        ATTENTION_REQUEST_EXPIRATION = Duration.ofSeconds(30L);
        Collator collator = COLLATOR = Collator.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)collator, (String)"COLLATOR");
        Comparator comparator2 = collator;
        comparator2 = new Comparator(comparator2){
            final /* synthetic */ Comparator $comparator;
            {
                this.$comparator = $comparator;
            }

            public final int compare(T a, T b) {
                RunningDevicePanel runningDevicePanel = (RunningDevicePanel)((Object)a);
                Comparator comparator2 = this.$comparator;
                boolean bl = false;
                RunningDevicePanel it = (RunningDevicePanel)((Object)b);
                String string = it.getTitle();
                bl = false;
                String string2 = it.getTitle();
                return comparator2.compare(string, string2);
            }
        };
        PANEL_COMPARATOR = new Comparator(comparator2){
            final /* synthetic */ Comparator $this_thenBy;
            {
                this.$this_thenBy = $receiver;
            }

            public final int compare(T a, T b) {
                int n;
                int previousCompare = this.$this_thenBy.compare(a, b);
                if (previousCompare != 0) {
                    n = previousCompare;
                } else {
                    RunningDevicePanel it = (RunningDevicePanel)((Object)a);
                    boolean bl = false;
                    Comparable comparable = it.getId();
                    it = (RunningDevicePanel)((Object)b);
                    Comparable comparable2 = comparable;
                    bl = false;
                    n = ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)it.getId());
                }
                return n;
            }
        };
        registeredProjects = new HashSet();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u0007H\u0016J\u0010\u0010\r\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/idea/streaming/StreamingToolWindowManager$ToggleDeviceFrameAction;", "Lcom/intellij/openapi/actionSystem/ToggleAction;", "Lcom/intellij/openapi/project/DumbAware;", "(Lcom/android/tools/idea/streaming/StreamingToolWindowManager;)V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "isSelected", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "setSelected", "", "state", "update", "intellij.android.streaming"})
    private final class ToggleDeviceFrameAction
    extends ToggleAction
    implements DumbAware {
        public ToggleDeviceFrameAction() {
            super("Show Device Frame");
        }

        public void update(@NotNull AnActionEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            super.update(event);
            RunningDevicePanel panel2 = StreamingToolWindowManager.this.selectedPanel;
            event.getPresentation().setEnabledAndVisible(panel2 instanceof EmulatorToolWindowPanel && ((EmulatorToolWindowPanel)panel2).getEmulator().getEmulatorConfig().getSkinFolder() != null);
        }

        public boolean isSelected(@NotNull AnActionEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            return StreamingToolWindowManager.this.getDeviceFrameVisible();
        }

        public void setSelected(@NotNull AnActionEvent event, boolean state2) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            StreamingToolWindowManager.this.setDeviceFrameVisible(state2);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.EDT;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u0007H\u0016\u00a8\u0006\r"}, d2={"Lcom/android/tools/idea/streaming/StreamingToolWindowManager$ToggleZoomToolbarAction;", "Lcom/intellij/openapi/actionSystem/ToggleAction;", "Lcom/intellij/openapi/project/DumbAware;", "(Lcom/android/tools/idea/streaming/StreamingToolWindowManager;)V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "isSelected", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "setSelected", "", "state", "intellij.android.streaming"})
    private final class ToggleZoomToolbarAction
    extends ToggleAction
    implements DumbAware {
        public ToggleZoomToolbarAction() {
            super("Show Zoom Controls");
        }

        public boolean isSelected(@NotNull AnActionEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            return StreamingToolWindowManager.this.getZoomToolbarIsVisible();
        }

        public void setSelected(@NotNull AnActionEvent event, boolean state2) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            StreamingToolWindowManager.this.setZoomToolbarIsVisible(state2);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.EDT;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u001eH\u0007J\u0010\u0010#\u001a\u00020\u000b2\u0006\u0010$\u001a\u00020%H\u0003R\u001e\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u00048\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0006\u0010\u0002R\u001e\u0010\u0007\u001a\n \u0005*\u0004\u0018\u00010\b0\b8\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\t\u0010\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082T\u00a2\u0006\u0002\n\u0000R)\u0010\u0010\u001a\u0015\u0012\f\u0012\n \u0005*\u0004\u0018\u00010\u00120\u00120\u0011\u00a2\u0006\u0002\b\u00138\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0014\u0010\u0002R&\u0010\u0015\u001a\u0012\u0012\u0004\u0012\u00020\u00170\u0016j\b\u0012\u0004\u0012\u00020\u0017`\u00188\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0019\u0010\u0002R\u000e\u0010\u001a\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\rX\u0082T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d8\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u001f\u0010\u0002\u00a8\u0006&"}, d2={"Lcom/android/tools/idea/streaming/StreamingToolWindowManager$Companion;", "", "()V", "ATTENTION_REQUEST_EXPIRATION", "Ljava/time/Duration;", "kotlin.jvm.PlatformType", "getATTENTION_REQUEST_EXPIRATION$annotations", "COLLATOR", "Ljava/text/Collator;", "getCOLLATOR$annotations", "DEVICE_FRAME_VISIBLE_DEFAULT", "", "DEVICE_FRAME_VISIBLE_PROPERTY", "", "EMULATOR_DISCOVERY_INTERVAL_MILLIS", "", "ID_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/android/tools/idea/streaming/DeviceId;", "Lorg/jetbrains/annotations/NotNull;", "getID_KEY$annotations", "PANEL_COMPARATOR", "Ljava/util/Comparator;", "Lcom/android/tools/idea/streaming/RunningDevicePanel;", "Lkotlin/Comparator;", "getPANEL_COMPARATOR$annotations", "ZOOM_TOOLBAR_VISIBLE_DEFAULT", "ZOOM_TOOLBAR_VISIBLE_PROPERTY", "registeredProjects", "", "Lcom/intellij/openapi/project/Project;", "getRegisteredProjects$annotations", "initializeForProject", "", "project", "isEmbeddedEmulator", "commandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "intellij.android.streaming"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        private static /* synthetic */ void getID_KEY$annotations() {
        }

        @JvmStatic
        private static /* synthetic */ void getATTENTION_REQUEST_EXPIRATION$annotations() {
        }

        @JvmStatic
        private static /* synthetic */ void getCOLLATOR$annotations() {
        }

        @JvmStatic
        private static /* synthetic */ void getPANEL_COMPARATOR$annotations() {
        }

        @JvmStatic
        private static /* synthetic */ void getRegisteredProjects$annotations() {
        }

        @AnyThread
        @JvmStatic
        public final void initializeForProject(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            if (registeredProjects.add(project)) {
                Disposer.register((Disposable)StreamingUtilsKt.getEarlyDisposable(project), (Disposable)new Disposable(project){
                    final /* synthetic */ Project $project;
                    {
                        this.$project = $project;
                    }

                    public final void dispose() {
                        StreamingToolWindowManager.access$getRegisteredProjects$cp().remove(this.$project);
                    }
                });
                new StreamingToolWindowManager(project, null);
            }
        }

        @AnyThread
        @JvmStatic
        private final boolean isEmbeddedEmulator(GeneralCommandLine commandLine) {
            return commandLine.getParametersList().getParameters().contains("-qt-hide-window");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\b\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J\u0019\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nH\u0083@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000eJ\"\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\n2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u0010J\b\u0010\u0011\u001a\u00020\fH\u0016J$\u0010\u0012\u001a\u00020\n2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u00102\u0006\u0010\r\u001a\u00020\nH\u0002J'\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u00102\u0006\u0010\r\u001a\u00020\nH\u0083@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u0014\u001a\u00020\fH\u0002J4\u0010\u0015\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\n2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u0010H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/idea/streaming/StreamingToolWindowManager$PhysicalDeviceWatcher;", "Lcom/intellij/openapi/Disposable;", "disposableParent", "(Lcom/android/tools/idea/streaming/StreamingToolWindowManager;Lcom/intellij/openapi/Disposable;)V", "adbSession", "Lcom/android/adblib/AdbSession;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "onlineDevices", "", "", "deviceConnected", "", "deviceSerialNumber", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "deviceProperties", "", "dispose", "getDeviceName", "getMirrorableDeviceProperties", "onlineDevicesChanged", "startMirroring", "deviceAbi", "deviceName", "intellij.android.streaming"})
    private final class PhysicalDeviceWatcher
    implements Disposable {
        @NotNull
        private final AdbSession adbSession;
        @NotNull
        private final CoroutineScope coroutineScope;
        @NotNull
        private Set<String> onlineDevices;

        public PhysicalDeviceWatcher(Disposable disposableParent) {
            Intrinsics.checkNotNullParameter((Object)disposableParent, (String)"disposableParent");
            this.adbSession = AdbLibService.Companion.getSession(StreamingToolWindowManager.this.project);
            this.onlineDevices = SetsKt.emptySet();
            Disposer.register((Disposable)disposableParent, (Disposable)this);
            ExecutorService executorService = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"EmulatorToolWindowManager.PhysicalDeviceWatcher", (int)1);
            Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"createBoundedApplication\u2026hysicalDeviceWatcher\", 1)");
            ExecutorService executor2 = executorService;
            this.coroutineScope = CoroutinesUtilsKt.AndroidCoroutineScope((Disposable)this, (CoroutineContext)((CoroutineContext)ExecutorsKt.from((ExecutorService)executor2)));
            BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                final /* synthetic */ PhysicalDeviceWatcher this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            void $this$collect$iv;
                            ResultKt.throwOnFailure((Object)object);
                            Flow flow2 = (Flow)AdbSessionKt.trackDevices$default((AdbSession)this.this$0.adbSession, null, (int)1, null);
                            PhysicalDeviceWatcher physicalDeviceWatcher = this.this$0;
                            boolean $i$f$collect = false;
                            this.label = 1;
                            Object object3 = $this$collect$iv.collect((FlowCollector)new FlowCollector<TrackedDeviceList>(physicalDeviceWatcher){
                                final /* synthetic */ PhysicalDeviceWatcher this$0;
                                {
                                    this.this$0 = physicalDeviceWatcher;
                                }

                                /*
                                 * Ignored method signature, as it can't be verified against descriptor
                                 */
                                @Nullable
                                public Object emit(Object value2, @NotNull Continuation $completion) {
                                    Continuation continuation = $completion;
                                    TrackedDeviceList deviceList2 = (TrackedDeviceList)value2;
                                    boolean bl = false;
                                    UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(this.this$0, deviceList2){
                                        final /* synthetic */ PhysicalDeviceWatcher this$0;
                                        final /* synthetic */ TrackedDeviceList $deviceList;
                                        {
                                            this.this$0 = $receiver;
                                            this.$deviceList = $deviceList;
                                        }

                                        /*
                                         * WARNING - void declaration
                                         */
                                        public final void run() {
                                            void $this$mapTo$iv$iv;
                                            void $this$map$iv;
                                            DeviceInfo it;
                                            void $this$filterTo$iv$iv;
                                            Iterable $this$filter$iv;
                                            Iterable iterable = this.$deviceList.getDevices().getEntries();
                                            PhysicalDeviceWatcher physicalDeviceWatcher = this.this$0;
                                            boolean $i$f$filter = false;
                                            void var3_4 = $this$filter$iv;
                                            Collection destination$iv$iv = new ArrayList<E>();
                                            boolean $i$f$filterTo = false;
                                            for (T element$iv$iv : $this$filterTo$iv$iv) {
                                                it = (DeviceInfo)element$iv$iv;
                                                boolean bl = false;
                                                if (!(it.getDeviceState() == DeviceState.ONLINE)) continue;
                                                destination$iv$iv.add(element$iv$iv);
                                            }
                                            $this$filter$iv = (List)destination$iv$iv;
                                            boolean $i$f$map = false;
                                            $this$filterTo$iv$iv = $this$map$iv;
                                            destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                                            boolean $i$f$mapTo = false;
                                            for (T item$iv$iv : $this$mapTo$iv$iv) {
                                                void p0;
                                                it = (DeviceInfo)item$iv$iv;
                                                Collection collection2 = destination$iv$iv;
                                                boolean bl = false;
                                                collection2.add(p0.getSerialNumber());
                                            }
                                            PhysicalDeviceWatcher.access$setOnlineDevices$p(physicalDeviceWatcher, CollectionsKt.toSet((Iterable)((List)destination$iv$iv)));
                                            PhysicalDeviceWatcher.access$onlineDevicesChanged(this.this$0);
                                        }
                                    });
                                    return Unit.INSTANCE;
                                }
                            }, (Continuation)this);
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            boolean $i$f$collect = false;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }

        private final void onlineDevicesChanged() {
            Set removed2 = SetsKt.minus(StreamingToolWindowManager.this.mirrorableDeviceProperties.keySet(), (Iterable)this.onlineDevices);
            StreamingToolWindowManager.this.mirroredDevices.removeAll(removed2);
            StreamingToolWindowManager.this.mirrorableDeviceProperties.keySet().removeAll(removed2);
            for (String device2 : removed2) {
                StreamingToolWindowManager.this.removePhysicalDevicePanel(device2);
            }
            ToolWindow toolWindow = StreamingToolWindowManager.this.getToolWindow();
            if (!toolWindow.isVisible() && StreamingToolWindowManager.this.mirrorableDeviceProperties.isEmpty() && StreamingToolWindowManager.this.emulators.isEmpty()) {
                StreamingToolWindowManager.this.hideLiveIndicator(toolWindow);
            }
            for (String deviceSerialNumber : this.onlineDevices) {
                if (StreamingToolWindowManager.this.mirroredDevices.contains(deviceSerialNumber)) continue;
                BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, deviceSerialNumber, null){
                    int label;
                    final /* synthetic */ PhysicalDeviceWatcher this$0;
                    final /* synthetic */ String $deviceSerialNumber;
                    {
                        this.this$0 = $receiver;
                        this.$deviceSerialNumber = $deviceSerialNumber;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                this.label = 1;
                                Object object3 = PhysicalDeviceWatcher.access$deviceConnected(this.this$0, this.$deviceSerialNumber, (Continuation)this);
                                if (object3 != object2) return Unit.INSTANCE;
                                return object2;
                            }
                            case 1: {
                                void $result;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object3 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)3, null);
            }
        }

        /*
         * Unable to fully structure code
         */
        @AnyThread
        private final Object deviceConnected(String var1_1, Continuation<? super Unit> var2_2) {
            if (!(var2_2 instanceof deviceConnected.1)) ** GOTO lbl-1000
            var5_3 = var2_2;
            if ((var5_3.label & -2147483648) != 0) {
                var5_3.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, var2_2){
                    Object L$0;
                    Object L$1;
                    /* synthetic */ Object result;
                    final /* synthetic */ PhysicalDeviceWatcher this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return PhysicalDeviceWatcher.access$deviceConnected(this.this$0, null, (Continuation)this);
                    }
                };
            }
            $result = $continuation.result;
            var6_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    $continuation.L$0 = this;
                    $continuation.L$1 = deviceSerialNumber;
                    $continuation.label = 1;
                    v0 = this.getMirrorableDeviceProperties(deviceSerialNumber, (Continuation<? super Map<String, String>>)$continuation);
                    if (v0 == var6_5) {
                        return var6_5;
                    }
                    ** GOTO lbl24
                }
                case 1: {
                    deviceSerialNumber = (String)$continuation.L$1;
                    this = (PhysicalDeviceWatcher)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl24:
                    // 2 sources

                    if ((deviceProperties = (Map)v0) != null) {
                        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(this, deviceSerialNumber, StreamingToolWindowManager.this, deviceProperties){
                            final /* synthetic */ PhysicalDeviceWatcher this$0;
                            final /* synthetic */ String $deviceSerialNumber;
                            final /* synthetic */ StreamingToolWindowManager this$1;
                            final /* synthetic */ Map<String, String> $deviceProperties;
                            {
                                this.this$0 = $receiver;
                                this.$deviceSerialNumber = $deviceSerialNumber;
                                this.this$1 = $receiver2;
                                this.$deviceProperties = $deviceProperties;
                            }

                            public final void run() {
                                if (PhysicalDeviceWatcher.access$getOnlineDevices$p(this.this$0).contains(this.$deviceSerialNumber) && StreamingToolWindowManager.access$getMirrorableDeviceProperties$p(this.this$1).put(this.$deviceSerialNumber, this.$deviceProperties) == null) {
                                    ToolWindow toolWindow = StreamingToolWindowManager.access$getToolWindow(this.this$1);
                                    StreamingToolWindowManager.access$showLiveIndicator(this.this$1, toolWindow);
                                    if (StreamingToolWindowManager.access$getContentCreated$p(this.this$1)) {
                                        this.this$0.deviceConnected(this.$deviceSerialNumber, this.$deviceProperties);
                                    } else if (StreamingToolWindowManager.access$getRecentAttentionRequests$p(this.this$1).getIfPresent((Object)this.$deviceSerialNumber) != null) {
                                        StreamingToolWindowManager.access$getRecentAttentionRequests$p(this.this$1).invalidate((Object)this.$deviceSerialNumber);
                                        StreamingToolWindowManager.access$setLastSelectedDeviceId$p(this.this$1, DeviceId.Companion.ofPhysicalDevice(this.$deviceSerialNumber));
                                        StreamingToolWindowManager.access$showAndActivate(this.this$1, toolWindow);
                                    }
                                }
                            }
                        });
                    }
                    return Unit.INSTANCE;
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        public final void deviceConnected(@NotNull String deviceSerialNumber, @NotNull Map<String, String> deviceProperties) {
            Intrinsics.checkNotNullParameter((Object)deviceSerialNumber, (String)"deviceSerialNumber");
            Intrinsics.checkNotNullParameter(deviceProperties, (String)"deviceProperties");
            if (!StreamingToolWindowManager.this.mirroredDevices.contains(deviceSerialNumber)) {
                String deviceName = this.getDeviceName(deviceProperties, deviceSerialNumber);
                String deviceAbi = deviceProperties.get("ro.product.cpu.abi");
                if (deviceAbi == null) {
                    PhysicalDeviceWatcher $this$thisLogger$iv = this;
                    boolean $i$f$thisLogger = false;
                    Logger logger2 = Logger.getInstance(PhysicalDeviceWatcher.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"Logger.getInstance(T::class.java)");
                    logger2.warn("Unable to determine ABI of " + deviceName);
                    return;
                }
                if (StreamingToolWindowManager.this.deviceMirroringSettings.getConfirmationDialogShown()) {
                    this.startMirroring(deviceSerialNumber, deviceAbi, deviceName, deviceProperties);
                } else if (!StreamingToolWindowManager.this.mirroringConfirmationDialogShowing) {
                    DialogWrapper dialogWrapper2;
                    StreamingToolWindowManager.this.mirroringConfirmationDialogShowing = true;
                    String title = "About to Start Mirroring of " + deviceName;
                    DialogWrapper $this$deviceConnected_u24lambda_u2d0 = dialogWrapper2 = MirroringConfirmationDialog.createWrapper$default(new MirroringConfirmationDialog(title), StreamingToolWindowManager.this.project, null, 2, null);
                    boolean bl = false;
                    $this$deviceConnected_u24lambda_u2d0.show();
                    DialogWrapper dialogWrapper3 = dialogWrapper2;
                    StreamingToolWindowManager.this.mirroringConfirmationDialogShowing = false;
                    switch (dialogWrapper3.getExitCode()) {
                        case 0: {
                            this.startMirroring(deviceSerialNumber, deviceAbi, deviceName, deviceProperties);
                            break;
                        }
                        case 2: {
                            StreamingToolWindowManager.this.deviceMirroringSettings.setDeviceMirroringEnabled(false);
                            break;
                        }
                        default: {
                            return;
                        }
                    }
                    StreamingToolWindowManager.this.deviceMirroringSettings.setConfirmationDialogShown(true);
                }
            }
        }

        private final void startMirroring(String deviceSerialNumber, String deviceAbi, String deviceName, Map<String, String> deviceProperties) {
            if (this.onlineDevices.contains(deviceSerialNumber) && StreamingToolWindowManager.this.mirroredDevices.add(deviceSerialNumber) && StreamingToolWindowManager.this.contentCreated) {
                StreamingToolWindowManager.this.addPhysicalDevicePanel(deviceSerialNumber, deviceAbi, deviceName, deviceProperties);
            }
        }

        /*
         * Unable to fully structure code
         */
        @AnyThread
        private final Object getMirrorableDeviceProperties(String var1_1, Continuation<? super Map<String, String>> var2_2) {
            if (!(var2_2 instanceof getMirrorableDeviceProperties.1)) ** GOTO lbl-1000
            var12_3 = var2_2;
            if ((var12_3.label & -2147483648) != 0) {
                var12_3.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, var2_2){
                    Object L$0;
                    Object L$1;
                    /* synthetic */ Object result;
                    final /* synthetic */ PhysicalDeviceWatcher this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return PhysicalDeviceWatcher.access$getMirrorableDeviceProperties(this.this$0, null, (Continuation)this);
                    }
                };
            }
            $result = $continuation.result;
            var13_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    if (!StringsKt.startsWith$default((String)deviceSerialNumber, (String)"emulator-", (boolean)false, (int)2, null)) ** GOTO lbl40
                    if (!((Boolean)StudioFlags.DEVICE_MIRRORING_STANDALONE_EMULATORS.get()).booleanValue()) {
                        return null;
                    }
                    $continuation.L$0 = this;
                    $continuation.L$1 = deviceSerialNumber;
                    $continuation.label = 1;
                    v0 = StreamingUtilsKt.suspendingGet(RunningEmulatorCatalog.Companion.getInstance().updateNow(), $continuation);
                    if (v0 == var13_5) {
                        return var13_5;
                    }
                    ** GOTO lbl27
                }
                case 1: {
                    deviceSerialNumber = (String)$continuation.L$1;
                    this = (PhysicalDeviceWatcher)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl27:
                    // 2 sources

                    emulators = (Set)v0;
                    var6_9 = emulators;
                    for (T var8_11 : var6_9) {
                        it = (EmulatorController)var8_11;
                        $i$a$-find-StreamingToolWindowManager$PhysicalDeviceWatcher$getMirrorableDeviceProperties$emulator$1 = false;
                        if (!Intrinsics.areEqual((Object)("emulator-" + it.getEmulatorId().getSerialPort()), (Object)deviceSerialNumber)) continue;
                        v1 = var8_11;
                        ** GOTO lbl36
                    }
                    v1 = null;
lbl36:
                    // 2 sources

                    emulator = v1;
                    if (emulator == null || emulator.getEmulatorId().isEmbedded()) {
                        return null;
                    }
lbl40:
                    // 4 sources

                    $continuation.L$0 = this;
                    $continuation.L$1 = null;
                    $continuation.label = 2;
                    v2 = AdbDeviceServicesKt.deviceProperties((AdbDeviceServices)this.adbSession.getDeviceServices(), (DeviceSelector)DeviceSelector.Companion.fromSerialNumber(deviceSerialNumber), (Continuation)$continuation);
                    ** if (v2 != var13_5) goto lbl47
lbl46:
                    // 1 sources

                    return var13_5;
lbl47:
                    // 1 sources

                    ** GOTO lbl54
                }
                case 2: {
                    this = (PhysicalDeviceWatcher)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
lbl54:
                    // 2 sources

                    $continuation.L$0 = this;
                    $continuation.label = 3;
                    v3 = ((DeviceProperties)v2).allReadonly((Continuation)$continuation);
                    ** if (v3 != var13_5) goto lbl59
lbl58:
                    // 1 sources

                    return var13_5;
lbl59:
                    // 1 sources

                    ** GOTO lbl66
                }
                case 3: {
                    this = (PhysicalDeviceWatcher)$continuation.L$0;
                    try {
                        ResultKt.throwOnFailure((Object)$result);
                        v3 = $result;
lbl66:
                        // 2 sources

                        properties = (Map)v3;
                        v4 = (String)properties.get("ro.build.version.sdk");
                        v5 = apiLevel = v4 != null ? Integer.parseInt(v4) : 33;
                        if (apiLevel < 26) {
                            return null;
                        }
                        v6 = (String)properties.get("ro.build.characteristics");
                        v7 = isWatch = v6 != null ? StringsKt.contains$default((CharSequence)v6, (CharSequence)"watch", (boolean)false, (int)2, null) : false;
                        if (isWatch && apiLevel < 30) {
                            return null;
                        }
                        return properties;
                    }
                    catch (CancellationException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        $i$f$thisLogger = false;
                        v8 = Logger.getInstance(PhysicalDeviceWatcher.class);
                        Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"Logger.getInstance(T::class.java)");
                        v8.warn((Throwable)e);
                        return null;
                    }
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        private final String getDeviceName(Map<String, String> deviceProperties, String deviceSerialNumber) {
            Object name;
            String string = deviceProperties.get("ro.boot.qemu.avd_name");
            if (string == null) {
                string = deviceProperties.get("ro.kernel.qemu.avd_name");
            }
            Object object = name = string != null ? StringsKt.replace$default((String)string, (char)'_', (char)' ', (boolean)false, (int)4, null) : null;
            if (name == null) {
                String manufacturer;
                CharSequence charSequence;
                Object object2 = deviceProperties.get("ro.product.model");
                if (object2 == null) {
                    object2 = name = deviceSerialNumber;
                }
                if (!((charSequence = (CharSequence)(manufacturer = deviceProperties.get("ro.product.manufacturer"))) == null || StringsKt.isBlank((CharSequence)charSequence)) && !Intrinsics.areEqual((Object)manufacturer, (Object)"unknown")) {
                    name = WordUtils.capitalize((String)manufacturer) + " " + (String)name;
                }
            }
            return name;
        }

        public void dispose() {
        }

        public static final /* synthetic */ Object access$deviceConnected(PhysicalDeviceWatcher $this, String deviceSerialNumber, Continuation $completion) {
            return $this.deviceConnected(deviceSerialNumber, (Continuation<? super Unit>)$completion);
        }

        public static final /* synthetic */ Set access$getOnlineDevices$p(PhysicalDeviceWatcher $this) {
            return $this.onlineDevices;
        }

        public static final /* synthetic */ Object access$getMirrorableDeviceProperties(PhysicalDeviceWatcher $this, String deviceSerialNumber, Continuation $completion) {
            return $this.getMirrorableDeviceProperties(deviceSerialNumber, (Continuation<? super Map<String, String>>)$completion);
        }

        public static final /* synthetic */ void access$setOnlineDevices$p(PhysicalDeviceWatcher $this, Set set) {
            $this.onlineDevices = set;
        }

        public static final /* synthetic */ void access$onlineDevicesChanged(PhysicalDeviceWatcher $this) {
            $this.onlineDevicesChanged();
        }
    }
}

