/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.streaming;

import com.android.tools.idea.AndroidEnvironmentUtils;
import com.android.tools.idea.avdmanager.HardwareAccelerationCheck;
import com.android.tools.idea.streaming.DeviceMirroringSettings;
import com.android.tools.idea.streaming.StreamingToolWindowManager;
import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.ToolWindowWindowAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowContentUiType;
import com.intellij.openapi.wm.ToolWindowFactory;
import com.intellij.openapi.wm.ToolWindowType;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0002J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\r\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/idea/streaming/StreamingToolWindowFactory;", "Lcom/intellij/openapi/wm/ToolWindowFactory;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "canLaunchEmulator", "", "createToolWindowContent", "", "project", "Lcom/intellij/openapi/project/Project;", "toolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "init", "isApplicable", "intellij.android.streaming"})
public final class StreamingToolWindowFactory
implements ToolWindowFactory,
DumbAware {
    public void createToolWindowContent(@NotNull Project project, @NotNull ToolWindow toolWindow) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
        toolWindow.setDefaultContentUiType(ToolWindowContentUiType.TABBED);
        StreamingToolWindowManager.Companion.initializeForProject(project);
    }

    public void init(@NotNull ToolWindow toolWindow) {
        Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
        toolWindow.setStripeTitle("Running Devices");
        toolWindow.setTitleActions(CollectionsKt.listOf((Object)new ToolWindowWindowAction(){

            public void update(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                ToolWindow toolWindow = this.getToolWindow(e);
                ToolWindowType it = toolWindow != null ? toolWindow.getType() : null;
                boolean bl = false;
                boolean bl2 = it == ToolWindowType.FLOATING || it == ToolWindowType.WINDOWED;
                if (bl2) {
                    e.getPresentation().setEnabledAndVisible(false);
                    return;
                }
                super.update(e);
                e.getPresentation().setIcon(AllIcons.Actions.MoveToWindow);
            }
        }));
    }

    public boolean isApplicable(@NotNull Project project) {
        boolean available;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        boolean bl = available = AndroidEnvironmentUtils.isAndroidEnvironment((Project)project) && (this.canLaunchEmulator() || DeviceMirroringSettings.Companion.getInstance().getDeviceMirroringEnabled());
        if (available) {
            StreamingToolWindowManager.Companion.initializeForProject(project);
        }
        return available;
    }

    private final boolean canLaunchEmulator() {
        return !HardwareAccelerationCheck.isChromeOSAndIsNotHWAccelerated();
    }
}

