/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.streaming;

import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.streaming.DeviceId;
import com.android.tools.idea.streaming.RunningDevicesConstants;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.DeviceMirroringSession;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.util.ui.components.BorderLayoutPanel;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u00002\u00020\u00012\u00020\u0002:\u0001,B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u001c\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\r2\n\b\u0002\u0010 \u001a\u0004\u0018\u00010!H&J\b\u0010\"\u001a\u00020!H&J\u0012\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020\u0016H\u0016J\u0010\u0010&\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020(H\u0004J\b\u0010)\u001a\u00020\u001eH\u0004J\u0010\u0010*\u001a\u00020\u001e2\u0006\u0010+\u001a\u00020\rH&R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0012\u0010\f\u001a\u00020\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0011\u001a\u00020\u0012X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0012\u0010\u0015\u001a\u00020\u0016X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0018\u0010\u0019\u001a\u00020\rX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u001a\u0010\u000e\"\u0004\b\u001b\u0010\u001c\u00a8\u0006-"}, d2={"Lcom/android/tools/idea/streaming/RunningDevicePanel;", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "Lcom/intellij/openapi/actionSystem/DataProvider;", "id", "Lcom/android/tools/idea/streaming/DeviceId;", "(Lcom/android/tools/idea/streaming/DeviceId;)V", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "getId", "()Lcom/android/tools/idea/streaming/DeviceId;", "isClosable", "", "()Z", "mirroringStartTime", "", "preferredFocusableComponent", "Ljavax/swing/JComponent;", "getPreferredFocusableComponent", "()Ljavax/swing/JComponent;", "title", "", "getTitle", "()Ljava/lang/String;", "zoomToolbarVisible", "getZoomToolbarVisible", "setZoomToolbarVisible", "(Z)V", "createContent", "", "deviceFrameVisible", "savedUiState", "Lcom/android/tools/idea/streaming/RunningDevicePanel$UiState;", "destroyContent", "getData", "", "dataId", "mirroringEnded", "deviceKind", "Lcom/google/wireless/android/sdk/stats/DeviceMirroringSession$DeviceKind;", "mirroringStarted", "setDeviceFrameVisible", "visible", "UiState", "intellij.android.streaming"})
public abstract class RunningDevicePanel
extends BorderLayoutPanel
implements DataProvider {
    @NotNull
    private final DeviceId id;
    private long mirroringStartTime;

    public RunningDevicePanel(@NotNull DeviceId id2) {
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        this.id = id2;
    }

    @NotNull
    public final DeviceId getId() {
        return this.id;
    }

    @NotNull
    public abstract String getTitle();

    @NotNull
    public abstract Icon getIcon();

    public abstract boolean isClosable();

    @NotNull
    public abstract JComponent getPreferredFocusableComponent();

    public abstract boolean getZoomToolbarVisible();

    public abstract void setZoomToolbarVisible(boolean var1);

    public abstract void createContent(boolean var1, @Nullable UiState var2);

    public static /* synthetic */ void createContent$default(RunningDevicePanel runningDevicePanel, boolean bl, UiState uiState, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createContent");
        }
        if ((n & 2) != 0) {
            uiState = null;
        }
        runningDevicePanel.createContent(bl, uiState);
    }

    @NotNull
    public abstract UiState destroyContent();

    public abstract void setDeviceFrameVisible(boolean var1);

    protected final void mirroringStarted() {
        this.mirroringStartTime = System.currentTimeMillis();
    }

    protected final void mirroringEnded(@NotNull DeviceMirroringSession.DeviceKind deviceKind) {
        Intrinsics.checkNotNullParameter((Object)deviceKind, (String)"deviceKind");
        long durationSec = (System.currentTimeMillis() - this.mirroringStartTime) / (long)1000;
        this.mirroringStartTime = 0L;
        AndroidStudioEvent.Builder studioEvent = AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.DEVICE_MIRRORING_SESSION).setDeviceMirroringSession(DeviceMirroringSession.newBuilder().setDeviceKind(deviceKind).setDurationSec(durationSec));
        Intrinsics.checkNotNullExpressionValue((Object)studioEvent, (String)"studioEvent");
        UsageTracker.log((AndroidStudioEvent.Builder)studioEvent);
    }

    @Nullable
    public Object getData(@NotNull String dataId) {
        Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
        return Intrinsics.areEqual((Object)dataId, (Object)RunningDevicesConstants.SERIAL_NUMBER_KEY.getName()) ? this.id.getSerialNumber() : null;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\bf\u0018\u00002\u00020\u0001\u00a8\u0006\u0002\u00c0\u0006\u0003"}, d2={"Lcom/android/tools/idea/streaming/RunningDevicePanel$UiState;", "", "intellij.android.streaming"})
    public static interface UiState {
    }
}

