/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.streaming;

import com.android.tools.adtui.common.StudioColorsKt;
import com.android.tools.idea.streaming.AbstractDisplayView;
import com.android.tools.idea.streaming.StreamingLoadingPanel;
import com.android.tools.idea.streaming.ZoomToolbarProvider;
import com.android.tools.idea.streaming.ZoomablePanel;
import com.android.tools.idea.streaming.emulator.NotificationHolderPanel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.components.JBScrollBar;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.plaf.ScrollBarUI;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u00032\u00020\u0004:\u0004/012B\u0015\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010*\u001a\u00020+J\u000e\u0010,\u001a\u00020+2\u0006\u0010-\u001a\u00020.R\u0012\u0010\t\u001a\u0004\u0018\u00018\u0000X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R$\u0010\u0012\u001a\u00028\u00002\u0006\u0010\u0011\u001a\u00028\u00008F@DX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\u00020\u001aX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010!\u001a\u00020 2\u0006\u0010\u001f\u001a\u00020 8@@@X\u0080\u000e\u00a2\u0006\f\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R$\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020\u00078F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)\u00a8\u00063"}, d2={"Lcom/android/tools/idea/streaming/AbstractDisplayPanel;", "T", "Lcom/android/tools/idea/streaming/AbstractDisplayView;", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "Lcom/intellij/openapi/Disposable;", "disposableParent", "zoomToolbarVisible", "", "(Lcom/intellij/openapi/Disposable;Z)V", "_displayView", "Lcom/android/tools/idea/streaming/AbstractDisplayView;", "centerPanel", "Lcom/android/tools/idea/streaming/emulator/NotificationHolderPanel;", "displayId", "", "getDisplayId", "()I", "view", "displayView", "getDisplayView", "()Lcom/android/tools/idea/streaming/AbstractDisplayView;", "setDisplayView", "(Lcom/android/tools/idea/streaming/AbstractDisplayView;)V", "floatingToolbar", "Ljavax/swing/JComponent;", "loadingPanel", "Lcom/android/tools/idea/streaming/StreamingLoadingPanel;", "getLoadingPanel", "()Lcom/android/tools/idea/streaming/StreamingLoadingPanel;", "scrollPane", "Ljavax/swing/JScrollPane;", "value", "Lcom/android/tools/idea/streaming/AbstractDisplayPanel$ZoomScrollState;", "zoomScrollState", "getZoomScrollState$intellij_android_streaming", "()Lcom/android/tools/idea/streaming/AbstractDisplayPanel$ZoomScrollState;", "setZoomScrollState$intellij_android_streaming", "(Lcom/android/tools/idea/streaming/AbstractDisplayPanel$ZoomScrollState;)V", "getZoomToolbarVisible", "()Z", "setZoomToolbarVisible", "(Z)V", "dispose", "", "showLongRunningOperationIndicator", "text", "", "LayeredPaneLayoutManager", "MyScrollBar", "MyScrollPane", "ZoomScrollState", "intellij.android.streaming"})
public abstract class AbstractDisplayPanel<T extends AbstractDisplayView>
extends BorderLayoutPanel
implements Disposable {
    @NotNull
    private final JScrollPane scrollPane;
    @NotNull
    private final NotificationHolderPanel centerPanel;
    @NotNull
    private JComponent floatingToolbar;
    @NotNull
    private final StreamingLoadingPanel loadingPanel;
    @Nullable
    private T _displayView;

    public AbstractDisplayPanel(@NotNull Disposable disposableParent, boolean zoomToolbarVisible) {
        JLayeredPane jLayeredPane;
        JPanel jPanel;
        Intrinsics.checkNotNullParameter((Object)disposableParent, (String)"disposableParent");
        Disposer.register((Disposable)disposableParent, (Disposable)this);
        this.setBackground((Color)StudioColorsKt.getPrimaryPanelBackground());
        JPanel $this$_init__u24lambda_u2d0 = jPanel = new JPanel();
        boolean bl = false;
        $this$_init__u24lambda_u2d0.setLayout(new BorderLayout());
        $this$_init__u24lambda_u2d0.setBorder(JBUI.Borders.empty((int)UIUtil.getScrollBarWidth()));
        $this$_init__u24lambda_u2d0.setOpaque(false);
        $this$_init__u24lambda_u2d0.setFocusable(true);
        JPanel zoomControlsLayerPane = jPanel;
        this.scrollPane = (JScrollPane)((Object)new MyScrollPane());
        JLayeredPane $this$_init__u24lambda_u2d1 = jLayeredPane = new JLayeredPane();
        boolean bl2 = false;
        $this$_init__u24lambda_u2d1.setLayout(new LayeredPaneLayoutManager());
        $this$_init__u24lambda_u2d1.setFocusable(true);
        Component component2 = zoomControlsLayerPane;
        Integer n = JLayeredPane.PALETTE_LAYER;
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"PALETTE_LAYER");
        $this$_init__u24lambda_u2d1.setLayer(component2, ((Number)n).intValue());
        Component component3 = this.scrollPane;
        Integer n2 = JLayeredPane.DEFAULT_LAYER;
        Intrinsics.checkNotNullExpressionValue((Object)n2, (String)"DEFAULT_LAYER");
        $this$_init__u24lambda_u2d1.setLayer(component3, ((Number)n2).intValue());
        $this$_init__u24lambda_u2d1.add((Component)zoomControlsLayerPane, "Center");
        $this$_init__u24lambda_u2d1.add((Component)this.scrollPane, "Center");
        JLayeredPane layeredPane = jLayeredPane;
        this.floatingToolbar = ZoomToolbarProvider.Companion.createToolbar((JComponent)((Object)this), this);
        this.floatingToolbar.setVisible(zoomToolbarVisible);
        zoomControlsLayerPane.add((Component)this.floatingToolbar, "East");
        this.loadingPanel = new StreamingLoadingPanel(this);
        this.loadingPanel.add(layeredPane, "Center");
        this.centerPanel = new NotificationHolderPanel((Component)((Object)this.loadingPanel));
        this.addToCenter((Component)((Object)this.centerPanel));
    }

    @NotNull
    protected final StreamingLoadingPanel getLoadingPanel() {
        return this.loadingPanel;
    }

    @NotNull
    public final T getDisplayView() {
        T t = this._displayView;
        if (t == null) {
            throw new IllegalStateException("displayView is not initialized");
        }
        return t;
    }

    protected final void setDisplayView(@NotNull T view) {
        Intrinsics.checkNotNullParameter(view, (String)"view");
        this._displayView = view;
        this.scrollPane.setViewportView((Component)this.getDisplayView());
    }

    public final int getDisplayId() {
        return ((AbstractDisplayView)((Object)this.getDisplayView())).getDisplayId();
    }

    public final boolean getZoomToolbarVisible() {
        return this.floatingToolbar.isVisible();
    }

    public final void setZoomToolbarVisible(boolean value2) {
        this.floatingToolbar.setVisible(value2);
    }

    @NotNull
    public final ZoomScrollState getZoomScrollState$intellij_android_streaming() {
        Point point = this.scrollPane.getViewport().getViewPosition();
        Intrinsics.checkNotNullExpressionValue((Object)point, (String)"scrollPane.viewport.viewPosition");
        return new ZoomScrollState(point, ((ZoomablePanel)((Object)this.getDisplayView())).getExplicitlySetPreferredSize$intellij_android_streaming());
    }

    public final void setZoomScrollState$intellij_android_streaming(@NotNull ZoomScrollState value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        if (value2.getPreferredViewSize() != null) {
            this.getDisplayView().setPreferredSize(value2.getPreferredViewSize());
            this.scrollPane.getViewport().setViewPosition(value2.getViewPosition());
        }
    }

    public final void showLongRunningOperationIndicator(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        this.loadingPanel.setLoadingText(text2);
        this.loadingPanel.startLoading();
    }

    public final void dispose() {
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/idea/streaming/AbstractDisplayPanel$ZoomScrollState;", "", "viewPosition", "Ljava/awt/Point;", "preferredViewSize", "Ljava/awt/Dimension;", "(Ljava/awt/Point;Ljava/awt/Dimension;)V", "getPreferredViewSize", "()Ljava/awt/Dimension;", "getViewPosition", "()Ljava/awt/Point;", "intellij.android.streaming"})
    public static final class ZoomScrollState {
        @NotNull
        private final Point viewPosition;
        @Nullable
        private final Dimension preferredViewSize;

        public ZoomScrollState(@NotNull Point viewPosition, @Nullable Dimension preferredViewSize) {
            Intrinsics.checkNotNullParameter((Object)viewPosition, (String)"viewPosition");
            this.viewPosition = viewPosition;
            this.preferredViewSize = preferredViewSize;
        }

        @NotNull
        public final Point getViewPosition() {
            return this.viewPosition;
        }

        @Nullable
        public final Dimension getPreferredViewSize() {
            return this.preferredViewSize;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000bH\u0016J\u0010\u0010\u000f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000bH\u0016J\u0012\u0010\u0010\u001a\u00020\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/idea/streaming/AbstractDisplayPanel$LayeredPaneLayoutManager;", "Ljava/awt/LayoutManager;", "()V", "addLayoutComponent", "", "name", "", "comp", "Ljava/awt/Component;", "layoutContainer", "target", "Ljava/awt/Container;", "minimumLayoutSize", "Ljava/awt/Dimension;", "parent", "preferredLayoutSize", "removeLayoutComponent", "intellij.android.streaming"})
    private static final class LayeredPaneLayoutManager
    implements LayoutManager {
        @Override
        public void layoutContainer(@NotNull Container target2) {
            Intrinsics.checkNotNullParameter((Object)target2, (String)"target");
            Insets insets = target2.getInsets();
            Intrinsics.checkNotNullExpressionValue((Object)insets, (String)"target.insets");
            Insets insets2 = insets;
            int top = insets2.top;
            int bottom = target2.getHeight() - insets2.bottom;
            int left2 = insets2.left;
            int right = target2.getWidth() - insets2.right;
            Component[] componentArray = target2.getComponents();
            Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"target.components");
            for (Component child : componentArray) {
                child.setBounds(left2, top, right - left2, bottom - top);
            }
        }

        @Override
        @NotNull
        public Dimension preferredLayoutSize(@NotNull Container parent2) {
            Dimension dimension2;
            Intrinsics.checkNotNullParameter((Object)parent2, (String)"parent");
            if (parent2.isPreferredSizeSet()) {
                Dimension dimension3 = parent2.getPreferredSize();
                dimension2 = dimension3;
                Intrinsics.checkNotNullExpressionValue((Object)dimension3, (String)"parent.preferredSize");
            } else {
                dimension2 = new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
            }
            return dimension2;
        }

        @Override
        @NotNull
        public Dimension minimumLayoutSize(@NotNull Container parent2) {
            Intrinsics.checkNotNullParameter((Object)parent2, (String)"parent");
            return new Dimension(0, 0);
        }

        @Override
        public void addLayoutComponent(@Nullable String name, @Nullable Component comp) {
        }

        @Override
        public void removeLayoutComponent(@Nullable Component comp) {
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\b\u0010\u0005\u001a\u00020\u0004H\u0016J\u0012\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J(\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\fH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/idea/streaming/AbstractDisplayPanel$MyScrollPane;", "Lcom/intellij/ui/components/JBScrollPane;", "()V", "createHorizontalScrollBar", "Ljavax/swing/JScrollBar;", "createVerticalScrollBar", "setBorder", "", "border", "Ljavax/swing/border/Border;", "setBounds", "x", "", "y", "width", "height", "intellij.android.streaming"})
    private static final class MyScrollPane
    extends JBScrollPane {
        public MyScrollPane() {
            super(0);
            this.setupCorners();
            this.verticalScrollBarPolicy = 20;
            this.horizontalScrollBarPolicy = 30;
            this.viewport.setBackground(this.getBackground());
        }

        @NotNull
        public JScrollBar createVerticalScrollBar() {
            return (JScrollBar)((Object)new MyScrollBar(1));
        }

        @NotNull
        public JScrollBar createHorizontalScrollBar() {
            return (JScrollBar)((Object)new MyScrollBar(0));
        }

        public void setBorder(@Nullable Border border) {
        }

        public void setBounds(int x, int y, int width, int height) {
            int oldWidth = this.getWidth();
            int oldHeight = this.getHeight();
            super.setBounds(x, y, width, height);
            Component view = this.viewport.getView();
            Dimension viewPreferredSize = view.getPreferredSize();
            if (viewPreferredSize.width <= oldWidth && viewPreferredSize.height <= oldHeight && (viewPreferredSize.width >= width || viewPreferredSize.height >= height) || (viewPreferredSize.width >= oldWidth || viewPreferredSize.height >= oldHeight) && viewPreferredSize.width <= width && width < viewPreferredSize.width * 2 && viewPreferredSize.height <= height && height < viewPreferredSize.height * 2) {
                view.setPreferredSize(null);
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0006H\u0016R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/android/tools/idea/streaming/AbstractDisplayPanel$MyScrollBar;", "Lcom/intellij/ui/components/JBScrollBar;", "orientation", "", "(I)V", "persistentUI", "Ljavax/swing/plaf/ScrollBarUI;", "getBlockIncrement", "direction", "getUnitIncrement", "setUI", "", "ui", "intellij.android.streaming"})
    private static final class MyScrollBar
    extends JBScrollBar {
        @Nullable
        private ScrollBarUI persistentUI;

        public MyScrollBar(@JdkConstants.AdjustableOrientation int orientation) {
            super(orientation);
            this.setOpaque(false);
        }

        public void setUI(@NotNull ScrollBarUI ui) {
            Intrinsics.checkNotNullParameter((Object)ui, (String)"ui");
            if (this.persistentUI == null) {
                this.persistentUI = ui;
            }
            super.setUI(this.persistentUI);
            this.setOpaque(false);
        }

        public int getUnitIncrement(int direction) {
            return 5;
        }

        public int getBlockIncrement(int direction) {
            return 1;
        }
    }
}

