/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.stats;

import com.android.tools.analytics.AnalyticsSettings;
import com.android.tools.idea.stats.StatisticsViewerListener;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.JBColor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;

public class StatisticsViewer
extends JPanel
implements Disposable {
    public static final String ID = "StatisticsViewer";
    public static final String TITLE = "Android Studio Usage Statistics";
    private final ConsoleViewImpl myConsoleView;
    private DialogWrapper myDialog;

    StatisticsViewer() {
        super(new BorderLayout(0, 0));
        Disposer.register((Disposable)ApplicationManager.getApplication(), (Disposable)this);
        Project project = ProjectManager.getInstance().getDefaultProject();
        this.myConsoleView = new ConsoleViewImpl(project, true);
        StatisticsViewerListener.register(this, (Function1<? super AndroidStudioEvent.Builder, Void>)((Function1)this::processEvent));
        this.layoutConsoleView();
        this.createDialog(project);
    }

    private Void processEvent(AndroidStudioEvent.Builder builder2) {
        this.myConsoleView.print("===\n", ConsoleViewContentType.NORMAL_OUTPUT);
        this.myConsoleView.print(AnalyticsSettings.getDateProvider().now().toString() + "\n", ConsoleViewContentType.NORMAL_OUTPUT);
        this.myConsoleView.print(builder2.build().toString(), ConsoleViewContentType.NORMAL_OUTPUT);
        return null;
    }

    private void createDialog(Project project) {
        this.myDialog = new DialogWrapper(project, true){
            {
                this.init();
            }

            protected JComponent createCenterPanel() {
                Disposer.register((Disposable)this.getDisposable(), (Disposable)StatisticsViewer.this);
                return StatisticsViewer.this;
            }

            protected String getDimensionServiceKey() {
                return StatisticsViewer.ID;
            }

            @NotNull
            protected Action[] createActions() {
                return new Action[]{new AbstractAction("Close"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        this.doOKAction();
                    }
                }};
            }
        };
        this.myDialog.setModal(false);
        this.myDialog.setTitle(TITLE);
        this.myDialog.setResizable(true);
        this.myDialog.show();
    }

    private void layoutConsoleView() {
        RunContentDescriptor descriptor2 = new RunContentDescriptor((ExecutionConsole)this.myConsoleView, null, (JComponent)this, TITLE);
        Disposer.register((Disposable)this, (Disposable)descriptor2);
        JComponent consoleViewComponent = this.myConsoleView.getComponent();
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        actionGroup.addAll(this.myConsoleView.createConsoleActions());
        ActionToolbar toolbar2 = ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)actionGroup, false);
        toolbar2.setTargetComponent(consoleViewComponent);
        JComponent ui = descriptor2.getComponent();
        ui.add((Component)consoleViewComponent, "Center");
        ui.add((Component)toolbar2.getComponent(), "West");
        consoleViewComponent.setBorder(BorderFactory.createLineBorder((Color)JBColor.GRAY));
    }

    @Override
    public void show() {
        this.myDialog.getPeer().getWindow().toFront();
    }

    public void dispose() {
    }
}

