/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.stats;

import com.android.tools.analytics.AnalyticsSettings;
import com.android.tools.idea.serverflags.ServerFlagService;
import com.android.tools.idea.serverflags.protos.FeatureSurveyConfig;
import com.android.tools.idea.serverflags.protos.Survey;
import com.android.tools.idea.stats.AndroidStudioUsageTracker;
import com.android.tools.idea.stats.ChoiceDialogHelperKt;
import com.android.tools.idea.stats.DefaultSatisfactionSurveyKt;
import com.android.tools.idea.stats.FeatureSurveys;
import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.Message;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.ide.IdeEventQueue;
import com.intellij.openapi.ui.DialogWrapper;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011J\u000e\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015J\u0010\u0010\u0016\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007R\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/idea/stats/FeatureSurveys;", "", "()V", "config", "Lcom/android/tools/idea/serverflags/protos/FeatureSurveyConfig;", "getConfig", "()Lcom/android/tools/idea/serverflags/protos/FeatureSurveyConfig;", "config$delegate", "Lkotlin/Lazy;", "isFeatureSurveyPending", "", "lock", "featureSurveyInvoked", "", "name", "", "generalInterval", "", "specificInterval", "processEvent", "event", "Lcom/google/wireless/android/sdk/stats/AndroidStudioEvent$Builder;", "shouldInvokeFeatureSurvey", "intellij.android.core"})
public final class FeatureSurveys {
    @NotNull
    public static final FeatureSurveys INSTANCE = new FeatureSurveys();
    private static boolean isFeatureSurveyPending;
    @NotNull
    private static final Object lock;
    @NotNull
    private static final Lazy config$delegate;

    private FeatureSurveys() {
    }

    public final void processEvent(@NotNull AndroidStudioEvent.Builder event) {
        Runnable runnable2;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        String name = "analytics/surveys/feature/" + event.getKind().getValueDescriptor().getName();
        Survey survey = (Survey)ServerFlagService.Companion.getInstance().getProtoOrNull(name, (Message)DefaultSatisfactionSurveyKt.getDEFAULT_SATISFACTION_SURVEY());
        if (survey == null) {
            return;
        }
        Survey survey2 = survey;
        if (!this.shouldInvokeFeatureSurvey(name)) {
            return;
        }
        IdeEventQueue eventQueue = IdeEventQueue.getInstance();
        Ref.ObjectRef runner = new Ref.ObjectRef();
        runner.element = new Runnable(eventQueue, (Ref.ObjectRef<Runnable>)runner, survey2, name){
            final /* synthetic */ IdeEventQueue $eventQueue;
            final /* synthetic */ Ref.ObjectRef<Runnable> $runner;
            final /* synthetic */ Survey $survey;
            final /* synthetic */ String $name;
            {
                this.$eventQueue = $eventQueue;
                this.$runner = $runner;
                this.$survey = $survey;
                this.$name = $name;
            }

            public final void run() {
                Runnable runnable2;
                if (this.$runner.element == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"runner");
                    runnable2 = null;
                } else {
                    runnable2 = (Runnable)this.$runner.element;
                }
                this.$eventQueue.removeIdleListener(runnable2);
                DialogWrapper dialog2 = ChoiceDialogHelperKt.createDialog$default(this.$survey, null, false, 6, null);
                dialog2.show();
                int generalInterval = FeatureSurveys.access$getConfig(FeatureSurveys.INSTANCE).getGeneralIntervalCancelled();
                int specificInterval = FeatureSurveys.access$getConfig(FeatureSurveys.INSTANCE).getSpecificIntervalCancelled();
                if (dialog2.isOK()) {
                    generalInterval = FeatureSurveys.access$getConfig(FeatureSurveys.INSTANCE).getGeneralIntervalCompleted();
                    specificInterval = FeatureSurveys.access$getConfig(FeatureSurveys.INSTANCE).getSpecificIntervalCompleted();
                }
                FeatureSurveys.INSTANCE.featureSurveyInvoked(this.$name, generalInterval, specificInterval);
                AnalyticsSettings.saveSettings();
            }
        };
        if (runner.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"runner");
            runnable2 = null;
        } else {
            runnable2 = (Runnable)runner.element;
        }
        eventQueue.addIdleListener(runnable2, this.getConfig().getIdleIntervalMs());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public final boolean shouldInvokeFeatureSurvey(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (!AnalyticsSettings.getOptedIn() || isFeatureSurveyPending) {
            return false;
        }
        Date now = AnalyticsSettings.getDateProvider().now();
        Date date = AnalyticsSettings.getNextFeatureSurveyDate();
        if (date != null) {
            Date it = date;
            boolean bl = false;
            if (now.before(it)) {
                return false;
            }
        }
        Map map2 = AnalyticsSettings.getNextFeatureSurveyDateMap();
        if (map2 != null) {
            Map map3 = map2;
            boolean bl = false;
            Date date2 = (Date)map3.get(name);
            if (date2 != null) {
                Date it = date2;
                boolean bl2 = false;
                if (now.before(it)) {
                    return false;
                }
            }
        }
        Object object = lock;
        synchronized (object) {
            block10: {
                boolean bl = false;
                if (!isFeatureSurveyPending) break block10;
                boolean bl3 = false;
                return bl3;
            }
            isFeatureSurveyPending = true;
            Unit unit = Unit.INSTANCE;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void featureSurveyInvoked(@NotNull String name, int generalInterval, int specificInterval) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Date now = AnalyticsSettings.getDateProvider().now();
        Intrinsics.checkNotNullExpressionValue((Object)now, (String)"now");
        AnalyticsSettings.setNextFeatureSurveyDate((Date)AndroidStudioUsageTracker.INSTANCE.daysFromNow(now, generalInterval));
        Map map2 = AnalyticsSettings.getNextFeatureSurveyDateMap();
        if (map2 == null) {
            map2 = new LinkedHashMap();
        }
        Map map3 = map2;
        map3.put(name, AndroidStudioUsageTracker.INSTANCE.daysFromNow(now, specificInterval));
        AnalyticsSettings.setNextFeatureSurveyDateMap((Map)map3);
        Object object = lock;
        synchronized (object) {
            boolean bl = false;
            isFeatureSurveyPending = false;
            Unit unit = Unit.INSTANCE;
        }
    }

    private final FeatureSurveyConfig getConfig() {
        Lazy lazy = config$delegate;
        return (FeatureSurveyConfig)lazy.getValue();
    }

    public static final /* synthetic */ FeatureSurveyConfig access$getConfig(FeatureSurveys $this) {
        return $this.getConfig();
    }

    static {
        lock = new Object();
        config$delegate = LazyKt.lazy((Function0)config.2.INSTANCE);
    }
}

