/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.stats;

import com.android.tools.analytics.HistogramUtil;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.concurrency.AndroidDispatchers;
import com.android.tools.idea.concurrency.CoroutinesUtilsKt;
import com.android.tools.idea.stats.CompletionStats;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.EditorCompletionStats;
import com.google.wireless.android.sdk.stats.EditorFileType;
import com.intellij.application.Topics;
import com.intellij.codeInsight.completion.CompletionPhaseListener;
import com.intellij.codeInsight.lookup.LookupEvent;
import com.intellij.codeInsight.lookup.LookupListener;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.util.messages.Topic;
import java.beans.PropertyChangeListener;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CompletableDeferred;
import kotlinx.coroutines.CompletableDeferredKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Deferred;
import org.HdrHistogram.Histogram;
import org.HdrHistogram.SingleWriterRecorder;
import org.jetbrains.android.AndroidPluginDisposable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0003\u001b\u001c\u001dB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0015\u001a\u00020\u00162\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\n0\u00182\u0006\u0010\u0019\u001a\u00020\fH\u0002J\u0006\u0010\u001a\u001a\u00020\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/android/tools/idea/stats/CompletionStats;", "", "()V", "MAX_LATENCY_MS", "", "activeFileType", "Lkotlinx/coroutines/Deferred;", "Lcom/google/wireless/android/sdk/stats/EditorFileType;", "completionLatencyHistograms", "Ljava/util/concurrent/ConcurrentHashMap;", "Lorg/HdrHistogram/SingleWriterRecorder;", "completionStartMs", "", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "insertionLatencyHistograms", "popupLatencyHistograms", "unknownFileType", "Lkotlinx/coroutines/CompletableDeferred;", "waitingForAdditionalCompletions", "", "recordLatency", "", "histograms", "Ljava/util/concurrent/ConcurrentMap;", "latencyMs", "reportCompletionStats", "MyCompletionPhaseListener", "MyLookupListener", "MyStartupActivity", "intellij.android.core"})
public final class CompletionStats {
    @NotNull
    public static final CompletionStats INSTANCE = new CompletionStats();
    private static final int MAX_LATENCY_MS = 60000;
    @NotNull
    private static final ConcurrentHashMap<EditorFileType, SingleWriterRecorder> popupLatencyHistograms = new ConcurrentHashMap();
    @NotNull
    private static final ConcurrentHashMap<EditorFileType, SingleWriterRecorder> completionLatencyHistograms = new ConcurrentHashMap();
    @NotNull
    private static final ConcurrentHashMap<EditorFileType, SingleWriterRecorder> insertionLatencyHistograms = new ConcurrentHashMap();
    private static long completionStartMs = -1L;
    private static boolean waitingForAdditionalCompletions;
    @NotNull
    private static final CompletableDeferred<EditorFileType> unknownFileType;
    @NotNull
    private static Deferred<? extends EditorFileType> activeFileType;
    @NotNull
    private static final CoroutineScope coroutineScope;

    private CompletionStats() {
    }

    public final void reportCompletionStats() {
        AndroidStudioEvent.Builder builder2;
        EditorCompletionStats.Builder allStats = EditorCompletionStats.newBuilder();
        Set allFileTypes = new LinkedHashSet();
        Set set = popupLatencyHistograms.keySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"popupLatencyHistograms.keys");
        allFileTypes.addAll(set);
        Set set2 = completionLatencyHistograms.keySet();
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"completionLatencyHistograms.keys");
        allFileTypes.addAll(set2);
        Set set3 = insertionLatencyHistograms.keySet();
        Intrinsics.checkNotNullExpressionValue((Object)set3, (String)"insertionLatencyHistograms.keys");
        allFileTypes.addAll(set3);
        for (EditorFileType fileType : allFileTypes) {
            SingleWriterRecorder insertionLatencies;
            Object object;
            SingleWriterRecorder singleWriterRecorder;
            SingleWriterRecorder completionLatencies;
            Object object2;
            SingleWriterRecorder singleWriterRecorder2;
            SingleWriterRecorder popupLatencies;
            Object object3;
            SingleWriterRecorder singleWriterRecorder3 = popupLatencyHistograms.get(fileType);
            if (singleWriterRecorder3 != null && (singleWriterRecorder3 = singleWriterRecorder3.getIntervalHistogram()) != null) {
                SingleWriterRecorder singleWriterRecorder4;
                SingleWriterRecorder it = singleWriterRecorder4 = singleWriterRecorder3;
                boolean bl = false;
                object3 = it.getTotalCount() > 0L ? singleWriterRecorder4 : null;
            } else {
                object3 = popupLatencies = null;
            }
            if ((singleWriterRecorder2 = completionLatencyHistograms.get(fileType)) != null && (singleWriterRecorder2 = singleWriterRecorder2.getIntervalHistogram()) != null) {
                SingleWriterRecorder singleWriterRecorder5;
                SingleWriterRecorder it = singleWriterRecorder5 = singleWriterRecorder2;
                boolean bl = false;
                object2 = it.getTotalCount() > 0L ? singleWriterRecorder5 : null;
            } else {
                object2 = completionLatencies = null;
            }
            if ((singleWriterRecorder = insertionLatencyHistograms.get(fileType)) != null && (singleWriterRecorder = singleWriterRecorder.getIntervalHistogram()) != null) {
                SingleWriterRecorder singleWriterRecorder6;
                SingleWriterRecorder it = singleWriterRecorder6 = singleWriterRecorder;
                boolean bl = false;
                object = it.getTotalCount() > 0L ? singleWriterRecorder6 : null;
            } else {
                object = insertionLatencies = null;
            }
            if (popupLatencies == null && completionLatencies == null && insertionLatencies == null) continue;
            EditorCompletionStats.Stats.Builder stats = EditorCompletionStats.Stats.newBuilder();
            stats.setFileType(fileType);
            if (popupLatencies != null) {
                stats.setPopupLatency(HistogramUtil.toProto((Histogram)popupLatencies));
            }
            if (completionLatencies != null) {
                stats.setFullCompletionLatency(HistogramUtil.toProto((Histogram)completionLatencies));
            }
            if (insertionLatencies != null) {
                stats.setInsertionLatency(HistogramUtil.toProto((Histogram)insertionLatencies));
            }
            allStats.addByFileType(stats.build());
        }
        if (allStats.getByFileTypeCount() == 0) {
            return;
        }
        AndroidStudioEvent.Builder $this$reportCompletionStats_u24lambda_u2d3 = builder2 = AndroidStudioEvent.newBuilder();
        boolean bl = false;
        $this$reportCompletionStats_u24lambda_u2d3.setKind(AndroidStudioEvent.EventKind.EDITOR_COMPLETION_STATS);
        $this$reportCompletionStats_u24lambda_u2d3.setEditorCompletionStats(allStats.build());
        AndroidStudioEvent.Builder builder3 = builder2;
        Intrinsics.checkNotNullExpressionValue((Object)builder3, (String)"newBuilder().apply {\n   \u2026 allStats.build()\n      }");
        UsageTracker.log((AndroidStudioEvent.Builder)builder3);
    }

    private final void recordLatency(ConcurrentMap<EditorFileType, SingleWriterRecorder> histograms, long latencyMs) {
        if (latencyMs < 0L || latencyMs > 60000L) {
            return;
        }
        Deferred<? extends EditorFileType> currentFileType = activeFileType;
        BuildersKt.async$default((CoroutineScope)coroutineScope, (CoroutineContext)((CoroutineContext)AndroidDispatchers.INSTANCE.getUiThread()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(currentFileType, histograms, latencyMs, null){
            int label;
            final /* synthetic */ Deferred<EditorFileType> $currentFileType;
            final /* synthetic */ ConcurrentMap<EditorFileType, SingleWriterRecorder> $histograms;
            final /* synthetic */ long $latencyMs;
            {
                this.$currentFileType = $currentFileType;
                this.$histograms = $histograms;
                this.$latencyMs = $latencyMs;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = this.$currentFileType.await((Continuation)this);
                        if (v0 == var4_2) {
                            return var4_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        fileType = (EditorFileType)v0;
                        histogram = this.$histograms.computeIfAbsent(fileType, (Function<EditorFileType, SingleWriterRecorder>)recordLatency.histogram.1.INSTANCE);
                        histogram.recordValue(this.$latencyMs);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    public static final /* synthetic */ void access$setActiveFileType$p(Deferred deferred) {
        activeFileType = deferred;
    }

    public static final /* synthetic */ CompletableDeferred access$getUnknownFileType$p() {
        return unknownFileType;
    }

    public static final /* synthetic */ CoroutineScope access$getCoroutineScope$p() {
        return coroutineScope;
    }

    static {
        unknownFileType = CompletableDeferredKt.CompletableDeferred((Object)EditorFileType.UNKNOWN);
        activeFileType = (Deferred)unknownFileType;
        coroutineScope = CoroutinesUtilsKt.AndroidCoroutineScope$default((Disposable)AndroidPluginDisposable.Companion.getApplicationInstance(), null, (int)2, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/android/tools/idea/stats/CompletionStats$MyStartupActivity;", "Lcom/intellij/openapi/startup/StartupActivity;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "runActivity", "", "project", "Lcom/intellij/openapi/project/Project;", "intellij.android.core"})
    public static final class MyStartupActivity
    implements StartupActivity,
    DumbAware {
        public void runActivity(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Topic topic = CompletionPhaseListener.TOPIC;
            Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
            Topics.subscribe((Topic)topic, (Disposable)((Disposable)project), (Object)new MyCompletionPhaseListener());
            LookupManager.getInstance((Project)project).addPropertyChangeListener((PropertyChangeListener)runActivity.1.INSTANCE);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/idea/stats/CompletionStats$MyCompletionPhaseListener;", "Lcom/intellij/codeInsight/completion/CompletionPhaseListener;", "()V", "completionPhaseChanged", "", "isCompletionRunning", "", "intellij.android.core"})
    public static final class MyCompletionPhaseListener
    implements CompletionPhaseListener {
        public void completionPhaseChanged(boolean isCompletionRunning) {
            if (isCompletionRunning) {
                completionStartMs = System.currentTimeMillis();
            } else if (waitingForAdditionalCompletions) {
                waitingForAdditionalCompletions = false;
                INSTANCE.recordLatency(completionLatencyHistograms, System.currentTimeMillis() - completionStartMs);
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\f\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/android/tools/idea/stats/CompletionStats$MyLookupListener;", "Lcom/intellij/codeInsight/lookup/LookupListener;", "()V", "itemSelectionStartMs", "", "beforeItemSelected", "", "event", "Lcom/intellij/codeInsight/lookup/LookupEvent;", "itemSelected", "", "lookupCanceled", "lookupShown", "intellij.android.core"})
    public static final class MyLookupListener
    implements LookupListener {
        private long itemSelectionStartMs = -1L;

        public void lookupShown(@NotNull LookupEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            INSTANCE.recordLatency(popupLatencyHistograms, System.currentTimeMillis() - completionStartMs);
            waitingForAdditionalCompletions = true;
        }

        public void lookupCanceled(@NotNull LookupEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            waitingForAdditionalCompletions = false;
        }

        public boolean beforeItemSelected(@NotNull LookupEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            this.itemSelectionStartMs = System.currentTimeMillis();
            waitingForAdditionalCompletions = false;
            return super.beforeItemSelected(event);
        }

        public void itemSelected(@NotNull LookupEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            INSTANCE.recordLatency(insertionLatencyHistograms, System.currentTimeMillis() - this.itemSelectionStartMs);
        }
    }
}

