/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.startup;

import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.stats.ToolWindowTrackerService;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.StudioProjectChange;
import com.intellij.concurrency.JobScheduler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0005H\u0016J\u0010\u0010\f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0005H\u0016R^\u0010\u0003\u001aR\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003 \u0006*\b\u0012\u0002\b\u0003\u0018\u00010\u00070\u0007 \u0006*(\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003 \u0006*\b\u0012\u0002\b\u0003\u0018\u00010\u00070\u0007\u0018\u00010\b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/android/tools/idea/startup/ProjectMetricsInitializer;", "Lcom/intellij/openapi/project/ProjectManagerListener;", "()V", "persistStatisticsSessionsMap", "", "Lcom/intellij/openapi/project/Project;", "kotlin.jvm.PlatformType", "Ljava/util/concurrent/Future;", "", "projectClosed", "", "project", "projectOpened", "intellij.android.core"})
public final class ProjectMetricsInitializer
implements ProjectManagerListener {
    private final Map<Project, Future<?>> persistStatisticsSessionsMap = Collections.synchronizedMap(new HashMap());

    public void projectOpened(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ToolWindowTrackerService service = ToolWindowTrackerService.Companion.getInstance(project);
        MessageBusConnection messageBusConnection = project.getMessageBus().connect((Disposable)project);
        Topic topic = ToolWindowManagerListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, (Object)service);
        int projectsOpen = ProjectManager.getInstance().getOpenProjects().length - 1;
        AndroidStudioEvent.Builder builder2 = AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.STUDIO_PROJECT_OPENED).setStudioProjectChange(StudioProjectChange.newBuilder().setProjectsOpen(projectsOpen));
        Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"newBuilder()\n           \u2026ojectsOpen(projectsOpen))");
        UsageTracker.log((AndroidStudioEvent.Builder)builder2);
        ScheduledFuture<?> scheduledFuture2 = JobScheduler.getScheduler().schedule(new Runnable(project, this){
            final /* synthetic */ Project $project;
            final /* synthetic */ ProjectMetricsInitializer this$0;
            {
                this.$project = $project;
                this.this$0 = $receiver;
            }

            public final void run() {
                DumbService.getInstance((Project)this.$project).runWhenSmart(new Runnable(this.this$0, this.$project){
                    final /* synthetic */ ProjectMetricsInitializer this$0;
                    final /* synthetic */ Project $project;
                    {
                        this.this$0 = $receiver;
                        this.$project = $project;
                    }

                    public final void run() {
                        ScheduledFuture<?> future2 = JobScheduler.getScheduler().scheduleWithFixedDelay(new Runnable(this.$project){
                            final /* synthetic */ Project $project;
                            {
                                this.$project = $project;
                            }

                            public final void run() {
                                Set<String> knownProjectIds = ProjectSystemUtil.getProjectSystem(this.$project).getKnownApplicationIds(this.$project);
                                AndroidStudioEvent.Builder builder2 = AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.PROJECT_IDS).addAllRawProjectIds((Iterable)knownProjectIds);
                                Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"newBuilder()\n           \u2026ojectIds(knownProjectIds)");
                                UsageTracker.log((AndroidStudioEvent.Builder)builder2);
                            }
                        }, 0L, 60L, TimeUnit.MINUTES);
                        Map map2 = ProjectMetricsInitializer.access$getPersistStatisticsSessionsMap$p(this.this$0);
                        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"persistStatisticsSessionsMap");
                        Map map3 = map2;
                        map3.put(this.$project, future2);
                    }
                });
            }
        }, 10L, TimeUnit.MINUTES);
        Map<Project, Future<?>> map2 = this.persistStatisticsSessionsMap;
        Intrinsics.checkNotNullExpressionValue(map2, (String)"persistStatisticsSessionsMap");
        map2.put(project, scheduledFuture2);
    }

    public void projectClosed(@NotNull Project project) {
        block0: {
            Future<?> future2;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            int projectsOpen = ProjectManager.getInstance().getOpenProjects().length;
            AndroidStudioEvent.Builder builder2 = AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.STUDIO_PROJECT_CLOSED).setStudioProjectChange(StudioProjectChange.newBuilder().setProjectsOpen(projectsOpen));
            Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"newBuilder()\n           \u2026ojectsOpen(projectsOpen))");
            UsageTracker.log((AndroidStudioEvent.Builder)builder2);
            Future<?> future3 = future2 = this.persistStatisticsSessionsMap.remove(project);
            if (future3 == null) break block0;
            future3.cancel(true);
        }
    }

    public static final /* synthetic */ Map access$getPersistStatisticsSessionsMap$p(ProjectMetricsInitializer $this) {
        return $this.persistStatisticsSessionsMap;
    }
}

