/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.startup;

import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.analytics.IdeBrandProviderKt;
import com.android.tools.idea.diagnostics.AndroidStudioSystemHealthMonitor;
import com.android.tools.idea.stats.AndroidStudioUsageTracker;
import com.android.tools.idea.stats.ConsentDialog;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.analytics.AndroidStudioAnalytics;
import com.intellij.concurrency.JobScheduler;
import com.intellij.ide.ApplicationInitializedListener;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;

public class AndroidStudioInitializer
implements ApplicationInitializedListener {
    public void componentsInitialized() {
        AndroidStudioInitializer.setupAnalytics();
        ApplicationManager.getApplication().executeOnPooledThread(() -> AndroidStudioSystemHealthMonitor.getInstance().start());
    }

    private static void setupAnalytics() {
        AndroidStudioAnalytics.getInstance().initializeAndroidStudioUsageTrackerAndPublisher();
        ConsentDialog.showConsentDialogIfNeeded();
        ApplicationInfo application = ApplicationInfo.getInstance();
        UsageTracker.setVersion((String)application.getStrictVersion());
        UsageTracker.setIdeBrand((AndroidStudioEvent.IdeBrand)IdeBrandProviderKt.currentIdeBrand());
        if (ApplicationManager.getApplication().isInternal()) {
            UsageTracker.setIdeaIsInternal((boolean)true);
        }
        AndroidStudioUsageTracker.setup(JobScheduler.getScheduler());
    }
}

