/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sqlite.ui.sqliteEvaluator;

import com.intellij.openapi.editor.Editor;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.HintHint;
import com.intellij.ui.HintListener;
import com.intellij.ui.LightweightHint;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.EventObject;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u001fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0016\u001a\u00020\u0017H\u0002J\u0014\u0010\u0018\u001a\u00020\u00172\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\n0\u001aJ\u001e\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001dR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\r\u001a\u0010\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\n0\n0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/android/tools/idea/sqlite/ui/sqliteEvaluator/QueryHistoryView;", "", "editorTextField", "Lcom/intellij/ui/EditorTextField;", "(Lcom/intellij/ui/EditorTextField;)V", "component", "Ljavax/swing/JComponent;", "getComponent", "()Ljavax/swing/JComponent;", "editorPermanentQuery", "", "hint", "Lcom/intellij/ui/LightweightHint;", "list", "Lcom/intellij/ui/components/JBList;", "kotlin.jvm.PlatformType", "listModel", "Ljavax/swing/DefaultListModel;", "panel", "Ljavax/swing/JPanel;", "shouldRestorePermanentQuery", "", "selectEntryAndCloseQueryHistory", "", "setQueryHistory", "queries", "", "show", "x", "", "y", "MyListCellRenderer", "app-inspection.inspectors.database"})
public final class QueryHistoryView {
    @NotNull
    private final EditorTextField editorTextField;
    @NotNull
    private final DefaultListModel<String> listModel;
    @NotNull
    private final JBList<String> list;
    @NotNull
    private final JPanel panel;
    @NotNull
    private final LightweightHint hint;
    @NotNull
    private final JComponent component;
    @NotNull
    private String editorPermanentQuery;
    private boolean shouldRestorePermanentQuery;

    public QueryHistoryView(@NotNull EditorTextField editorTextField2) {
        Intrinsics.checkNotNullParameter((Object)editorTextField2, (String)"editorTextField");
        this.editorTextField = editorTextField2;
        this.listModel = new DefaultListModel();
        this.list = new JBList((ListModel)this.listModel);
        this.panel = new JPanel(new BorderLayout());
        this.hint = new LightweightHint((JComponent)this.panel);
        JComponent jComponent = this.hint.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"hint.component");
        this.component = jComponent;
        this.editorPermanentQuery = "";
        this.shouldRestorePermanentQuery = true;
        this.hint.setForceShowAsPopup(true);
        this.hint.setCancelOnClickOutside(true);
        this.hint.setResizable(true);
        this.hint.setFocusRequestor((JComponent)this.list);
        this.hint.addHintListener(new HintListener(){

            public final void hintHidden(@NotNull EventObject it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                editorTextField.requestFocusInWindow();
            }
        });
        this.list.getEmptyText().setShowAboveCenter(false);
        this.list.setSelectionMode(0);
        this.list.setCellRenderer((ListCellRenderer)((Object)new MyListCellRenderer()));
        this.list.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(@NotNull FocusEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            }

            @Override
            public void focusLost(@NotNull FocusEvent e) {
                Editor editor;
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (shouldRestorePermanentQuery) {
                    editorTextField.setText(editorPermanentQuery);
                }
                if ((editor = editorTextField.getEditor()) != null && (editor = editor.getSelectionModel()) != null) {
                    editor.setSelection(0, 0);
                }
                list.clearSelection();
            }
        });
        this.list.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public final void valueChanged(@NotNull ListSelectionEvent e) {
                block2: {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    if (e.getValueIsAdjusting()) {
                        return;
                    }
                    int viewIndex = list.getSelectionModel().getMinSelectionIndex();
                    if (viewIndex < 0) {
                        return;
                    }
                    String query = (String)listModel.get(viewIndex);
                    editorTextField.setText(query);
                    Editor editor = editorTextField.getEditor();
                    if (editor == null || (editor = editor.getSelectionModel()) == null) break block2;
                    editor.setSelection(0, query.length());
                }
            }
        });
        this.list.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(@NotNull KeyEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            }

            @Override
            public void keyPressed(@NotNull KeyEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            }

            @Override
            public void keyReleased(@NotNull KeyEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (e.getKeyCode() == 10) {
                    this.selectEntryAndCloseQueryHistory();
                }
            }
        });
        this.list.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            }

            @Override
            public void mouseMoved(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                int viewIndex = list.locationToIndex(e.getPoint());
                if (viewIndex < 0) {
                    return;
                }
                list.setSelectedIndex(viewIndex);
            }
        });
        DoubleClickListener doubleClickListener2 = new DoubleClickListener(this){
            final /* synthetic */ QueryHistoryView this$0;
            {
                this.this$0 = $receiver;
            }

            protected boolean onDoubleClick(@NotNull MouseEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                QueryHistoryView.access$selectEntryAndCloseQueryHistory(this.this$0);
                return false;
            }
        };
        doubleClickListener2.installOn((Component)this.list);
        JBScrollPane listScroller = new JBScrollPane((Component)this.list);
        listScroller.setBorder((Border)JBUI.Borders.empty());
        JBLabel instructionsLabel = new JBLabel("Press Enter to insert");
        instructionsLabel.setFont(instructionsLabel.getFont().deriveFont(11.0f));
        instructionsLabel.setBorder((Border)JBUI.Borders.empty((int)2, (int)8, (int)2, (int)8));
        instructionsLabel.setEnabled(false);
        this.panel.add((Component)listScroller, "Center");
        this.panel.add((Component)instructionsLabel, "South");
        this.list.setFixedCellWidth(JBUI.scale((int)350));
    }

    @NotNull
    public final JComponent getComponent() {
        return this.component;
    }

    public final void show(@NotNull JComponent component2, int x, int y) {
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        String string = this.editorTextField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"editorTextField.text");
        this.editorPermanentQuery = string;
        this.shouldRestorePermanentQuery = true;
        this.hint.show(component2, x, y, (JComponent)this.editorTextField, new HintHint());
    }

    public final void setQueryHistory(@NotNull List<String> queries) {
        Intrinsics.checkNotNullParameter(queries, (String)"queries");
        this.listModel.clear();
        Iterable $this$forEach$iv = queries;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            this.listModel.addElement(it);
        }
    }

    private final void selectEntryAndCloseQueryHistory() {
        int selectedViewIndex = this.list.getSelectionModel().getMinSelectionIndex();
        if (selectedViewIndex < 0) {
            return;
        }
        String query = this.listModel.get(selectedViewIndex);
        this.editorTextField.setText(query);
        this.shouldRestorePermanentQuery = false;
        this.hint.hide();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J8\u0010\u0004\u001a\u00020\u00052\u000e\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0014\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/idea/sqlite/ui/sqliteEvaluator/QueryHistoryView$MyListCellRenderer;", "Lcom/intellij/ui/ColoredListCellRenderer;", "", "()V", "customizeCellRenderer", "", "list", "Ljavax/swing/JList;", "value", "index", "", "selected", "", "hasFocus", "app-inspection.inspectors.database"})
    private static final class MyListCellRenderer
    extends ColoredListCellRenderer<String> {
        protected void customizeCellRenderer(@NotNull JList<? extends String> list2, @NotNull String value2, int index2, boolean selected, boolean hasFocus) {
            Intrinsics.checkNotNullParameter(list2, (String)"list");
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            this.append(index2 + 1 + ".");
            this.append("  ");
            this.append(value2);
        }
    }
}

