/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sqlite.ui.mainView;

import com.android.tools.adtui.common.ColoredIconGenerator;
import com.android.tools.adtui.stdui.CommonButton;
import com.android.tools.idea.sqlite.localization.DatabaseInspectorBundle;
import com.android.tools.idea.sqlite.model.ExportDialogParams;
import com.android.tools.idea.sqlite.model.SqliteColumn;
import com.android.tools.idea.sqlite.model.SqliteDatabaseId;
import com.android.tools.idea.sqlite.model.SqliteSchema;
import com.android.tools.idea.sqlite.model.SqliteTable;
import com.android.tools.idea.sqlite.ui.mainView.AddColumns;
import com.android.tools.idea.sqlite.ui.mainView.AddTable;
import com.android.tools.idea.sqlite.ui.mainView.DatabaseInspectorView;
import com.android.tools.idea.sqlite.ui.mainView.DatabaseInspectorViewImpl;
import com.android.tools.idea.sqlite.ui.mainView.IndexedSqliteColumn;
import com.android.tools.idea.sqlite.ui.mainView.IndexedSqliteTable;
import com.android.tools.idea.sqlite.ui.mainView.LeftPanelView;
import com.android.tools.idea.sqlite.ui.mainView.RemoveColumns;
import com.android.tools.idea.sqlite.ui.mainView.RemoveTable;
import com.android.tools.idea.sqlite.ui.mainView.SchemaDiffOperation;
import com.android.tools.idea.sqlite.ui.mainView.ViewDatabase;
import com.google.wireless.android.sdk.stats.AppInspectionEvent;
import com.intellij.icons.AllIcons;
import com.intellij.ide.HelpTooltip;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.util.IconLoader;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.ui.treeStructure.actions.CollapseAllAction;
import com.intellij.util.ui.JBUI;
import icons.StudioIcons;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001KB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J&\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00162\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fH\u0002J \u0010!\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u00020\nJ.\u0010'\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010(\u001a\u00020\u00162\u0006\u0010)\u001a\u00020*2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020 0\u001fH\u0002J\b\u0010,\u001a\u00020\u0006H\u0002J\u0006\u0010-\u001a\u00020.J\u0012\u0010/\u001a\u0004\u0018\u0001002\u0006\u00101\u001a\u000202H\u0002J\b\u00103\u001a\u00020\u0006H\u0002J\u001a\u00104\u001a\u0004\u0018\u00010\u00162\u0006\u0010(\u001a\u00020\u00162\u0006\u00105\u001a\u000206H\u0002J\u0010\u00107\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020#H\u0002J\u001a\u00108\u001a\u0004\u0018\u00010\u00162\u0006\u0010(\u001a\u00020\u00162\u0006\u00109\u001a\u000206H\u0002J\u0018\u0010:\u001a\u00020\u001a2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010;\u001a\u00020<H\u0002J\b\u0010=\u001a\u00020>H\u0002J\u000e\u0010?\u001a\u00020\n2\u0006\u0010\"\u001a\u00020#J\u000e\u0010@\u001a\u00020\u001a2\u0006\u0010A\u001a\u00020>J\u0010\u0010B\u001a\u00020\u001a2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010C\u001a\u00020\u001a2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010D\u001a\u00020\u001a2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u001c\u0010E\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020#2\f\u0010F\u001a\b\u0012\u0004\u0012\u00020G0\u001fJ\b\u0010H\u001a\u00020\u001aH\u0002J\u000e\u0010I\u001a\u00020\u001a2\u0006\u0010J\u001a\u00020>R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u0004\u0018\u00010\u0016*\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006L"}, d2={"Lcom/android/tools/idea/sqlite/ui/mainView/LeftPanelView;", "", "mainView", "Lcom/android/tools/idea/sqlite/ui/mainView/DatabaseInspectorViewImpl;", "(Lcom/android/tools/idea/sqlite/ui/mainView/DatabaseInspectorViewImpl;)V", "component", "Ljavax/swing/JPanel;", "getComponent", "()Ljavax/swing/JPanel;", "databasesCount", "", "getDatabasesCount", "()I", "exportButton", "Lcom/android/tools/adtui/stdui/CommonButton;", "keepConnectionsOpenButton", "refreshSchemaButton", "rootPanel", "runSqlButton", "tree", "Lcom/intellij/ui/treeStructure/Tree;", "selectedNode", "Ljavax/swing/tree/DefaultMutableTreeNode;", "getSelectedNode", "(Lcom/intellij/ui/treeStructure/Tree;)Ljavax/swing/tree/DefaultMutableTreeNode;", "addColumnsToTableNode", "", "treeModel", "Ljavax/swing/tree/DefaultTreeModel;", "tableNode", "columnsToAdd", "", "Lcom/android/tools/idea/sqlite/ui/mainView/IndexedSqliteColumn;", "addDatabaseSchema", "viewDatabase", "Lcom/android/tools/idea/sqlite/ui/mainView/ViewDatabase;", "schema", "Lcom/android/tools/idea/sqlite/model/SqliteSchema;", "index", "addNewTableNode", "databaseNode", "sqliteTableToAdd", "Lcom/android/tools/idea/sqlite/ui/mainView/IndexedSqliteTable;", "sqliteColumnsToAdd", "createCenterPanel", "createCollapseTreeAction", "Lcom/intellij/openapi/actionSystem/AnAction;", "createExportDialogParams", "Lcom/android/tools/idea/sqlite/model/ExportDialogParams;", "actionOrigin", "Lcom/google/wireless/android/sdk/stats/AppInspectionEvent$DatabaseInspectorEvent$ExportDialogOpenedEvent$Origin;", "createNorthPanel", "findColumnNode", "columnName", "", "findDatabaseNode", "findTableNode", "tableName", "fireAction", "e", "Ljava/awt/event/InputEvent;", "hasLiveDatabases", "", "removeDatabaseSchema", "setRefreshButtonState", "state", "setUpExportPopUp", "setUpSchemaTree", "setUpSchemaTreeListeners", "updateDatabase", "diffOperations", "Lcom/android/tools/idea/sqlite/ui/mainView/SchemaDiffOperation;", "updateExportButtonEnabledState", "updateKeepConnectionOpenButton", "enabled", "SchemaTreeCellRenderer", "app-inspection.inspectors.database"})
public final class LeftPanelView {
    @NotNull
    private final DatabaseInspectorViewImpl mainView;
    @NotNull
    private final JPanel rootPanel;
    @NotNull
    private final Tree tree;
    @NotNull
    private final CommonButton refreshSchemaButton;
    @NotNull
    private final CommonButton runSqlButton;
    @NotNull
    private final CommonButton keepConnectionsOpenButton;
    @NotNull
    private final CommonButton exportButton;
    @NotNull
    private final JPanel component;

    public LeftPanelView(@NotNull DatabaseInspectorViewImpl mainView) {
        Intrinsics.checkNotNullParameter((Object)mainView, (String)"mainView");
        this.mainView = mainView;
        this.rootPanel = new JPanel(new BorderLayout());
        this.tree = new Tree();
        this.refreshSchemaButton = new CommonButton(AllIcons.Actions.Refresh);
        this.runSqlButton = new CommonButton(StudioIcons.DatabaseInspector.NEW_QUERY);
        this.keepConnectionsOpenButton = new CommonButton(StudioIcons.DatabaseInspector.KEEP_DATABASES_OPEN);
        this.exportButton = new CommonButton(AllIcons.ToolbarDecorator.Export);
        this.component = this.rootPanel;
        JPanel northPanel = this.createNorthPanel();
        JPanel centerPanel2 = this.createCenterPanel();
        this.rootPanel.add((Component)northPanel, "North");
        this.rootPanel.add((Component)centerPanel2, "Center");
        this.setUpSchemaTree(this.tree);
    }

    @NotNull
    public final JPanel getComponent() {
        return this.component;
    }

    public final int getDatabasesCount() {
        Object object = this.tree.getModel().getRoot();
        DefaultMutableTreeNode defaultMutableTreeNode = object instanceof DefaultMutableTreeNode ? (DefaultMutableTreeNode)object : null;
        return defaultMutableTreeNode != null ? defaultMutableTreeNode.getChildCount() : 0;
    }

    @NotNull
    public final AnAction createCollapseTreeAction() {
        return (AnAction)new CollapseAllAction((JTree)this.tree);
    }

    public final void updateKeepConnectionOpenButton(boolean enabled) {
        if (enabled) {
            this.keepConnectionsOpenButton.setIcon(StudioIcons.DatabaseInspector.KEEP_DATABASES_OPEN);
        } else {
            this.keepConnectionsOpenButton.setIcon(StudioIcons.DatabaseInspector.ALLOW_DATABASES_TO_CLOSE);
        }
        this.keepConnectionsOpenButton.setDisabledIcon(IconLoader.getDisabledIcon((Icon)this.keepConnectionsOpenButton.getIcon()));
    }

    public final void addDatabaseSchema(@NotNull ViewDatabase viewDatabase, @Nullable SqliteSchema schema, int index2) {
        DefaultMutableTreeNode defaultMutableTreeNode;
        Intrinsics.checkNotNullParameter((Object)viewDatabase, (String)"viewDatabase");
        TreeModel treeModel = this.tree.getModel();
        Intrinsics.checkNotNull((Object)treeModel, (String)"null cannot be cast to non-null type javax.swing.tree.DefaultTreeModel");
        DefaultTreeModel treeModel2 = (DefaultTreeModel)treeModel;
        if (treeModel2.getRoot() == null) {
            DefaultMutableTreeNode root = new DefaultMutableTreeNode("Databases");
            treeModel2.setRoot(root);
            defaultMutableTreeNode = root;
        } else {
            Object object = treeModel2.getRoot();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type javax.swing.tree.DefaultMutableTreeNode");
            defaultMutableTreeNode = (DefaultMutableTreeNode)object;
        }
        DefaultMutableTreeNode root = defaultMutableTreeNode;
        DefaultMutableTreeNode schemaNode = new DefaultMutableTreeNode(viewDatabase);
        Object object = schema;
        if (object != null && (object = ((SqliteSchema)object).getTables()) != null) {
            Iterable $this$sortedBy$iv = (Iterable)object;
            boolean $i$f$sortedBy = false;
            object = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    SqliteTable it = (SqliteTable)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)it.getName());
                    it = (SqliteTable)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName())));
                }
            });
            if (object != null) {
                Iterable $this$forEach$iv = (Iterable)object;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    SqliteTable table2 = (SqliteTable)element$iv;
                    boolean bl = false;
                    DefaultMutableTreeNode tableNode = new DefaultMutableTreeNode(table2);
                    Iterable $this$forEach$iv2 = table2.getColumns();
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv2 : $this$forEach$iv2) {
                        SqliteColumn column2 = (SqliteColumn)element$iv2;
                        boolean bl2 = false;
                        tableNode.add(new DefaultMutableTreeNode(column2));
                    }
                    schemaNode.add(tableNode);
                }
            }
        }
        treeModel2.insertNodeInto(schemaNode, root, index2);
        if (schema == null) {
            this.tree.expandPath(new TreePath(root));
        } else {
            this.tree.expandPath(new TreePath(schemaNode.getPath()));
        }
        this.refreshSchemaButton.setEnabled(true);
        this.runSqlButton.setEnabled(true);
        this.keepConnectionsOpenButton.setEnabled(this.hasLiveDatabases());
    }

    /*
     * WARNING - void declaration
     */
    public final void updateDatabase(@NotNull ViewDatabase viewDatabase, @NotNull List<? extends SchemaDiffOperation> diffOperations) {
        Intrinsics.checkNotNullParameter((Object)viewDatabase, (String)"viewDatabase");
        Intrinsics.checkNotNullParameter(diffOperations, (String)"diffOperations");
        TreeModel treeModel = this.tree.getModel();
        Intrinsics.checkNotNull((Object)treeModel, (String)"null cannot be cast to non-null type javax.swing.tree.DefaultTreeModel");
        DefaultTreeModel treeModel2 = (DefaultTreeModel)treeModel;
        DefaultMutableTreeNode databaseNode = this.findDatabaseNode(viewDatabase);
        databaseNode.setUserObject(viewDatabase);
        for (SchemaDiffOperation schemaDiffOperation : diffOperations) {
            void $this$forEach$iv;
            void $this$mapTo$iv$iv;
            DefaultMutableTreeNode tableNode;
            SchemaDiffOperation schemaDiffOperation2 = schemaDiffOperation;
            if (schemaDiffOperation2 instanceof AddTable) {
                this.addNewTableNode(treeModel2, databaseNode, ((AddTable)schemaDiffOperation).getIndexedSqliteTable(), ((AddTable)schemaDiffOperation).getColumns());
                continue;
            }
            if (schemaDiffOperation2 instanceof AddColumns) {
                if (this.findTableNode(databaseNode, ((AddColumns)schemaDiffOperation).getTableName()) == null) {
                    Object object = new String[]{((AddColumns)schemaDiffOperation).getTableName()};
                    object = DatabaseInspectorBundle.INSTANCE.message("tree.node.not.found", (String[])object);
                    throw new IllegalStateException(object.toString());
                }
                tableNode.setUserObject(((AddColumns)schemaDiffOperation).getNewTable());
                this.addColumnsToTableNode(treeModel2, tableNode, ((AddColumns)schemaDiffOperation).getColumns());
                continue;
            }
            if (schemaDiffOperation2 instanceof RemoveTable) {
                if (this.findTableNode(databaseNode, ((RemoveTable)schemaDiffOperation).getTableName()) == null) {
                    Object object = new String[]{((RemoveTable)schemaDiffOperation).getTableName()};
                    object = DatabaseInspectorBundle.INSTANCE.message("tree.node.not.found", (String[])object);
                    throw new IllegalStateException(object.toString());
                }
                treeModel2.removeNodeFromParent(tableNode);
                continue;
            }
            if (!(schemaDiffOperation2 instanceof RemoveColumns)) continue;
            if (this.findTableNode(databaseNode, ((RemoveColumns)schemaDiffOperation).getTableName()) == null) {
                Object object = new String[]{((RemoveColumns)schemaDiffOperation).getTableName()};
                object = DatabaseInspectorBundle.INSTANCE.message("tree.node.not.found", (String[])object);
                throw new IllegalStateException(object.toString());
            }
            tableNode.setUserObject(((RemoveColumns)schemaDiffOperation).getNewTable());
            Iterable $this$map$iv = ((RemoveColumns)schemaDiffOperation).getColumnsToRemove();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                SqliteColumn sqliteColumn = (SqliteColumn)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add(this.findColumnNode(tableNode, it.getName()));
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                DefaultMutableTreeNode it = (DefaultMutableTreeNode)element$iv;
                boolean bl = false;
                treeModel2.removeNodeFromParent(it);
            }
        }
    }

    public final int removeDatabaseSchema(@NotNull ViewDatabase viewDatabase) {
        Intrinsics.checkNotNullParameter((Object)viewDatabase, (String)"viewDatabase");
        TreeModel treeModel = this.tree.getModel();
        Intrinsics.checkNotNull((Object)treeModel, (String)"null cannot be cast to non-null type javax.swing.tree.DefaultTreeModel");
        DefaultTreeModel treeModel2 = (DefaultTreeModel)treeModel;
        DefaultMutableTreeNode databaseNode = this.findDatabaseNode(viewDatabase);
        treeModel2.removeNodeFromParent(databaseNode);
        this.keepConnectionsOpenButton.setEnabled(this.hasLiveDatabases());
        if (this.getDatabasesCount() == 0) {
            this.tree.setModel((TreeModel)new DefaultTreeModel(null));
            this.refreshSchemaButton.setEnabled(false);
            this.runSqlButton.setEnabled(false);
        }
        return this.getDatabasesCount();
    }

    private final JPanel createNorthPanel() {
        JPanel northPanel = new JPanel(new FlowLayout(0));
        this.refreshSchemaButton.setDisabledIcon(IconLoader.getDisabledIcon((Icon)AllIcons.Actions.Refresh));
        this.refreshSchemaButton.setName("refresh-schema-button");
        this.refreshSchemaButton.setEnabled(false);
        this.refreshSchemaButton.setToolTipText(DatabaseInspectorBundle.INSTANCE.message("action.refresh.schema.tooltip", new String[0]));
        northPanel.add((Component)this.refreshSchemaButton);
        this.refreshSchemaButton.addActionListener(new ActionListener(this){
            final /* synthetic */ LeftPanelView this$0;
            {
                this.this$0 = $receiver;
            }

            public final void actionPerformed(ActionEvent it) {
                Iterable $this$forEach$iv = LeftPanelView.access$getMainView$p(this.this$0).getListeners();
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    DatabaseInspectorView.Listener it2 = (DatabaseInspectorView.Listener)element$iv;
                    boolean bl = false;
                    it2.refreshAllOpenDatabasesSchemaActionInvoked();
                }
            }
        });
        this.runSqlButton.setDisabledIcon(IconLoader.getDisabledIcon((Icon)StudioIcons.DatabaseInspector.NEW_QUERY));
        this.runSqlButton.setName("run-sql-button");
        this.runSqlButton.setEnabled(false);
        this.runSqlButton.setToolTipText(DatabaseInspectorBundle.INSTANCE.message("action.run.query.tooltip", new String[0]));
        northPanel.add((Component)this.runSqlButton);
        this.runSqlButton.addActionListener(new ActionListener(this){
            final /* synthetic */ LeftPanelView this$0;
            {
                this.this$0 = $receiver;
            }

            public final void actionPerformed(ActionEvent it) {
                Iterable $this$forEach$iv = LeftPanelView.access$getMainView$p(this.this$0).getListeners();
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    DatabaseInspectorView.Listener it2 = (DatabaseInspectorView.Listener)element$iv;
                    boolean bl = false;
                    it2.openSqliteEvaluatorTabActionInvoked();
                }
            }
        });
        this.keepConnectionsOpenButton.setDisabledIcon(IconLoader.getDisabledIcon((Icon)this.keepConnectionsOpenButton.getIcon()));
        this.keepConnectionsOpenButton.setName("keep-connections-open-button");
        this.keepConnectionsOpenButton.setEnabled(false);
        new HelpTooltip().setTitle(DatabaseInspectorBundle.INSTANCE.message("action.keep.open.tooltip.title", new String[0])).setDescription(DatabaseInspectorBundle.INSTANCE.message("action.keep.open.tooltip.desc", new String[0])).setLink(DatabaseInspectorBundle.INSTANCE.message("learn.more", new String[0]), (Runnable)createNorthPanel.3.INSTANCE).installOn((JComponent)this.keepConnectionsOpenButton);
        northPanel.add((Component)this.keepConnectionsOpenButton);
        this.keepConnectionsOpenButton.addActionListener(new ActionListener(this){
            final /* synthetic */ LeftPanelView this$0;
            {
                this.this$0 = $receiver;
            }

            public final void actionPerformed(ActionEvent it) {
                Iterable $this$forEach$iv = LeftPanelView.access$getMainView$p(this.this$0).getListeners();
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    DatabaseInspectorView.Listener it2 = (DatabaseInspectorView.Listener)element$iv;
                    boolean bl = false;
                    it2.toggleKeepConnectionOpenActionInvoked();
                }
            }
        });
        this.exportButton.setName("export-button");
        this.exportButton.setDisabledIcon(IconLoader.getDisabledIcon((Icon)this.exportButton.getIcon()));
        new HelpTooltip().setTitle(DatabaseInspectorBundle.INSTANCE.message("action.export.button.tooltip.title", new String[0])).installOn((JComponent)this.exportButton);
        northPanel.add((Component)this.exportButton);
        this.exportButton.addActionListener(new ActionListener(this){
            final /* synthetic */ LeftPanelView this$0;
            {
                this.this$0 = $receiver;
            }

            public final void actionPerformed(ActionEvent it) {
                ExportDialogParams exportDialogParams = LeftPanelView.access$createExportDialogParams(this.this$0, AppInspectionEvent.DatabaseInspectorEvent.ExportDialogOpenedEvent.Origin.SCHEMA_TREE_EXPORT_BUTTON);
                if (exportDialogParams == null) {
                    return;
                }
                ExportDialogParams exportParams = exportDialogParams;
                Iterable $this$forEach$iv = LeftPanelView.access$getMainView$p(this.this$0).getListeners();
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    DatabaseInspectorView.Listener it2 = (DatabaseInspectorView.Listener)element$iv;
                    boolean bl = false;
                    it2.showExportToFileDialogInvoked(exportParams);
                }
            }
        });
        this.updateExportButtonEnabledState();
        this.tree.addTreeSelectionListener(new TreeSelectionListener(this){
            final /* synthetic */ LeftPanelView this$0;
            {
                this.this$0 = $receiver;
            }

            public final void valueChanged(TreeSelectionEvent it) {
                LeftPanelView.access$updateExportButtonEnabledState(this.this$0);
            }
        });
        return northPanel;
    }

    private final void updateExportButtonEnabledState() {
        this.exportButton.setEnabled(this.createExportDialogParams(AppInspectionEvent.DatabaseInspectorEvent.ExportDialogOpenedEvent.Origin.SCHEMA_TREE_EXPORT_BUTTON) != null);
    }

    private final ExportDialogParams createExportDialogParams(AppInspectionEvent.DatabaseInspectorEvent.ExportDialogOpenedEvent.Origin actionOrigin) {
        Object object;
        DefaultMutableTreeNode selectedNode;
        DefaultMutableTreeNode defaultMutableTreeNode = selectedNode = this.getSelectedNode(this.tree);
        Object selected = defaultMutableTreeNode != null ? defaultMutableTreeNode.getUserObject() : null;
        DefaultMutableTreeNode defaultMutableTreeNode2 = selectedNode;
        if (defaultMutableTreeNode2 != null) {
            DefaultMutableTreeNode it = defaultMutableTreeNode2;
            boolean bl = false;
            TreeNode treeNode = it.getParent();
            DefaultMutableTreeNode defaultMutableTreeNode3 = treeNode instanceof DefaultMutableTreeNode ? (DefaultMutableTreeNode)treeNode : null;
            object = defaultMutableTreeNode3 != null ? defaultMutableTreeNode3.getUserObject() : null;
        } else {
            object = null;
        }
        Object parent2 = object;
        return selected instanceof ViewDatabase ? (ExportDialogParams)new ExportDialogParams.ExportDatabaseDialogParams(((ViewDatabase)selected).getDatabaseId(), actionOrigin) : (selected instanceof SqliteTable && parent2 instanceof ViewDatabase ? (ExportDialogParams)new ExportDialogParams.ExportTableDialogParams(((ViewDatabase)parent2).getDatabaseId(), ((SqliteTable)selected).getName(), actionOrigin) : null);
    }

    private final DefaultMutableTreeNode getSelectedNode(Tree $this$selectedNode) {
        TreePath treePath = $this$selectedNode.getSelectionPath();
        Object object = treePath != null ? treePath.getLastPathComponent() : null;
        return object instanceof DefaultMutableTreeNode ? (DefaultMutableTreeNode)object : null;
    }

    private final JPanel createCenterPanel() {
        JPanel centerPanel2 = new JPanel(new BorderLayout());
        centerPanel2.setBorder(IdeBorderFactory.createBorder((int)2));
        JBScrollPane scrollPane = new JBScrollPane((Component)this.tree);
        scrollPane.setBorder((Border)JBUI.Borders.empty());
        centerPanel2.add((Component)scrollPane, "Center");
        return centerPanel2;
    }

    private final void setUpSchemaTree(Tree tree2) {
        tree2.setCellRenderer((TreeCellRenderer)((Object)new SchemaTreeCellRenderer()));
        tree2.setRootVisible(false);
        tree2.setModel((TreeModel)new DefaultTreeModel(null));
        tree2.setToggleClickCount(0);
        tree2.getEmptyText().setText(DatabaseInspectorBundle.INSTANCE.message("nothing.to.show", new String[0]));
        tree2.getEmptyText().setShowAboveCenter(false);
        tree2.setName("left-panel-tree");
        this.setUpExportPopUp(tree2);
        this.setUpSchemaTreeListeners(tree2);
    }

    private final void setUpExportPopUp(Tree tree2) {
        AnAction[] anActionArray = DatabaseInspectorBundle.INSTANCE.message("action.export.button.tooltip.title", new String[0]);
        AnAction exportAction2 = new AnAction(this, (String)anActionArray){
            final /* synthetic */ LeftPanelView this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                ExportDialogParams exportDialogParams = LeftPanelView.access$createExportDialogParams(this.this$0, AppInspectionEvent.DatabaseInspectorEvent.ExportDialogOpenedEvent.Origin.SCHEMA_TREE_CONTEXT_MENU);
                if (exportDialogParams == null) {
                    return;
                }
                ExportDialogParams exportParams = exportDialogParams;
                Iterable $this$forEach$iv = LeftPanelView.access$getMainView$p(this.this$0).getListeners();
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    DatabaseInspectorView.Listener it = (DatabaseInspectorView.Listener)element$iv;
                    boolean bl = false;
                    it.showExportToFileDialogInvoked(exportParams);
                }
            }

            public void update(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                e.getPresentation().setEnabled(LeftPanelView.access$createExportDialogParams(this.this$0, AppInspectionEvent.DatabaseInspectorEvent.ExportDialogOpenedEvent.Origin.SCHEMA_TREE_CONTEXT_MENU) != null);
                super.update(e);
            }
        };
        anActionArray = new AnAction[]{exportAction2};
        PopupHandler.installFollowingSelectionTreePopup((JTree)((JTree)tree2), (ActionGroup)((ActionGroup)new DefaultActionGroup(anActionArray)), (String)"unknown");
    }

    private final void setUpSchemaTreeListeners(Tree tree2) {
        KeyAdapter treeKeyAdapter2 = new KeyAdapter(this, tree2){
            final /* synthetic */ LeftPanelView this$0;
            final /* synthetic */ Tree $tree;
            {
                this.this$0 = $receiver;
                this.$tree = $tree;
            }

            public void keyPressed(@NotNull KeyEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (event.getKeyCode() == 10) {
                    LeftPanelView.access$fireAction(this.this$0, this.$tree, event);
                }
            }
        };
        DoubleClickListener treeDoubleClickListener2 = new DoubleClickListener(this, tree2){
            final /* synthetic */ LeftPanelView this$0;
            final /* synthetic */ Tree $tree;
            {
                this.this$0 = $receiver;
                this.$tree = $tree;
            }

            protected boolean onDoubleClick(@NotNull MouseEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                LeftPanelView.access$fireAction(this.this$0, this.$tree, event);
                return true;
            }
        };
        tree2.addKeyListener((KeyListener)treeKeyAdapter2);
        treeDoubleClickListener2.installOn((Component)tree2);
    }

    private final void fireAction(Tree tree2, InputEvent e) {
        DefaultMutableTreeNode defaultMutableTreeNode = this.getSelectedNode(tree2);
        if (defaultMutableTreeNode == null) {
            return;
        }
        DefaultMutableTreeNode selectedNode = defaultMutableTreeNode;
        Object sqliteTable = selectedNode.getUserObject();
        if (sqliteTable instanceof SqliteTable) {
            TreeNode treeNode = selectedNode.getParent();
            Intrinsics.checkNotNull((Object)treeNode, (String)"null cannot be cast to non-null type javax.swing.tree.DefaultMutableTreeNode");
            DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)treeNode;
            Object object = parentNode.getUserObject();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.android.tools.idea.sqlite.ui.mainView.ViewDatabase");
            ViewDatabase viewDatabase = (ViewDatabase)object;
            Iterable $this$forEach$iv = this.mainView.getListeners();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                DatabaseInspectorView.Listener l = (DatabaseInspectorView.Listener)element$iv;
                boolean bl = false;
                l.tableNodeActionInvoked(viewDatabase.getDatabaseId(), (SqliteTable)sqliteTable);
            }
            e.consume();
        } else {
            TreePath path2 = new TreePath(selectedNode.getPath());
            if (tree2.isExpanded(path2)) {
                tree2.collapsePath(path2);
            } else {
                tree2.expandPath(path2);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void addNewTableNode(DefaultTreeModel treeModel, DefaultMutableTreeNode databaseNode, IndexedSqliteTable sqliteTableToAdd, List<IndexedSqliteColumn> sqliteColumnsToAdd) {
        void $this$forEach$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        SqliteTable sqliteTable = sqliteTableToAdd.component1();
        int index2 = sqliteTableToAdd.component2();
        DefaultMutableTreeNode newTableNode = new DefaultMutableTreeNode(sqliteTable);
        Iterable $this$sortedBy$iv = sqliteColumnsToAdd;
        boolean $i$f$sortedBy = false;
        $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                IndexedSqliteColumn it = (IndexedSqliteColumn)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getIndex());
                it = (IndexedSqliteColumn)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getIndex()));
            }
        });
        boolean $i$f$map = false;
        Iterator iterator2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IndexedSqliteColumn indexedSqliteColumn = (IndexedSqliteColumn)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(it.getSqliteColumn());
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SqliteColumn column2 = (SqliteColumn)element$iv;
            boolean bl = false;
            newTableNode.add(new DefaultMutableTreeNode(column2));
        }
        treeModel.insertNodeInto(newTableNode, databaseNode, index2);
    }

    private final void addColumnsToTableNode(DefaultTreeModel treeModel, DefaultMutableTreeNode tableNode, List<IndexedSqliteColumn> columnsToAdd) {
        Iterable $this$forEach$iv = columnsToAdd;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IndexedSqliteColumn indexedSqliteColumn = (IndexedSqliteColumn)element$iv;
            boolean bl = false;
            SqliteColumn sqliteColumn = indexedSqliteColumn.component1();
            int index2 = indexedSqliteColumn.component2();
            DefaultMutableTreeNode newColumnNode = new DefaultMutableTreeNode(sqliteColumn);
            treeModel.insertNodeInto(newColumnNode, tableNode, index2);
        }
    }

    private final DefaultMutableTreeNode findDatabaseNode(ViewDatabase viewDatabase) {
        Object element$iv2;
        block1: {
            Object object = this.tree.getModel().getRoot();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type javax.swing.tree.DefaultMutableTreeNode");
            DefaultMutableTreeNode root = (DefaultMutableTreeNode)object;
            Enumeration<TreeNode> enumeration = root.children();
            Intrinsics.checkNotNullExpressionValue(enumeration, (String)"root.children()");
            Sequence $this$first$iv = SequencesKt.map((Sequence)SequencesKt.asSequence((Iterator)CollectionsKt.iterator(enumeration)), (Function1)findDatabaseNode.1.INSTANCE);
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                DefaultMutableTreeNode it = (DefaultMutableTreeNode)element$iv2;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getUserObject(), (Object)viewDatabase)) continue;
                break block1;
            }
            throw new NoSuchElementException("Sequence contains no element matching the predicate.");
        }
        return (DefaultMutableTreeNode)element$iv2;
    }

    private final DefaultMutableTreeNode findTableNode(DefaultMutableTreeNode databaseNode, String tableName) {
        Object v2;
        block1: {
            Enumeration<TreeNode> enumeration = databaseNode.children();
            Intrinsics.checkNotNullExpressionValue(enumeration, (String)"databaseNode.children()");
            Sequence $this$firstOrNull$iv = SequencesKt.filter((Sequence)SequencesKt.map((Sequence)SequencesKt.asSequence((Iterator)CollectionsKt.iterator(enumeration)), (Function1)findTableNode.1.INSTANCE), (Function1)findTableNode.2.INSTANCE);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                DefaultMutableTreeNode it = (DefaultMutableTreeNode)element$iv;
                boolean bl = false;
                Object object = it.getUserObject();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.android.tools.idea.sqlite.model.SqliteTable");
                if (!Intrinsics.areEqual((Object)((SqliteTable)object).getName(), (Object)tableName)) continue;
                v2 = element$iv;
                break block1;
            }
            v2 = null;
        }
        return v2;
    }

    private final DefaultMutableTreeNode findColumnNode(DefaultMutableTreeNode databaseNode, String columnName) {
        Object v2;
        block1: {
            Enumeration<TreeNode> enumeration = databaseNode.children();
            Intrinsics.checkNotNullExpressionValue(enumeration, (String)"databaseNode.children()");
            Sequence $this$firstOrNull$iv = SequencesKt.filter((Sequence)SequencesKt.map((Sequence)SequencesKt.asSequence((Iterator)CollectionsKt.iterator(enumeration)), (Function1)findColumnNode.1.INSTANCE), (Function1)findColumnNode.2.INSTANCE);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                DefaultMutableTreeNode it = (DefaultMutableTreeNode)element$iv;
                boolean bl = false;
                Object object = it.getUserObject();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.android.tools.idea.sqlite.model.SqliteColumn");
                if (!Intrinsics.areEqual((Object)((SqliteColumn)object).getName(), (Object)columnName)) continue;
                v2 = element$iv;
                break block1;
            }
            v2 = null;
        }
        return v2;
    }

    private final boolean hasLiveDatabases() {
        Object object = this.tree.getModel().getRoot();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type javax.swing.tree.DefaultMutableTreeNode");
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)object;
        Enumeration<TreeNode> enumeration = root.children();
        Intrinsics.checkNotNullExpressionValue(enumeration, (String)"root.children()");
        return !((Collection)SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)SequencesKt.asSequence((Iterator)CollectionsKt.iterator(enumeration)), (Function1)hasLiveDatabases.1.INSTANCE), (Function1)hasLiveDatabases.2.INSTANCE))).isEmpty();
    }

    public final void setRefreshButtonState(boolean state2) {
        this.refreshSchemaButton.setEnabled(state2);
    }

    public static final /* synthetic */ DatabaseInspectorViewImpl access$getMainView$p(LeftPanelView $this) {
        return $this.mainView;
    }

    public static final /* synthetic */ ExportDialogParams access$createExportDialogParams(LeftPanelView $this, AppInspectionEvent.DatabaseInspectorEvent.ExportDialogOpenedEvent.Origin actionOrigin) {
        return $this.createExportDialogParams(actionOrigin);
    }

    public static final /* synthetic */ void access$updateExportButtonEnabledState(LeftPanelView $this) {
        $this.updateExportButtonEnabledState();
    }

    public static final /* synthetic */ void access$fireAction(LeftPanelView $this, Tree tree2, InputEvent e) {
        $this.fireAction(tree2, e);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002JB\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/idea/sqlite/ui/mainView/LeftPanelView$SchemaTreeCellRenderer;", "Lcom/intellij/ui/ColoredTreeCellRenderer;", "()V", "colorTextAttributes", "Lcom/intellij/ui/SimpleTextAttributes;", "customizeCellRenderer", "", "tree", "Ljavax/swing/JTree;", "value", "", "selected", "", "expanded", "leaf", "row", "", "hasFocus", "app-inspection.inspectors.database"})
    private static final class SchemaTreeCellRenderer
    extends ColoredTreeCellRenderer {
        @NotNull
        private final SimpleTextAttributes colorTextAttributes = new SimpleTextAttributes(0, (Color)JBColor.gray);

        public void customizeCellRenderer(@NotNull JTree tree2, @Nullable Object value2, boolean selected, boolean expanded, boolean leaf, int row2, boolean hasFocus) {
            Intrinsics.checkNotNullParameter((Object)tree2, (String)"tree");
            this.setToolTipText(null);
            if (value2 instanceof DefaultMutableTreeNode) {
                Object userObject = ((DefaultMutableTreeNode)value2).getUserObject();
                if (userObject instanceof ViewDatabase) {
                    this.append(((ViewDatabase)userObject).getDatabaseId().getName());
                    if (((ViewDatabase)userObject).isOpen()) {
                        this.setIcon(((ViewDatabase)userObject).getDatabaseId() instanceof SqliteDatabaseId.LiveSqliteDatabaseId ? StudioIcons.DatabaseInspector.DATABASE : StudioIcons.DatabaseInspector.DATABASE_OFFLINE);
                    } else {
                        this.append(" (closed)", this.colorTextAttributes);
                        this.setIcon(StudioIcons.DatabaseInspector.DATABASE_UNAVAILABLE);
                    }
                    this.setToolTipText(((ViewDatabase)userObject).getDatabaseId().getPath());
                } else if (userObject instanceof SqliteTable) {
                    this.setIcon(((SqliteTable)userObject).isView() ? StudioIcons.DatabaseInspector.VIEW : StudioIcons.DatabaseInspector.TABLE);
                    this.append(((SqliteTable)userObject).getName());
                } else if (userObject instanceof SqliteColumn) {
                    if (((SqliteColumn)userObject).getInPrimaryKey()) {
                        this.setIcon(StudioIcons.DatabaseInspector.PRIMARY_KEY);
                    } else {
                        this.setIcon(StudioIcons.DatabaseInspector.COLUMN);
                    }
                    this.append(((SqliteColumn)userObject).getName());
                    this.append("  :  ", this.colorTextAttributes);
                    String string = ((SqliteColumn)userObject).getAffinity().name();
                    Locale locale = Locale.US;
                    Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
                    String string2 = string.toUpperCase(locale);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toUpperCase(locale)");
                    this.append(string2, this.colorTextAttributes);
                    this.append(((SqliteColumn)userObject).isNullable() ? "" : ", NOT NULL", this.colorTextAttributes);
                } else if (userObject instanceof String) {
                    this.append((String)userObject);
                }
            }
            if (hasFocus && this.getIcon() != null) {
                Icon icon2 = this.getIcon();
                Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"icon");
                this.setIcon(ColoredIconGenerator.generateWhiteIcon((Icon)icon2));
            }
        }
    }
}

