/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sqlite.fileType;

import com.android.tools.idea.sqlite.DatabaseInspectorFlagController;
import com.android.tools.idea.sqlite.fileType.SqliteFileType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.util.io.ByteSequence;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/idea/sqlite/fileType/SqliteFileTypeDetector;", "Lcom/intellij/openapi/fileTypes/FileTypeRegistry$FileTypeDetector;", "()V", "SQLITE3_FORMAT_HEADER", "", "detect", "Lcom/intellij/openapi/fileTypes/FileType;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "firstBytes", "Lcom/intellij/openapi/util/io/ByteSequence;", "firstCharsIfText", "", "getVersion", "", "app-inspection.inspectors.database"})
public final class SqliteFileTypeDetector
implements FileTypeRegistry.FileTypeDetector {
    @NotNull
    private final byte[] SQLITE3_FORMAT_HEADER;

    public SqliteFileTypeDetector() {
        byte[] byArray = "SQLite format 3\u0000".getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        this.SQLITE3_FORMAT_HEADER = byArray;
    }

    @Nullable
    public FileType detect(@NotNull VirtualFile file2, @NotNull ByteSequence firstBytes, @Nullable CharSequence firstCharsIfText) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)firstBytes, (String)"firstBytes");
        return DatabaseInspectorFlagController.INSTANCE.isOpenFileEnabled() == false ? null : (firstBytes.length() < this.SQLITE3_FORMAT_HEADER.length ? null : (Arrays.equals(firstBytes.subSequence(0, this.SQLITE3_FORMAT_HEADER.length).toBytes(), this.SQLITE3_FORMAT_HEADER) ? (FileType)SqliteFileType.INSTANCE : null));
    }

    public int getVersion() {
        return 1;
    }
}

