/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.serverflags;

import com.android.tools.idea.serverflags.ServerFlagDownloader;
import com.android.tools.idea.serverflags.ServerFlagUtilitiesKt;
import com.google.common.io.ByteStreams;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Service
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00032\u00020\u0001:\u0002\u0003\u0004B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0005"}, d2={"Lcom/android/tools/idea/serverflags/ServerFlagDownloader;", "", "()V", "Companion", "Initializer", "intellij.android.core"})
public final class ServerFlagDownloader {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public ServerFlagDownloader() {
        ApplicationManager.getApplication().executeOnPooledThread((Runnable)1.INSTANCE);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0006\u0010\t\u001a\u00020\nJ.\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\f2\u000e\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0011J\u0006\u0010\u0012\u001a\u00020\u0013J\u0018\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0006H\u0002\u00a8\u0006\u0016"}, d2={"Lcom/android/tools/idea/serverflags/ServerFlagDownloader$Companion;", "", "()V", "downloadFile", "", "tempFile", "Ljava/io/File;", "url", "Ljava/net/URL;", "downloadServerFlagList", "", "baseUrl", "", "localCacheDirectory", "Ljava/nio/file/Path;", "version", "tempFileCreator", "Lkotlin/Function0;", "getInstance", "Lcom/android/tools/idea/serverflags/ServerFlagDownloader;", "saveFile", "localFilePath", "intellij.android.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ServerFlagDownloader getInstance() {
            Object object = ApplicationManager.getApplication().getService(ServerFlagDownloader.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getApplication().getServ\u2026agDownloader::class.java)");
            return (ServerFlagDownloader)object;
        }

        public final void downloadServerFlagList() {
            String baseUrl = System.getProperty("studio.server.flags.baseurl.override", "https://dl.google.com/android/studio/server_flags/release");
            Intrinsics.checkNotNullExpressionValue((Object)baseUrl, (String)"baseUrl");
            this.downloadServerFlagList(baseUrl, ServerFlagUtilitiesKt.getLocalCacheDirectory(), ServerFlagUtilitiesKt.getFlagsVersion(), (Function0<? extends File>)((Function0)downloadServerFlagList.1.INSTANCE));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void downloadServerFlagList(@NotNull String baseUrl, @NotNull Path localCacheDirectory, @NotNull String version2, @NotNull Function0<? extends File> tempFileCreator) {
            Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
            Intrinsics.checkNotNullParameter((Object)localCacheDirectory, (String)"localCacheDirectory");
            Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
            Intrinsics.checkNotNullParameter(tempFileCreator, (String)"tempFileCreator");
            URL uRL = ServerFlagUtilitiesKt.buildUrl(baseUrl, version2);
            if (uRL == null) {
                return;
            }
            URL url = uRL;
            File file2 = (File)tempFileCreator.invoke();
            if (file2 == null) {
                return;
            }
            File tempFile = file2;
            try {
                if (!this.downloadFile(tempFile, url)) {
                    return;
                }
                if (ServerFlagUtilitiesKt.unmarshalFlagList(tempFile) == null) {
                    return;
                }
                Path localFilePath = ServerFlagUtilitiesKt.buildLocalFilePath(localCacheDirectory, version2);
                File file3 = localFilePath.toFile();
                Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"localFilePath.toFile()");
                this.saveFile(tempFile, file3);
            }
            finally {
                tempFile.delete();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final boolean downloadFile(File tempFile, URL url) {
            boolean bl;
            try {
                Closeable closeable = url.openStream();
                Throwable throwable = null;
                try {
                    long l;
                    InputStream inputStream = (InputStream)closeable;
                    boolean bl2 = false;
                    Closeable closeable2 = new FileOutputStream(tempFile);
                    Throwable throwable2 = null;
                    try {
                        FileOutputStream outputStream = (FileOutputStream)closeable2;
                        boolean bl3 = false;
                        l = ByteStreams.copy((InputStream)inputStream, (OutputStream)outputStream);
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                    }
                    long l2 = l;
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                bl = true;
            }
            catch (IOException e) {
                bl = false;
            }
            return bl;
        }

        private final void saveFile(File tempFile, File localFilePath) {
            try {
                FilesKt.copyTo$default((File)tempFile, (File)localFilePath, (boolean)true, (int)0, (int)4, null);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/idea/serverflags/ServerFlagDownloader$Initializer;", "Lcom/intellij/openapi/startup/StartupActivity$Background;", "()V", "runActivity", "", "project", "Lcom/intellij/openapi/project/Project;", "intellij.android.core"})
    private static final class Initializer
    implements StartupActivity.Background {
        public void runActivity(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Companion.getInstance();
        }
    }
}

