/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk.install.patch;

import com.android.io.CancellableFileIo;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.tools.idea.sdk.install.patch.PatchInstaller;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.util.lang.UrlClassLoader;
import java.awt.Component;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PatchRunner {
    private static final String PATCHER_JAR_FN = "patcher.jar";
    private static final String RUNNER_CLASS_NAME = "com.intellij.updater.Runner";
    private static final String UPDATER_UI_CLASS_NAME = "com.intellij.updater.UpdaterUI";
    private static final String REPO_UI_CLASS_NAME = "com.android.tools.idea.sdk.updater.RepoUpdaterUI";
    private static final String PATCH_GENERATOR_CLASS_NAME = "com.android.tools.idea.sdk.updater.PatchGenerator";
    private final Class<?> myRunnerClass;
    private final Class<?> myUiBaseClass;
    private final Class<?> myUiClass;
    private final Class<?> myGeneratorClass;
    private final Path myPatcherJar;
    private static final Map<LocalPackage, PatchRunner> ourCache = new WeakHashMap<LocalPackage, PatchRunner>();

    public boolean run(@NotNull Path destination, @NotNull Path patchFile, @NotNull ProgressIndicator progress2) throws RestartRequiredException {
        Method doInstall;
        Object ui;
        try {
            ui = this.myUiClass.getDeclaredConstructor(Component.class, ProgressIndicator.class).newInstance(null, progress2);
        }
        catch (ReflectiveOperationException e) {
            progress2.logWarning("Failed to create updater UI!", (Throwable)e);
            return false;
        }
        try {
            Method initLogger = this.myRunnerClass.getMethod("initLogger", new Class[0]);
            initLogger.invoke(null, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            progress2.logWarning("Failed to initialize logger!", (Throwable)e);
            return false;
        }
        try {
            doInstall = this.myRunnerClass.getMethod("doInstall", String.class, this.myUiBaseClass, String.class);
        }
        catch (Throwable e) {
            progress2.logWarning("Failed to find main method in runner!", e);
            return false;
        }
        try {
            progress2.logInfo("Running patcher...");
            if (!((Boolean)doInstall.invoke(null, patchFile.toString(), ui, destination.toString())).booleanValue()) {
                progress2.logWarning("Failed to apply patch");
                return false;
            }
            progress2.logInfo("Patch applied.");
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof RestartRequiredException) {
                throw (RestartRequiredException)e.getTargetException();
            }
            progress2.logWarning("Failed to run patcher", (Throwable)e);
            return false;
        }
        catch (Throwable e) {
            progress2.logWarning("Failed to run patcher", e);
            return false;
        }
        return true;
    }

    public boolean generatePatch(@Nullable File existingRoot, @NotNull File newRoot, @Nullable String existingDescription, @NotNull String newDescription, @NotNull File destination, @NotNull ProgressIndicator progress2) {
        try {
            Method generateMethod = this.myGeneratorClass.getMethod("generateFullPackage", File.class, File.class, File.class, String.class, String.class, ProgressIndicator.class);
            return (Boolean)generateMethod.invoke(null, newRoot, existingRoot, destination, existingDescription, newDescription, progress2);
        }
        catch (NoSuchMethodException e) {
            progress2.logWarning("Patcher doesn't support full package generation!");
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable reason = e.getTargetException();
            progress2.logWarning("Patch invocation failed! ", reason);
            return false;
        }
        catch (IllegalAccessException e) {
            progress2.logWarning("Patch generation failed!");
            return false;
        }
    }

    @Nullable
    private static Path getPatcherFile(@Nullable LocalPackage patcherPackage) {
        Path patcherFile = patcherPackage == null ? null : patcherPackage.getLocation().resolve(PATCHER_JAR_FN);
        return patcherFile != null && CancellableFileIo.exists((Path)patcherFile, (LinkOption[])new LinkOption[0]) ? patcherFile : null;
    }

    @VisibleForTesting
    PatchRunner(@NotNull Path jarFile, @NotNull Class<?> runnerClass, @NotNull Class<?> uiBaseClass, @NotNull Class<?> uiClass, @NotNull Class<?> generatorClass) {
        this.myPatcherJar = jarFile;
        this.myRunnerClass = runnerClass;
        this.myUiBaseClass = uiBaseClass;
        this.myUiClass = uiClass;
        this.myGeneratorClass = generatorClass;
    }

    @NotNull
    private static ClassLoader getClassLoader(@NotNull Path patcherJar) {
        return UrlClassLoader.build().files(Collections.singletonList(patcherJar)).parent(PatchInstaller.class.getClassLoader()).get();
    }

    @NotNull
    public Path getPatcherJar() {
        return this.myPatcherJar;
    }

    public static class DefaultFactory
    implements Factory {
        @Override
        @Nullable
        public PatchRunner getPatchRunner(@NotNull LocalPackage runnerPackage, @NotNull ProgressIndicator progress2) {
            PatchRunner result2 = ourCache.get(runnerPackage);
            if (result2 != null) {
                return result2;
            }
            try {
                Path patcherFile = PatchRunner.getPatcherFile(runnerPackage);
                if (patcherFile == null) {
                    progress2.logWarning("Failed to find patcher JAR!");
                    return null;
                }
                ClassLoader loader = PatchRunner.getClassLoader(patcherFile);
                Class<?> runnerClass = Class.forName(PatchRunner.RUNNER_CLASS_NAME, true, loader);
                Class<?> uiBaseClass = Class.forName(PatchRunner.UPDATER_UI_CLASS_NAME, true, loader);
                Class<?> uiClass = Class.forName(PatchRunner.REPO_UI_CLASS_NAME, true, loader);
                Class<?> generatorClass = Class.forName(PatchRunner.PATCH_GENERATOR_CLASS_NAME, true, loader);
                result2 = new PatchRunner(patcherFile, runnerClass, uiBaseClass, uiClass, generatorClass);
                ourCache.put(runnerPackage, result2);
                return result2;
            }
            catch (ClassNotFoundException e) {
                progress2.logWarning("Failed to load patcher classes!");
                return null;
            }
        }
    }

    public static interface Factory {
        @Nullable
        public PatchRunner getPatchRunner(@NotNull LocalPackage var1, @NotNull ProgressIndicator var2);
    }

    public static class RestartRequiredException
    extends RuntimeException {
    }
}

