/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk.install.patch;

import com.android.io.CancellableFileIo;
import com.android.repository.api.Downloader;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RemotePackage;
import com.android.repository.api.RepoManager;
import com.android.repository.impl.installer.AbstractInstaller;
import com.android.repository.impl.meta.Archive;
import com.android.repository.util.InstallerUtil;
import com.android.tools.idea.sdk.install.patch.PatchInstallerUtil;
import com.android.tools.idea.sdk.install.patch.PatchOperation;
import com.android.utils.PathUtils;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class FullInstaller
extends AbstractInstaller
implements PatchOperation {
    private static final String UNZIP_DIR_FN = "unzip";
    private final LocalPackage myExisting;
    private LocalPackage myPatcher;
    private Path myUnzippedPackage;
    private Path myGeneratedPatch;

    public FullInstaller(@Nullable LocalPackage existing2, @NotNull RemotePackage p, @NotNull RepoManager mgr, @NotNull Downloader downloader) {
        super(p, mgr, downloader);
        this.myExisting = existing2;
        this.myPatcher = PatchInstallerUtil.getDependantPatcher(this.getPackage(), this.getRepoManager());
        if (this.myPatcher == null) {
            this.myPatcher = PatchInstallerUtil.getLatestPatcher(this.getRepoManager());
        }
    }

    protected boolean doComplete(@Nullable Path installTemp, @NotNull ProgressIndicator progress2) {
        if (this.myPatcher == null) {
            return false;
        }
        return PatchInstallerUtil.installPatch(this, this.myGeneratedPatch, progress2);
    }

    protected boolean doPrepare(@NotNull Path installTempPath, @NotNull ProgressIndicator progress2) {
        if (!this.downloadAndUnzip(installTempPath, this.getDownloader(), progress2.createSubProgress(0.5))) {
            progress2.setFraction(1.0);
            return false;
        }
        this.myUnzippedPackage = installTempPath.resolve(UNZIP_DIR_FN);
        try (Stream childrenStream = CancellableFileIo.list((Path)this.myUnzippedPackage);){
            List children = childrenStream.limit(2L).collect(Collectors.toList());
            if (children.size() == 1) {
                this.myUnzippedPackage = (Path)children.get(0);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.myGeneratedPatch = PatchInstallerUtil.generatePatch(this, installTempPath, progress2.createSubProgress(1.0));
        progress2.setFraction(1.0);
        return this.myGeneratedPatch != null;
    }

    private boolean downloadAndUnzip(@NotNull Path installTempPath, @NotNull Downloader downloader, @NotNull ProgressIndicator progress2) {
        URL url = InstallerUtil.resolveCompleteArchiveUrl((RemotePackage)this.getPackage(), (ProgressIndicator)progress2);
        if (url == null) {
            progress2.logWarning("No compatible archive found!");
            return false;
        }
        Archive archive = this.getPackage().getArchive();
        assert (archive != null);
        try {
            Path downloadLocation = installTempPath.resolve(url.getFile());
            downloader.downloadFullyWithCaching(url, downloadLocation, archive.getComplete().getTypedChecksum(), progress2.createSubProgress(0.5));
            progress2.setFraction(0.5);
            if (progress2.isCanceled()) {
                progress2.setFraction(1.0);
                return false;
            }
            if (!CancellableFileIo.exists((Path)downloadLocation, (LinkOption[])new LinkOption[0])) {
                progress2.setFraction(1.0);
                progress2.logWarning("Failed to download package!");
                return false;
            }
            Path unzip = installTempPath.resolve(UNZIP_DIR_FN);
            Files.createDirectories(unzip, new FileAttribute[0]);
            InstallerUtil.unzip((Path)downloadLocation, (Path)unzip, (long)archive.getComplete().getSize(), (ProgressIndicator)progress2.createSubProgress(1.0));
            progress2.setFraction(1.0);
            if (progress2.isCanceled()) {
                return false;
            }
            try {
                PathUtils.deleteRecursivelyIfExists((Path)downloadLocation);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return true;
        }
        catch (IOException e) {
            StringBuilder message2 = new StringBuilder("An error occurred while preparing SDK package ").append(this.getPackage().getDisplayName());
            String exceptionMessage = e.getMessage();
            if (exceptionMessage != null && !exceptionMessage.isEmpty()) {
                message2.append(": ").append(exceptionMessage);
            } else {
                message2.append(".");
            }
            progress2.logWarning(message2.toString(), (Throwable)e);
            progress2.setFraction(1.0);
            return false;
        }
    }

    @Override
    @Nullable
    public LocalPackage getExisting() {
        return this.myExisting;
    }

    @Override
    @NotNull
    public LocalPackage getPatcher(@NotNull ProgressIndicator progressIndicator) {
        return this.myPatcher;
    }

    @Override
    @NotNull
    public Path getNewFilesRoot() {
        return this.myUnzippedPackage;
    }

    @Override
    @NotNull
    public String getNewVersionName() {
        return this.getPackage().getDisplayName() + " Version " + this.getPackage().getVersion();
    }

    protected void cleanup(@NotNull ProgressIndicator progress2) {
        super.cleanup(progress2);
        try {
            PathUtils.deleteRecursivelyIfExists((Path)this.getLocation(progress2));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.myUnzippedPackage != null) {
            try {
                PathUtils.deleteRecursivelyIfExists((Path)this.myUnzippedPackage);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

