/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk;

import com.android.io.CancellableFileIo;
import com.android.tools.adtui.validation.Validator;
import com.android.tools.idea.ui.validation.validators.PathValidator;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SdkPaths {
    private SdkPaths() {
    }

    @NotNull
    public static ValidationResult validateAndroidSdk(@Nullable Path sdkPath, boolean includePathInMessage) {
        return SdkPaths.validatedSdkPath(sdkPath, "SDK", false, includePathInMessage);
    }

    @Deprecated
    @NotNull
    public static ValidationResult validateAndroidSdk(@Nullable File sdkFile, boolean includePathInMessage) {
        return SdkPaths.validateAndroidSdk(sdkFile == null ? null : sdkFile.toPath(), includePathInMessage);
    }

    @Deprecated
    @NotNull
    public static ValidationResult validateAndroidNdk(@Nullable File ndkPath, boolean includePathInMessage) {
        return SdkPaths.validateAndroidNdk(ndkPath == null ? null : ndkPath.toPath(), includePathInMessage);
    }

    @NotNull
    public static ValidationResult validateAndroidNdk(@Nullable Path ndkPath, boolean includePathInMessage) {
        Path toolchainsDirPath;
        Validator.Result result2;
        Validator.Severity severity;
        if (ndkPath != null && (severity = (result2 = PathValidator.forAndroidNdkLocation().validate(ndkPath)).getSeverity()) == Validator.Severity.ERROR) {
            return ValidationResult.error(result2.getMessage());
        }
        ValidationResult validationResult = SdkPaths.validatedSdkPath(ndkPath, "NDK", false, includePathInMessage);
        if (validationResult.success && ndkPath != null && !CancellableFileIo.isDirectory((Path)(toolchainsDirPath = ndkPath.resolve("toolchains")), (LinkOption[])new LinkOption[0])) {
            String message2 = includePathInMessage ? String.format("The NDK at\n'%1$s'\ndoes not contain any toolchains.", ndkPath) : "NDK does not contain any toolchains.";
            return ValidationResult.error(message2);
        }
        return validationResult;
    }

    @NotNull
    private static ValidationResult validatedSdkPath(@Nullable Path sdkPath, @NotNull String sdkName, boolean checkForWritable, boolean includePathInMessage) {
        if (sdkPath == null) {
            return ValidationResult.error("");
        }
        String cause = null;
        if (!CancellableFileIo.isDirectory((Path)sdkPath, (LinkOption[])new LinkOption[0])) {
            cause = "does not belong to a directory.";
        } else if (!CancellableFileIo.isReadable((Path)sdkPath)) {
            cause = "is not readable.";
        } else if (checkForWritable && !CancellableFileIo.isWritable((Path)sdkPath)) {
            cause = "is not writable.";
        }
        if (StringUtil.isNotEmpty((String)cause)) {
            String message2 = includePathInMessage ? String.format("The %1$s path\n'%2$s'\n%3$s", sdkName, sdkPath, cause) : String.format("The %1$s path %2$s", sdkName, cause);
            return ValidationResult.error(message2);
        }
        Path platformsDirPath = sdkPath.resolve("platforms");
        if (!CancellableFileIo.isDirectory((Path)platformsDirPath, (LinkOption[])new LinkOption[0])) {
            String message3 = includePathInMessage ? String.format("The %1$s at\n'%2$s'\ndoes not contain any platforms.", sdkName, sdkPath) : String.format("%1$s does not contain any platforms.", sdkName);
            return ValidationResult.error(message3);
        }
        return ValidationResult.SUCCESS;
    }

    public static class ValidationResult {
        @NotNull
        public static final ValidationResult SUCCESS = new ValidationResult(true, null);
        public final boolean success;
        @Nullable
        public final String message;

        @NotNull
        static ValidationResult error(@NotNull String message2) {
            return new ValidationResult(false, message2);
        }

        private ValidationResult(boolean success2, @Nullable String message2) {
            this.success = success2;
            this.message = message2;
        }
    }
}

