/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk;

import com.android.repository.Revision;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.util.EmbeddedDistributionPaths;
import com.android.tools.idea.io.FilePaths;
import com.android.tools.idea.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.sdk.AndroidSdkPathStore;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.Jdks;
import com.android.tools.idea.sdk.SdkPaths;
import com.android.tools.idea.sdk.extensions.SdkExtensions;
import com.android.utils.FileUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ex.ProjectEx;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.impl.ProjectJdkImpl;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.serviceContainer.NonInjectable;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.SystemProperties;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.sdk.AndroidSdkAdditionalData;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class IdeSdks {
    private static final JavaSdkVersion MIN_JDK_VERSION = JavaSdkVersion.JDK_1_8;
    private static final JavaSdkVersion MAX_JDK_VERSION;
    @NonNls
    public static final String MAC_JDK_CONTENT_PATH = "Contents/Home";
    @NotNull
    public static final JavaSdkVersion DEFAULT_JDK_VERSION;
    @NotNull
    public static final String JDK_LOCATION_ENV_VARIABLE_NAME = "STUDIO_GRADLE_JDK";
    @NotNull
    public static final String ANDROID_STUDIO_DEFAULT_JDK_NAME = "Android Studio default JDK";
    @NotNull
    private static final Logger LOG;
    @NotNull
    private final AndroidSdks myAndroidSdks;
    @NotNull
    private final Jdks myJdks;
    @NotNull
    private final EmbeddedDistributionPaths myEmbeddedDistributionPaths;
    @NotNull
    private final IdeInfo myIdeInfo;
    @NotNull
    private final Map<String, LocalPackage> localPackagesByPrefix = new HashMap<String, LocalPackage>();
    private final EnvVariableSettings myEnvVariableSettings = new EnvVariableSettings();

    @NotNull
    public static IdeSdks getInstance() {
        return (IdeSdks)ApplicationManager.getApplication().getService(IdeSdks.class);
    }

    public IdeSdks() {
        this(AndroidSdks.getInstance(), Jdks.getInstance(), EmbeddedDistributionPaths.getInstance(), IdeInfo.getInstance());
    }

    @NonInjectable
    @VisibleForTesting
    public IdeSdks(@NotNull AndroidSdks androidSdks, @NotNull Jdks jdks, @NotNull EmbeddedDistributionPaths embeddedDistributionPaths, @NotNull IdeInfo ideInfo) {
        this.myAndroidSdks = androidSdks;
        this.myJdks = jdks;
        this.myEmbeddedDistributionPaths = embeddedDistributionPaths;
        this.myIdeInfo = ideInfo;
    }

    @Nullable
    public File getAndroidSdkPath() {
        File candidate;
        Path sdkPath = AndroidSdkPathStore.getInstance().getAndroidSdkPath();
        if (sdkPath != null && this.isValidAndroidSdkPath(candidate = sdkPath.toFile())) {
            return candidate;
        }
        return null;
    }

    @Nullable
    public LocalPackage getSpecificLocalPackage(@NotNull String prefix) {
        if (this.localPackagesByPrefix.containsKey(prefix)) {
            return this.localPackagesByPrefix.get(prefix);
        }
        AndroidSdkHandler sdkHandler = this.myAndroidSdks.tryToChooseSdkHandler();
        LocalPackage result2 = sdkHandler.getLatestLocalPackageForPrefix(prefix, null, true, (ProgressIndicator)new StudioLoggerProgressIndicator(IdeSdks.class));
        if (result2 != null) {
            this.setSpecificLocalPackage(prefix, result2);
        }
        return result2;
    }

    @VisibleForTesting
    public void setSpecificLocalPackage(@NotNull String prefix, @NotNull LocalPackage localPackage) {
        this.localPackagesByPrefix.put(prefix, localPackage);
    }

    @Nullable
    public LocalPackage getHighestLocalNdkPackage(boolean allowPreview) {
        return this.getHighestLocalNdkPackage(allowPreview, null);
    }

    @Nullable
    public LocalPackage getHighestLocalNdkPackage(boolean allowPreview, @Nullable Predicate<Revision> filter2) {
        AndroidSdkHandler sdkHandler = this.myAndroidSdks.tryToChooseSdkHandler();
        LocalPackage ndk = sdkHandler.getLatestLocalPackageForPrefix("ndk", filter2, allowPreview, (ProgressIndicator)new StudioLoggerProgressIndicator(IdeSdks.class));
        if (ndk != null) {
            return ndk;
        }
        LocalPackage ndkPackage = sdkHandler.getLocalPackage("ndk-bundle", (ProgressIndicator)new StudioLoggerProgressIndicator(IdeSdks.class));
        if (filter2 != null && ndkPackage != null && filter2.test(ndkPackage.getVersion())) {
            return ndkPackage;
        }
        return null;
    }

    @Nullable
    public File getAndroidNdkPath() {
        return this.getAndroidNdkPath(null);
    }

    @Nullable
    public File getAndroidNdkPath(@Nullable Predicate<Revision> filter2) {
        LocalPackage ndk = this.getHighestLocalNdkPackage(false, filter2);
        if (ndk != null) {
            return ndk.getLocation().toFile();
        }
        return null;
    }

    @Nullable
    public Path getJdkPath() {
        return this.doGetJdkPath(true);
    }

    @Nullable
    private Path doGetJdkPath(boolean createJdkIfNeeded) {
        Sdk jdk = this.doGetJdk(createJdkIfNeeded);
        if (jdk != null && jdk.getHomePath() != null) {
            return Paths.get(jdk.getHomePath(), new String[0]);
        }
        return null;
    }

    public void cleanJdkEnvVariableInitialization() {
        this.myEnvVariableSettings.cleanInitialization();
    }

    public void overrideJdkEnvVariable(@Nullable String envVariableValue) {
        this.myEnvVariableSettings.overrideValue(envVariableValue);
    }

    public boolean isUsingEnvVariableJdk() {
        return this.myEnvVariableSettings.isUseJdkEnvVariable();
    }

    public boolean isJdkEnvVariableDefined() {
        return this.myEnvVariableSettings.isJdkEnvVariableDefined();
    }

    public boolean isJdkEnvVariableValid() {
        return this.myEnvVariableSettings.IsJdkEnvVariableValid();
    }

    @Nullable
    public File getEnvVariableJdkFile() {
        return this.myEnvVariableSettings.getJdkFile();
    }

    @Nullable
    public String getEnvVariableJdkValue() {
        return this.myEnvVariableSettings.getVariableValue();
    }

    public boolean setUseEnvVariableJdk(boolean useJdkEnvVariable) {
        return this.myEnvVariableSettings.setUseJdkEnvVariable(useJdkEnvVariable);
    }

    public Sdk setJdkPath(@NotNull Path path2) {
        if (JdkUtil.checkForJdk((Path)path2)) {
            ApplicationManager.getApplication().assertWriteAccessAllowed();
            Path canonicalPath = IdeSdks.resolvePath(path2);
            Sdk chosenJdk = null;
            ProjectJdkTable projectJdkTable = ProjectJdkTable.getInstance();
            for (Sdk jdk : projectJdkTable.getSdksOfType((SdkTypeId)JavaSdk.getInstance())) {
                if (!FileUtil.pathsEqual((String)jdk.getHomePath(), (String)canonicalPath.toString())) continue;
                chosenJdk = jdk;
                break;
            }
            if (chosenJdk == null) {
                if (Files.isDirectory(canonicalPath, new LinkOption[0])) {
                    chosenJdk = this.createJdk(canonicalPath);
                    if (chosenJdk == null) {
                        throw new IllegalStateException("Failed to create IDEA JDK from '" + path2 + "'");
                    }
                    this.setJdkOfAndroidSdks(chosenJdk);
                } else {
                    throw new IllegalStateException("The resolved path '" + canonicalPath + "' was not found");
                }
            }
            this.setUseEnvVariableJdk(false);
            return chosenJdk;
        }
        return null;
    }

    public void removeInvalidJdksFromTable() {
        ApplicationManager.getApplication().runWriteAction(() -> {
            ProjectJdkTable projectJdkTable = ProjectJdkTable.getInstance();
            List jdks = projectJdkTable.getSdksOfType((SdkTypeId)JavaSdk.getInstance());
            for (Sdk jdk : jdks) {
                String homePath = jdk.getHomePath();
                if (homePath != null && this.validateJdkPath(Paths.get(homePath, new String[0])) != null) continue;
                projectJdkTable.removeJdk(jdk);
            }
        });
    }

    private void setJdkOfAndroidSdks(@NotNull Sdk jdk) {
        for (Sdk sdk : this.myAndroidSdks.getAllAndroidSdks()) {
            AndroidSdkAdditionalData oldData = this.myAndroidSdks.getAndroidSdkAdditionalData(sdk);
            if (oldData == null) continue;
            oldData.setJavaSdk(jdk);
            SdkModificator modificator = sdk.getSdkModificator();
            modificator.setSdkAdditionalData((SdkAdditionalData)oldData);
            modificator.commitChanges();
        }
    }

    @NotNull
    public List<Sdk> setAndroidSdkPath(@NotNull File path2, @Nullable Project currentProject) {
        return this.setAndroidSdkPath(path2, null, currentProject);
    }

    @NotNull
    public List<Sdk> setAndroidSdkPath(@NotNull File path2, @Nullable Sdk javaSdk, @Nullable Project currentProject) {
        if (this.isValidAndroidSdkPath(path2)) {
            ApplicationManager.getApplication().assertWriteAccessAllowed();
            AndroidSdkPathStore.getInstance().setAndroidSdkPath(path2.toPath());
            this.updateSdkData(path2);
            ArrayList<Sdk> sdksToDelete = new ArrayList<Sdk>();
            Path resolved = IdeSdks.resolvePath(path2.toPath());
            AndroidSdkData sdkData = AndroidSdkData.getSdkData(resolved.toFile(), true);
            if (sdkData != null) {
                for (Sdk sdk : this.myAndroidSdks.getAllAndroidSdks()) {
                    if (!sdk.getName().startsWith("Android ")) continue;
                    sdksToDelete.add(sdk);
                }
            }
            for (Sdk sdk : sdksToDelete) {
                ProjectJdkTable.getInstance().removeJdk(sdk);
            }
            List<Sdk> sdks = this.createAndroidSdkPerAndroidTarget(resolved.toFile(), javaSdk);
            IdeSdks.afterAndroidSdkPathUpdate(resolved.toFile());
            return sdks;
        }
        return Collections.emptyList();
    }

    private void updateSdkData(@NotNull File path2) {
        AndroidSdkData oldSdkData = AndroidSdkData.getSdkData(path2);
        this.myAndroidSdks.setSdkData(oldSdkData);
    }

    private static void afterAndroidSdkPathUpdate(@NotNull File androidSdkPath) {
        Project[] openProjects = ProjectManager.getInstance().getOpenProjects();
        if (openProjects.length == 0) {
            return;
        }
        AndroidSdkEventListener[] eventListeners = (AndroidSdkEventListener[])AndroidSdkEventListener.EP_NAME.getExtensions();
        for (Project project : openProjects) {
            if (!ProjectSystemUtil.requiresAndroidModel(project)) continue;
            for (AndroidSdkEventListener listener2 : eventListeners) {
                listener2.afterSdkPathChange(androidSdkPath, project);
            }
        }
    }

    public boolean isValidAndroidSdkPath(@NotNull File path2) {
        return SdkPaths.validateAndroidSdk((File)path2, (boolean)false).success;
    }

    @NotNull
    public List<Sdk> createAndroidSdkPerAndroidTarget(@NotNull File androidSdkPath) {
        List<Sdk> sdks = this.createAndroidSdkPerAndroidTarget(androidSdkPath, null);
        IdeSdks.updateWelcomeRunAndroidSdkAction();
        return sdks;
    }

    public static void updateWelcomeRunAndroidSdkAction() {
        ActionManager actionManager = (ActionManager)ApplicationManager.getApplication().getServiceIfCreated(ActionManager.class);
        if (actionManager == null) {
            return;
        }
        AnAction sdkManagerAction = actionManager.getAction("WelcomeScreen.RunAndroidSdkManager");
        if (sdkManagerAction != null) {
            sdkManagerAction.update(AnActionEvent.createFromDataContext((String)"unknown", null, dataId -> null));
        }
    }

    @NotNull
    private List<Sdk> createAndroidSdkPerAndroidTarget(@NotNull File androidSdkPath, @Nullable Sdk javaSdk) {
        Sdk ideJdk;
        AndroidSdkData sdkData = AndroidSdkData.getSdkData(androidSdkPath);
        if (sdkData == null) {
            return Collections.emptyList();
        }
        IAndroidTarget[] targets = sdkData.getTargets(false);
        if (targets.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<Sdk> sdks = new ArrayList<Sdk>();
        Sdk sdk = ideJdk = javaSdk != null ? javaSdk : this.getJdk();
        if (ideJdk != null) {
            for (IAndroidTarget target2 : targets) {
                if (!target2.isPlatform() || this.doesIdeAndroidSdkExist(target2)) continue;
                String name = this.myAndroidSdks.chooseNameForNewLibrary(target2);
                Sdk sdk2 = this.myAndroidSdks.create(target2, sdkData.getLocationFile(), name, ideJdk, true);
                if (sdk2 == null) continue;
                sdks.add(sdk2);
            }
        }
        return sdks;
    }

    private boolean doesIdeAndroidSdkExist(@NotNull IAndroidTarget target2) {
        for (Sdk sdk : this.getEligibleAndroidSdks()) {
            IAndroidTarget platformTarget = IdeSdks.getTarget(sdk);
            AndroidVersion version2 = target2.getVersion();
            AndroidVersion existingVersion = platformTarget.getVersion();
            if (!existingVersion.equals((Object)version2)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private static IAndroidTarget getTarget(@NotNull Sdk sdk) {
        AndroidPlatform androidPlatform = AndroidPlatform.getInstance(sdk);
        assert (androidPlatform != null);
        return androidPlatform.getTarget();
    }

    @NotNull
    private static Path resolvePath(@NotNull Path path2) {
        try {
            String resolvedPath = FileUtil.resolveShortWindowsName((String)path2.toString());
            return Paths.get(resolvedPath, new String[0]);
        }
        catch (IOException iOException) {
            return path2;
        }
    }

    public boolean isUsingEmbeddedJdk() {
        if (!this.myIdeInfo.isAndroidStudio()) {
            return false;
        }
        Path jdkPath = this.doGetJdkPath(false);
        Path embeddedJdkPath = this.getEmbeddedJdkPath();
        return jdkPath != null && embeddedJdkPath != null && FileUtil.pathsEqual((String)jdkPath.toString(), (String)embeddedJdkPath.toString());
    }

    public void setUseEmbeddedJdk() {
        Preconditions.checkState((boolean)this.myIdeInfo.isAndroidStudio(), (Object)"This method is for use in Android Studio only.");
        Path embeddedJdkPath = this.getEmbeddedJdkPath();
        this.setJdkPath(embeddedJdkPath);
    }

    @Nullable
    public Path getEmbeddedJdkPath() {
        if (!this.myIdeInfo.isAndroidStudio()) {
            return null;
        }
        return this.myEmbeddedDistributionPaths.getEmbeddedJdkPath();
    }

    public boolean isUsingJavaHomeJdk() {
        return this.isUsingJavaHomeJdk(ApplicationManager.getApplication().isUnitTestMode());
    }

    @VisibleForTesting
    boolean isUsingJavaHomeJdk(boolean assumeUnitTest) {
        if (!this.myIdeInfo.isAndroidStudio()) {
            return false;
        }
        Path jdkPath = this.doGetJdkPath(!assumeUnitTest);
        return IdeSdks.isSameAsJavaHomeJdk(jdkPath);
    }

    public static boolean isSameAsJavaHomeJdk(@Nullable Path path2) {
        String javaHome = IdeSdks.getJdkFromJavaHome();
        return javaHome != null && FileUtil.pathsEqual((String)path2.toString(), (String)javaHome);
    }

    @Nullable
    public static String getJdkFromJavaHome() {
        String terminalValue = IdeSdks.doGetJdkFromPathOrParent(EnvironmentUtil.getValue((String)"JAVA_HOME"));
        if (!Strings.isNullOrEmpty((String)terminalValue)) {
            return terminalValue;
        }
        String envVariableValue = IdeSdks.doGetJdkFromPathOrParent(System.getenv("JAVA_HOME"));
        if (!Strings.isNullOrEmpty((String)envVariableValue)) {
            return envVariableValue;
        }
        return IdeSdks.doGetJdkFromPathOrParent(SystemProperties.getJavaHome());
    }

    @VisibleForTesting
    @Nullable
    static String doGetJdkFromPathOrParent(@Nullable String path2) {
        Path pathFile;
        if (Strings.isNullOrEmpty((String)path2)) {
            return null;
        }
        try {
            pathFile = Paths.get(path2, new String[0]);
        }
        catch (InvalidPathException exc) {
            return null;
        }
        String result2 = IdeSdks.doGetJdkFromPath(pathFile);
        if (result2 != null) {
            return result2;
        }
        Path parentFile = pathFile.getParent();
        if (parentFile != null) {
            return IdeSdks.doGetJdkFromPath(parentFile);
        }
        return null;
    }

    @Nullable
    private static String doGetJdkFromPath(@NotNull Path file2) {
        Path potentialPath;
        if (JdkUtil.checkForJdk((Path)file2)) {
            return file2.toString();
        }
        if (SystemInfo.isMac && Files.isDirectory(potentialPath = file2.resolve(MAC_JDK_CONTENT_PATH), new LinkOption[0]) && JdkUtil.checkForJdk((Path)potentialPath)) {
            return potentialPath.toString();
        }
        return null;
    }

    @Nullable
    public Sdk getJdk() {
        return this.doGetJdk(true);
    }

    @Nullable
    @VisibleForTesting
    Sdk doGetJdk(boolean createIfNeeded) {
        Sdk jdk;
        if (this.myEnvVariableSettings.isUseJdkEnvVariable()) {
            return this.myEnvVariableSettings.getSdk();
        }
        if ((this.myIdeInfo.isAndroidStudio() || this.myIdeInfo.isGameTools()) && (jdk = ProjectJdkTable.getInstance().findJdk(ANDROID_STUDIO_DEFAULT_JDK_NAME, JavaSdk.getInstance().getName())) != null) {
            return jdk;
        }
        JavaSdkVersion preferredVersion = DEFAULT_JDK_VERSION;
        Sdk existingJdk = this.getExistingJdk(preferredVersion);
        if (existingJdk != null) {
            return existingJdk;
        }
        if (createIfNeeded) {
            return this.createNewJdk(preferredVersion);
        }
        return null;
    }

    @Nullable
    private Sdk getExistingJdk(@Nullable JavaSdkVersion preferredVersion) {
        List<Sdk> androidSdks = this.getEligibleAndroidSdks();
        if (!androidSdks.isEmpty()) {
            Sdk androidSdk = androidSdks.get(0);
            AndroidSdkAdditionalData data2 = this.myAndroidSdks.getAndroidSdkAdditionalData(androidSdk);
            assert (data2 != null);
            Sdk jdk = data2.getJavaSdk();
            if (this.isJdkCompatible(jdk, preferredVersion)) {
                return jdk;
            }
        }
        JavaSdk javaSdk = JavaSdk.getInstance();
        List jdks = ProjectJdkTable.getInstance().getSdksOfType((SdkTypeId)javaSdk);
        if (!jdks.isEmpty()) {
            for (Sdk jdk : jdks) {
                if (!this.isJdkCompatible(jdk, preferredVersion)) continue;
                return jdk;
            }
        }
        return null;
    }

    @Nullable
    private Sdk createNewJdk(@Nullable JavaSdkVersion preferredVersion) {
        Sdk jdk;
        if (this.myIdeInfo.isAndroidStudio() && (jdk = this.myJdks.createEmbeddedJdk()) != null) {
            assert (this.isJdkCompatible(jdk, preferredVersion));
            return jdk;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            LOG.warn("Using non-deterministic JDK lookup. Test may render different results in different environments.");
        }
        JavaSdk javaSdk = JavaSdk.getInstance();
        List jdks = ProjectJdkTable.getInstance().getSdksOfType((SdkTypeId)javaSdk);
        Set checkedJdkPaths = jdks.stream().map(Sdk::getHomePath).collect(Collectors.toSet());
        List<File> jdkPaths = IdeSdks.getPotentialJdkPaths();
        for (File jdkPath : jdkPaths) {
            Sdk jdk2;
            if (checkedJdkPaths.contains(jdkPath.getAbsolutePath())) continue;
            if (JdkUtil.checkForJdk((Path)jdkPath.toPath()) && this.isJdkCompatible(jdk2 = this.createJdk(jdkPath.toPath()), preferredVersion)) {
                return jdk2;
            }
            if (!SystemInfo.isLinux) continue;
            for (File child : FileUtil.notNullize((File[])jdkPath.listFiles())) {
                Sdk jdk3;
                if (!child.isDirectory() || !JdkUtil.checkForJdk((Path)child.toPath()) || !this.isJdkCompatible(jdk3 = this.myJdks.createJdk(child.getPath()), preferredVersion)) continue;
                return jdk3;
            }
        }
        return null;
    }

    @NotNull
    private static List<File> getPotentialJdkPaths() {
        JavaSdk javaSdk = JavaSdk.getInstance();
        ArrayList jdkPaths = Lists.newArrayList((Iterable)javaSdk.suggestHomePaths());
        jdkPaths.add(SystemProperties.getJavaHome());
        jdkPaths.add(0, System.getenv("JDK_HOME"));
        ArrayList virtualFiles = Lists.newArrayListWithCapacity((int)jdkPaths.size());
        for (String jdkPath : jdkPaths) {
            File javaHome;
            if (jdkPath == null || !(javaHome = new File(jdkPath)).isDirectory()) continue;
            virtualFiles.add(javaHome);
        }
        return virtualFiles;
    }

    public boolean isJdkCompatible(@Nullable Sdk jdk) {
        return this.isJdkCompatible(jdk, MIN_JDK_VERSION);
    }

    @Contract(value="null, _ -> false")
    public boolean isJdkCompatible(@Nullable Sdk jdk, @Nullable JavaSdkVersion preferredVersion) {
        if (jdk == null) {
            return false;
        }
        if (!(jdk.getSdkType() instanceof JavaSdk)) {
            return false;
        }
        if (preferredVersion == null) {
            return true;
        }
        if (!JavaSdk.getInstance().isOfVersionOrHigher(jdk, JavaSdkVersion.JDK_1_8)) {
            return false;
        }
        if (((Boolean)StudioFlags.ALLOW_DIFFERENT_JDK_VERSION.get()).booleanValue()) {
            return true;
        }
        JavaSdkVersion jdkVersion = JavaSdk.getInstance().getVersion(jdk);
        if (jdkVersion == null) {
            return false;
        }
        return this.isJdkVersionCompatible(preferredVersion, jdkVersion);
    }

    @VisibleForTesting
    boolean isJdkVersionCompatible(@NotNull JavaSdkVersion preferredVersion, @NotNull JavaSdkVersion jdkVersion) {
        return jdkVersion.compareTo((Enum)preferredVersion) >= 0 && jdkVersion.compareTo((Enum)MAX_JDK_VERSION) <= 0;
    }

    @NotNull
    public List<Sdk> getEligibleAndroidSdks() {
        ArrayList<Sdk> sdks = new ArrayList<Sdk>();
        for (Sdk sdk : this.myAndroidSdks.getAllAndroidSdks()) {
            if (!sdk.getName().startsWith("Android ") || AndroidPlatform.getInstance(sdk) == null) continue;
            sdks.add(sdk);
        }
        return sdks;
    }

    public boolean hasConfiguredAndroidSdk() {
        return this.getAndroidSdkPath() != null;
    }

    @VisibleForTesting
    @Nullable
    public Sdk createJdk(@NotNull Path homeDirectory) {
        ProjectJdkTable projectJdkTable = ProjectJdkTable.getInstance();
        for (Sdk jdk : projectJdkTable.getSdksOfType((SdkTypeId)JavaSdk.getInstance())) {
            if (!FileUtil.pathsEqual((String)jdk.getHomePath(), (String)homeDirectory.toString())) continue;
            return jdk;
        }
        return this.myJdks.createJdk(homeDirectory.toString());
    }

    @NotNull
    public static Sdk findOrCreateJdk(@NotNull String name, @NotNull Path jdkPath) {
        String homePath;
        ProjectJdkTable jdkTable = ProjectJdkTable.getInstance();
        Sdk existingJdk = jdkTable.findJdk(name);
        if (existingJdk != null && (homePath = existingJdk.getHomePath()) != null && FileUtils.isSameFile((File)jdkPath.toFile(), (File)new File(homePath))) {
            return existingJdk;
        }
        JavaSdk javaSdkType = JavaSdk.getInstance();
        Sdk newJdk = javaSdkType.createJdk(name, jdkPath.toAbsolutePath().toString());
        ApplicationManager.getApplication().runWriteAction(() -> {
            if (existingJdk != null) {
                jdkTable.removeJdk(existingJdk);
            }
            jdkTable.addJdk(newJdk);
        });
        return newJdk;
    }

    @TestOnly
    public static void removeJdksOn(@NotNull Disposable disposable2) {
        if (disposable2 instanceof ProjectEx) {
            disposable2 = ((ProjectEx)disposable2).getEarlyDisposable();
        }
        Disposer.register((Disposable)disposable2, () -> WriteAction.run(() -> {
            for (Sdk sdk : ProjectJdkTable.getInstance().getAllJdks()) {
                ProjectJdkTable.getInstance().removeJdk(sdk);
            }
        }));
    }

    @Nullable
    public Path validateJdkPath(@NotNull Path path2) {
        Path macPath;
        Path possiblePath = null;
        if (JdkUtil.checkForJdk((Path)path2)) {
            possiblePath = path2;
        } else if (SystemInfo.isMac && Files.isDirectory(macPath = path2.resolve(MAC_JDK_CONTENT_PATH), new LinkOption[0]) && JdkUtil.checkForJdk((Path)macPath)) {
            possiblePath = macPath;
        }
        if (possiblePath != null) {
            if (((Boolean)StudioFlags.ALLOW_DIFFERENT_JDK_VERSION.get()).booleanValue() || IdeSdks.isJdkSameVersion(possiblePath, this.getRunningVersionOrDefault())) {
                return possiblePath;
            }
            LOG.warn("Trying to use JDK with different version: " + possiblePath);
        } else {
            File file2 = FilePaths.stringToFile((String)path2.toString());
            IdeSdks.showValidateDetails(file2);
            if (SystemInfo.isMac) {
                IdeSdks.showValidateDetails(new File(file2, MAC_JDK_CONTENT_PATH));
            }
        }
        return null;
    }

    private static void showValidateDetails(@NotNull File homePath) {
        LOG.warn("Could not validate JDK at " + homePath + ":");
        LOG.warn("  File exists: " + homePath.exists());
        LOG.warn("  Javac: " + (new File(homePath, "bin/javac").isFile() || new File(homePath, "bin/javac.exe").isFile()));
        LOG.warn("  JDK: " + new File(homePath, "jre/lib/rt.jar").exists());
        LOG.warn("  JRE: " + new File(homePath, "lib/rt.jar").exists());
        LOG.warn("  Jigsaw JDK/JRE: " + JdkUtil.isModularRuntime((Path)homePath.toPath()));
        LOG.warn("  Apple JDK: " + new File(homePath, "../Classes/classes.jar").exists());
        LOG.warn("  IBM JDK: " + new File(homePath, "jre/lib/vm.jar").exists());
        LOG.warn("  Custom build: " + new File(homePath, "classes").isDirectory());
    }

    @Nullable
    public String generateInvalidJdkReason(@NotNull Path path2) {
        String reason;
        Path validPath = this.validateJdkPath(path2);
        if (validPath != null) {
            return null;
        }
        Path possiblePath = path2;
        if (SystemInfo.isMac) {
            Path macPath = path2.resolve(MAC_JDK_CONTENT_PATH);
            if (Files.isDirectory(macPath, new LinkOption[0]) && JdkUtil.checkForJdk((Path)macPath)) {
                reason = this.getInvalidJdkReason(macPath);
                if (reason == null) {
                    possiblePath = macPath;
                }
            } else {
                reason = this.getInvalidJdkReason(path2);
            }
        } else {
            reason = this.getInvalidJdkReason(path2);
        }
        if (reason != null) {
            return reason;
        }
        if (((Boolean)StudioFlags.ALLOW_DIFFERENT_JDK_VERSION.get()).booleanValue() || IdeSdks.isJdkSameVersion(possiblePath, this.getRunningVersionOrDefault())) {
            return null;
        }
        return "JDK version should be " + this.getRunningVersionOrDefault();
    }

    @Nullable
    private String getInvalidJdkReason(@NotNull Path path2) {
        if (!Files.exists(path2.resolve("bin/javac"), new LinkOption[0]) && !Files.exists(path2.resolve("bin/javac.exe"), new LinkOption[0])) {
            return "There is no bin/javac in " + path2;
        }
        if (!(JdkUtil.isModularRuntime((Path)path2) || Files.exists(path2.resolve("jre/lib/rt.jar"), new LinkOption[0]) || Files.isDirectory(path2.resolve("classes"), new LinkOption[0]) || Files.exists(path2.resolve("jre/lib/vm.jar"), new LinkOption[0]) || Files.exists(path2.resolve("../Classes/classes.jar"), new LinkOption[0]))) {
            return "Required JDK files from " + path2 + " are missing";
        }
        return null;
    }

    @NotNull
    public JavaSdkVersion getRunningVersionOrDefault() {
        JavaSdkVersion currentlyRunning;
        String versionString = System.getProperty("java.version");
        if (versionString != null && (currentlyRunning = JavaSdkVersion.fromVersionString((String)versionString)) != null) {
            return currentlyRunning;
        }
        JavaSdkVersion embeddedVersion = Jdks.getInstance().findVersion(this.myEmbeddedDistributionPaths.getEmbeddedJdkPath());
        return embeddedVersion != null ? embeddedVersion : DEFAULT_JDK_VERSION;
    }

    @Contract(value="null, _ -> false")
    public static boolean isJdkSameVersion(@Nullable Path jdkLocation, @NotNull JavaSdkVersion expectedVersion) {
        if (jdkLocation == null) {
            return false;
        }
        JavaSdkVersion version2 = Jdks.getInstance().findVersion(jdkLocation);
        return version2 != null && version2.compareTo((Enum)expectedVersion) == 0;
    }

    public void recreateProjectJdkTable() {
        Runnable cleanJdkTableAction = () -> {
            ProjectJdkTable jdkTable = ProjectJdkTable.getInstance();
            for (Sdk jdk : jdkTable.getSdksOfType((SdkTypeId)JavaSdk.getInstance())) {
                Sdk recreatedJdk;
                Sdk sdk = recreatedJdk = jdk.getHomePath() != null ? this.recreateJdk(jdk.getHomePath(), jdk.getName()) : null;
                if (recreatedJdk != null) {
                    jdkTable.updateJdk(jdk, recreatedJdk);
                    continue;
                }
                jdkTable.removeJdk(jdk);
            }
        };
        ApplicationManager.getApplication().runWriteAction(cleanJdkTableAction);
    }

    public void recreateOrAddJdkInTable(@NotNull String jdkPath, @NotNull String jdkName) {
        ProjectJdkTable jdkTable = ProjectJdkTable.getInstance();
        Sdk jdkInTable = jdkTable.findJdk(jdkName);
        Sdk updatedJdk = this.recreateJdk(jdkPath, jdkName);
        if (updatedJdk == null) {
            if (jdkInTable != null) {
                jdkTable.removeJdk(jdkInTable);
            }
            return;
        }
        if (jdkInTable != null) {
            boolean shouldUpdate;
            boolean bl = shouldUpdate = !SdkExtensions.isEqualTo(jdkInTable, updatedJdk);
            if (shouldUpdate) {
                ProjectJdkTable.getInstance().updateJdk(jdkInTable, updatedJdk);
            }
            Disposer.dispose((Disposable)((ProjectJdkImpl)updatedJdk));
        } else {
            jdkTable.addJdk(updatedJdk);
        }
    }

    @Nullable
    private Sdk recreateJdk(@NotNull String jdkPath, @NotNull String jdkName) {
        if (this.validateJdkPath(Paths.get(jdkPath, new String[0])) != null) {
            return JavaSdk.getInstance().createJdk(jdkName, jdkPath, false);
        }
        return null;
    }

    static {
        DEFAULT_JDK_VERSION = MAX_JDK_VERSION = JavaSdkVersion.JDK_17;
        LOG = Logger.getInstance(IdeSdks.class);
    }

    private class EnvVariableSettings {
        private Sdk mySdk;
        private String myVariableValue;
        private File myJdkFile;
        private boolean myUseJdkEnvVariable;
        private boolean myInitialized;
        private final Object myInitializationLock = new Object();

        public EnvVariableSettings() {
            this.cleanInitialization();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cleanInitialization() {
            Object object = this.myInitializationLock;
            synchronized (object) {
                this.myVariableValue = null;
                this.myJdkFile = null;
                this.mySdk = null;
                this.myUseJdkEnvVariable = false;
                this.myInitialized = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void initialize() {
            Object object = this.myInitializationLock;
            synchronized (object) {
                if (this.myInitialized) {
                    return;
                }
            }
            this.initialize(System.getenv(IdeSdks.JDK_LOCATION_ENV_VARIABLE_NAME));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void initialize(@Nullable String value2) {
            Path envVariableJdkPath;
            Object object = this.myInitializationLock;
            synchronized (object) {
                if (this.myInitialized) {
                    return;
                }
                if (value2 == null) {
                    this.setInitializationAsNotDefined();
                    return;
                }
                envVariableJdkPath = IdeSdks.this.validateJdkPath(Paths.get(value2, new String[0]));
                if (envVariableJdkPath == null) {
                    this.setInitializationAsDefinedButInvalid(value2);
                    LOG.warn("The provided JDK path is invalid: " + value2);
                    return;
                }
            }
            Path finalEnvVariableJdkPath = envVariableJdkPath;
            Runnable createJdkTask = () -> {
                Object object = this.myInitializationLock;
                synchronized (object) {
                    if (!this.myInitialized) {
                        try {
                            @Nullable Sdk jdk = IdeSdks.this.createJdk(finalEnvVariableJdkPath);
                            if (jdk != null) {
                                this.setInitialization(value2, FilePaths.stringToFile((String)finalEnvVariableJdkPath.toString()), jdk);
                                LOG.info("Using Gradle JDK from STUDIO_GRADLE_JDK=" + value2);
                            } else {
                                this.setInitializationAsDefinedButInvalid(value2);
                                LOG.warn("Could not use provided jdk from " + value2);
                            }
                        }
                        catch (Throwable exc) {
                            this.setInitializationAsDefinedButInvalid(value2);
                            LOG.warn("Could not use provided jdk from " + value2, exc);
                        }
                    }
                }
            };
            Application application = ApplicationManager.getApplication();
            boolean onReadAction = application.isReadAccessAllowed();
            boolean hasWriteIntendLock = application.isWriteThread();
            if (onReadAction && !hasWriteIntendLock) {
                application.invokeLater(createJdkTask);
                throw new AssertionError((Object)"Cannot create JDK from a read action without write intend");
            }
            application.invokeAndWait(createJdkTask);
        }

        private void setInitializationAsNotDefined() {
            this.setInitialization(null, null, null);
        }

        private void setInitializationAsDefinedButInvalid(@NotNull String envVariableValue) {
            this.setInitialization(envVariableValue, null, null);
        }

        private void setInitialization(@Nullable String variableValue2, @Nullable File jdkFile, @Nullable Sdk sdk) {
            this.myVariableValue = variableValue2;
            this.myJdkFile = jdkFile;
            this.mySdk = sdk;
            this.myUseJdkEnvVariable = variableValue2 != null && jdkFile != null && sdk != null;
            this.myInitialized = true;
        }

        public boolean isUseJdkEnvVariable() {
            this.initialize();
            return this.myUseJdkEnvVariable;
        }

        boolean isJdkEnvVariableDefined() {
            this.initialize();
            return this.myVariableValue != null;
        }

        public boolean IsJdkEnvVariableValid() {
            this.initialize();
            return this.mySdk != null;
        }

        public File getJdkFile() {
            this.initialize();
            return this.myJdkFile;
        }

        public Sdk getSdk() {
            this.initialize();
            return this.mySdk;
        }

        public String getVariableValue() {
            this.initialize();
            return this.myVariableValue;
        }

        public boolean setUseJdkEnvVariable(boolean use2) {
            this.initialize();
            if (!this.IsJdkEnvVariableValid()) {
                return false;
            }
            this.myUseJdkEnvVariable = use2;
            return true;
        }

        public void overrideValue(@Nullable String value2) {
            ExternalSystemApiUtil.doWriteAction(() -> {
                Object object = this.myInitializationLock;
                synchronized (object) {
                    this.myInitialized = false;
                    this.initialize(value2);
                }
            });
        }
    }

    public static interface AndroidSdkEventListener {
        public static final ExtensionPointName<AndroidSdkEventListener> EP_NAME = ExtensionPointName.create((String)"com.android.ide.sdkEventListener");

        public void afterSdkPathChange(@NotNull File var1, @NotNull Project var2);
    }
}

