/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.util;

import com.android.tools.idea.run.util.LaunchStatus;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutputTypes;
import java.util.List;
import java.util.function.BooleanSupplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ProcessHandlerLaunchStatus
implements LaunchStatus {
    @NotNull
    private ProcessHandler myProcessHandler;
    private boolean myTerminated;
    private List<BooleanSupplier> launchTerminationConditions = Lists.newCopyOnWriteArrayList();

    public ProcessHandlerLaunchStatus(@NotNull ProcessHandler processHandler2) {
        this.myProcessHandler = processHandler2;
    }

    @Override
    @NotNull
    public ProcessHandler getProcessHandler() {
        return this.myProcessHandler;
    }

    public void setProcessHandler(@NotNull ProcessHandler processHandler2) {
        this.myProcessHandler = processHandler2;
    }

    @Override
    public boolean isLaunchTerminated() {
        if (this.myTerminated) {
            return true;
        }
        if (this.launchTerminationConditions.stream().anyMatch(condition -> !condition.getAsBoolean())) {
            return false;
        }
        return this.myProcessHandler.isProcessTerminated() || this.myProcessHandler.isProcessTerminating();
    }

    @Override
    public void addLaunchTerminationCondition(BooleanSupplier launchTerminatedCondition) {
        this.launchTerminationConditions.add(launchTerminatedCondition);
    }

    @Override
    public void terminateLaunch(@Nullable String errorMessage, boolean destroyProcess) {
        this.myTerminated = true;
        if (!Strings.isNullOrEmpty((String)errorMessage)) {
            this.myProcessHandler.notifyTextAvailable(errorMessage + "\n", ProcessOutputTypes.STDERR);
        }
        if (destroyProcess) {
            this.myProcessHandler.destroyProcess();
        }
    }
}

