/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.tasks;

import com.android.ddmlib.CollectingOutputReceiver;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.idea.run.util.LaunchStatus;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.diagnostic.Logger;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class ShellCommandLauncher {
    private static final String TARGET_REGEX = "\\berror\\b";
    @VisibleForTesting
    static final Pattern errorPattern = Pattern.compile("\\berror\\b", 2);

    public static boolean execute(@NotNull String command2, @NotNull IDevice device2, @NotNull LaunchStatus launchStatus, @NotNull ConsolePrinter printer, long timeout, @NotNull TimeUnit timeoutUnit) {
        printer.stdout("$ adb shell " + command2);
        AndroidLaunchReceiver receiver2 = new AndroidLaunchReceiver(launchStatus);
        try {
            device2.executeShellCommand(command2, (IShellOutputReceiver)receiver2, timeout, timeoutUnit);
        }
        catch (Exception e) {
            Logger logger2 = Logger.getInstance(ShellCommandLauncher.class);
            logger2.warn("Unexpected exception while executing shell command: " + command2);
            logger2.warn((Throwable)e);
            launchStatus.terminateLaunch("Unexpected error while executing: " + command2, true);
            return false;
        }
        String output = receiver2.getOutput();
        if (errorPattern.matcher(output).find()) {
            launchStatus.terminateLaunch("Error while executing: " + command2, true);
            printer.stderr(output);
            return false;
        }
        return true;
    }

    private static class AndroidLaunchReceiver
    extends CollectingOutputReceiver {
        private final LaunchStatus myLaunchStatus;

        public AndroidLaunchReceiver(@NotNull LaunchStatus state2) {
            this.myLaunchStatus = state2;
        }

        public boolean isCancelled() {
            return this.myLaunchStatus.isLaunchTerminated();
        }
    }
}

