/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.tasks;

import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.notification.NotificationListener;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class LaunchResult {
    private Result myResult = Result.SUCCESS;
    private String myMessage = "";
    private String myErrorId = "";
    private String myConsoleMessage = "";
    private NotificationListener myNotificationListener = null;
    private String myConsoleHyperlinkText = "";
    private HyperlinkInfo myConsoleHyperlinkInfo = null;
    private final List<Runnable> myOnFinishedCallbacks = new ArrayList<Runnable>();

    public void setResult(Result result2) {
        this.myResult = result2;
    }

    public Result getResult() {
        return this.myResult;
    }

    public void setMessage(String message2) {
        this.myMessage = message2;
    }

    public String getMessage() {
        return this.myMessage;
    }

    public void setErrorId(String id2) {
        this.myErrorId = id2;
    }

    public String getErrorId() {
        return this.myErrorId;
    }

    public void setConsoleMessage(String consoleMessage) {
        this.myConsoleMessage = consoleMessage;
    }

    public String getConsoleMessage() {
        return this.myConsoleMessage;
    }

    public void setConsoleHyperlink(String hyperlinkText, HyperlinkInfo hyperlinkInfo) {
        this.myConsoleHyperlinkText = hyperlinkText;
        this.myConsoleHyperlinkInfo = hyperlinkInfo;
    }

    public String getConsoleHyperlinkText() {
        return this.myConsoleHyperlinkText;
    }

    public HyperlinkInfo getConsoleHyperlinkInfo() {
        return this.myConsoleHyperlinkInfo;
    }

    public NotificationListener getNotificationListener() {
        return this.myNotificationListener;
    }

    public void setNotificationListener(NotificationListener listener2) {
        this.myNotificationListener = listener2;
    }

    public List<Runnable> onFinishedCallbacks() {
        return this.myOnFinishedCallbacks;
    }

    public void addOnFinishedCallback(Runnable runnable2) {
        this.myOnFinishedCallbacks.add(runnable2);
    }

    @NotNull
    public static LaunchResult success() {
        return new LaunchResult();
    }

    @NotNull
    public static LaunchResult error(@NotNull String errorId, @NotNull String taskDescription) {
        LaunchResult result2 = new LaunchResult();
        result2.setResult(Result.ERROR);
        result2.setErrorId(errorId);
        result2.setMessage("Error " + taskDescription);
        result2.setConsoleMessage("Error while " + taskDescription);
        return result2;
    }

    @NotNull
    public static LaunchResult warning(@NotNull String message2) {
        LaunchResult result2 = new LaunchResult();
        result2.setResult(Result.WARNING);
        result2.setMessage(message2);
        result2.setConsoleMessage(message2);
        return result2;
    }

    public static enum Result {
        SUCCESS,
        WARNING,
        ERROR;

    }
}

