/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.tasks;

import com.android.ddmlib.IDevice;
import com.android.tools.deployer.Deployer;
import com.android.tools.deployer.DeployerException;
import com.android.tools.deployer.InstallOptions;
import com.android.tools.deployer.tasks.Canceller;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.run.ApkInfo;
import com.android.tools.idea.run.tasks.AbstractDeployTask;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class DeployTask
extends AbstractDeployTask {
    private static final Logger LOG = Logger.getInstance(DeployTask.class);
    public static final String ID = "DEPLOY";
    private final String[] userInstallOptions;
    private final boolean installOnAllUsers;

    public DeployTask(@NotNull Project project, @NotNull Collection<ApkInfo> packages, String userInstallOptions, boolean installOnAllUsers, boolean alwaysInstallWithPm) {
        super(project, packages, false, alwaysInstallWithPm);
        if (userInstallOptions != null && !userInstallOptions.isEmpty()) {
            userInstallOptions = userInstallOptions.trim();
            this.userInstallOptions = userInstallOptions.split("\\s");
        } else {
            this.userInstallOptions = new String[0];
        }
        this.installOnAllUsers = installOnAllUsers;
    }

    @Override
    @NotNull
    public String getId() {
        return ID;
    }

    @Override
    protected boolean shouldTaskLaunchApp() {
        return true;
    }

    @Override
    protected Deployer.Result perform(IDevice device2, Deployer deployer, @NotNull ApkInfo apkInfo, @NotNull Canceller canceller) throws DeployerException {
        boolean isDontKillSupported;
        Set<ApkInfo.AppInstallOption> requiredInstallOptions;
        InstallOptions.Builder options2 = InstallOptions.builder().setAllowDebuggable();
        if (!this.installOnAllUsers && device2.getVersion().isGreaterOrEqualThan(24)) {
            options2.setInstallOnUser("current");
        }
        if (device2.supportsFeature(IDevice.HardwareFeature.EMBEDDED)) {
            options2.setGrantAllPermissions();
        }
        if ((requiredInstallOptions = apkInfo.getRequiredInstallOptions()).contains((Object)ApkInfo.AppInstallOption.GRANT_ALL_PERMISSIONS) && device2.getVersion().isGreaterOrEqualThan(ApkInfo.AppInstallOption.GRANT_ALL_PERMISSIONS.minSupportedApiLevel)) {
            options2.setGrantAllPermissions();
        }
        if (requiredInstallOptions.contains((Object)ApkInfo.AppInstallOption.FORCE_QUERYABLE) && device2.getVersion().isGreaterOrEqualThan(ApkInfo.AppInstallOption.FORCE_QUERYABLE.minSupportedApiLevel)) {
            options2.setForceQueryable();
        }
        if (device2.getVersion().isGreaterOrEqualThan(28)) {
            options2.setInstallFullApk();
        }
        if (isDontKillSupported = device2.getVersion().isGreaterOrEqualThan(24)) {
            options2.setDontKill();
        }
        if (this.userInstallOptions != null) {
            options2.setUserInstallOptions(this.userInstallOptions);
        }
        options2.setSkipVerification(device2, apkInfo.getApplicationId());
        LOG.info("Installing application: " + apkInfo.getApplicationId());
        Deployer.InstallMode installMode = Deployer.InstallMode.DELTA;
        if (!((Boolean)StudioFlags.DELTA_INSTALL.get()).booleanValue()) {
            installMode = Deployer.InstallMode.FULL;
        }
        options2.setCancelChecker(canceller);
        Deployer.Result result2 = deployer.install(apkInfo.getApplicationId(), DeployTask.getPathsToInstall(apkInfo), options2.build(), installMode);
        if (!result2.skippedInstall && isDontKillSupported) {
            device2.forceStop(apkInfo.getApplicationId());
        }
        return result2;
    }

    @Override
    @NotNull
    public String getDescription() {
        return "Install";
    }

    @Override
    @NotNull
    public String getFailureTitle() {
        return "Installation did not succeed.";
    }

    @Override
    @NotNull
    protected String createSkippedApkInstallMessage(List<String> skippedApkList, boolean all) {
        if (all) {
            return "App restart successful without requiring a re-install.";
        }
        return "App restart successful without re-installing the following APK(s): " + skippedApkList.stream().collect(Collectors.joining(", "));
    }
}

