/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.tasks;

import com.android.ddmlib.IDevice;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.idea.run.activity.StartActivityFlagsProvider;
import com.android.tools.idea.run.tasks.AppLaunchTask;
import com.android.tools.idea.run.tasks.LaunchContext;
import com.android.tools.idea.run.tasks.LaunchResult;
import com.android.tools.idea.run.tasks.ShellCommandLauncher;
import com.android.tools.idea.run.util.LaunchStatus;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class AndroidDeepLinkLaunchTask
extends AppLaunchTask {
    private static final String ID = "LAUNCH_DEEP_LINK";
    @NotNull
    private final String myDeepLink;
    @NotNull
    StartActivityFlagsProvider myStartActivityFlagsProvider;

    public AndroidDeepLinkLaunchTask(@NotNull String deepLink, @NotNull StartActivityFlagsProvider startActivityFlagsProvider) {
        this.myDeepLink = deepLink;
        this.myStartActivityFlagsProvider = startActivityFlagsProvider;
    }

    @Override
    @NotNull
    public String getDescription() {
        return "Launching URL";
    }

    @Override
    public int getDuration() {
        return 2;
    }

    @Override
    public LaunchResult run(@NotNull LaunchContext launchContext) {
        ConsolePrinter printer = launchContext.getConsolePrinter();
        IDevice device2 = launchContext.getDevice();
        LaunchStatus launchStatus = launchContext.getLaunchStatus();
        printer.stdout("Launching deeplink: " + this.myDeepLink + ".\n");
        UsageTracker.log((AndroidStudioEvent.Builder)AndroidStudioEvent.newBuilder().setCategory(AndroidStudioEvent.EventCategory.APP_INDEXING).setKind(AndroidStudioEvent.EventKind.APP_INDEXING_DEEP_LINK_LAUNCHED));
        ShellCommandLauncher.execute("setprop log.tag.AppIndexApi VERBOSE", device2, launchStatus, printer, 5L, TimeUnit.SECONDS);
        String command2 = AndroidDeepLinkLaunchTask.getLaunchDeepLinkCommand(this.myDeepLink, this.myStartActivityFlagsProvider.getFlags(device2));
        boolean successful = ShellCommandLauncher.execute(command2, device2, launchStatus, printer, 5L, TimeUnit.SECONDS);
        return successful ? LaunchResult.success() : LaunchResult.error("", this.getDescription());
    }

    @Override
    @NotNull
    public String getId() {
        return ID;
    }

    @NotNull
    public static String getLaunchDeepLinkCommand(@NotNull String deepLink, @NotNull String extraFlags) {
        return "am start -a android.intent.action.VIEW -c android.intent.category.BROWSABLE -d " + AndroidDeepLinkLaunchTask.singleQuoteShell(deepLink) + (String)(extraFlags.isEmpty() ? "" : " " + extraFlags);
    }

    @NotNull
    private static String singleQuoteShell(@NotNull String literal) {
        return "'" + literal.replace("'", "'\\''") + "'";
    }
}

