/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.tasks;

import com.android.ddmlib.AdbHelper;
import com.android.ddmlib.IDevice;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.deploy.proto.Deploy;
import com.android.tools.deployer.AdbClient;
import com.android.tools.deployer.AdbInstaller;
import com.android.tools.deployer.ChangeType;
import com.android.tools.deployer.DeployMetric;
import com.android.tools.deployer.Deployer;
import com.android.tools.deployer.DeployerException;
import com.android.tools.deployer.DeployerOption;
import com.android.tools.deployer.Installer;
import com.android.tools.deployer.MetricsRecorder;
import com.android.tools.deployer.UIService;
import com.android.tools.deployer.tasks.Canceller;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.log.LogWrapper;
import com.android.tools.idea.run.ApkFileUnit;
import com.android.tools.idea.run.ApkInfo;
import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.idea.run.DeploymentService;
import com.android.tools.idea.run.IdeService;
import com.android.tools.idea.run.tasks.LaunchContext;
import com.android.tools.idea.run.tasks.LaunchResult;
import com.android.tools.idea.run.tasks.LaunchTask;
import com.android.tools.idea.run.ui.BaseAction;
import com.android.tools.idea.util.StudioPathManager;
import com.android.utils.ILogger;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableMap;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.ApplyChangesAgentError;
import com.google.wireless.android.sdk.stats.LaunchTaskDetail;
import com.intellij.execution.Executor;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.commands.ActionCommand;
import com.intellij.openapi.util.text.StringUtil;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractDeployTask
implements LaunchTask {
    public static final int MIN_API_VERSION = 26;
    private static final NotificationGroup NOTIFICATION_GROUP = NotificationGroup.toolWindowGroup((String)"UnifiedDeployTask", (String)"Run", (boolean)true, (PluginId)PluginId.getId((String)"org.jetbrains.android"));
    private static final Map<StudioFlags.OptimisticInstallSupportLevel, EnumSet<ChangeType>> OPTIMISTIC_INSTALL_SUPPORT = ImmutableMap.of((Object)StudioFlags.OptimisticInstallSupportLevel.DISABLED, EnumSet.noneOf(ChangeType.class), (Object)StudioFlags.OptimisticInstallSupportLevel.DEX, EnumSet.of(ChangeType.DEX), (Object)StudioFlags.OptimisticInstallSupportLevel.DEX_AND_NATIVE, EnumSet.of(ChangeType.DEX, ChangeType.NATIVE_LIBRARY), (Object)StudioFlags.OptimisticInstallSupportLevel.DEX_AND_NATIVE_AND_RESOURCES, EnumSet.of(ChangeType.DEX, ChangeType.NATIVE_LIBRARY, ChangeType.RESOURCE));
    @NotNull
    private final Project myProject;
    @NotNull
    private final Collection<ApkInfo> myPackages;
    @NotNull
    protected List<LaunchTaskDetail> mySubTaskDetails;
    protected final boolean myRerunOnSwapFailure;
    protected final boolean myAlwaysInstallWithPm;
    public static final Logger LOG = Logger.getInstance(AbstractDeployTask.class);

    public AbstractDeployTask(@NotNull Project project, @NotNull Collection<ApkInfo> packages, boolean rerunOnSwapFailure, boolean alwaysInstallWithPm) {
        this.myProject = project;
        this.myPackages = packages;
        this.myRerunOnSwapFailure = rerunOnSwapFailure;
        this.myAlwaysInstallWithPm = alwaysInstallWithPm;
        this.mySubTaskDetails = new ArrayList<LaunchTaskDetail>();
    }

    @Override
    public int getDuration() {
        return 20;
    }

    public List<Deployer.Result> run(IDevice device2, final ConsoleView console, ILogger logger2) throws DeployerException {
        ConsolePrinter printer = new ConsolePrinter(){

            @Override
            public void stdout(@NotNull String message2) {
                console.print(message2, ConsoleViewContentType.NORMAL_OUTPUT);
            }

            @Override
            public void stderr(@NotNull String message2) {
                console.print(message2, ConsoleViewContentType.ERROR_OUTPUT);
            }
        };
        return this.doRun(device2, printer, new Canceller(){

            public boolean cancelled() {
                ProgressIndicator indicator = ProgressIndicatorProvider.getGlobalProgressIndicator();
                return indicator != null && indicator.isCanceled();
            }
        }, logger2);
    }

    @Override
    public LaunchResult run(final @NotNull LaunchContext launchContext) {
        IDevice device2 = launchContext.getDevice();
        Executor executor2 = launchContext.getExecutor();
        ConsolePrinter printer = launchContext.getConsolePrinter();
        LogWrapper logger2 = new LogWrapper(LOG);
        try {
            launchContext.setLaunchApp(this.shouldTaskLaunchApp());
            List<Deployer.Result> results = this.doRun(device2, printer, new Canceller(){

                public boolean cancelled() {
                    return launchContext.getProgressIndicator().isCanceled();
                }
            }, (ILogger)logger2);
            if (results.stream().anyMatch(result2 -> result2.needsRestart)) {
                launchContext.setKillBeforeLaunch(true);
                launchContext.setLaunchApp(true);
            }
        }
        catch (DeployerException e) {
            LOG.warn(String.format("%s failed: %s %s", this.getDescription(), e.getMessage(), e.getDetails()));
            return this.toLaunchResult(executor2, e, printer);
        }
        return new LaunchResult();
    }

    private List<Deployer.Result> doRun(@NotNull IDevice device2, ConsolePrinter printer, Canceller canceller, ILogger logger2) throws DeployerException {
        Stopwatch stopwatch = Stopwatch.createStarted();
        MetricsRecorder metrics = new MetricsRecorder();
        long vmClockStartNs = System.nanoTime();
        long wallClockStartMs = System.currentTimeMillis();
        AdbClient adb = new AdbClient(device2, logger2);
        AdbHelper.setAbbExecAllowed((boolean)((Boolean)StudioFlags.DDMLIB_ABB_EXEC_INSTALL_ENABLE.get()));
        AdbInstaller.Mode adbInstallerMode = AdbInstaller.Mode.DAEMON;
        if (!((Boolean)StudioFlags.APPLY_CHANGES_KEEP_CONNECTION_ALIVE.get()).booleanValue()) {
            adbInstallerMode = AdbInstaller.Mode.ONE_SHOT;
        }
        AdbInstaller installer = new AdbInstaller(this.getLocalInstaller(), adb, (Collection)metrics.getDeployMetrics(), logger2, adbInstallerMode);
        DeploymentService service = DeploymentService.getInstance(this.myProject);
        IdeService ideService = new IdeService(this.myProject);
        EnumSet<ChangeType> optimisticInstallSupport = EnumSet.noneOf(ChangeType.class);
        if (!this.myAlwaysInstallWithPm) {
            optimisticInstallSupport = OPTIMISTIC_INSTALL_SUPPORT.getOrDefault(StudioFlags.OPTIMISTIC_INSTALL_SUPPORT_LEVEL.get(), EnumSet.noneOf(ChangeType.class));
        }
        DeployerOption option = new DeployerOption.Builder().setUseOptimisticSwap(((Boolean)StudioFlags.APPLY_CHANGES_OPTIMISTIC_SWAP.get()).booleanValue()).setUseOptimisticResourceSwap(((Boolean)StudioFlags.APPLY_CHANGES_OPTIMISTIC_RESOURCE_SWAP.get()).booleanValue()).setOptimisticInstallSupport(optimisticInstallSupport).setUseStructuralRedefinition(((Boolean)StudioFlags.APPLY_CHANGES_STRUCTURAL_DEFINITION.get()).booleanValue()).setUseVariableReinitialization(((Boolean)StudioFlags.APPLY_CHANGES_VARIABLE_REINITIALIZATION.get()).booleanValue()).setFastRestartOnSwapFail(this.getFastRerunOnSwapFailure()).enableCoroutineDebugger(((Boolean)StudioFlags.COROUTINE_DEBUGGER_ENABLE.get()).booleanValue()).build();
        Deployer deployer = new Deployer(adb, service.getDeploymentCacheDatabase(), service.getDexDatabase(), service.getTaskRunner(), (Installer)installer, (UIService)ideService, metrics, logger2, option);
        ArrayList<String> idsSkippedInstall = new ArrayList<String>();
        ArrayList<Deployer.Result> results = new ArrayList<Deployer.Result>();
        for (ApkInfo apkInfo : this.myPackages) {
            Deployer.Result result2 = this.perform(device2, deployer, apkInfo, canceller);
            if (result2.skippedInstall) {
                idsSkippedInstall.add(apkInfo.getApplicationId());
            }
            results.add(result2);
        }
        this.addSubTaskDetails(metrics.getDeployMetrics(), vmClockStartNs, wallClockStartMs);
        this.logAgentFailures(metrics.getAgentFailures());
        stopwatch.stop();
        long duration2 = stopwatch.elapsed(TimeUnit.MILLISECONDS);
        if (idsSkippedInstall.isEmpty()) {
            String content2 = String.format("%s successfully finished in %s.", this.getDescription(), StringUtil.formatDuration((long)duration2));
            printer.stdout(content2);
            logger2.info("%s", new Object[]{content2});
        } else {
            String title = String.format("%s successfully finished in %s.", this.getDescription(), StringUtil.formatDuration((long)duration2));
            String content3 = this.createSkippedApkInstallMessage(idsSkippedInstall, idsSkippedInstall.size() == this.myPackages.size());
            printer.stdout(content3);
            logger2.info("%s. %s", new Object[]{title, content3});
            NOTIFICATION_GROUP.createNotification(content3, NotificationType.INFORMATION).notify(this.myProject);
        }
        return results;
    }

    protected abstract String getFailureTitle();

    protected abstract boolean shouldTaskLaunchApp();

    protected abstract Deployer.Result perform(IDevice var1, Deployer var2, @NotNull ApkInfo var3, @NotNull Canceller var4) throws DeployerException;

    private String getLocalInstaller() {
        Path path2 = StudioPathManager.isRunningFromSources() ? StudioPathManager.resolvePathFromSourcesRoot((String)"bazel-bin/tools/base/deploy/installer/android-installer") : Paths.get(PathManager.getHomePath(), "plugins/android/resources/installer");
        return path2.toString();
    }

    protected static List<String> getPathsToInstall(@NotNull ApkInfo apkInfo) {
        return apkInfo.getFiles().stream().map(ApkFileUnit::getApkPath).map(Path::toString).collect(Collectors.toList());
    }

    @NotNull
    protected Project getProject() {
        return this.myProject;
    }

    final boolean getFastRerunOnSwapFailure() {
        return this.myRerunOnSwapFailure;
    }

    private void addSubTaskDetails(@NotNull Collection<DeployMetric> metrics, long startNanoTime, long startWallClockMs) {
        for (DeployMetric metric : metrics) {
            if (metric.getName().isEmpty()) continue;
            LaunchTaskDetail.Builder detail = LaunchTaskDetail.newBuilder();
            long startOffsetMs = TimeUnit.NANOSECONDS.toMillis(metric.getStartTimeNs() - startNanoTime);
            long endOffsetMs = TimeUnit.NANOSECONDS.toMillis(metric.getEndTimeNs() - startNanoTime);
            detail.setId(this.getId() + "." + metric.getName()).setStartTimestampMs(startWallClockMs + startOffsetMs).setEndTimestampMs(startWallClockMs + endOffsetMs).setTid((int)metric.getThreadId());
            if (metric.hasStatus()) {
                detail.setStatus(metric.getStatus());
            }
            this.mySubTaskDetails.add(detail.build());
        }
    }

    private void logAgentFailures(List<Deploy.AgentExceptionLog> agentExceptionLogs) {
        for (Deploy.AgentExceptionLog log : agentExceptionLogs) {
            UsageTracker.log((AndroidStudioEvent.Builder)AbstractDeployTask.toStudioEvent(log));
        }
    }

    private static AndroidStudioEvent.Builder toStudioEvent(Deploy.AgentExceptionLog log) {
        ApplyChangesAgentError.AgentPurpose purpose = ApplyChangesAgentError.AgentPurpose.forNumber((int)log.getAgentPurposeValue());
        ApplyChangesAgentError.Builder builder2 = ApplyChangesAgentError.newBuilder().setEventTimeMs(TimeUnit.MILLISECONDS.convert(log.getEventTimeNs(), TimeUnit.NANOSECONDS)).setAgentAttachTimeMs(TimeUnit.MILLISECONDS.convert(log.getAgentAttachTimeNs(), TimeUnit.NANOSECONDS)).setAgentAttachCount(log.getAgentAttachCount()).setAgentPurpose(purpose);
        log.getFailedClassesList().stream().map(ApplyChangesAgentError.TargetClass::valueOf).forEach(arg_0 -> ((ApplyChangesAgentError.Builder)builder2).addTargetClasses(arg_0));
        return AndroidStudioEvent.newBuilder().setCategory(AndroidStudioEvent.EventCategory.DEPLOYMENT).setKind(AndroidStudioEvent.EventKind.APPLY_CHANGES_AGENT_ERROR).setApplyChangesAgentError(builder2);
    }

    @Override
    @NotNull
    public Collection<LaunchTaskDetail> getSubTaskDetails() {
        return this.mySubTaskDetails;
    }

    public LaunchResult toLaunchResult(@NotNull Executor executor2, @NotNull DeployerException e, @NotNull ConsolePrinter printer) {
        LaunchResult result2 = new LaunchResult();
        result2.setResult(LaunchResult.Result.ERROR);
        StringBuilder bubbleError = new StringBuilder(this.getFailureTitle());
        bubbleError.append("\n");
        bubbleError.append(e.getMessage());
        DeployerException.Error error = e.getError();
        String callToAction = error.getCallToAction();
        DeployerException.ResolutionAction resolutionAction = error.getResolution();
        if ("Debug".equals(executor2.getId()) && resolutionAction == DeployerException.ResolutionAction.APPLY_CHANGES) {
            callToAction = "Rerun";
            resolutionAction = DeployerException.ResolutionAction.RUN_APP;
        }
        if (resolutionAction != DeployerException.ResolutionAction.NONE) {
            if (this.myRerunOnSwapFailure) {
                bubbleError.append(String.format("\n%s will be done automatically</a>", callToAction));
            } else {
                bubbleError.append(String.format("\n<a href='%s'>%s</a>", resolutionAction, callToAction));
            }
        }
        result2.setMessage(bubbleError.toString());
        result2.setConsoleMessage(this.getFailureTitle() + "\n" + e.getMessage() + "\n" + e.getDetails());
        result2.setErrorId(e.getId());
        DeploymentHyperlinkInfo hyperlinkInfo = new DeploymentHyperlinkInfo(executor2, resolutionAction, printer);
        result2.setConsoleHyperlink(callToAction, hyperlinkInfo);
        result2.setNotificationListener(new DeploymentErrorNotificationListener(resolutionAction, hyperlinkInfo));
        if (this.myRerunOnSwapFailure) {
            result2.addOnFinishedCallback(() -> hyperlinkInfo.navigate(this.myProject));
        }
        return result2;
    }

    protected abstract String createSkippedApkInstallMessage(List<String> var1, boolean var2);

    @Override
    @NotNull
    public Collection<ApkInfo> getApkInfos() {
        return this.myPackages;
    }

    private static class DeploymentHyperlinkInfo
    implements HyperlinkInfo {
        @Nullable
        private final String myActionId;
        @NotNull
        private final ConsolePrinter myPrinter;

        public DeploymentHyperlinkInfo(@NotNull Executor executor2, @NotNull DeployerException.ResolutionAction resolutionAction, @NotNull ConsolePrinter printer) {
            this.myPrinter = printer;
            switch (resolutionAction) {
                case APPLY_CHANGES: {
                    this.myActionId = "android.deploy.ApplyChanges";
                    break;
                }
                case RUN_APP: {
                    this.myActionId = "Debug".equals(executor2.getId()) ? "Debug" : "Run";
                    break;
                }
                case RETRY: {
                    this.myActionId = executor2.getActionName();
                    break;
                }
                default: {
                    this.myActionId = null;
                }
            }
        }

        public void navigate(@NotNull Project project) {
            BaseAction.DisableMessage message2;
            if (this.myActionId == null) {
                return;
            }
            ActionManager manager = ActionManager.getInstance();
            AnAction action2 = manager.getAction(this.myActionId);
            if (action2 == null) {
                return;
            }
            if (action2 instanceof BaseAction && (message2 = BaseAction.getDisableMessage(project)) != null) {
                this.myPrinter.stderr(String.format("%s is disabled because %s.", action2.getTemplatePresentation().getText(), message2.getDescription()));
                return;
            }
            manager.tryToExecute(action2, ActionCommand.getInputEvent((String)this.myActionId), null, "unknown", true);
        }
    }

    private class DeploymentErrorNotificationListener
    implements NotificationListener {
        @NotNull
        private final DeployerException.ResolutionAction myResolutionAction;
        @NotNull
        private final DeploymentHyperlinkInfo myHyperlinkInfo;

        public DeploymentErrorNotificationListener(@NotNull DeployerException.ResolutionAction resolutionAction, DeploymentHyperlinkInfo hyperlinkInfo) {
            this.myResolutionAction = resolutionAction;
            this.myHyperlinkInfo = hyperlinkInfo;
        }

        public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
            if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED && event.getDescription().equals(this.myResolutionAction.name())) {
                this.myHyperlinkInfo.navigate(AbstractDeployTask.this.myProject);
            }
        }
    }
}

