/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.editor;

import com.android.tools.idea.run.TargetSelectionMode;
import com.android.tools.idea.run.editor.DeployTargetProvider;
import com.android.tools.idea.run.editor.DeployTargetState;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class DeployTargetContext
implements JDOMExternalizable {
    public String TARGET_SELECTION_MODE = TargetSelectionMode.SHOW_DIALOG.name();
    private final Collection<DeployTargetProvider> myDeployTargetProviders;
    private final Map<String, DeployTargetState> myDeployTargetStates;

    public DeployTargetContext() {
        this(DeployTargetProvider.getProviders());
    }

    @VisibleForTesting
    DeployTargetContext(@NotNull Collection<DeployTargetProvider> deployTargetProviders) {
        this.myDeployTargetProviders = deployTargetProviders;
        this.myDeployTargetStates = (Map)deployTargetProviders.stream().collect(ImmutableMap.toImmutableMap(DeployTargetProvider::getId, DeployTargetProvider::createState));
    }

    @NotNull
    public List<DeployTargetProvider> getApplicableDeployTargetProviders(boolean testConfiguration) {
        return this.myDeployTargetProviders.stream().filter(provider2 -> provider2.isApplicable(testConfiguration)).collect(Collectors.toList());
    }

    @NotNull
    public DeployTargetProvider getCurrentDeployTargetProvider() {
        String mode = this.getTargetSelectionMode().name();
        Optional<DeployTargetProvider> optionalProvider = this.myDeployTargetProviders.stream().filter(provider2 -> provider2.getId().equals(mode)).findFirst();
        return optionalProvider.orElseThrow(AssertionError::new);
    }

    @NotNull
    public Map<String, DeployTargetState> getDeployTargetStates() {
        return this.myDeployTargetStates;
    }

    @NotNull
    public DeployTargetState getCurrentDeployTargetState() {
        DeployTargetProvider currentTarget = this.getCurrentDeployTargetProvider();
        return this.myDeployTargetStates.get(currentTarget.getId());
    }

    @NotNull
    public DeployTargetState getDeployTargetState(@NotNull DeployTargetProvider target2) {
        return this.myDeployTargetStates.get(target2.getId());
    }

    public void setTargetSelectionMode(@NotNull TargetSelectionMode mode) {
        this.TARGET_SELECTION_MODE = mode.name();
    }

    public void setTargetSelectionMode(@NotNull DeployTargetProvider target2) {
        this.TARGET_SELECTION_MODE = target2.getId();
    }

    @NotNull
    public TargetSelectionMode getTargetSelectionMode() {
        try {
            TargetSelectionMode mode = TargetSelectionMode.valueOf(this.TARGET_SELECTION_MODE);
            switch (mode) {
                case DEVICE_AND_SNAPSHOT_COMBO_BOX: 
                case FIREBASE_DEVICE_MATRIX: 
                case FIREBASE_DEVICE_DEBUGGING: {
                    return mode;
                }
                case SHOW_DIALOG: 
                case EMULATOR: 
                case USB_DEVICE: {
                    return TargetSelectionMode.DEVICE_AND_SNAPSHOT_COMBO_BOX;
                }
            }
            throw new AssertionError((Object)mode);
        }
        catch (IllegalArgumentException exception) {
            return TargetSelectionMode.DEVICE_AND_SNAPSHOT_COMBO_BOX;
        }
    }

    public void readExternal(Element element2) throws InvalidDataException {
        DefaultJDOMExternalizer.readExternal((Object)this, (Element)element2);
        for (DeployTargetState state2 : this.myDeployTargetStates.values()) {
            DefaultJDOMExternalizer.readExternal((Object)state2, (Element)element2);
        }
    }

    public void writeExternal(Element element2) throws WriteExternalException {
        DefaultJDOMExternalizer.writeExternal((Object)this, (Element)element2);
        for (DeployTargetState state2 : this.myDeployTargetStates.values()) {
            DefaultJDOMExternalizer.writeExternal((Object)state2, (Element)element2);
        }
    }
}

