/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.editor;

import com.android.tools.idea.instantapp.InstantAppUrlFinder;
import com.android.tools.idea.instantapp.InstantApps;
import com.android.tools.idea.projectsystem.SourceProviderManager;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ArrayUtil;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeepLinkChooserDialog
extends DialogWrapper {
    private static final String TAG_INTENT_FILTER = "intent-filter";
    private static final String TAG_ACTION = "action";
    private static final String TAG_CATEGORY = "category";
    private static final String TAG_DATA = "data";
    private static final String ACTION_VIEW = "android.intent.action.VIEW";
    private static final String CATEGORY_DEFAULT = "android.intent.category.DEFAULT";
    private static final String CATEGORY_BROWSABLE = "android.intent.category.BROWSABLE";
    Project myProject;
    String mySelectedDeepLink = null;
    JBList myList;

    public DeepLinkChooserDialog(@NotNull Project project, @Nullable Module module2) {
        super(project);
        this.myProject = project;
        ArrayList<String> deepLinks = new ArrayList<String>();
        if (module2 != null && module2.getModuleFile() != null && module2.getModuleFile().getParent() != null) {
            AndroidFacet facet2;
            XmlFile manifest = DeepLinkChooserDialog.getAndroidManifestPsi(module2);
            if (manifest != null) {
                deepLinks.addAll(DeepLinkChooserDialog.getAllDeepLinks(manifest.getRootTag()));
            }
            if ((facet2 = AndroidFacet.getInstance((Module)module2)) != null) {
                List<Module> featureModules = InstantApps.findFeatureModules(facet2);
                for (Module featureModule : featureModules) {
                    deepLinks.addAll((Collection<String>)new InstantAppUrlFinder(featureModule).getAllUrls());
                }
            }
        }
        this.myList = new JBList((Object[])ArrayUtil.toStringArray(deepLinks));
        this.myList.setEmptyText("None found in AndroidManifest.xml");
        this.init();
    }

    @Nullable
    public String getSelectedDeepLink() {
        return this.mySelectedDeepLink;
    }

    @Nullable
    protected JComponent createCenterPanel() {
        JBScrollPane scrollPane = new JBScrollPane((Component)this.myList);
        this.myList.setSelectedIndex(0);
        new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent e) {
                int index2 = DeepLinkChooserDialog.this.myList.locationToIndex(e.getPoint());
                if (index2 != -1 && DeepLinkChooserDialog.this.myList.getModel().getElementAt(index2) != null) {
                    DeepLinkChooserDialog.this.myList.setSelectedIndex(index2);
                    DeepLinkChooserDialog.this.doOKAction();
                }
                return false;
            }
        }.installOn((Component)this.myList);
        return scrollPane;
    }

    protected void doOKAction() {
        this.mySelectedDeepLink = (String)this.myList.getSelectedValue();
        super.doOKAction();
    }

    @Nullable
    private static XmlFile getAndroidManifestPsi(@NotNull Module module2) {
        PsiFile psiFile;
        VirtualFile manifest;
        AndroidFacet facet2 = AndroidFacet.getInstance((Module)module2);
        if (facet2 != null && (manifest = SourceProviderManager.getInstance(facet2).getMainManifestFile()) != null && (psiFile = PsiManager.getInstance((Project)module2.getProject()).findFile(manifest)) instanceof XmlFile) {
            return (XmlFile)psiFile;
        }
        return null;
    }

    @VisibleForTesting
    static List<String> getAllDeepLinks(XmlTag root) {
        if (root == null) {
            return new ArrayList<String>();
        }
        List<XmlTag> intentFilters = DeepLinkChooserDialog.searchXmlTagsByName(root, TAG_INTENT_FILTER);
        ArrayList<String> deepLinks = new ArrayList<String>();
        for (XmlTag intentFilter : intentFilters) {
            String deepLink = DeepLinkChooserDialog.getDeepLinkFromIntentFilter(intentFilter);
            if (deepLink == null) continue;
            deepLinks.add(deepLink);
        }
        return deepLinks;
    }

    @NotNull
    private static List<XmlTag> searchXmlTagsByName(@NotNull XmlTag root, final @NotNull String tagName) {
        final ArrayList<XmlTag> tags = new ArrayList<XmlTag>();
        root.accept((PsiElementVisitor)new XmlRecursiveElementVisitor(){

            public void visitXmlTag(XmlTag tag) {
                super.visitXmlTag(tag);
                if (tag.getName().equalsIgnoreCase(tagName)) {
                    tags.add(tag);
                }
            }
        });
        return tags;
    }

    @Nullable
    private static String getDeepLinkFromIntentFilter(@NotNull XmlTag intentFilter) {
        List<XmlTag> actions2 = DeepLinkChooserDialog.searchXmlTagsByName(intentFilter, TAG_ACTION);
        boolean hasActionView = false;
        for (XmlTag action2 : actions2) {
            String name = action2.getAttributeValue("name", "http://schemas.android.com/apk/res/android");
            if (name == null || !name.equals(ACTION_VIEW)) continue;
            hasActionView = true;
            break;
        }
        if (!hasActionView) {
            return null;
        }
        List<XmlTag> categories = DeepLinkChooserDialog.searchXmlTagsByName(intentFilter, TAG_CATEGORY);
        boolean hasDefaultCategory = false;
        boolean hasBrowsableCategory = false;
        for (XmlTag category : categories) {
            String name = category.getAttributeValue("name", "http://schemas.android.com/apk/res/android");
            if (name != null && name.equals(CATEGORY_DEFAULT)) {
                hasDefaultCategory = true;
                continue;
            }
            if (name == null || !name.equals(CATEGORY_BROWSABLE)) continue;
            hasBrowsableCategory = true;
        }
        if (!hasDefaultCategory || !hasBrowsableCategory) {
            return null;
        }
        List<XmlTag> datas = DeepLinkChooserDialog.searchXmlTagsByName(intentFilter, TAG_DATA);
        String scheme = null;
        String host = null;
        String pathPrefix = null;
        String path2 = null;
        for (XmlTag data2 : datas) {
            if (null != data2.getAttributeValue("scheme", "http://schemas.android.com/apk/res/android")) {
                scheme = data2.getAttributeValue("scheme", "http://schemas.android.com/apk/res/android");
            }
            if (null != data2.getAttributeValue("host", "http://schemas.android.com/apk/res/android")) {
                host = data2.getAttributeValue("host", "http://schemas.android.com/apk/res/android");
            }
            if (null != data2.getAttributeValue("pathPrefix", "http://schemas.android.com/apk/res/android")) {
                pathPrefix = data2.getAttributeValue("pathPrefix", "http://schemas.android.com/apk/res/android");
            }
            if (null == data2.getAttributeValue("path", "http://schemas.android.com/apk/res/android")) continue;
            path2 = data2.getAttributeValue("path", "http://schemas.android.com/apk/res/android");
        }
        if (scheme != null) {
            StringBuilder builder2 = new StringBuilder(scheme);
            builder2.append("://");
            if (host != null) {
                builder2.append(host);
                if (path2 != null) {
                    builder2.append(path2);
                } else if (pathPrefix != null) {
                    builder2.append(pathPrefix);
                }
            }
            return builder2.toString();
        }
        return null;
    }
}

