/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.editor;

import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.model.AndroidModel;
import com.android.tools.idea.projectsystem.ModuleSystemUtil;
import com.android.tools.idea.run.AndroidRunConfiguration;
import com.android.tools.idea.run.ConfigurationSpecificEditor;
import com.android.tools.idea.run.activity.launch.ActivityLaunchOption;
import com.android.tools.idea.run.activity.launch.ActivityLaunchOptionState;
import com.android.tools.idea.run.activity.launch.DeepLinkLaunch;
import com.android.tools.idea.run.activity.launch.DefaultActivityLaunch;
import com.android.tools.idea.run.activity.launch.LaunchOptionConfigurableContext;
import com.android.tools.idea.run.activity.launch.NoLaunch;
import com.android.tools.idea.run.editor.DynamicFeaturesParameters;
import com.android.tools.idea.run.editor.InstallOption;
import com.android.tools.idea.run.editor.LaunchConfigurableWrapper;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.intellij.compiler.options.CompileStepBeforeRun;
import com.intellij.compiler.options.CompileStepBeforeRunNoErrorCheck;
import com.intellij.execution.BeforeRunTask;
import com.intellij.execution.impl.ConfigurationSettingsEditorWrapper;
import com.intellij.execution.ui.ConfigurationModuleSelector;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ex.ConfigurableCardPanel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactManager;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.impl.run.BuildArtifactsBeforeRunTaskProvider;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTextField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.SmartList;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.annotations.NotNull;

public class ApplicationRunParameters<T extends AndroidRunConfiguration>
implements ConfigurationSpecificEditor<T>,
ActionListener {
    private JPanel myPanel;
    private ComboBox myDeployOptionCombo;
    private LabeledComponent<ComboBox> myCustomArtifactLabeledComponent;
    private final ComboBox myArtifactCombo;
    private LabeledComponent<JBTextField> myPmOptionsLabeledComponent;
    private ComboBox myLaunchOptionCombo;
    private ConfigurableCardPanel myLaunchOptionsCardPanel;
    private LabeledComponent<JBTextField> myAmOptionsLabeledComponent;
    private JComponent myDynamicFeaturesParametersComponent;
    private JBCheckBox myInstantAppDeployCheckBox;
    private JBCheckBox myAllUsersCheckbox;
    private JBCheckBox myAlwaysInstallWithPmCheckbox;
    private JBCheckBox myClearAppStorageCheckbox;
    private final Project myProject;
    private final ConfigurationModuleSelector myModuleSelector;
    private Artifact myLastSelectedArtifact;
    private final ImmutableMap<String, LaunchConfigurableWrapper> myConfigurables;
    private DynamicFeaturesParameters myDynamicFeaturesParameters;

    public ApplicationRunParameters(Project project, ConfigurationModuleSelector moduleSelector2) {
        this.myProject = project;
        this.myModuleSelector = moduleSelector2;
        this.$$$setupUI$$$();
        this.myDeployOptionCombo.setModel((ComboBoxModel)new CollectionComboBoxModel(Arrays.asList(InstallOption.values())));
        this.myDeployOptionCombo.setRenderer((ListCellRenderer)((Object)new InstallOption.Renderer()));
        this.myDeployOptionCombo.addActionListener((ActionListener)this);
        this.myDeployOptionCombo.setSelectedItem((Object)InstallOption.DEFAULT_APK);
        this.myArtifactCombo = (ComboBox)this.myCustomArtifactLabeledComponent.getComponent();
        this.myArtifactCombo.setRenderer((ListCellRenderer)SimpleListCellRenderer.create((label, value2, index2) -> {
            if (value2 instanceof Artifact) {
                Artifact artifact2 = (Artifact)value2;
                label.setText(artifact2.getName());
                label.setIcon(artifact2.getArtifactType().getIcon());
            } else if (value2 instanceof String) {
                label.setText("<html><font color='red'>" + value2 + "</font></html>");
            }
        }));
        this.myArtifactCombo.setModel(new DefaultComboBoxModel<Object>(this.getAndroidArtifacts().toArray()));
        this.myArtifactCombo.addActionListener((ActionListener)this);
        ((JBTextField)this.myPmOptionsLabeledComponent.getComponent()).getEmptyText().setText("Options to 'pm install' command");
        this.myLaunchOptionCombo.setModel((ComboBoxModel)new CollectionComboBoxModel(AndroidRunConfiguration.LAUNCH_OPTIONS));
        this.myLaunchOptionCombo.setRenderer((ListCellRenderer)((Object)new ActivityLaunchOption.Renderer()));
        this.myLaunchOptionCombo.addActionListener((ActionListener)this);
        ((JBTextField)this.myAmOptionsLabeledComponent.getComponent()).getEmptyText().setText("Options to 'am start' command");
        this.myInstantAppDeployCheckBox.addActionListener((ActionListener)this);
        LaunchOptionConfigurableContext context2 = new LaunchOptionConfigurableContext(){

            @Override
            public Module getModule() {
                Module selectedModule = ApplicationRunParameters.this.myModuleSelector.getModule();
                return selectedModule == null ? null : ModuleSystemUtil.getMainModule(selectedModule);
            }
        };
        ImmutableMap.Builder builder2 = ImmutableMap.builder();
        for (ActivityLaunchOption activityLaunchOption : AndroidRunConfiguration.LAUNCH_OPTIONS) {
            builder2.put((Object)activityLaunchOption.getId(), (Object)new LaunchConfigurableWrapper(project, context2, activityLaunchOption));
        }
        this.myConfigurables = builder2.build();
        this.myLaunchOptionCombo.setSelectedItem((Object)DefaultActivityLaunch.INSTANCE);
        this.myInstantAppDeployCheckBox.setVisible(((Boolean)StudioFlags.UAB_ENABLE_NEW_INSTANT_APP_RUN_CONFIGURATIONS.get()).booleanValue());
        this.myAlwaysInstallWithPmCheckbox.setVisible(StudioFlags.OPTIMISTIC_INSTALL_SUPPORT_LEVEL.get() != StudioFlags.OptimisticInstallSupportLevel.DISABLED);
    }

    private void createUIComponents() {
        this.myDynamicFeaturesParameters = new DynamicFeaturesParameters();
        this.myDynamicFeaturesParametersComponent = this.myDynamicFeaturesParameters.getComponent();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.myDeployOptionCombo) {
            InstallOption option = (InstallOption)((Object)this.myDeployOptionCombo.getSelectedItem());
            this.myCustomArtifactLabeledComponent.setVisible(option == InstallOption.CUSTOM_ARTIFACT);
            this.myPmOptionsLabeledComponent.setVisible(option != InstallOption.NOTHING);
            if (option == InstallOption.CUSTOM_ARTIFACT) {
                this.updateBuildArtifactBeforeRunSetting();
            }
        } else if (source == this.myArtifactCombo) {
            this.updateBuildArtifactBeforeRunSetting();
        } else if (source == this.myLaunchOptionCombo) {
            ActivityLaunchOption option = (ActivityLaunchOption)this.myLaunchOptionCombo.getSelectedItem();
            this.myAmOptionsLabeledComponent.setVisible(option != NoLaunch.INSTANCE);
            this.myLaunchOptionsCardPanel.select((Object)((Configurable)this.myConfigurables.get((Object)option.getId())), true);
        } else if (source == this.myInstantAppDeployCheckBox && this.myModuleSelector.getModule() != null) {
            this.myDynamicFeaturesParameters.updateBasedOnInstantState(this.myModuleSelector.getModule(), this.myInstantAppDeployCheckBox.isSelected());
        }
    }

    @NotNull
    private static InstallOption getDeployOption(boolean deploy, boolean deployFromBundle, String artifactName) {
        Preconditions.checkArgument((!deployFromBundle || deploy ? 1 : 0) != 0);
        if (deploy) {
            if (deployFromBundle) {
                return StringUtil.isEmpty((String)artifactName) ? InstallOption.APK_FROM_BUNDLE : InstallOption.CUSTOM_ARTIFACT;
            }
            return StringUtil.isEmpty((String)artifactName) ? InstallOption.DEFAULT_APK : InstallOption.CUSTOM_ARTIFACT;
        }
        return InstallOption.NOTHING;
    }

    @Override
    public void resetFrom(@NotNull AndroidRunConfiguration configuration) {
        InstallOption installOption = ApplicationRunParameters.getDeployOption(configuration.DEPLOY, configuration.DEPLOY_APK_FROM_BUNDLE, configuration.ARTIFACT_NAME);
        this.myDeployOptionCombo.setSelectedItem((Object)installOption);
        this.myInstantAppDeployCheckBox.setSelected(this.myInstantAppDeployCheckBox.isEnabled() && configuration.DEPLOY_AS_INSTANT);
        Module currentModule = this.myModuleSelector.getModule();
        if (currentModule != null) {
            this.myDynamicFeaturesParameters.updateBasedOnInstantState(currentModule, this.myInstantAppDeployCheckBox.isSelected());
        }
        if (installOption == InstallOption.CUSTOM_ARTIFACT) {
            String artifactName = StringUtil.notNullize((String)configuration.ARTIFACT_NAME);
            ArrayList arrayList = Lists.newArrayList(this.getAndroidArtifacts());
            Artifact selectedArtifact = ApplicationRunParameters.findArtifactByName(arrayList, artifactName);
            if (selectedArtifact != null) {
                this.myArtifactCombo.setModel(new DefaultComboBoxModel<Object>(arrayList.toArray()));
                this.myArtifactCombo.setSelectedItem((Object)selectedArtifact);
            } else {
                ArrayList items2 = Lists.newArrayList((Object[])arrayList.toArray());
                items2.add(artifactName);
                this.myArtifactCombo.setModel(new DefaultComboBoxModel<Object>(items2.toArray()));
                this.myArtifactCombo.setSelectedItem((Object)artifactName);
            }
        }
        ((JBTextField)this.myPmOptionsLabeledComponent.getComponent()).setText(configuration.PM_INSTALL_OPTIONS);
        this.myAllUsersCheckbox.setSelected(configuration.ALL_USERS);
        this.myAlwaysInstallWithPmCheckbox.setSelected(configuration.ALWAYS_INSTALL_WITH_PM);
        this.myClearAppStorageCheckbox.setSelected(configuration.CLEAR_APP_STORAGE);
        for (ActivityLaunchOption activityLaunchOption : AndroidRunConfiguration.LAUNCH_OPTIONS) {
            ActivityLaunchOptionState state2 = configuration.getLaunchOptionState(activityLaunchOption.getId());
            assert (state2 != null) : "State is null for option: " + activityLaunchOption.getDisplayName();
            ((LaunchConfigurableWrapper)this.myConfigurables.get((Object)activityLaunchOption.getId())).resetFrom(state2);
        }
        ActivityLaunchOption activityLaunchOption = ApplicationRunParameters.getLaunchOption(configuration.MODE);
        this.myLaunchOptionCombo.setSelectedItem((Object)activityLaunchOption);
        ((JBTextField)this.myAmOptionsLabeledComponent.getComponent()).setText(configuration.ACTIVITY_EXTRA_FLAGS);
        this.myDynamicFeaturesParameters.setDisabledDynamicFeatures(configuration.getDisabledDynamicFeatures());
    }

    @NotNull
    private static ActivityLaunchOption getLaunchOption(String mode) {
        if (StringUtil.isEmpty((String)mode)) {
            mode = DefaultActivityLaunch.INSTANCE.getId();
        }
        for (ActivityLaunchOption activityLaunchOption : AndroidRunConfiguration.LAUNCH_OPTIONS) {
            if (!activityLaunchOption.getId().equals(mode)) continue;
            return activityLaunchOption;
        }
        throw new IllegalStateException("Unexpected error determining launch mode");
    }

    @Override
    public void applyTo(@NotNull AndroidRunConfiguration configuration) {
        Iterator<? extends ActivityLaunchOption> item2;
        InstallOption installOption = (InstallOption)((Object)this.myDeployOptionCombo.getSelectedItem());
        configuration.DEPLOY = installOption != InstallOption.NOTHING;
        configuration.DEPLOY_APK_FROM_BUNDLE = installOption == InstallOption.APK_FROM_BUNDLE;
        configuration.DEPLOY_AS_INSTANT = this.myInstantAppDeployCheckBox.isSelected();
        configuration.ARTIFACT_NAME = "";
        if (installOption == InstallOption.CUSTOM_ARTIFACT && (item2 = ((ComboBox)this.myCustomArtifactLabeledComponent.getComponent()).getSelectedItem()) instanceof Artifact) {
            configuration.ARTIFACT_NAME = ((Artifact)item2).getName();
        }
        configuration.PM_INSTALL_OPTIONS = StringUtil.notNullize((String)((JBTextField)this.myPmOptionsLabeledComponent.getComponent()).getText());
        configuration.ALL_USERS = this.myAllUsersCheckbox.isSelected();
        configuration.ALWAYS_INSTALL_WITH_PM = this.myAlwaysInstallWithPmCheckbox.isSelected();
        configuration.CLEAR_APP_STORAGE = this.myClearAppStorageCheckbox.isSelected();
        for (ActivityLaunchOption activityLaunchOption : AndroidRunConfiguration.LAUNCH_OPTIONS) {
            ActivityLaunchOptionState state2 = configuration.getLaunchOptionState(activityLaunchOption.getId());
            assert (state2 != null) : "State is null for option: " + activityLaunchOption.getDisplayName();
            ((LaunchConfigurableWrapper)this.myConfigurables.get((Object)activityLaunchOption.getId())).applyTo(state2);
        }
        ActivityLaunchOption activityLaunchOption = (ActivityLaunchOption)this.myLaunchOptionCombo.getSelectedItem();
        configuration.MODE = activityLaunchOption.getId();
        configuration.ACTIVITY_EXTRA_FLAGS = StringUtil.notNullize((String)((JBTextField)this.myAmOptionsLabeledComponent.getComponent()).getText());
        configuration.getLaunchOptionState(configuration.MODE).setAmFlags(configuration.ACTIVITY_EXTRA_FLAGS);
        configuration.setDisabledDynamicFeatures(this.myDynamicFeaturesParameters.getDisabledDynamicFeatures());
    }

    @Override
    public Component getComponent() {
        return this.myPanel;
    }

    public void dispose() {
    }

    private void updateBuildArtifactBeforeRunSetting() {
        Artifact newArtifact = null;
        Object item2 = this.myArtifactCombo.getSelectedItem();
        if (item2 instanceof Artifact) {
            newArtifact = (Artifact)item2;
        }
        if (Objects.equals(newArtifact, this.myLastSelectedArtifact)) {
            return;
        }
        if (this.myLastSelectedArtifact != null) {
            BuildArtifactsBeforeRunTaskProvider.setBuildArtifactBeforeRunOption((JComponent)this.myPanel, (Project)this.myProject, (Artifact)this.myLastSelectedArtifact, (boolean)false);
        }
        if (newArtifact != null) {
            BuildArtifactsBeforeRunTaskProvider.setBuildArtifactBeforeRunOption((JComponent)this.myPanel, (Project)this.myProject, (Artifact)newArtifact, (boolean)true);
        }
        if (this.myLastSelectedArtifact == null || newArtifact == null) {
            this.addOrRemoveMakeTask(newArtifact == null);
        }
        this.myLastSelectedArtifact = newArtifact;
    }

    private void addOrRemoveMakeTask(boolean add2) {
        DataContext dataContext = DataManager.getInstance().getDataContext((Component)this.myPanel);
        ConfigurationSettingsEditorWrapper editor = (ConfigurationSettingsEditorWrapper)ConfigurationSettingsEditorWrapper.CONFIGURATION_EDITOR_KEY.getData(dataContext);
        if (editor == null) {
            return;
        }
        SmartList makeTasks = new SmartList();
        for (BeforeRunTask task2 : editor.getStepsBeforeLaunch()) {
            if (!(task2 instanceof CompileStepBeforeRun.MakeBeforeRunTask) && !(task2 instanceof CompileStepBeforeRunNoErrorCheck.MakeBeforeRunTaskNoErrorCheck)) continue;
            makeTasks.add(task2);
        }
        if (add2) {
            if (makeTasks.isEmpty()) {
                editor.addBeforeLaunchStep((BeforeRunTask)new CompileStepBeforeRun.MakeBeforeRunTask());
            } else {
                for (BeforeRunTask task2 : makeTasks) {
                    task2.setEnabled(true);
                }
            }
        } else {
            for (BeforeRunTask task2 : makeTasks) {
                task2.setEnabled(false);
            }
        }
    }

    @NotNull
    private Collection<? extends Artifact> getAndroidArtifacts() {
        ArtifactManager artifactManager = ArtifactManager.getInstance((Project)this.myProject);
        ArtifactType androidArtifactType = ArtifactType.findById((String)"apk");
        return artifactManager == null || androidArtifactType == null ? Collections.emptyList() : artifactManager.getArtifactsByType(androidArtifactType);
    }

    private static Artifact findArtifactByName(@NotNull List<Artifact> artifacts, @NotNull String artifactName) {
        for (Artifact artifact2 : artifacts) {
            if (!artifactName.equals(artifact2.getName())) continue;
            return artifact2;
        }
        return null;
    }

    public void onModuleChanged() {
        boolean isInstantApp;
        Module currentModule = this.myModuleSelector.getModule();
        if (currentModule == null) {
            this.myInstantAppDeployCheckBox.setEnabled(false);
            this.myInstantAppDeployCheckBox.setSelected(false);
            return;
        }
        AndroidFacet facet2 = AndroidFacet.getInstance((Module)currentModule);
        AndroidModel model2 = AndroidModel.get(currentModule);
        boolean bl = isInstantApp = facet2 != null && ((AndroidFacetConfiguration)facet2.getConfiguration()).getProjectType() == 4;
        if (isInstantApp) {
            this.myLaunchOptionCombo.setSelectedItem((Object)DeepLinkLaunch.INSTANCE);
            this.myDeployOptionCombo.setSelectedItem((Object)InstallOption.DEFAULT_APK);
        } else {
            this.myInstantAppDeployCheckBox.setEnabled(model2 != null && model2.isInstantAppCompatible());
            if (model2 == null || !model2.isInstantAppCompatible()) {
                this.myInstantAppDeployCheckBox.setSelected(false);
            }
            this.myLaunchOptionCombo.setSelectedItem((Object)DefaultActivityLaunch.INSTANCE);
        }
        this.myDeployOptionCombo.setEnabled(!isInstantApp);
        this.myCustomArtifactLabeledComponent.setEnabled(!isInstantApp);
        this.myLaunchOptionCombo.setEnabled(!isInstantApp);
        this.myDynamicFeaturesParameters.setActiveModule(currentModule, model2 != null && model2.isInstantAppCompatible() && (Boolean)StudioFlags.UAB_ENABLE_NEW_INSTANT_APP_RUN_CONFIGURATIONS.get() != false ? DynamicFeaturesParameters.AvailableDeployTypes.INSTANT_AND_INSTALLED : DynamicFeaturesParameters.AvailableDeployTypes.INSTALLED_ONLY);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        JBCheckBox jBCheckBox2;
        JBCheckBox jBCheckBox3;
        LabeledComponent labeledComponent;
        ConfigurableCardPanel configurableCardPanel;
        ComboBox comboBox2;
        LabeledComponent labeledComponent2;
        JBCheckBox jBCheckBox4;
        LabeledComponent labeledComponent3;
        ComboBox comboBox3;
        JPanel jPanel;
        this.createUIComponents();
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(13, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        TitledSeparator titledSeparator = new TitledSeparator();
        titledSeparator.setText("Installation Options");
        jPanel.add((Component)titledSeparator, new GridConstraints(0, 0, 1, 4, 0, 1, 3, 0, null, null, null));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Deploy:");
        jBLabel.setDisplayedMnemonic('D');
        jBLabel.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jBLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null, 2));
        this.myDeployOptionCombo = comboBox3 = new ComboBox();
        jPanel.add((Component)comboBox3, new GridConstraints(1, 1, 1, 1, 0, 1, 3, 3, new Dimension(100, -1), null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(1, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myCustomArtifactLabeledComponent = labeledComponent3 = new LabeledComponent();
        labeledComponent3.setComponentClass("com.intellij.openapi.ui.ComboBox");
        labeledComponent3.setLabelLocation("West");
        labeledComponent3.setText("&Artifact");
        jPanel.add((Component)labeledComponent3, new GridConstraints(2, 0, 1, 4, 0, 1, 3, 3, null, null, null, 2));
        JComponent jComponent = this.myDynamicFeaturesParametersComponent;
        jPanel.add((Component)jComponent, new GridConstraints(3, 0, 1, 4, 0, 3, 3, 3, null, null, null, 2));
        this.myAllUsersCheckbox = jBCheckBox4 = new JBCheckBox();
        jBCheckBox4.setText("Install for all users (if already installed, will only update for existing users)");
        jPanel.add((Component)jBCheckBox4, new GridConstraints(4, 0, 1, 4, 8, 0, 3, 0, null, null, null, 2));
        this.myPmOptionsLabeledComponent = labeledComponent2 = new LabeledComponent();
        labeledComponent2.setComponentClass("com.intellij.ui.components.JBTextField");
        labeledComponent2.setLabelLocation("West");
        labeledComponent2.setText("&Install Flags");
        jPanel.add((Component)labeledComponent2, new GridConstraints(7, 0, 1, 4, 0, 3, 3, 3, null, null, null, 2));
        TitledSeparator titledSeparator2 = new TitledSeparator();
        titledSeparator2.setText("Launch Options");
        jPanel.add((Component)titledSeparator2, new GridConstraints(8, 0, 1, 4, 0, 1, 3, 0, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Launch:");
        jBLabel2.setDisplayedMnemonic('L');
        jBLabel2.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jBLabel2, new GridConstraints(9, 0, 1, 1, 8, 0, 0, 0, null, null, null, 2));
        this.myLaunchOptionCombo = comboBox2 = new ComboBox();
        jPanel.add((Component)comboBox2, new GridConstraints(9, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(9, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myLaunchOptionsCardPanel = configurableCardPanel = new ConfigurableCardPanel();
        jPanel.add((Component)configurableCardPanel, new GridConstraints(10, 0, 1, 4, 0, 3, 3, 3, null, null, null, 2));
        this.myAmOptionsLabeledComponent = labeledComponent = new LabeledComponent();
        labeledComponent.setComponentClass("com.intellij.ui.components.JBTextField");
        labeledComponent.setLabelLocation("West");
        labeledComponent.setText("Launch &Flags");
        jPanel.add((Component)labeledComponent, new GridConstraints(11, 0, 1, 4, 0, 3, 3, 3, null, null, null, 2));
        Spacer spacer3 = new Spacer();
        jPanel.add((Component)spacer3, new GridConstraints(12, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myInstantAppDeployCheckBox = jBCheckBox3 = new JBCheckBox();
        jBCheckBox3.setText("Deploy as instant app");
        jPanel.add((Component)jBCheckBox3, new GridConstraints(1, 2, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myAlwaysInstallWithPmCheckbox = jBCheckBox2 = new JBCheckBox();
        jBCheckBox2.setText("Always install with package manager (disables deploy optimizations on Android 11 and later)");
        jPanel.add((Component)jBCheckBox2, new GridConstraints(5, 0, 1, 4, 8, 0, 3, 0, null, null, null, 2));
        this.myClearAppStorageCheckbox = jBCheckBox = new JBCheckBox();
        jBCheckBox.setText("Clear app storage before deployment");
        jPanel.add((Component)jBCheckBox, new GridConstraints(6, 0, 1, 4, 8, 0, 3, 0, null, null, null, 2));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup = new ButtonGroup();
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

