/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.deployment.liveedit;

import com.android.annotations.Trace;
import com.android.ddmlib.IDevice;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.deploy.proto.Deploy;
import com.android.tools.deployer.AdbClient;
import com.android.tools.deployer.AdbInstaller;
import com.android.tools.deployer.Installer;
import com.android.tools.deployer.MetricsRecorder;
import com.android.tools.deployer.tasks.LiveUpdateDeployer;
import com.android.tools.idea.editors.literals.EditEvent;
import com.android.tools.idea.editors.literals.EditState;
import com.android.tools.idea.editors.literals.EditStatus;
import com.android.tools.idea.editors.literals.LiveEditService;
import com.android.tools.idea.editors.literals.LiveLiteralsMonitorHandler;
import com.android.tools.idea.editors.literals.LiveLiteralsService;
import com.android.tools.idea.editors.liveedit.LiveEditAdvancedConfiguration;
import com.android.tools.idea.editors.liveedit.LiveEditApplicationConfiguration;
import com.android.tools.idea.execution.common.AndroidExecutionTarget;
import com.android.tools.idea.execution.common.AndroidSessionInfo;
import com.android.tools.idea.execution.common.processhandler.AndroidRemoteDebugProcessHandler;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.log.LogWrapper;
import com.android.tools.idea.run.deployment.liveedit.AndroidLiveEditCodeGenerator;
import com.android.tools.idea.run.deployment.liveedit.ErrorReporterKt;
import com.android.tools.idea.run.deployment.liveedit.LiveEditUpdateException;
import com.android.tools.idea.run.deployment.liveedit.PrebuildChecksKt;
import com.android.tools.idea.run.deployment.liveedit.SourceInlineCandidate;
import com.android.tools.idea.util.StudioPathManager;
import com.android.utils.ILogger;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.LiveEditEvent;
import com.intellij.concurrency.JobScheduler;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.ide.ActivityTracker;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ThreeState;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

public class AndroidLiveEditDeployMonitor {
    private static final LogWrapper LOGGER = new LogWrapper(Logger.getInstance(AndroidLiveEditDeployMonitor.class));
    private static final EditStatus LOADING = new EditStatus(EditState.LOADING, "Application being deployed.", null);
    private static final EditStatus UPDATE_IN_PROGRESS = new EditStatus(EditState.IN_PROGRESS, "Live edit update in progress.", null);
    private static final EditStatus UP_TO_DATE = new EditStatus(EditState.UP_TO_DATE, "Up to date.", null);
    private static final EditStatus OUT_OF_DATE = new EditStatus(EditState.OUT_OF_DATE, "Refresh to view the latest Live Edit Changes. App state may be reset.", LiveEditService.getPIGGYBACK_ACTION_ID());
    private static final EditStatus RECOMPOSE_NEEDED = new EditStatus(EditState.RECOMPOSE_NEEDED, "Hard refresh must occur for all changes to be applied. App state will be reset.", "android.deploy.livedit.recompose");
    private static final EditStatus RECOMPOSE_ERROR = new EditStatus(EditState.RECOMPOSE_ERROR, "Error during recomposition.", null);
    private static final EditStatus DEBUGGER_ATTACHED = new EditStatus(EditState.RECOMPOSE_ERROR, "The app is currently running in debugging or profiling mode. These modes are not compatible with Live Edit.", "Run");
    private static final EditStatus GRADLE_SYNC_ERROR = new EditStatus(EditState.ERROR, "Gradle sync needs to be performed. Sync and rerun the app.", null);
    @NotNull
    private final Project project;
    @NotNull
    private final LinkedHashMap<String, SourceInlineCandidate> sourceInlineCandidateCache;
    private String applicationId;
    private final ScheduledExecutorService methodChangesExecutor = Executors.newSingleThreadScheduledExecutor();
    @NotNull
    private final Map<IDevice, EditStatus> editStatus = new ConcurrentHashMap<IDevice, EditStatus>();
    private final ArrayList<EditEvent> bufferedEvents = new ArrayList();
    private final Set<String> filesWithCompilationErrors = new HashSet<String>();
    private AtomicReference<Long> gradleTimeSync = new AtomicReference<Long>(Integer.toUnsignedLong(0));
    private static final Random random = new Random();

    public void resetState() {
        this.bufferedEvents.clear();
        this.filesWithCompilationErrors.clear();
    }

    public AndroidLiveEditDeployMonitor(@NotNull LiveEditService liveEditService, @NotNull Project project) {
        this.project = project;
        this.sourceInlineCandidateCache = liveEditService.getInlineCandidateCache();
        EditsListener editsListener = new EditsListener();
        liveEditService.addOnEditListener(editsListener::onLiteralsChanged);
        liveEditService.addEditStatusProvider(new EditStatusGetter());
        Disposer.register((Disposable)liveEditService, (Disposable)editsListener);
    }

    public void notifyDebug(String applicationId2, IDevice device2) {
        this.updateEditStatus(device2, DEBUGGER_ATTACHED);
    }

    public Callable<?> getCallback(String applicationId2, IDevice device2) {
        String deviceId = device2.getSerialNumber();
        LiveLiteralsService.getInstance(this.project).liveLiteralsMonitorStopped(deviceId + "#" + applicationId2);
        if (!LiveEditApplicationConfiguration.getInstance().isLiveEdit()) {
            LOGGER.info("Live Edit on device disabled via settings.", new Object[0]);
            return null;
        }
        if (!AndroidLiveEditDeployMonitor.supportLiveEdits(device2)) {
            LOGGER.info("Live edit not support for device %s targeting app %s", new Object[]{this.project.getName(), applicationId2});
            return null;
        }
        LOGGER.info("Creating monitor for project %s targeting app %s", new Object[]{this.project.getName(), applicationId2});
        this.updateEditStatus(device2, LOADING);
        return () -> this.methodChangesExecutor.schedule(() -> {
            this.applicationId = applicationId2;
            this.gradleTimeSync.set(GradleSyncState.getInstance(this.project).getLastSyncFinishedTimeStamp());
            LiveEditService.getInstance(this.project).resetState();
            LiveLiteralsMonitorHandler.DeviceType deviceType = device2.isEmulator() ? LiveLiteralsMonitorHandler.DeviceType.EMULATOR : LiveLiteralsMonitorHandler.DeviceType.PHYSICAL;
            LiveLiteralsService.getInstance(this.project).liveLiteralsMonitorStarted(deviceId + "#" + applicationId2, deviceType);
        }, 0L, TimeUnit.NANOSECONDS).get();
    }

    @Trace
    public void onManualLETrigger(Project project) {
        this.methodChangesExecutor.schedule(this::doOnManualLETrigger, 0L, TimeUnit.MILLISECONDS);
    }

    private void doOnManualLETrigger() {
        if (this.bufferedEvents.isEmpty()) {
            return;
        }
        this.updateEditStatus(UPDATE_IN_PROGRESS);
        while (!this.processChanges(this.project, this.bufferedEvents, LiveEditEvent.Mode.MANUAL)) {
            LOGGER.info("ProcessChanges was interrupted", new Object[0]);
        }
        this.bufferedEvents.clear();
    }

    @Trace
    boolean handleChangedMethods(Project project, List<EditEvent> changes) {
        LOGGER.info("Change detected for project %s targeting app %s", new Object[]{project.getName(), this.applicationId});
        if (LiveEditService.Companion.isLeTriggerManual()) {
            this.updateEditStatus(OUT_OF_DATE);
            if (this.bufferedEvents.size() < 2000) {
                this.bufferedEvents.addAll(changes);
            } else {
                this.updateEditStatus(new EditStatus(EditState.ERROR, "Too many buffered LE keystrokes. Redeploy app.", null));
            }
            return true;
        }
        return this.processChanges(project, changes, LiveEditEvent.Mode.AUTO);
    }

    @Trace
    private boolean processChanges(Project project, List<EditEvent> changes, LiveEditEvent.Mode mode) {
        LiveEditEvent.Builder event = LiveEditEvent.newBuilder().setMode(mode);
        long start2 = System.nanoTime();
        ArrayList<AndroidLiveEditCodeGenerator.CodeGeneratorOutput> compiled = new ArrayList<AndroidLiveEditCodeGenerator.CodeGeneratorOutput>();
        try {
            PrebuildChecksKt.PrebuildChecks(project, changes);
            List<AndroidLiveEditCodeGenerator.CodeGeneratorInput> inputs = changes.stream().map(change -> new AndroidLiveEditCodeGenerator.CodeGeneratorInput(change.getFile(), change.getOrigin(), change.getParentGroup())).collect(Collectors.toList());
            if (!new AndroidLiveEditCodeGenerator(project, this.sourceInlineCandidateCache).compile(inputs, compiled, !LiveEditService.isLeTriggerManual())) {
                return false;
            }
            for (EditEvent change2 : changes) {
                this.filesWithCompilationErrors.remove(change2.getFile().getName());
            }
        }
        catch (LiveEditUpdateException e) {
            boolean recoverable = e.getError().getRecoverable();
            if (recoverable) {
                this.filesWithCompilationErrors.add(e.getSource().getName());
            }
            this.updateEditStatus(new EditStatus(recoverable ? EditState.PAUSED : EditState.ERROR, ErrorReporterKt.errorMessage(e), null));
            return true;
        }
        event.setHasNonCompose(compiled.stream().anyMatch(c -> c.getFunctionType() == AndroidLiveEditCodeGenerator.FunctionType.KOTLIN));
        long compileFinish = System.nanoTime();
        event.setCompileDurationMs(TimeUnit.NANOSECONDS.toMillis(compileFinish - start2));
        LOGGER.info("LiveEdit compile completed in %dms", new Object[]{event.getCompileDurationMs()});
        Optional error = AndroidLiveEditDeployMonitor.deviceIterator(project).map(device2 -> this.pushUpdatesToDevice(this.applicationId, (IDevice)device2, (List<AndroidLiveEditCodeGenerator.CodeGeneratorOutput>)compiled)).flatMap(Collection::stream).findFirst();
        if (error.isPresent()) {
            event.setStatus(AndroidLiveEditDeployMonitor.errorToStatus((LiveUpdateDeployer.UpdateLiveEditError)error.get()));
        } else {
            event.setStatus(LiveEditEvent.Status.SUCCESS);
        }
        long pushFinish = System.nanoTime();
        event.setPushDurationMs(TimeUnit.NANOSECONDS.toMillis(pushFinish - compileFinish));
        LOGGER.info("LiveEdit push completed in %dms", new Object[]{event.getPushDurationMs()});
        AndroidLiveEditDeployMonitor.logLiveEditEvent(event);
        return true;
    }

    private void scheduleErrorPolling(LiveUpdateDeployer deployer, Installer installer, AdbClient adb, String packageName2) {
        ScheduledExecutorService scheduler = JobScheduler.getScheduler();
        ScheduledFuture<?> statusPolling = scheduler.scheduleWithFixedDelay(() -> {
            boolean hasError;
            boolean bl = hasError = !deployer.retrieveComposeStatus(installer, adb, packageName2);
            if (hasError) {
                this.updateEditStatus(RECOMPOSE_ERROR);
            }
        }, 2L, 2L, TimeUnit.SECONDS);
        scheduler.schedule(() -> statusPolling.cancel(true), 10L, TimeUnit.SECONDS);
    }

    private static LiveEditEvent.Status errorToStatus(LiveUpdateDeployer.UpdateLiveEditError error) {
        switch (error.getType()) {
            case ADDED_METHOD: {
                return LiveEditEvent.Status.UNSUPPORTED_ADDED_METHOD;
            }
            case REMOVED_METHOD: {
                return LiveEditEvent.Status.UNSUPPORTED_REMOVED_METHOD;
            }
            case ADDED_CLASS: {
                return LiveEditEvent.Status.UNSUPPORTED_ADDED_CLASS;
            }
            case ADDED_FIELD: 
            case MODIFIED_FIELD: {
                return LiveEditEvent.Status.UNSUPPORTED_ADDED_FIELD;
            }
            case REMOVED_FIELD: {
                return LiveEditEvent.Status.UNSUPPORTED_REMOVED_FIELD;
            }
            case MODIFIED_SUPER: 
            case ADDED_INTERFACE: 
            case REMOVED_INTERFACE: {
                return LiveEditEvent.Status.UNSUPPORTED_MODIFY_INHERITANCE;
            }
            case UNSUPPORTED_COMPOSE_VERSION: {
                return LiveEditEvent.Status.UNKNOWN;
            }
        }
        return LiveEditEvent.Status.UNKNOWN;
    }

    private static void logLiveEditEvent(LiveEditEvent.Builder event) {
        if (random.nextDouble() < 0.1) {
            UsageTracker.log((AndroidStudioEvent.Builder)AndroidStudioEvent.newBuilder().setCategory(AndroidStudioEvent.EventCategory.DEPLOYMENT).setKind(AndroidStudioEvent.EventKind.LIVE_EDIT_EVENT).setLiveEditEvent(event));
        }
    }

    private void updateEditStatus(@NotNull IDevice device2, @NotNull EditStatus status2) {
        this.editStatus.put(device2, status2);
        ActivityTracker.getInstance().inc();
    }

    private void updateEditStatus(@NotNull EditStatus status2) {
        this.editStatus.replaceAll((device2, oldStatus) -> status2);
        ActivityTracker.getInstance().inc();
    }

    @NotNull
    public EditStatus mergeStatuses(@NotNull Map<IDevice, EditStatus> editStatus2) {
        if (StringUtil.isEmpty((String)this.applicationId)) {
            return LiveEditService.DISABLED_STATUS;
        }
        Set devices2 = AndroidLiveEditDeployMonitor.deviceIterator(this.project).filter(d -> Arrays.stream(d.getClients()).anyMatch(c -> this.applicationId.equals(c.getClientData().getPackageName()))).collect(Collectors.toSet());
        HashSet<IDevice> keys = new HashSet<IDevice>(editStatus2.keySet());
        keys.retainAll(devices2);
        List statuses = editStatus2.entrySet().stream().filter(e -> keys.contains(e.getKey())).map(Map.Entry::getValue).collect(Collectors.toList());
        EditStatus mergedStatus = LiveEditService.DISABLED_STATUS;
        for (EditStatus status2 : statuses) {
            if (status2.getEditState().ordinal() >= mergedStatus.getEditState().ordinal()) continue;
            mergedStatus = status2;
        }
        return mergedStatus;
    }

    private static Stream<IDevice> deviceIterator(Project project) {
        List<AndroidSessionInfo> sessions = AndroidSessionInfo.findActiveSession(project);
        if (sessions == null) {
            LOGGER.info("No running session found for %s", new Object[]{project.getName()});
            return Stream.empty();
        }
        return sessions.stream().map(AndroidSessionInfo::getExecutionTarget).filter(t -> t instanceof AndroidExecutionTarget).flatMap(t -> ((AndroidExecutionTarget)((Object)t)).getRunningDevices().stream()).filter(AndroidLiveEditDeployMonitor::supportLiveEdits);
    }

    private static Installer newInstaller(IDevice device2) {
        MetricsRecorder metrics = new MetricsRecorder();
        AdbClient adb = new AdbClient(device2, (ILogger)LOGGER);
        return new AdbInstaller(AndroidLiveEditDeployMonitor.getLocalInstaller(), adb, (Collection)metrics.getDeployMetrics(), (ILogger)LOGGER, AdbInstaller.Mode.DAEMON);
    }

    public void sendRecomposeRequest() {
        this.updateEditStatus(UPDATE_IN_PROGRESS);
        this.methodChangesExecutor.schedule(this::doSendRecomposeRequest, 0L, TimeUnit.MILLISECONDS);
    }

    private void doSendRecomposeRequest() {
        try {
            AndroidLiveEditDeployMonitor.deviceIterator(this.project).forEach(device2 -> this.sendRecomposeRequests((IDevice)device2));
        }
        finally {
            this.updateEditStatus(UP_TO_DATE);
        }
    }

    private void sendRecomposeRequests(IDevice device2) {
        LiveUpdateDeployer deployer = new LiveUpdateDeployer((ILogger)LOGGER);
        Installer installer = AndroidLiveEditDeployMonitor.newInstaller(device2);
        AdbClient adb = new AdbClient(device2, (ILogger)LOGGER);
        deployer.recompose(installer, adb, this.applicationId);
        this.scheduleErrorPolling(deployer, installer, adb, this.applicationId);
    }

    private List<LiveUpdateDeployer.UpdateLiveEditError> pushUpdatesToDevice(String applicationId2, IDevice device2, List<AndroidLiveEditCodeGenerator.CodeGeneratorOutput> updates) {
        LiveUpdateDeployer deployer = new LiveUpdateDeployer((ILogger)LOGGER);
        Installer installer = AndroidLiveEditDeployMonitor.newInstaller(device2);
        AdbClient adb = new AdbClient(device2, (ILogger)LOGGER);
        ArrayList<LiveUpdateDeployer.UpdateLiveEditError> results = new ArrayList<LiveUpdateDeployer.UpdateLiveEditError>();
        boolean recomposeNeeded = false;
        for (AndroidLiveEditCodeGenerator.CodeGeneratorOutput update2 : updates) {
            boolean useDebugMode = LiveEditAdvancedConfiguration.getInstance().getUseDebugMode();
            boolean usePartialRecompose = LiveEditAdvancedConfiguration.getInstance().getUsePartialRecompose() && (update2.getFunctionType() == AndroidLiveEditCodeGenerator.FunctionType.COMPOSABLE || update2.getHasGroupId());
            boolean recomposeAfterPriming = true;
            LiveUpdateDeployer.UpdateLiveEditsParam param = new LiveUpdateDeployer.UpdateLiveEditsParam(update2.getClassName(), update2.getMethodName(), update2.getMethodDesc(), usePartialRecompose, update2.getGroupId(), update2.getClassData(), update2.getSupportClasses(), useDebugMode, recomposeAfterPriming);
            if (useDebugMode) {
                AndroidLiveEditDeployMonitor.writeDebugToTmp(update2.getClassName().replaceAll("/", ".") + ".class", update2.getClassData());
                for (String supportClassName : update2.getSupportClasses().keySet()) {
                    byte[] bytecode = update2.getSupportClasses().get(supportClassName);
                    AndroidLiveEditDeployMonitor.writeDebugToTmp(supportClassName.replaceAll("/", ".") + ".class", bytecode);
                }
            }
            LiveUpdateDeployer.UpdateLiveEditResult result2 = deployer.updateLiveEdit(installer, adb, applicationId2, param);
            if (LiveEditService.Companion.isLeTriggerManual() && result2.recomposeType == Deploy.AgentLiveEditResponse.RecomposeType.RESET_SKIPPED) {
                recomposeNeeded = true;
            }
            results.addAll(result2.errors);
        }
        if (recomposeNeeded) {
            this.updateEditStatus(device2, RECOMPOSE_NEEDED);
        } else {
            if (this.filesWithCompilationErrors.isEmpty()) {
                this.updateEditStatus(device2, UP_TO_DATE);
            } else {
                Optional errorFilename = ((Stream)this.filesWithCompilationErrors.stream().sequential()).findFirst();
                String errorMsg = ErrorReporterKt.leErrorMessage(LiveEditUpdateException.Error.COMPILATION_ERROR, (String)errorFilename.get());
                this.updateEditStatus(device2, new EditStatus(EditState.PAUSED, errorMsg, null));
            }
            this.scheduleErrorPolling(deployer, installer, adb, applicationId2);
        }
        if (!results.isEmpty()) {
            LiveUpdateDeployer.UpdateLiveEditError firstProblem = (LiveUpdateDeployer.UpdateLiveEditError)results.get(0);
            if (firstProblem.getType() == Deploy.UnsupportedChange.Type.UNSUPPORTED_COMPOSE_VERSION) {
                this.updateEditStatus(device2, new EditStatus(EditState.COMPOSE_VERSION_ERROR, firstProblem.getMessage(), null));
            } else {
                this.updateEditStatus(device2, new EditStatus(EditState.ERROR, firstProblem.getMessage(), null));
            }
        }
        return results;
    }

    private static void writeDebugToTmp(String name, byte[] data2) {
        String tmpPath = System.getProperty("java.io.tmpdir");
        if (tmpPath == null) {
            return;
        }
        Path path2 = Paths.get(tmpPath, name);
        try {
            Files.write(path2, data2, new OpenOption[0]);
            LOGGER.info("Wrote debug file at '%s'", new Object[]{path2.toAbsolutePath()});
        }
        catch (IOException e) {
            LOGGER.info("Unable to write debug file '%s'", new Object[]{path2.toAbsolutePath()});
        }
    }

    private static boolean supportLiveEdits(IDevice device2) {
        return device2.getVersion().isGreaterOrEqualThan(30);
    }

    private static String getLocalInstaller() {
        Path path2 = StudioPathManager.isRunningFromSources() ? StudioPathManager.resolvePathFromSourcesRoot((String)"bazel-bin/tools/base/deploy/installer/android-installer") : Paths.get(PathManager.getHomePath(), "plugins/android/resources/installer");
        return path2.toString();
    }

    @VisibleForTesting
    public class EditsListener
    implements Disposable {
        private final ConcurrentLinkedQueue<EditEvent> changedMethodQueue = new ConcurrentLinkedQueue();

        public EditsListener() {
            AndroidLiveEditDeployMonitor.this.gradleTimeSync.set(GradleSyncState.getInstance(AndroidLiveEditDeployMonitor.this.project).getLastSyncFinishedTimeStamp());
        }

        public void dispose() {
            AndroidLiveEditDeployMonitor.this.editStatus.clear();
            AndroidLiveEditDeployMonitor.this.methodChangesExecutor.shutdownNow();
        }

        public void onLiteralsChanged(EditEvent event) {
            if (!LiveEditApplicationConfiguration.getInstance().isLiveEdit()) {
                return;
            }
            if (StringUtil.isEmpty((String)AndroidLiveEditDeployMonitor.this.applicationId)) {
                return;
            }
            if (AndroidLiveEditDeployMonitor.this.mergeStatuses(AndroidLiveEditDeployMonitor.this.editStatus).getEditState() == EditState.ERROR) {
                return;
            }
            if (GradleSyncState.getInstance(AndroidLiveEditDeployMonitor.this.project).isSyncNeeded() != ThreeState.NO || AndroidLiveEditDeployMonitor.this.gradleTimeSync.get().compareTo(GradleSyncState.getInstance(AndroidLiveEditDeployMonitor.this.project).getLastSyncFinishedTimeStamp()) != 0) {
                AndroidLiveEditDeployMonitor.this.updateEditStatus(GRADLE_SYNC_ERROR);
                return;
            }
            this.changedMethodQueue.add(event);
            AndroidLiveEditDeployMonitor.this.methodChangesExecutor.schedule(this::processChanges, (long)LiveEditAdvancedConfiguration.getInstance().getRefreshRateMs(), TimeUnit.MILLISECONDS);
        }

        private void processChanges() {
            if (this.changedMethodQueue.isEmpty()) {
                return;
            }
            ArrayList<EditEvent> copy = new ArrayList<EditEvent>();
            this.changedMethodQueue.removeIf(e -> {
                copy.add((EditEvent)e);
                return true;
            });
            AndroidLiveEditDeployMonitor.this.editStatus.replaceAll((key, status2) -> {
                switch (status2.getEditState()) {
                    case PAUSED: 
                    case UP_TO_DATE: 
                    case LOADING: 
                    case IN_PROGRESS: 
                    case RECOMPOSE_ERROR: {
                        return UPDATE_IN_PROGRESS;
                    }
                }
                return status2;
            });
            if (!AndroidLiveEditDeployMonitor.this.handleChangedMethods(AndroidLiveEditDeployMonitor.this.project, copy)) {
                this.changedMethodQueue.addAll(copy);
                AndroidLiveEditDeployMonitor.this.methodChangesExecutor.schedule(this::processChanges, (long)LiveEditAdvancedConfiguration.getInstance().getRefreshRateMs(), TimeUnit.MILLISECONDS);
            }
        }
    }

    private class EditStatusGetter
    implements LiveEditService.EditStatusProvider {
        private EditStatusGetter() {
        }

        @Override
        @NotNull
        public EditStatus status(@NotNull IDevice device2) {
            if (StringUtil.isEmpty((String)AndroidLiveEditDeployMonitor.this.applicationId)) {
                return LiveEditService.DISABLED_STATUS;
            }
            return AndroidLiveEditDeployMonitor.this.editStatus.compute(device2, (d, s) -> {
                EditStatus result2;
                if (!device2.isOnline()) {
                    result2 = LiveEditService.DISABLED_STATUS;
                } else {
                    List<AndroidSessionInfo> info2 = AndroidSessionInfo.findActiveSession(AndroidLiveEditDeployMonitor.this.project);
                    if (info2 != null && info2.stream().filter(i -> DefaultDebugExecutor.getDebugExecutorInstance().getId().equals(i.getExecutorId())).map(AndroidSessionInfo::getProcessHandler).filter(p -> p instanceof AndroidRemoteDebugProcessHandler).map(p -> (AndroidRemoteDebugProcessHandler)p).anyMatch(p -> !p.isProcessTerminating() && !p.isProcessTerminated() && p.isPackageRunning((IDevice)d, AndroidLiveEditDeployMonitor.this.applicationId))) {
                        result2 = DEBUGGER_ATTACHED;
                    } else {
                        boolean appAlive = Arrays.stream(device2.getClients()).anyMatch(c -> AndroidLiveEditDeployMonitor.this.applicationId.equals(c.getClientData().getPackageName()));
                        result2 = s == null ? LiveEditService.DISABLED_STATUS : (s == LOADING && appAlive ? UP_TO_DATE : (s != LOADING && !appAlive ? LiveEditService.DISABLED_STATUS : s));
                    }
                }
                return result2;
            });
        }

        @Override
        @NotNull
        public Map<IDevice, EditStatus> status() {
            if (StringUtil.isEmpty((String)AndroidLiveEditDeployMonitor.this.applicationId)) {
                return Collections.emptyMap();
            }
            Set devices2 = AndroidLiveEditDeployMonitor.deviceIterator(AndroidLiveEditDeployMonitor.this.project).filter(d -> Arrays.stream(d.getClients()).anyMatch(c -> AndroidLiveEditDeployMonitor.this.applicationId.equals(c.getClientData().getPackageName()))).collect(Collectors.toSet());
            return AndroidLiveEditDeployMonitor.this.editStatus.keySet().stream().filter(devices2::contains).collect(Collectors.toMap(d -> d, this::status));
        }

        @Override
        @NotNull
        public Set<IDevice> devices() {
            if (StringUtil.isEmpty((String)AndroidLiveEditDeployMonitor.this.applicationId)) {
                return Collections.emptySet();
            }
            return AndroidLiveEditDeployMonitor.deviceIterator(AndroidLiveEditDeployMonitor.this.project).filter(d -> Arrays.stream(d.getClients()).anyMatch(c -> AndroidLiveEditDeployMonitor.this.applicationId.equals(c.getClientData().getPackageName()))).collect(Collectors.toSet());
        }
    }
}

