/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.deployment;

import com.android.tools.idea.run.deployment.AsyncSupplier;
import com.intellij.openapi.diagnostic.Logger;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class Worker<V> {
    @Nullable
    private Future<V> myResultFuture;
    @Nullable
    private V myResult;

    Worker() {
    }

    @NotNull
    Optional<V> perform(@NotNull AsyncSupplier<V> task2) {
        if (this.myResultFuture == null) {
            this.myResultFuture = task2.get();
        }
        if (this.myResultFuture.isCancelled()) {
            this.myResultFuture = task2.get();
            return Optional.ofNullable(this.myResult);
        }
        if (!this.myResultFuture.isDone()) {
            return Optional.ofNullable(this.myResult);
        }
        try {
            this.myResult = this.myResultFuture.get();
            assert (this.myResult != null);
            this.myResultFuture = task2.get();
            return Optional.of(this.myResult);
        }
        catch (InterruptedException exception) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(exception);
        }
        catch (ExecutionException exception) {
            Logger.getInstance(Worker.class).warn((Throwable)exception);
            this.myResultFuture = task2.get();
            return Optional.ofNullable(this.myResult);
        }
    }
}

