/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.deployment;

import com.android.ddmlib.IDevice;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.run.AndroidDevice;
import com.android.tools.idea.run.DeploymentApplicationService;
import com.android.tools.idea.run.LaunchCompatibility;
import com.android.tools.idea.run.LaunchableAndroidDevice;
import com.android.tools.idea.run.deployment.BootWithSnapshotTarget;
import com.android.tools.idea.run.deployment.ColdBootTarget;
import com.android.tools.idea.run.deployment.ConnectedDevice;
import com.android.tools.idea.run.deployment.Device;
import com.android.tools.idea.run.deployment.Key;
import com.android.tools.idea.run.deployment.KeyToConnectionTimeMap;
import com.android.tools.idea.run.deployment.QuickBootTarget;
import com.android.tools.idea.run.deployment.RunningDeviceTarget;
import com.android.tools.idea.run.deployment.Snapshot;
import com.android.tools.idea.run.deployment.Target;
import com.android.tools.idea.run.deployment.VirtualDeviceName;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.Futures;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.ui.LayeredIcon;
import icons.StudioIcons;
import java.nio.file.Path;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Future;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class VirtualDevice
extends Device {
    private static final Icon ourPhoneIcon = StudioIcons.DeviceExplorer.VIRTUAL_DEVICE_PHONE;
    private static final Icon ourWearIcon = StudioIcons.DeviceExplorer.VIRTUAL_DEVICE_WEAR;
    private static final Icon ourTvIcon = StudioIcons.DeviceExplorer.VIRTUAL_DEVICE_TV;
    @Nullable
    private final VirtualDeviceName myNameKey;
    @NotNull
    private final @NotNull Collection<@NotNull Snapshot> mySnapshots;
    private final boolean mySelectDeviceSnapshotComboBoxSnapshotsEnabled;

    @NotNull
    static VirtualDevice newConnectedDevice(@NotNull ConnectedDevice connectedDevice, @NotNull KeyToConnectionTimeMap map2, @Nullable VirtualDevice virtualDevice) {
        VirtualDeviceName nameKey;
        Device device2;
        if (virtualDevice == null) {
            device2 = connectedDevice;
            nameKey = null;
        } else {
            device2 = virtualDevice;
            nameKey = virtualDevice.myNameKey;
        }
        Key key = device2.getKey();
        return new Builder().setName(device2.getName()).setLaunchCompatibility(connectedDevice.getLaunchCompatibility()).setKey(key).setConnectionTime(map2.get(key)).setAndroidDevice(connectedDevice.getAndroidDevice()).setNameKey(nameKey).addAllSnapshots(device2.getSnapshots()).setType(device2.getType()).build();
    }

    private VirtualDevice(@NotNull Builder builder2) {
        super(builder2);
        this.myNameKey = builder2.myNameKey;
        this.mySnapshots = new ArrayList<Snapshot>(builder2.mySnapshots);
        this.mySelectDeviceSnapshotComboBoxSnapshotsEnabled = builder2.mySelectDeviceSnapshotComboBoxSnapshotsEnabled;
    }

    @NotNull
    @NotNull Optional<@NotNull VirtualDeviceName> getNameKey() {
        return Optional.ofNullable(this.myNameKey);
    }

    void coldBoot(@NotNull Project project) {
        ((LaunchableAndroidDevice)this.getAndroidDevice()).coldBoot(project);
    }

    void quickBoot(@NotNull Project project) {
        ((LaunchableAndroidDevice)this.getAndroidDevice()).quickBoot(project);
    }

    void bootWithSnapshot(@NotNull Project project, @NotNull Path snapshot) {
        ((LaunchableAndroidDevice)this.getAndroidDevice()).bootWithSnapshot(project, snapshot.toString());
    }

    @Override
    @NotNull
    Icon getIcon() {
        Icon deviceIcon;
        switch (this.getType()) {
            case TV: {
                deviceIcon = ourTvIcon;
                break;
            }
            case WEAR: {
                deviceIcon = ourWearIcon;
                break;
            }
            case PHONE: {
                deviceIcon = ourPhoneIcon;
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected device type: " + this.getType());
            }
        }
        if (this.isConnected()) {
            deviceIcon = ExecutionUtil.getLiveIndicator((Icon)deviceIcon);
        }
        switch (this.getLaunchCompatibility().getState()) {
            case ERROR: {
                return new LayeredIcon(new Icon[]{deviceIcon, StudioIcons.Common.ERROR_DECORATOR});
            }
            case WARNING: {
                return new LayeredIcon(new Icon[]{deviceIcon, AllIcons.General.WarningDecorator});
            }
            case OK: {
                return deviceIcon;
            }
        }
        throw new IllegalStateException("Unexpected device state: " + this.getLaunchCompatibility().getState());
    }

    @Override
    boolean isConnected() {
        return this.getConnectionTime() != null;
    }

    @Override
    @NotNull
    @NotNull Collection<@NotNull Snapshot> getSnapshots() {
        return this.mySnapshots;
    }

    @Override
    @NotNull
    Target getDefaultTarget() {
        if (!this.mySelectDeviceSnapshotComboBoxSnapshotsEnabled) {
            return new QuickBootTarget(this.getKey());
        }
        if (this.isConnected()) {
            return new RunningDeviceTarget(this.getKey());
        }
        return new QuickBootTarget(this.getKey());
    }

    @Override
    @NotNull
    @NotNull Collection<@NotNull Target> getTargets() {
        if (!this.mySelectDeviceSnapshotComboBoxSnapshotsEnabled) {
            return Collections.singletonList(new QuickBootTarget(this.getKey()));
        }
        if (this.isConnected()) {
            return Collections.singletonList(new RunningDeviceTarget(this.getKey()));
        }
        if (this.mySnapshots.isEmpty()) {
            return Collections.singletonList(new QuickBootTarget(this.getKey()));
        }
        ArrayList<Target> targets = new ArrayList<Target>(2 + this.mySnapshots.size());
        Key deviceKey = this.getKey();
        targets.add(new ColdBootTarget(deviceKey));
        targets.add(new QuickBootTarget(deviceKey));
        this.mySnapshots.stream().map(Snapshot::getDirectory).map(snapshotKey -> new BootWithSnapshotTarget(deviceKey, (Path)snapshotKey)).forEach(targets::add);
        return targets;
    }

    @Override
    @NotNull
    Future<AndroidVersion> getAndroidVersion() {
        AndroidDevice androidDevice = this.getAndroidDevice();
        if (androidDevice instanceof LaunchableAndroidDevice) {
            return Futures.immediateFuture((Object)((LaunchableAndroidDevice)androidDevice).getAvdInfo().getAndroidVersion());
        }
        IDevice ddmlibDevice = this.getDdmlibDevice();
        assert (ddmlibDevice != null);
        return DeploymentApplicationService.getInstance().getVersion(ddmlibDevice);
    }

    public boolean equals(@Nullable Object object) {
        if (!(object instanceof VirtualDevice)) {
            return false;
        }
        VirtualDevice device2 = (VirtualDevice)object;
        return this.getName().equals(device2.getName()) && this.getType().equals((Object)device2.getType()) && this.getLaunchCompatibility().equals(device2.getLaunchCompatibility()) && this.getKey().equals(device2.getKey()) && Objects.equals(this.getConnectionTime(), device2.getConnectionTime()) && this.getAndroidDevice().equals(device2.getAndroidDevice()) && Objects.equals(this.myNameKey, device2.myNameKey) && this.mySnapshots.equals(device2.mySnapshots) && this.mySelectDeviceSnapshotComboBoxSnapshotsEnabled == device2.mySelectDeviceSnapshotComboBoxSnapshotsEnabled;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getName(), this.getType(), this.getLaunchCompatibility(), this.getKey(), this.getConnectionTime(), this.getAndroidDevice(), this.myNameKey, this.mySnapshots, this.mySelectDeviceSnapshotComboBoxSnapshotsEnabled});
    }

    static final class Builder
    extends Device.Builder {
        @Nullable
        private VirtualDeviceName myNameKey;
        @NotNull
        private final @NotNull Collection<@NotNull Snapshot> mySnapshots = new ArrayList<Snapshot>();
        private boolean mySelectDeviceSnapshotComboBoxSnapshotsEnabled = (Boolean)StudioFlags.SELECT_DEVICE_SNAPSHOT_COMBO_BOX_SNAPSHOTS_ENABLED.get();

        Builder() {
        }

        @NotNull
        Builder setName(@NotNull String name) {
            this.myName = name;
            return this;
        }

        @NotNull
        Builder setLaunchCompatibility(LaunchCompatibility launchCompatibility) {
            this.myLaunchCompatibility = launchCompatibility;
            return this;
        }

        @NotNull
        Builder setKey(@NotNull Key key) {
            this.myKey = key;
            return this;
        }

        @NotNull
        @VisibleForTesting
        Builder setConnectionTime(@NotNull Instant connectionTime) {
            this.myConnectionTime = connectionTime;
            return this;
        }

        @NotNull
        Builder setAndroidDevice(@NotNull AndroidDevice androidDevice) {
            this.myAndroidDevice = androidDevice;
            return this;
        }

        @NotNull
        Builder setNameKey(@Nullable VirtualDeviceName nameKey) {
            this.myNameKey = nameKey;
            return this;
        }

        @NotNull
        Builder addSnapshot(@NotNull Snapshot snapshot) {
            this.mySnapshots.add(snapshot);
            return this;
        }

        @NotNull
        Builder addAllSnapshots(@NotNull @NotNull Collection<@NotNull Snapshot> snapshots) {
            this.mySnapshots.addAll(snapshots);
            return this;
        }

        @NotNull
        Builder setSelectDeviceSnapshotComboBoxSnapshotsEnabled(boolean selectDeviceSnapshotComboBoxSnapshotsEnabled) {
            this.mySelectDeviceSnapshotComboBoxSnapshotsEnabled = selectDeviceSnapshotComboBoxSnapshotsEnabled;
            return this;
        }

        @NotNull
        Builder setType(@NotNull Device.Type type) {
            this.myType = type;
            return this;
        }

        @Override
        @NotNull
        VirtualDevice build() {
            return new VirtualDevice(this);
        }
    }
}

