/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.deployment;

import com.android.tools.idea.run.deployment.DeploymentCollections;
import com.android.tools.idea.run.deployment.Key;
import com.android.tools.idea.run.deployment.RunningDeviceTarget;
import com.android.tools.idea.run.deployment.Target;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class TargetsForWritingSupplier {
    @NotNull
    private final @NotNull Collection<@NotNull RunningDeviceTarget> myRunningDeviceTargets;
    @NotNull
    private final @NotNull Collection<@NotNull Target> myTargets;

    TargetsForWritingSupplier(@Nullable Target oldTarget, @Nullable Target newTarget) {
        this(DeploymentCollections.toList(oldTarget), DeploymentCollections.toList(newTarget));
    }

    TargetsForWritingSupplier(@NotNull @NotNull Collection<@NotNull Target> oldTargets, @NotNull @NotNull Collection<@NotNull Target> newTargets) {
        Map<Key, Target> keyToTargetMap = oldTargets.stream().collect(Collectors.toMap(Target::getDeviceKey, target2 -> target2));
        int size = newTargets.size();
        this.myRunningDeviceTargets = new ArrayList<RunningDeviceTarget>(size);
        this.myTargets = new ArrayList<Target>(size);
        newTargets.forEach(newTarget -> {
            if (newTarget instanceof RunningDeviceTarget) {
                Target oldTarget = (Target)keyToTargetMap.get(newTarget.getDeviceKey());
                if (oldTarget != null) {
                    this.myTargets.add(oldTarget);
                }
                this.myRunningDeviceTargets.add((RunningDeviceTarget)newTarget);
            } else {
                this.myTargets.add((Target)newTarget);
            }
        });
    }

    @NotNull
    @NotNull Optional<@NotNull RunningDeviceTarget> getDropDownRunningDeviceTarget() {
        return DeploymentCollections.toOptional(this.myRunningDeviceTargets);
    }

    @NotNull
    @NotNull Optional<@NotNull Target> getDropDownTarget() {
        return DeploymentCollections.toOptional(this.myTargets);
    }

    @NotNull
    @NotNull Collection<@NotNull RunningDeviceTarget> getDialogRunningDeviceTargets() {
        return this.myRunningDeviceTargets;
    }

    @NotNull
    @NotNull Collection<@NotNull Target> getDialogTargets() {
        return this.myTargets;
    }
}

