/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.deployment;

import com.android.tools.idea.run.deployment.Device;
import com.android.tools.idea.run.deployment.DeviceComparator;
import com.android.tools.idea.run.deployment.PhysicalDevice;
import com.android.tools.idea.run.deployment.SelectMultipleDevicesDialogTableModelRow;
import com.android.tools.idea.run.deployment.Target;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.swing.Icon;
import javax.swing.table.AbstractTableModel;
import org.jetbrains.annotations.NotNull;

final class SelectMultipleDevicesDialogTableModel
extends AbstractTableModel {
    static final int SELECTED_MODEL_COLUMN_INDEX = 0;
    static final int TYPE_MODEL_COLUMN_INDEX = 1;
    private static final int DEVICE_MODEL_COLUMN_INDEX = 2;
    private static final int SERIAL_NUMBER_MODEL_COLUMN_INDEX = 3;
    private static final int BOOT_OPTION_MODEL_COLUMN_INDEX = 4;
    @NotNull
    private final @NotNull List<@NotNull SelectMultipleDevicesDialogTableModelRow> myRows;
    @NotNull
    private final Multiset<String> myDeviceNameMultiset;

    SelectMultipleDevicesDialogTableModel(@NotNull @NotNull List<@NotNull Device> devices2, @NotNull BooleanSupplier selectDeviceSnapshotComboBoxSnapshotsEnabledGet) {
        devices2.sort(new DeviceComparator());
        this.myRows = new ArrayList<SelectMultipleDevicesDialogTableModelRow>();
        for (Device device2 : devices2) {
            for (Target target2 : device2.getTargets()) {
                this.myRows.add(new SelectMultipleDevicesDialogTableModelRow(device2, selectDeviceSnapshotComboBoxSnapshotsEnabledGet, target2));
            }
        }
        this.myDeviceNameMultiset = (Multiset)devices2.stream().map(Device::getName).collect(Collectors.toCollection(() -> HashMultiset.create((int)devices2.size())));
    }

    @NotNull
    @NotNull Set<@NotNull Target> getSelectedTargets() {
        return this.myRows.stream().filter(SelectMultipleDevicesDialogTableModelRow::isSelected).map(SelectMultipleDevicesDialogTableModelRow::getTarget).collect(Collectors.toSet());
    }

    void setSelectedTargets(@NotNull @NotNull Set<@NotNull Target> selectedTargets) {
        IntStream.range(0, this.myRows.size()).filter(modelRowIndex -> selectedTargets.contains(this.myRows.get(modelRowIndex).getTarget())).forEach(modelRowIndex -> this.setValueAt(true, modelRowIndex, 0));
    }

    @Override
    public int getRowCount() {
        return this.myRows.size();
    }

    @Override
    public int getColumnCount() {
        return 5;
    }

    @Override
    @NotNull
    public String getColumnName(int modelColumnIndex) {
        switch (modelColumnIndex) {
            case 0: {
                return "";
            }
            case 1: {
                return "Type";
            }
            case 2: {
                return "Device";
            }
            case 3: {
                return "Serial Number";
            }
            case 4: {
                return "Boot Option";
            }
        }
        throw new AssertionError(modelColumnIndex);
    }

    @Override
    @NotNull
    public Class<?> getColumnClass(int modelColumnIndex) {
        switch (modelColumnIndex) {
            case 0: {
                return Boolean.class;
            }
            case 1: {
                return Icon.class;
            }
            case 2: 
            case 3: 
            case 4: {
                return Object.class;
            }
        }
        throw new AssertionError(modelColumnIndex);
    }

    @Override
    public boolean isCellEditable(int modelRowIndex, int modelColumnIndex) {
        switch (modelColumnIndex) {
            case 0: {
                return true;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return false;
            }
        }
        throw new AssertionError(modelColumnIndex);
    }

    @Override
    @NotNull
    public Object getValueAt(int modelRowIndex, int modelColumnIndex) {
        switch (modelColumnIndex) {
            case 0: {
                return this.myRows.get(modelRowIndex).isSelected();
            }
            case 1: {
                return this.myRows.get(modelRowIndex).getDevice().getIcon();
            }
            case 2: {
                return this.myRows.get(modelRowIndex).getDeviceCellText();
            }
            case 3: {
                return this.getSerialNumber(this.myRows.get(modelRowIndex).getDevice());
            }
            case 4: {
                return this.myRows.get(modelRowIndex).getBootOption();
            }
        }
        throw new AssertionError(modelColumnIndex);
    }

    @NotNull
    private Object getSerialNumber(@NotNull Device device2) {
        if (!(device2 instanceof PhysicalDevice)) {
            return "";
        }
        if (this.myDeviceNameMultiset.count((Object)device2.getName()) != 1) {
            return device2.getKey().toString();
        }
        return "";
    }

    @Override
    public void setValueAt(@NotNull Object value2, int modelRowIndex, int modelColumnIndex) {
        this.myRows.get(modelRowIndex).setSelected((Boolean)value2);
        this.fireTableCellUpdated(modelRowIndex, modelColumnIndex);
    }
}

