/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.deployment;

import com.android.tools.idea.run.deployment.BooleanTableCellEditor;
import com.android.tools.idea.run.deployment.SelectMultipleDevicesDialogTableModel;
import com.android.tools.idea.run.deployment.Target;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;

final class SelectMultipleDevicesDialogTable
extends JBTable {
    SelectMultipleDevicesDialogTable() {
        JTableHeader header = this.getTableHeader();
        header.setReorderingAllowed(false);
        header.setResizingAllowed(false);
        this.setDefaultEditor(Boolean.class, new BooleanTableCellEditor());
        this.setRowHeight(JBUI.scale((int)40));
        this.setRowSelectionAllowed(false);
    }

    @NotNull
    @NotNull Set<@NotNull Target> getSelectedTargets() {
        return ((SelectMultipleDevicesDialogTableModel)this.dataModel).getSelectedTargets();
    }

    void setSelectedTargets(@NotNull @NotNull Set<@NotNull Target> selectedTargets) {
        ((SelectMultipleDevicesDialogTableModel)this.dataModel).setSelectedTargets(selectedTargets);
    }

    boolean isSelected(int viewRowIndex) {
        int modelRowIndex = this.convertRowIndexToModel(viewRowIndex);
        return (Boolean)this.dataModel.getValueAt(modelRowIndex, 0);
    }

    @VisibleForTesting
    void setSelected(boolean selected, int viewRowIndex) {
        this.dataModel.setValueAt(selected, this.convertRowIndexToModel(viewRowIndex), 0);
    }

    @NotNull
    @VisibleForTesting
    List<List<Object>> getData() {
        ArrayList<List<Object>> data2 = new ArrayList<List<Object>>(1 + this.getRowCount());
        List columnNames = IntStream.range(0, this.getColumnCount()).mapToObj(arg_0 -> this.getColumnName(arg_0)).collect(Collectors.toList());
        data2.add(columnNames);
        IntStream.range(0, this.getRowCount()).mapToObj(this::getRowAt).forEach(data2::add);
        return data2;
    }

    @NotNull
    private List<Object> getRowAt(int viewRowIndex) {
        return IntStream.range(0, this.getColumnCount()).mapToObj(viewColumnIndex -> this.getValueAt(viewRowIndex, viewColumnIndex)).collect(Collectors.toList());
    }

    public void setModel(@NotNull TableModel model2) {
        super.setModel(model2);
        if (this.tableHeader == null) {
            return;
        }
        if (this.getColumnCount() == 0) {
            return;
        }
        this.setSelectedAndIconColumnMaxWidthsToFit();
    }

    private void setSelectedAndIconColumnMaxWidthsToFit() {
        this.setMaxWidthToFit(this.convertColumnIndexToView(0));
        this.setMaxWidthToFit(this.convertColumnIndexToView(1));
    }

    private void setMaxWidthToFit(int viewColumnIndex) {
        OptionalInt maxPreferredWidth = IntStream.range(-1, this.getRowCount()).map(viewRowIndex -> this.getPreferredWidth(viewRowIndex, viewColumnIndex)).max();
        maxPreferredWidth.ifPresent(this.getColumnModel().getColumn(viewColumnIndex)::setMaxWidth);
    }

    private int getPreferredWidth(int viewRowIndex, int viewColumnIndex) {
        Component component2;
        if (viewRowIndex == -1) {
            String name = this.getColumnName(viewColumnIndex);
            component2 = this.getTableHeader().getDefaultRenderer().getTableCellRendererComponent((JTable)((Object)this), name, false, false, -1, viewColumnIndex);
        } else {
            component2 = this.prepareRenderer(this.getCellRenderer(viewRowIndex, viewColumnIndex), viewRowIndex, viewColumnIndex);
        }
        return component2.getPreferredSize().width + JBUI.scale((int)8);
    }

    public void createDefaultColumnsFromModel() {
        while (this.columnModel.getColumnCount() != 0) {
            this.columnModel.removeColumn(this.columnModel.getColumn(0));
        }
        IntStream.range(0, this.dataModel.getColumnCount()).filter(this::notAllValuesEqualEmptyString).mapToObj(TableColumn::new).forEach(arg_0 -> this.addColumn(arg_0));
    }

    private boolean notAllValuesEqualEmptyString(int modelColumnIndex) {
        return !IntStream.range(0, this.dataModel.getRowCount()).mapToObj(modelRowIndex -> this.dataModel.getValueAt(modelRowIndex, modelColumnIndex)).allMatch(Predicate.isEqual(""));
    }
}

