/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.deployment;

import com.android.tools.idea.run.deployment.AsyncDevicesGetter;
import com.android.tools.idea.run.deployment.DeviceAndSnapshotComboBoxAction;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.serviceContainer.NonInjectable;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

final class SelectMultipleDevicesAction
extends AnAction {
    static final String ID = "SelectMultipleDevices";
    @NotNull
    private final @NotNull Function<@NotNull Project, @NotNull AsyncDevicesGetter> myAsyncDevicesGetterGetInstance;

    private SelectMultipleDevicesAction() {
        this(AsyncDevicesGetter::getInstance);
    }

    @NonInjectable
    @VisibleForTesting
    SelectMultipleDevicesAction(@NotNull @NotNull Function<@NotNull Project, @NotNull AsyncDevicesGetter> asyncDevicesGetterGetInstance) {
        this.myAsyncDevicesGetterGetInstance = asyncDevicesGetterGetInstance;
    }

    public void update(@NotNull AnActionEvent event) {
        Project project = event.getProject();
        Presentation presentation = event.getPresentation();
        if (project == null) {
            presentation.setEnabledAndVisible(false);
            return;
        }
        boolean empty = this.myAsyncDevicesGetterGetInstance.apply(project).get().map(Collection::isEmpty).orElse(true);
        presentation.setEnabledAndVisible(!empty);
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        DeviceAndSnapshotComboBoxAction.getInstance().selectMultipleDevices(Objects.requireNonNull(event.getProject()));
    }
}

