/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.deployment;

import com.android.tools.idea.run.deployment.Device;
import com.android.tools.idea.run.deployment.DeviceAndSnapshotComboBoxAction;
import com.android.tools.idea.run.deployment.SelectDeviceAction;
import com.android.tools.idea.run.deployment.SnapshotActionGroup;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

final class PopupActionGroup
extends DefaultActionGroup {
    @NotNull
    private final Collection<Device> myDevices;
    @NotNull
    private final DeviceAndSnapshotComboBoxAction myComboBoxAction;
    @NotNull
    private final ActionManager myManager;

    PopupActionGroup(@NotNull Collection<Device> devices2, @NotNull DeviceAndSnapshotComboBoxAction comboBoxAction) {
        this(devices2, comboBoxAction, ActionManager.getInstance());
    }

    @VisibleForTesting
    PopupActionGroup(@NotNull @NotNull Collection<@NotNull Device> devices2, @NotNull DeviceAndSnapshotComboBoxAction comboBoxAction, @NotNull ActionManager manager) {
        this.myDevices = devices2;
        this.myComboBoxAction = comboBoxAction;
        this.myManager = manager;
        Collection<AnAction> actions2 = comboBoxAction.areSnapshotsEnabled() ? this.newSelectDeviceActionsOrSnapshotActionGroups() : this.newSelectDeviceActions();
        this.addAll(actions2);
        if (!actions2.isEmpty()) {
            this.addSeparator();
        }
        this.add(manager.getAction("SelectMultipleDevices"));
        this.add(manager.getAction("Android.AdbDevicePairing"));
        this.add(manager.getAction("Android.WearDevicePairing"));
        this.add(manager.getAction("Android.DeviceManager"));
        AnAction action2 = manager.getAction("DeveloperServices.ConnectionAssistant");
        if (action2 == null) {
            return;
        }
        this.addSeparator();
        this.add(action2);
    }

    @NotNull
    private @NotNull Collection<@NotNull AnAction> newSelectDeviceActionsOrSnapshotActionGroups() {
        boolean availableDevicesPresent;
        int size = this.myDevices.size();
        ArrayList<Device> runningDevices = new ArrayList<Device>(size);
        ArrayList<Device> availableDevices = new ArrayList<Device>(size);
        for (Device device2 : this.myDevices) {
            if (device2.isConnected()) {
                runningDevices.add(device2);
                continue;
            }
            availableDevices.add(device2);
        }
        boolean runningDevicesPresent = !runningDevices.isEmpty();
        ArrayList<AnAction> actions2 = new ArrayList<AnAction>(3 + size);
        if (runningDevicesPresent) {
            actions2.add(this.myManager.getAction("RunningDevices"));
        }
        runningDevices.stream().map(this::newSelectDeviceAction).forEach(actions2::add);
        boolean bl = availableDevicesPresent = !availableDevices.isEmpty();
        if (runningDevicesPresent && availableDevicesPresent) {
            actions2.add((AnAction)Separator.create());
        }
        if (availableDevicesPresent) {
            actions2.add(this.myManager.getAction("AvailableDevices"));
        }
        availableDevices.stream().map(this::newSelectDeviceActionOrSnapshotActionGroup).forEach(actions2::add);
        return actions2;
    }

    @NotNull
    private AnAction newSelectDeviceActionOrSnapshotActionGroup(@NotNull Device device2) {
        if (!device2.getSnapshots().isEmpty()) {
            return new SnapshotActionGroup(device2, this.myComboBoxAction);
        }
        return this.newSelectDeviceAction(device2);
    }

    @NotNull
    private Collection<AnAction> newSelectDeviceActions() {
        boolean availableDevicesPresent;
        List runningDevices = ContainerUtil.filter(this.myDevices, Device::isConnected);
        List availableDevices = ContainerUtil.filter(this.myDevices, device2 -> !device2.isConnected());
        boolean runningDevicesPresent = !runningDevices.isEmpty();
        ArrayList<AnAction> actions2 = new ArrayList<AnAction>(1 + runningDevices.size() + 2 + availableDevices.size());
        if (runningDevicesPresent) {
            actions2.add(this.myManager.getAction("RunningDevices"));
        }
        runningDevices.stream().map(this::newSelectDeviceAction).forEach(actions2::add);
        boolean bl = availableDevicesPresent = !availableDevices.isEmpty();
        if (runningDevicesPresent && availableDevicesPresent) {
            actions2.add((AnAction)Separator.create());
        }
        if (availableDevicesPresent) {
            actions2.add(this.myManager.getAction("AvailableDevices"));
        }
        availableDevices.stream().map(this::newSelectDeviceAction).forEach(actions2::add);
        return actions2;
    }

    @NotNull
    private AnAction newSelectDeviceAction(@NotNull Device device2) {
        return new SelectDeviceAction(device2, this.myComboBoxAction);
    }
}

