/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.deployment;

import com.android.ddmlib.IDevice;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.run.AndroidDevice;
import com.android.tools.idea.run.DeploymentApplicationService;
import com.android.tools.idea.run.LaunchCompatibility;
import com.android.tools.idea.run.deployment.ConnectedDevice;
import com.android.tools.idea.run.deployment.Device;
import com.android.tools.idea.run.deployment.Key;
import com.android.tools.idea.run.deployment.KeyToConnectionTimeMap;
import com.android.tools.idea.run.deployment.RunningDeviceTarget;
import com.android.tools.idea.run.deployment.Snapshot;
import com.android.tools.idea.run.deployment.Target;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.icons.AllIcons;
import com.intellij.ui.LayeredIcon;
import icons.StudioIcons;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.concurrent.Future;
import java.util.function.Function;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class PhysicalDevice
extends Device {
    private static final Icon ourPhoneIcon = ExecutionUtil.getLiveIndicator((Icon)StudioIcons.DeviceExplorer.PHYSICAL_DEVICE_PHONE);
    private static final Icon ourWearIcon = ExecutionUtil.getLiveIndicator((Icon)StudioIcons.DeviceExplorer.PHYSICAL_DEVICE_WEAR);
    private static final Icon ourTvIcon = ExecutionUtil.getLiveIndicator((Icon)StudioIcons.DeviceExplorer.PHYSICAL_DEVICE_TV);

    @NotNull
    static PhysicalDevice newDevice(@NotNull ConnectedDevice device2, @NotNull Function<ConnectedDevice, String> getName, @NotNull KeyToConnectionTimeMap map2) {
        Key key = device2.getKey();
        return new Builder().setName(getName.apply(device2)).setLaunchCompatibility(device2.getLaunchCompatibility()).setKey(key).setConnectionTime(map2.get(key)).setAndroidDevice(device2.getAndroidDevice()).setType(device2.getType()).build();
    }

    private PhysicalDevice(@NotNull Builder builder2) {
        super(builder2);
    }

    @Override
    @NotNull
    Icon getIcon() {
        Icon deviceIcon;
        switch (this.getType()) {
            case TV: {
                deviceIcon = ourTvIcon;
                break;
            }
            case WEAR: {
                deviceIcon = ourWearIcon;
                break;
            }
            case PHONE: {
                deviceIcon = ourPhoneIcon;
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected device type: " + this.getType());
            }
        }
        switch (this.getLaunchCompatibility().getState()) {
            case ERROR: {
                return new LayeredIcon(new Icon[]{deviceIcon, StudioIcons.Common.ERROR_DECORATOR});
            }
            case WARNING: {
                return new LayeredIcon(new Icon[]{deviceIcon, AllIcons.General.WarningDecorator});
            }
            case OK: {
                return deviceIcon;
            }
        }
        throw new IllegalStateException("Unexpected device state: " + this.getLaunchCompatibility().getState());
    }

    @Override
    boolean isConnected() {
        return true;
    }

    @Override
    @NotNull
    @NotNull Collection<@NotNull Snapshot> getSnapshots() {
        return Collections.emptyList();
    }

    @Override
    @NotNull
    Target getDefaultTarget() {
        return new RunningDeviceTarget(this.getKey());
    }

    @Override
    @NotNull
    @NotNull Collection<@NotNull Target> getTargets() {
        return Collections.singletonList(new RunningDeviceTarget(this.getKey()));
    }

    @Override
    @NotNull
    Future<AndroidVersion> getAndroidVersion() {
        IDevice device2 = this.getDdmlibDevice();
        assert (device2 != null);
        return DeploymentApplicationService.getInstance().getVersion(device2);
    }

    public boolean equals(@Nullable Object object) {
        if (!(object instanceof PhysicalDevice)) {
            return false;
        }
        Device device2 = (Device)object;
        return this.getName().equals(device2.getName()) && this.getType().equals((Object)device2.getType()) && this.getLaunchCompatibility().equals(device2.getLaunchCompatibility()) && this.getKey().equals(device2.getKey()) && Objects.equals(this.getConnectionTime(), device2.getConnectionTime()) && this.getAndroidDevice().equals(device2.getAndroidDevice());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getName(), this.getType(), this.getLaunchCompatibility(), this.getKey(), this.getConnectionTime(), this.getAndroidDevice()});
    }

    @VisibleForTesting
    static final class Builder
    extends Device.Builder {
        Builder() {
        }

        @NotNull
        @VisibleForTesting
        Builder setName(@NotNull String name) {
            this.myName = name;
            return this;
        }

        @NotNull
        Builder setLaunchCompatibility(@NotNull LaunchCompatibility launchCompatibility) {
            this.myLaunchCompatibility = launchCompatibility;
            return this;
        }

        @NotNull
        @VisibleForTesting
        Builder setKey(@NotNull Key key) {
            this.myKey = key;
            return this;
        }

        @NotNull
        @VisibleForTesting
        Builder setConnectionTime(@NotNull Instant connectionTime) {
            this.myConnectionTime = connectionTime;
            return this;
        }

        @NotNull
        @VisibleForTesting
        Builder setAndroidDevice(@NotNull AndroidDevice androidDevice) {
            this.myAndroidDevice = androidDevice;
            return this;
        }

        @NotNull
        Builder setType(@NotNull Device.Type type) {
            this.myType = type;
            return this;
        }

        @Override
        @NotNull
        PhysicalDevice build() {
            return new PhysicalDevice(this);
        }
    }
}

