/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.deployment;

import com.android.tools.idea.run.deployment.DeviceAndSnapshotComboBoxExecutionTarget;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.ExecutionTargetManager;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.serviceContainer.NonInjectable;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

final class ExecutionTargetService {
    @NotNull
    private final Project myProject;
    @NotNull
    private final Function<Project, ExecutionTargetManager> myExecutionTargetManagerGetInstance;
    @NotNull
    private final Function<Project, RunManager> myRunManagerGetInstance;

    private ExecutionTargetService(@NotNull Project project) {
        this(project, ExecutionTargetManager::getInstance, RunManager::getInstance);
    }

    @NonInjectable
    @VisibleForTesting
    ExecutionTargetService(@NotNull Project project, @NotNull Function<Project, ExecutionTargetManager> executionTargetManagerGetInstance, @NotNull Function<Project, RunManager> runManagerGetInstance) {
        this.myProject = project;
        this.myExecutionTargetManagerGetInstance = executionTargetManagerGetInstance;
        this.myRunManagerGetInstance = runManagerGetInstance;
    }

    @NotNull
    static ExecutionTargetService getInstance(@NotNull Project project) {
        return (ExecutionTargetService)project.getService(ExecutionTargetService.class);
    }

    @VisibleForTesting
    DeviceAndSnapshotComboBoxExecutionTarget getActiveTarget() {
        return (DeviceAndSnapshotComboBoxExecutionTarget)this.myExecutionTargetManagerGetInstance.apply(this.myProject).getActiveTarget();
    }

    void setActiveTarget(@NotNull DeviceAndSnapshotComboBoxExecutionTarget target2) {
        ExecutionTargetManager executionTargetManager = this.myExecutionTargetManagerGetInstance.apply(this.myProject);
        if (executionTargetManager.getActiveTarget().equals((Object)target2)) {
            return;
        }
        ApplicationManager.getApplication().invokeAndWait(() -> {
            RunManager runManager = this.myRunManagerGetInstance.apply(this.myProject);
            RunnerAndConfigurationSettings settings = runManager.getSelectedConfiguration();
            if (settings == null || runManager.findSettings(settings.getConfiguration()) == null) {
                return;
            }
            executionTargetManager.setActiveTarget((ExecutionTarget)target2);
        });
    }
}

