/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.deployment;

import com.android.tools.idea.run.deployment.BootWithSnapshotTarget;
import com.android.tools.idea.run.deployment.ColdBootTarget;
import com.android.tools.idea.run.deployment.Device;
import com.android.tools.idea.run.deployment.DevicesSelectedServiceException;
import com.android.tools.idea.run.deployment.Key;
import com.android.tools.idea.run.deployment.QuickBootTarget;
import com.android.tools.idea.run.deployment.RunningDeviceTarget;
import com.android.tools.idea.run.deployment.SerialNumber;
import com.android.tools.idea.run.deployment.Target;
import com.android.tools.idea.run.deployment.TargetsForReadingSupplier;
import com.android.tools.idea.run.deployment.TargetsForWritingSupplier;
import com.android.tools.idea.run.deployment.VirtualDeviceName;
import com.android.tools.idea.run.deployment.VirtualDevicePath;
import com.android.tools.idea.run.util.InstantConverter;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.serviceContainer.NonInjectable;
import com.intellij.util.xmlb.Converter;
import com.intellij.util.xmlb.annotations.OptionTag;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.XCollection;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.time.Clock;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class DevicesSelectedService {
    @NotNull
    private final PersistentStateComponent myPersistentStateComponent;
    @NotNull
    private final Clock myClock;

    private DevicesSelectedService(@NotNull Project project) {
        this((PersistentStateComponent)project.getService(PersistentStateComponent.class), Clock.systemDefaultZone());
    }

    @NonInjectable
    @VisibleForTesting
    DevicesSelectedService(@NotNull PersistentStateComponent persistentStateComponent, @NotNull Clock clock) {
        this.myPersistentStateComponent = persistentStateComponent;
        this.myClock = clock;
    }

    @NotNull
    static DevicesSelectedService getInstance(@NotNull Project project) {
        return (DevicesSelectedService)project.getService(DevicesSelectedService.class);
    }

    @NotNull
    @NotNull Optional<@NotNull Target> getTargetSelectedWithComboBox(@NotNull @NotNull List<@NotNull Device> devices2) {
        Target target2;
        if (devices2.isEmpty()) {
            return Optional.empty();
        }
        State state2 = this.myPersistentStateComponent.getState();
        TargetsForReadingSupplier supplier2 = new TargetsForReadingSupplier(devices2, state2.getRunningDeviceTargetSelectedWithDropDown(), state2.getTargetSelectedWithDropDown());
        if (supplier2.getDropDownRunningDeviceTargetToRemove().isPresent()) {
            state2.runningDeviceTargetSelectedWithDropDown = null;
            if (state2.targetSelectedWithDropDown == null) {
                state2.timeTargetWasSelectedWithDropDown = null;
            }
        }
        if ((target2 = (Target)supplier2.getDropDownTarget().orElse(null)) == null) {
            return Optional.of(devices2.get(0).getDefaultTarget());
        }
        Optional<Device> optionalSelectedDevice = devices2.stream().filter(target2::matches).findFirst();
        if (!optionalSelectedDevice.isPresent()) {
            return Optional.of(devices2.get(0).getDefaultTarget());
        }
        Optional<Device> optionalConnectedDevice = devices2.stream().filter(Device::isConnected).findFirst();
        if (!optionalConnectedDevice.isPresent()) {
            return Optional.of(target2);
        }
        Device connectedDevice = optionalConnectedDevice.get();
        assert (state2.timeTargetWasSelectedWithDropDown != null);
        Instant connectionTime = connectedDevice.getConnectionTime();
        assert (connectionTime != null);
        if (state2.timeTargetWasSelectedWithDropDown.isBefore(connectionTime)) {
            return Optional.of(connectedDevice.getDefaultTarget());
        }
        return Optional.of(target2);
    }

    void setTargetSelectedWithComboBox(@Nullable Target targetSelectedWithComboBox) {
        State state2 = this.myPersistentStateComponent.getState();
        state2.multipleDevicesSelectedInDropDown = false;
        TargetsForWritingSupplier supplier2 = new TargetsForWritingSupplier(state2.getTargetSelectedWithDropDown(), targetSelectedWithComboBox);
        state2.setRunningDeviceTargetSelectedWithDropDown(supplier2.getDropDownRunningDeviceTarget().orElse(null));
        state2.setTargetSelectedWithDropDown(supplier2.getDropDownTarget().orElse(null));
        state2.timeTargetWasSelectedWithDropDown = targetSelectedWithComboBox == null ? null : this.myClock.instant();
    }

    boolean isMultipleDevicesSelectedInComboBox() {
        return this.myPersistentStateComponent.getState().multipleDevicesSelectedInDropDown;
    }

    void setMultipleDevicesSelectedInComboBox(boolean multipleDevicesSelectedInComboBox) {
        this.myPersistentStateComponent.getState().multipleDevicesSelectedInDropDown = multipleDevicesSelectedInComboBox;
    }

    @NotNull
    @NotNull Set<@NotNull Target> getTargetsSelectedWithDialog(@NotNull @NotNull List<@NotNull Device> devices2) {
        State state2 = this.myPersistentStateComponent.getState();
        Collection<RunningDeviceTarget> runningDeviceTargets = state2.getRunningDeviceTargetsSelectedWithDialog();
        TargetsForReadingSupplier supplier2 = new TargetsForReadingSupplier(devices2, runningDeviceTargets, state2.getTargetsSelectedWithDialog());
        runningDeviceTargets.removeAll(supplier2.getDialogRunningDeviceTargetsToRemove());
        state2.setRunningDeviceTargetsSelectedWithDialog(runningDeviceTargets);
        return supplier2.getDialogTargets();
    }

    void setTargetsSelectedWithDialog(@NotNull @NotNull Set<@NotNull Target> targetsSelectedWithDialog) {
        State state2 = this.myPersistentStateComponent.getState();
        TargetsForWritingSupplier supplier2 = new TargetsForWritingSupplier(state2.getTargetsSelectedWithDialog(), targetsSelectedWithDialog);
        state2.setRunningDeviceTargetsSelectedWithDialog(supplier2.getDialogRunningDeviceTargets());
        state2.setTargetsSelectedWithDialog(supplier2.getDialogTargets());
    }

    private static final class PathConverter
    extends Converter<Path> {
        @NotNull
        private final FileSystem myFileSystem = FileSystems.getDefault();

        private PathConverter() {
        }

        @NotNull
        public Path fromString(@NotNull String string) {
            return this.myFileSystem.getPath(string, new String[0]);
        }

        @NotNull
        public String toString(@NotNull Path path2) {
            return path2.toString();
        }
    }

    private static enum KeyType {
        VIRTUAL_DEVICE_PATH,
        VIRTUAL_DEVICE_NAME,
        SERIAL_NUMBER;

    }

    @Tag(value="Key")
    private static final class KeyState {
        @OptionTag(tag="type", nameAttribute="")
        @Nullable
        public KeyType type;
        @OptionTag(tag="value", nameAttribute="")
        @Nullable
        public String value;

        private KeyState() {
        }

        private KeyState(@NotNull Key key) {
            if (key instanceof VirtualDevicePath) {
                this.type = KeyType.VIRTUAL_DEVICE_PATH;
            } else if (key instanceof VirtualDeviceName) {
                this.type = KeyType.VIRTUAL_DEVICE_NAME;
            } else if (key instanceof SerialNumber) {
                this.type = KeyType.SERIAL_NUMBER;
            } else assert (false) : key;
            this.value = key.toString();
        }

        @NotNull
        private Key asKey() throws DevicesSelectedServiceException {
            if (this.type == null) {
                throw new DevicesSelectedServiceException();
            }
            if (this.value == null) {
                throw new DevicesSelectedServiceException();
            }
            switch (this.type) {
                case VIRTUAL_DEVICE_PATH: {
                    return new VirtualDevicePath(this.value);
                }
                case VIRTUAL_DEVICE_NAME: {
                    return new VirtualDeviceName(this.value);
                }
                case SERIAL_NUMBER: {
                    return new SerialNumber(this.value);
                }
            }
            throw new DevicesSelectedServiceException(this.type.toString());
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type, this.value});
        }

        public boolean equals(@Nullable Object object) {
            if (!(object instanceof KeyState)) {
                return false;
            }
            KeyState key = (KeyState)object;
            return Objects.equals((Object)this.type, (Object)key.type) && Objects.equals(this.value, key.value);
        }
    }

    private static enum TargetType {
        RUNNING_DEVICE_TARGET,
        COLD_BOOT_TARGET,
        QUICK_BOOT_TARGET,
        BOOT_WITH_SNAPSHOT_TARGET;

    }

    @Tag(value="Target")
    private static final class TargetState {
        @OptionTag(tag="type", nameAttribute="")
        @Nullable
        public TargetType type;
        @OptionTag(tag="deviceKey", nameAttribute="")
        @Nullable
        public KeyState deviceKey;
        @OptionTag(tag="snapshotKey", nameAttribute="", converter=PathConverter.class)
        @Nullable
        public Path snapshotKey;

        private TargetState() {
        }

        private TargetState(@NotNull Target target2) {
            if (target2 instanceof RunningDeviceTarget) {
                this.type = TargetType.RUNNING_DEVICE_TARGET;
            } else if (target2 instanceof ColdBootTarget) {
                this.type = TargetType.COLD_BOOT_TARGET;
            } else if (target2 instanceof QuickBootTarget) {
                this.type = TargetType.QUICK_BOOT_TARGET;
            } else if (target2 instanceof BootWithSnapshotTarget) {
                this.type = TargetType.BOOT_WITH_SNAPSHOT_TARGET;
                this.snapshotKey = ((BootWithSnapshotTarget)target2).getSnapshotKey();
            } else assert (false) : target2;
            this.deviceKey = new KeyState(target2.getDeviceKey());
        }

        @NotNull
        private Target asTarget() throws DevicesSelectedServiceException {
            if (this.type == null) {
                throw new DevicesSelectedServiceException();
            }
            if (this.deviceKey == null) {
                throw new DevicesSelectedServiceException();
            }
            switch (this.type) {
                case RUNNING_DEVICE_TARGET: {
                    return new RunningDeviceTarget(this.deviceKey.asKey());
                }
                case COLD_BOOT_TARGET: {
                    return new ColdBootTarget(this.deviceKey.asKey());
                }
                case QUICK_BOOT_TARGET: {
                    return new QuickBootTarget(this.deviceKey.asKey());
                }
                case BOOT_WITH_SNAPSHOT_TARGET: {
                    assert (this.snapshotKey != null);
                    return new BootWithSnapshotTarget(this.deviceKey.asKey(), this.snapshotKey);
                }
            }
            throw new DevicesSelectedServiceException(this.type.toString());
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type, this.deviceKey, this.snapshotKey});
        }

        public boolean equals(@Nullable Object object) {
            if (!(object instanceof TargetState)) {
                return false;
            }
            TargetState target2 = (TargetState)object;
            return Objects.equals((Object)this.type, (Object)target2.type) && Objects.equals(this.deviceKey, target2.deviceKey) && Objects.equals(this.snapshotKey, target2.snapshotKey);
        }
    }

    private static final class State {
        @OptionTag(tag="runningDeviceTargetSelectedWithDropDown", nameAttribute="")
        @Nullable
        public TargetState runningDeviceTargetSelectedWithDropDown;
        @OptionTag(tag="targetSelectedWithDropDown", nameAttribute="")
        @Nullable
        public TargetState targetSelectedWithDropDown;
        @OptionTag(tag="timeTargetWasSelectedWithDropDown", nameAttribute="", converter=InstantConverter.class)
        @Nullable
        public Instant timeTargetWasSelectedWithDropDown;
        @OptionTag(tag="multipleDevicesSelectedInDropDown", nameAttribute="")
        public boolean multipleDevicesSelectedInDropDown;
        @XCollection(style=XCollection.Style.v2)
        @NotNull
        public @NotNull Collection<@NotNull TargetState> runningDeviceTargetsSelectedWithDialog = Collections.emptyList();
        @XCollection(style=XCollection.Style.v2)
        @NotNull
        public @NotNull Collection<@NotNull TargetState> targetsSelectedWithDialog = Collections.emptyList();

        private State() {
        }

        @Nullable
        private RunningDeviceTarget getRunningDeviceTargetSelectedWithDropDown() {
            return (RunningDeviceTarget)State.getTargetSelectedWithDropDown(this.runningDeviceTargetSelectedWithDropDown);
        }

        private void setRunningDeviceTargetSelectedWithDropDown(@Nullable RunningDeviceTarget runningDeviceTargetSelectedWithDropDown) {
            if (runningDeviceTargetSelectedWithDropDown == null) {
                this.runningDeviceTargetSelectedWithDropDown = null;
                return;
            }
            this.runningDeviceTargetSelectedWithDropDown = new TargetState(runningDeviceTargetSelectedWithDropDown);
        }

        @Nullable
        private Target getTargetSelectedWithDropDown() {
            return State.getTargetSelectedWithDropDown(this.targetSelectedWithDropDown);
        }

        private void setTargetSelectedWithDropDown(@Nullable Target targetSelectedWithDropDown) {
            if (targetSelectedWithDropDown == null) {
                this.targetSelectedWithDropDown = null;
                return;
            }
            this.targetSelectedWithDropDown = new TargetState(targetSelectedWithDropDown);
        }

        @Nullable
        private static Target getTargetSelectedWithDropDown(@Nullable TargetState targetState) {
            if (targetState == null) {
                return null;
            }
            try {
                return targetState.asTarget();
            }
            catch (DevicesSelectedServiceException exception) {
                Logger.getInstance(DevicesSelectedService.class).warn((Throwable)exception);
                return null;
            }
        }

        @NotNull
        private @NotNull Collection<@NotNull RunningDeviceTarget> getRunningDeviceTargetsSelectedWithDialog() {
            return State.getTargetsSelectedWithDialog(this.runningDeviceTargetsSelectedWithDialog, RunningDeviceTarget.class);
        }

        private void setRunningDeviceTargetsSelectedWithDialog(@NotNull @NotNull Collection<@NotNull RunningDeviceTarget> runningDeviceTargetsSelectedWithDialog) {
            this.runningDeviceTargetsSelectedWithDialog = State.asTargetStates(runningDeviceTargetsSelectedWithDialog);
        }

        @NotNull
        private @NotNull Collection<@NotNull Target> getTargetsSelectedWithDialog() {
            return State.getTargetsSelectedWithDialog(this.targetsSelectedWithDialog, Target.class);
        }

        private void setTargetsSelectedWithDialog(@NotNull @NotNull Collection<@NotNull Target> targetsSelectedWithDialog) {
            this.targetsSelectedWithDialog = State.asTargetStates(targetsSelectedWithDialog);
        }

        @NotNull
        private static <T> @NotNull Collection<@NotNull T> getTargetsSelectedWithDialog(@NotNull @NotNull Collection<@NotNull TargetState> targetStates, @NotNull @NotNull Class<@NotNull T> c) {
            try {
                ArrayList<T> targets = new ArrayList<T>(targetStates.size());
                for (TargetState targetState : targetStates) {
                    targets.add(c.cast(targetState.asTarget()));
                }
                return targets;
            }
            catch (DevicesSelectedServiceException exception) {
                Logger.getInstance(DevicesSelectedService.class).warn((Throwable)exception);
                return Collections.emptyList();
            }
        }

        @NotNull
        private static <T extends Target> @NotNull Collection<@NotNull TargetState> asTargetStates(@NotNull @NotNull Collection<@NotNull T> targets) {
            return targets.stream().map(x$0 -> new TargetState((Target)x$0)).collect(Collectors.toList());
        }

        public int hashCode() {
            return Objects.hash(this.runningDeviceTargetSelectedWithDropDown, this.targetSelectedWithDropDown, this.timeTargetWasSelectedWithDropDown, this.multipleDevicesSelectedInDropDown, this.runningDeviceTargetsSelectedWithDialog, this.targetsSelectedWithDialog);
        }

        public boolean equals(@Nullable Object object) {
            if (!(object instanceof State)) {
                return false;
            }
            State state2 = (State)object;
            return Objects.equals(this.runningDeviceTargetSelectedWithDropDown, state2.runningDeviceTargetSelectedWithDropDown) && Objects.equals(this.targetSelectedWithDropDown, state2.targetSelectedWithDropDown) && Objects.equals(this.timeTargetWasSelectedWithDropDown, state2.timeTargetWasSelectedWithDropDown) && this.multipleDevicesSelectedInDropDown == state2.multipleDevicesSelectedInDropDown && this.runningDeviceTargetsSelectedWithDialog.equals(state2.runningDeviceTargetsSelectedWithDialog) && this.targetsSelectedWithDialog.equals(state2.targetsSelectedWithDialog);
        }
    }

    @com.intellij.openapi.components.State(name="deploymentTargetDropDown", storages={@Storage(value="deploymentTargetDropDown.xml")})
    @Service
    @VisibleForTesting
    static final class PersistentStateComponent
    implements com.intellij.openapi.components.PersistentStateComponent<State> {
        @NotNull
        private State myState = new State();

        PersistentStateComponent() {
        }

        @NotNull
        public State getState() {
            return this.myState;
        }

        public void loadState(@NotNull State state2) {
            this.myState = state2;
        }
    }
}

