/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.deployment;

import com.android.ddmlib.IDevice;
import com.android.tools.idea.execution.common.AndroidExecutionTarget;
import com.android.tools.idea.run.AndroidRunConfigurationBase;
import com.android.tools.idea.run.deployment.AsyncDevicesGetter;
import com.android.tools.idea.run.deployment.Device;
import com.android.tools.idea.run.deployment.DeviceAndSnapshotComboBoxAction;
import com.android.tools.idea.run.deployment.Key;
import com.android.tools.idea.run.deployment.Target;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.util.UserDataHolderBase;
import icons.StudioIcons;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class DeviceAndSnapshotComboBoxExecutionTarget
extends AndroidExecutionTarget {
    @NotNull
    private final @NotNull Collection<@NotNull Key> myKeys;
    @NotNull
    private final AsyncDevicesGetter myDevicesGetter;

    DeviceAndSnapshotComboBoxExecutionTarget(@NotNull @NotNull Collection<@NotNull Target> targets, @NotNull AsyncDevicesGetter devicesGetter) {
        this.myKeys = targets.stream().map(Target::getDeviceKey).collect(Collectors.toSet());
        this.myDevicesGetter = devicesGetter;
    }

    @Override
    public boolean isApplicationRunning(@NotNull String appPackage) {
        return this.deviceStream().anyMatch(device2 -> device2.isRunning(appPackage));
    }

    @Override
    public int getAvailableDeviceCount() {
        return (int)this.deviceStream().count();
    }

    @Override
    @NotNull
    public @NotNull ListenableFuture<@NotNull Collection<@NotNull IDevice>> getRunningDevicesAsync() {
        List futures2 = this.deviceStream().filter(Device::isConnected).map(Device::getDdmlibDeviceAsync).collect(Collectors.toList());
        ListenableFuture future2 = Futures.successfulAsList(futures2);
        return Futures.transform((ListenableFuture)future2, DeviceAndSnapshotComboBoxExecutionTarget::filterNonNull, (Executor)MoreExecutors.directExecutor());
    }

    @NotNull
    private static @NotNull Collection<@NotNull IDevice> filterNonNull(@NotNull Collection<@Nullable IDevice> devices2) {
        return devices2.stream().filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    @NotNull
    public Collection<IDevice> getRunningDevices() {
        return this.deviceStream().filter(Device::isConnected).map(Device::getDdmlibDeviceAsync).map(Futures::getUnchecked).collect(Collectors.toList());
    }

    @NotNull
    private @NotNull Stream<@NotNull Device> deviceStream() {
        return this.myDevicesGetter.get().map(this::filteredStream).orElseGet(Stream::empty);
    }

    @NotNull
    private @NotNull Stream<@NotNull Device> filteredStream(@NotNull @NotNull Collection<@NotNull Device> devices2) {
        return devices2.stream().filter(device2 -> this.myKeys.contains(device2.getKey()));
    }

    @NotNull
    public String getId() {
        return this.myKeys.stream().sorted().map(Object::toString).collect(Collectors.joining(", ", "device_and_snapshot_combo_box_target[", "]"));
    }

    @NotNull
    public String getDisplayName() {
        List devices2 = this.deviceStream().collect(Collectors.toList());
        switch (devices2.size()) {
            case 0: {
                return "No Devices";
            }
            case 1: {
                return ((Device)devices2.get(0)).getName();
            }
        }
        return "Multiple Devices";
    }

    @NotNull
    public Icon getIcon() {
        List devices2 = this.deviceStream().collect(Collectors.toList());
        if (devices2.size() == 1) {
            return ((Device)devices2.get(0)).getIcon();
        }
        return StudioIcons.DeviceExplorer.MULTIPLE_DEVICES;
    }

    public boolean canRun(@NotNull RunConfiguration configuration) {
        Boolean deploysToLocalDevice = false;
        if (configuration instanceof UserDataHolderBase) {
            deploysToLocalDevice = (Boolean)((UserDataHolderBase)configuration).getUserData(DeviceAndSnapshotComboBoxAction.DEPLOYS_TO_LOCAL_DEVICE);
        }
        return configuration instanceof AndroidRunConfigurationBase || deploysToLocalDevice != null && deploysToLocalDevice != false;
    }
}

