/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.deployment;

import com.android.ddmlib.Client;
import com.android.ddmlib.IDevice;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.run.AndroidRunConfigurationBase;
import com.android.tools.idea.run.ApkProvisionException;
import com.android.tools.idea.run.ApplicationIdProvider;
import com.android.tools.idea.run.deployable.Deployable;
import com.android.tools.idea.run.deployable.DeployableProvider;
import com.android.tools.idea.run.deployment.Device;
import com.android.tools.idea.run.deployment.DeviceAndSnapshotComboBoxAction;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.serviceContainer.NonInjectable;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeviceAndSnapshotComboBoxDeployableProvider
implements DeployableProvider {
    @NotNull
    private final @NotNull Supplier<@NotNull DeviceAndSnapshotComboBoxAction> myDeviceAndSnapshotComboBoxActionGetInstance;
    @NotNull
    private final @NotNull Supplier<@NotNull Logger> myLoggerGetInstance;
    private boolean myStackTraceLoggedOnce;

    private DeviceAndSnapshotComboBoxDeployableProvider() {
        this(DeviceAndSnapshotComboBoxAction::getInstance, () -> Logger.getInstance(DeviceAndSnapshotComboBoxDeployableProvider.class));
    }

    @NonInjectable
    @VisibleForTesting
    DeviceAndSnapshotComboBoxDeployableProvider(@NotNull @NotNull Supplier<@NotNull DeviceAndSnapshotComboBoxAction> deviceAndSnapshotComboBoxActionGetInstance, @NotNull @NotNull Supplier<@NotNull Logger> loggerGetInstance) {
        this.myDeviceAndSnapshotComboBoxActionGetInstance = deviceAndSnapshotComboBoxActionGetInstance;
        this.myLoggerGetInstance = loggerGetInstance;
    }

    @Override
    @Nullable
    public Deployable getDeployable(@NotNull RunConfiguration runConfiguration) {
        if (!(runConfiguration instanceof AndroidRunConfigurationBase)) {
            return null;
        }
        AndroidRunConfigurationBase androidRunConfiguration = (AndroidRunConfigurationBase)runConfiguration;
        List<Device> devices2 = this.myDeviceAndSnapshotComboBoxActionGetInstance.get().getSelectedDevices(androidRunConfiguration.getProject());
        if (devices2.size() != 1) {
            return null;
        }
        ApplicationIdProvider applicationIdProvider = androidRunConfiguration.getApplicationIdProvider();
        if (applicationIdProvider == null) {
            return null;
        }
        return this.getPackageName(applicationIdProvider).map(name -> new DeployableDevice((Device)devices2.get(0), (String)name)).orElse(null);
    }

    @NotNull
    private @NotNull Optional<@NotNull String> getPackageName(@NotNull ApplicationIdProvider provider2) {
        try {
            String name = provider2.getPackageName();
            this.myStackTraceLoggedOnce = false;
            return Optional.of(name);
        }
        catch (ApkProvisionException exception) {
            if (!this.myStackTraceLoggedOnce) {
                this.myLoggerGetInstance.get().warn((Throwable)exception);
                this.myStackTraceLoggedOnce = true;
            } else {
                this.myLoggerGetInstance.get().warn("An ApkProvisionException has been thrown more than once: " + exception);
            }
            return Optional.empty();
        }
    }

    @VisibleForTesting
    static final class DeployableDevice
    implements Deployable {
        @NotNull
        private final Device myDevice;
        @NotNull
        private final String myPackageName;

        @VisibleForTesting
        DeployableDevice(@NotNull Device device2, @NotNull String packageName2) {
            this.myDevice = device2;
            this.myPackageName = packageName2;
        }

        @Override
        @NotNull
        public Future<AndroidVersion> getVersion() {
            return this.myDevice.getAndroidVersion();
        }

        @Override
        @NotNull
        public List<Client> searchClientsForPackage() {
            IDevice iDevice = this.myDevice.getDdmlibDevice();
            if (iDevice == null) {
                return Collections.emptyList();
            }
            return Deployable.searchClientsForPackage(iDevice, this.myPackageName);
        }

        @Override
        public boolean isOnline() {
            IDevice iDevice = this.myDevice.getDdmlibDevice();
            if (iDevice == null) {
                return false;
            }
            return iDevice.isOnline();
        }

        @Override
        public boolean isUnauthorized() {
            IDevice iDevice = this.myDevice.getDdmlibDevice();
            if (iDevice == null) {
                return false;
            }
            return iDevice.getState() == IDevice.DeviceState.UNAUTHORIZED;
        }

        public int hashCode() {
            return 31 * this.myDevice.hashCode() + this.myPackageName.hashCode();
        }

        public boolean equals(@Nullable Object object) {
            if (!(object instanceof DeployableDevice)) {
                return false;
            }
            DeployableDevice device2 = (DeployableDevice)object;
            return this.myDevice.equals(device2.myDevice) && this.myPackageName.equals(device2.myPackageName);
        }
    }
}

